/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import javax.swing.Action;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.action.BaseModelAction;

public class XmlSelectionAction
extends BaseModelAction {
    private final boolean _needsSelection;

    public XmlSelectionAction(String string, KeyStroke keyStroke, String string2, boolean bl) {
        super(string, keyStroke, string2, bl, false);
        this._needsSelection = bl;
    }

    public boolean isActiveViewAction() {
        return true;
    }

    protected boolean needToUpdateEnabled(XmlModelEvent xmlModelEvent) {
        return xmlModelEvent.isSelectionOrRangeSelectionChanged() || this.needsToRespondToReadOnlyChange(xmlModelEvent);
    }

    protected boolean isEnabledImpl() {
        if (!super.isEnabledImpl()) {
            return false;
        }
        AbstractModel abstractModel = this.getModel();
        abstractModel.acquireReadLock();
        try {
            Selection selection = abstractModel.getSelection();
            boolean bl = selection.isEmpty();
            if (selection.hasRangeSelection() && selection.getRangeSelection().getStart() == selection.getRangeSelection().getEnd()) {
                bl = true;
            }
            boolean bl2 = this._needsSelection ^ bl;
            abstractModel.releaseReadLock();
            return bl2;
        }
        catch (Throwable throwable) {
            abstractModel.releaseReadLock();
            throw throwable;
        }
    }

    protected static void setActionName(Action action, String string) {
        String string2 = StringUtils.stripMnemonic((String)string);
        int n = StringUtils.getMnemonicKeyCode((String)string);
        action.putValue("Name", string2);
        action.putValue("MnemonicKey", IntegerUtils.getInteger((int)n));
    }
}

