/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.validator;

import java.util.Map;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.validator.CachingValidatorCallback;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class BaseValidatorCallback
extends CachingValidatorCallback {
    private XmlContext _context;

    public Map getCacheForThread() {
        return this.getCache();
    }

    public Map getCache() {
        Map map = null;
        XmlContext xmlContext = this.getContext();
        if (xmlContext != null) {
            XmlModel xmlModel = xmlContext.getModel();
            xmlModel.acquireReadLock();
            try {
                Document document = xmlContext.getModel().getDocument();
                if (document != null) {
                    map = BaseValidatorCallback.getCache((Document)document);
                }
            }
            finally {
                xmlModel.releaseReadLock();
            }
        }
        return map;
    }

    protected final void warning(ErrorHandler errorHandler, int n, String string, Node node) {
        try {
            errorHandler.warning((SAXParseException)((Object)new ValidationException(n, string, node)));
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected final void error(ErrorHandler errorHandler, int n, String string, Node node) {
        try {
            errorHandler.error((SAXParseException)((Object)new ValidationException(n, string, node)));
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected XmlContext getContext() {
        return this._context;
    }

    public void __ensureContextIsAttached(XmlContext xmlContext) {
        if (this._context == null) {
            this._context = xmlContext;
        }
    }
}

