/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.oviewer.base;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.dbdev.oviewer.base.ViewerEditor;
import oracle.dbdev.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.controls.IResultSetTableDrillDown;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Connections;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.explorer.CustomTree;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.ideimpl.navigator.ConnectionNavigatorManager;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.DatabaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.OCBBaseFolder;

public class NavSelectionListener
implements ViewSelectionListener,
MouseListener,
MouseMotionListener,
IResultSetTableDrillDown {
    private Node _pendingNodeSelectionChange;
    private boolean _hasMousePressed;
    private boolean _hasMouseReleased;
    private boolean _hasSelectionChanged;
    private boolean _inRightClick;
    private static NavSelectionListener _instance;

    private NavSelectionListener() {
    }

    public static NavSelectionListener getInstance() {
        return _instance;
    }

    public static void initialize() {
        NavigatorManager connectionNavigatorManager = ConnectionNavigatorManager.getConnectionNavigatorManager();
        NavigatorWindow navigatorWindow = connectionNavigatorManager.getNavigatorWindow();
        _instance = new NavSelectionListener();
        navigatorWindow.addViewSelectionListener((ViewSelectionListener)_instance);
        Component navigatorUI = navigatorWindow.getGUI();
        JTree tree = NavSelectionListener.findTree(navigatorUI);
        tree.addMouseListener(_instance);
        tree.addMouseMotionListener(_instance);
        Ide.getMainWindow().addActiveViewListener(new ActiveViewListener(){

            public void activeViewChanged(ActiveViewEvent e) {
                ExplorerNode root;
                JTree tree;
                e.getNewView().addViewSelectionListener((ViewSelectionListener)_instance);
                if (e.getOldView() != null) {
                    e.getOldView().removeViewSelectionListener((ViewSelectionListener)_instance);
                }
                if ((tree = NavSelectionListener.findTree(e.getNewView().getGUI())) != null && tree.getModel().getRoot() instanceof ExplorerNode && ((root = (ExplorerNode)tree.getModel().getRoot()).getUserObject() instanceof Connections || root.getUserObject() instanceof DatabaseConnectionNode)) {
                    boolean add = true;
                    for (MouseListener l : tree.getMouseListeners()) {
                        if (l != _instance) continue;
                        add = false;
                    }
                    if (add) {
                        tree.addMouseListener(_instance);
                        tree.addMouseMotionListener(_instance);
                    }
                }
            }
        });
    }

    private static JTree findTree(Component rootComponent) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(rootComponent);
        while (!components.isEmpty()) {
            Component component = (Component)components.removeLast();
            if (component instanceof JTree) {
                JTree jTree = (JTree)component;
                return jTree;
            }
            if (!(component instanceof Container)) continue;
            Container container = (Container)component;
            components.addAll(Arrays.asList(container.getComponents()));
        }
        return null;
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        Element selectedElement;
        Element[] selection = e.getSelection();
        if (selection != null && selection.length == 1 && ((selectedElement = selection[0]) instanceof DatabaseNode || selectedElement instanceof OCBBaseFolder)) {
            this._pendingNodeSelectionChange = (Node)selectedElement;
            boolean postpone = false;
            if (!this._hasSelectionChanged && this._hasMousePressed && (!this._hasMouseReleased || this._inRightClick)) {
                postpone = true;
            }
            if (postpone) {
                this._hasSelectionChanged = true;
            } else {
                this.doPendingChanges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void whenDatabaseObjectSelected(Node selectedNode) {
        ViewerNode viewerNode = ViewerNode.getUnpinnedInstance();
        DatabaseNode currentNode = viewerNode.getDatabaseNode();
        DBObject dbObject = new DBObject(selectedNode);
        if (!this.raiseEditor(selectedNode)) {
            Context context;
            boolean hasViewer;
            boolean isDifferentType;
            EditorManager editorManager = EditorManager.getEditorManager();
            if (currentNode == null) {
                isDifferentType = true;
                hasViewer = this.hasViewer(dbObject);
            } else {
                isDifferentType = currentNode.getClass() != selectedNode.getClass();
                hasViewer = isDifferentType ? this.hasViewer(dbObject) : true;
            }
            if (isDifferentType && hasViewer) {
                this.closeObjectViewer(viewerNode);
            }
            if (hasViewer) {
                viewerNode.setViewedObject(dbObject);
                context = Context.newIdeContext((Node)viewerNode);
            } else {
                context = Context.newIdeContext((Node)dbObject.getNode());
            }
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            openEditorOptions.setFlags(1);
            WaitCursor waitCursor = Ide.getWaitCursor();
            try {
                waitCursor.show(0L);
                editorManager.openEditor(openEditorOptions);
            }
            finally {
                waitCursor.hide();
            }
        }
    }

    private boolean hasViewer(DBObject dbObject) {
        boolean ret = false;
        if (dbObject.getNode() instanceof DatabaseNode || dbObject.getNode() instanceof OCBBaseFolder) {
            ViewerNode testNode = new ViewerNode();
            testNode.setViewedObject(dbObject);
            EditorManager editorManager = EditorManager.getEditorManager();
            EditorAddin bestEditorAddin = editorManager.getBestEditorAddin((Node)testNode);
            if (bestEditorAddin != null) {
                ret = true;
            }
        }
        return ret;
    }

    private void closeObjectViewer(ViewerNode viewerNode) {
        EditorManager editorManager = EditorManager.getEditorManager();
        List editors = editorManager.getAllEditors();
        for (int i = editors.size() - 1; i >= 0; --i) {
            Editor editor = (Editor)editors.get(i);
            Context context = editor.getContext();
            Node node = context.getNode();
            if (viewerNode == node) continue;
            editors.remove(i);
        }
        if (!editors.isEmpty()) {
            editorManager.closeEditors(editors);
        }
    }

    public void mouseClicked(MouseEvent e) {
        TreePath path = ((CustomTree)e.getSource()).getPathForLocation(e.getX(), e.getY());
        if (path != null && ((CustomTree)e.getSource()).getSelectionCount() > 0 && ((ExplorerNode)((CustomTree)e.getSource()).getLastSelectedPathComponent()).getUserObject() instanceof DatabaseNode) {
            this.whenDatabaseObjectSelected((Node)((ExplorerNode)((CustomTree)e.getSource()).getLastSelectedPathComponent()).getUserObject());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (((CustomTree)e.getSource()).getSelectionCount() > 0 && ((ExplorerNode)((CustomTree)e.getSource()).getLastSelectedPathComponent()).getUserObject() instanceof DatabaseNode) {
            this._pendingNodeSelectionChange = (Node)((ExplorerNode)((CustomTree)e.getSource()).getLastSelectedPathComponent()).getUserObject();
        }
        this._inRightClick = e.getModifiers() == 4;
        this.cancelPendingChanges();
        this._hasMousePressed = true;
    }

    public boolean raiseEditor(Node node) {
        boolean ret = false;
        List list = EditorManager.getEditorManager().getAllEditors();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof ViewerEditor) || ((ViewerEditor)((Object)list.get(i))).getViewerNode() == null || node != ((ViewerEditor)((Object)list.get(i))).getViewerNode().getDatabaseNode()) continue;
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(((Editor)list.get(i)).getContext());
            openEditorOptions.setFlags(1);
            EditorManager.getEditorManager().openEditor(openEditorOptions);
            ret = true;
        }
        return ret;
    }

    public void mouseReleased(MouseEvent e) {
        if (((CustomTree)e.getSource()).getSelectionCount() > 0 && ((ExplorerNode)((CustomTree)e.getSource()).getLastSelectedPathComponent()).getUserObject() instanceof DatabaseNode) {
            this._pendingNodeSelectionChange = (Node)((ExplorerNode)((CustomTree)e.getSource()).getLastSelectedPathComponent()).getUserObject();
        }
        TreePath path = ((CustomTree)e.getSource()).getPathForLocation(e.getX(), e.getY());
        if (this._hasSelectionChanged && path != null) {
            this.doPendingChanges();
        } else {
            this._hasMouseReleased = true;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.cancelPendingChanges();
        this._hasMousePressed = true;
    }

    public void mouseMoved(MouseEvent e) {
    }

    private void doPendingChanges() {
        Node node = this._pendingNodeSelectionChange;
        this.cancelPendingChanges();
        this.whenDatabaseObjectSelected(node);
    }

    private void cancelPendingChanges() {
        this._pendingNodeSelectionChange = null;
        this._hasMousePressed = false;
        this._hasMouseReleased = false;
        this._hasSelectionChanged = false;
    }

    public void performDrill(Node node) {
        this.whenDatabaseObjectSelected(node);
    }
}

