/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.oviewer.base;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.raptor.explorer.dt.IViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.resource.IdeArb;
import oracle.javatools.db.Database;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.browser.jdbc.DatabaseNode;

public class ViewerNode
extends Node
implements IViewerNode,
Observer {
    public static final int RELATION_NODE_CHANGED_MESSAGE_ID = UpdateMessage.newMessageID((String)(ViewerNode.class.getName() + ".relationNodeChanged"));
    public static final int RELATION_NODE_MODIFIED_MESSAGE_ID = UpdateMessage.newMessageID((String)(ViewerNode.class.getName() + ".relationNodeModified"));
    private static final String PROTOCOL = "ide.viewernode";
    private static ViewerNode INSTANCE;
    private static int _nodeId;
    private boolean _pinned = true;
    private DBObject _dbObject;
    private Database _database;
    private ArrayList _dirtyComponents = new ArrayList(1);
    private static List<ViewerNode> _instances;

    public static ViewerNode createInstance() {
        INSTANCE = new ViewerNode();
        _instances.add(INSTANCE);
        return INSTANCE;
    }

    public static ViewerNode getInstance() {
        return INSTANCE;
    }

    public static ViewerNode getUnpinnedInstance() {
        if (!INSTANCE.getPinned()) {
            return INSTANCE;
        }
        for (int i = 0; i < _instances.size(); ++i) {
            ViewerNode vn = _instances.get(i);
            if (vn.getPinned()) continue;
            INSTANCE = vn;
            return vn;
        }
        return ViewerNode.createInstance();
    }

    public ViewerNode() {
        URL url = URLFactory.newURL((String)PROTOCOL, (String)("ViewerNode" + _nodeId++));
        this.setURL(url);
        this.setPinned(false);
        this.getAttributes().set(ElementAttributes.SAVEABLE | ElementAttributes.CLOSEABLE);
    }

    public String getShortLabel() {
        String ret = "";
        if (this._database != null) {
            String shortLabel;
            Node node = this._dbObject.getNode();
            ret = shortLabel = node.getShortLabel();
        }
        return ret;
    }

    public Icon getIcon() {
        Icon ret = null;
        if (this._dbObject != null) {
            String objectType = this._dbObject.getObjectType();
            ret = DBUtil.getFolderIcon((String)objectType);
        }
        return ret;
    }

    public String getLongLabel() {
        if (this._dbObject != null) {
            String longLabel = this._dbObject.getNode().getLongLabel();
            return longLabel;
        }
        return "no viewable object";
    }

    public void setPinned(boolean pinned) {
        if (this._pinned != pinned) {
            this._pinned = pinned;
        }
    }

    public boolean getPinned() {
        return this._pinned;
    }

    public void setViewedObject(DBObject dbObject) {
        if (this.checkCanChange()) {
            if (this._dbObject != null) {
                this._dbObject.getNode().detach((Observer)this);
            }
            this._database = dbObject.getDatabase();
            this._dbObject = dbObject;
            if (this._dbObject.getNode() instanceof Node) {
                this._dbObject.getNode().attach((Observer)this);
            }
            this.notifyObservers((Object)this, new UpdateMessage(RELATION_NODE_CHANGED_MESSAGE_ID, (Object)this));
            this.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
            this.setOpen(this._dbObject.getNode() != null);
        }
    }

    private boolean checkCanChange() {
        boolean ret = true;
        if (this.isDirty()) {
            try {
                String message = MessageFormat.format(IdeArb.getString((int)217), this.getLongLabel());
                int confirm = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)message, (String)this.getLongLabel(), null);
                switch (confirm) {
                    case 1: {
                        this.save();
                        break;
                    }
                    case 0: {
                        this.revert();
                        break;
                    }
                    default: {
                        ret = false;
                        break;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                ret = false;
            }
        }
        return ret;
    }

    public DatabaseNode getDatabaseNode() {
        return (DatabaseNode)(this._dbObject != null && this._dbObject.getNode() != null && this._dbObject.getNode() instanceof DatabaseNode ? this._dbObject.getNode() : null);
    }

    public Database getDatabase() {
        return this._database;
    }

    public DBObject getDBObject() {
        return this._dbObject;
    }

    public void addDirtyComponent(DirtyComponent dirtyComponent) {
        if (!this._dirtyComponents.contains(dirtyComponent)) {
            this._dirtyComponents.add(dirtyComponent);
            this.markDirty(true);
        }
    }

    public void removeDirtyComponent(DirtyComponent dirtyComponent) {
        if (this._dirtyComponents.remove(dirtyComponent) && this._dirtyComponents.isEmpty()) {
            this.markDirty(false);
        }
    }

    public void update(Object o, UpdateMessage msg) {
        if (msg.getMessageID() == UpdateMessage.CONTENT_MODIFIED) {
            this.notifyObservers(o, new UpdateMessage(RELATION_NODE_MODIFIED_MESSAGE_ID, (Object)this));
        }
    }

    protected void openImpl() throws IOException {
        INSTANCE = this;
    }

    protected void revertImpl() throws IOException {
        this._dirtyComponents.clear();
    }

    protected void saveImpl() throws IOException {
        for (int i = 0; i < this._dirtyComponents.size(); ++i) {
            DirtyComponent dirtyComponent = (DirtyComponent)this._dirtyComponents.get(i);
            dirtyComponent.save(this);
        }
        this._dirtyComponents.clear();
    }

    static {
        URLFileSystem.registerHelper((String)PROTOCOL, (URLFileSystemHelper)new FileSystemHelper());
        _nodeId = 0;
        _instances = new ArrayList<ViewerNode>(1);
    }

    private static final class FileSystemHelper
    extends URLFileSystemHelper {
        private FileSystemHelper() {
        }

        public String getPlatformPathName(URL url) {
            ViewerNode node = INSTANCE;
            for (ViewerNode cand : _instances) {
                URL candUrl = cand.getURL();
                if (!ModelUtil.areEqual((Object)url.getPath(), (Object)candUrl.getPath())) continue;
                node = cand;
                break;
            }
            return node != null ? node.getLongLabel() : "Viewer Node";
        }
    }

    public static interface DirtyComponent {
        public void save(ViewerNode var1) throws IOException;
    }
}

