/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.oviewer.table;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.dbdev.oviewer.base.ViewerEditor;
import oracle.dbdev.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.controls.IProgressFeedback;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.MetaDataDDLGenerator;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.plugins.EditorPlugin;

public class DDLViewer
extends ViewerEditor {
    private BasicEditorPane _code;
    private DBObject _lastdbObject;
    private DBObject _dbObject;
    private IdeAction _refreshAction;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_TE_Editor");

    protected JComponent createViewerUI() {
        this._code = EditorFactory.createIdeEditorPane();
        BasicDocument document = (BasicDocument)this._code.getDocument();
        document.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
        this._code.setEditable(false);
        this._code.setCaretPosition(0);
        LineGutterPlugin sqlGutter = new LineGutterPlugin();
        this._code.installPlugin((EditorPlugin)sqlGutter);
        JScrollPane spSql = new JScrollPane((Component)this._code, 22, 32);
        spSql.setRowHeaderView((Component)sqlGutter);
        this._refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)Translate.translate((String)"Refresh"), null, null, (Icon)IdeArb.getIcon((int)324), null, (boolean)true);
        this._refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction arg0, Context arg1) {
                DDLViewer.this.updateContent(true);
                return true;
            }

            public boolean update(IdeAction arg0, Context arg1) {
                return false;
            }
        });
        ((Toolbar)super.getFixedTopMargin()).add((ToggleAction)this._refreshAction.newLocalAction((View)this));
        return spSql;
    }

    protected String getBinds() {
        return null;
    }

    protected void updateContent() {
        this.updateContent(false);
    }

    protected void updateContent(boolean force) {
        ViewerNode viewerNode = this.getViewerNode();
        if (viewerNode != null) {
            this._dbObject = viewerNode.getDBObject();
        }
        if (force || this._dbObject != null && (this._lastdbObject == null || this._lastdbObject.getObjectName() != this._dbObject.getObjectName())) {
            this._code.setEditable(true);
            ProgressRunnable runner = new ProgressRunnable(){

                protected void doCancel() {
                    super.doCancel();
                    DDLViewer.this._code.setText("--Generation of DDL was cancelled");
                }

                protected Object doWork() throws Exception {
                    return MetaDataDDLGenerator.getDDL((DBObject)DDLViewer.this._dbObject);
                }

                protected void finish(Object result) {
                    DDLViewer.this._code.setText(result.toString());
                }
            };
            IProgressFeedback feedback = new IProgressFeedback(){

                public void feedback(String s) {
                    Log.status((String)s);
                }
            };
            runner.setTitle(Translate.translate((String)"Generating DDL...."));
            runner.setCancelable(true);
            try {
                runner.start(true);
            }
            catch (ProgressException e) {
                this._code.setText("--Generation of DDL was cancelled");
            }
            this._code.setEditable(false);
            this._code.setCaretPosition(0);
            this._lastdbObject = this._dbObject;
        }
    }

    public Object getPrintable() {
        return this._code;
    }

    protected void cleanUp() {
    }

    public Object getEditorAttribute(String attribute) {
        boolean scrollable = false;
        if ("horizontal_scrollbar_policy".equals(attribute) && !scrollable) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(attribute) && !scrollable) {
            return new Integer(21);
        }
        if ("scrollable".equals(attribute) && !scrollable) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(attribute);
    }
}

