/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.oviewer.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class SortColumnPicker
extends JPanel
implements ListSelectionListener,
ListDataListener,
Cloneable {
    private JList lstFrom = new JList();
    private JList lstTo = new JList();
    private ListPicker pckFrom = new ListPicker(this.lstFrom);
    private ListPicker pckTo = new ReorderableListPicker(this.lstTo);
    private Shuttle shtColumns = new Shuttle();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel lblFrom = new JLabel();
    private JLabel lblTo = new JLabel();
    private DBObjectRenderer renderer = new DBObjectRenderer();
    protected DefaultListModel mdlFrom = new DefaultListModel();
    protected DefaultListModel mdlTo = new DefaultListModel();
    private JRadioButton _rdbAscending = new JRadioButton();
    private JRadioButton _rdbDescending = new JRadioButton();
    private JCheckBox _cbxNullFirst = new JCheckBox();
    private ButtonGroup _bgOrder = new ButtonGroup();
    private int start;
    private int end;

    public SortColumnPicker() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.start = 0;
        this.end = 0;
    }

    protected void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.shtColumns.setFromPicker((ItemPicker)this.pckFrom);
        this.shtColumns.setToPicker((ItemPicker)this.pckTo);
        this.shtColumns.add((Component)this.lblFrom, (Object)"FromHeader");
        this.shtColumns.add((Component)this.lblTo, (Object)"ToHeader");
        ResourceUtils.resLabel((JLabel)this.lblFrom, (Component)this.lstFrom, (String)CmWizardsArb.getString((int)118));
        ResourceUtils.resLabel((JLabel)this.lblTo, (Component)this.lstTo, (String)CmWizardsArb.getString((int)119));
        this.lstFrom.setCellRenderer(this.renderer);
        this.lstTo.setCellRenderer(this.renderer);
        this._rdbAscending.setText(CreateDialogArb.getString((int)517));
        this._rdbDescending.setText(CreateDialogArb.getString((int)518));
        this._cbxNullFirst.setText(CreateDialogArb.getString((int)521));
        this._bgOrder.add(this._rdbAscending);
        this._bgOrder.add(this._rdbDescending);
        this._rdbAscending.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SortColumnPicker.this.lstTo.getSelectedIndex() != -1) {
                    SortCol sortCol = (SortCol)SortColumnPicker.this.mdlTo.get(SortColumnPicker.this.lstTo.getSelectedIndex());
                    sortCol.setAscending(true);
                    SortColumnPicker.this.lstTo.repaint();
                }
            }
        });
        this._rdbDescending.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SortColumnPicker.this.lstTo.getSelectedIndex() != -1) {
                    SortCol sortCol = (SortCol)SortColumnPicker.this.mdlTo.get(SortColumnPicker.this.lstTo.getSelectedIndex());
                    sortCol.setAscending(false);
                    SortColumnPicker.this.lstTo.repaint();
                }
            }
        });
        this._cbxNullFirst.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SortColumnPicker.this.lstTo.getSelectedIndex() != -1) {
                    SortCol sortCol = (SortCol)SortColumnPicker.this.mdlTo.get(SortColumnPicker.this.lstTo.getSelectedIndex());
                    sortCol.setNullFirst(SortColumnPicker.this._cbxNullFirst.isSelected());
                }
            }
        });
        this.add((Component)this.shtColumns, new GridBagConstraints(0, 0, 1, 4, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._rdbAscending, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this._rdbDescending, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._cbxNullFirst, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
    }

    public void init(String[] columns) {
        this.mdlFrom.removeAllElements();
        this.mdlTo.removeAllElements();
        for (int i = 0; i < columns.length; ++i) {
            this.mdlFrom.addElement(new SortCol(columns[i]));
        }
        this.lstFrom.setModel(this.mdlFrom);
        this.lstTo.setModel(this.mdlTo);
        this.lstFrom.setSelectedIndex(0);
        this.shtColumns.setEnabled(true);
        this.lstFrom.setEnabled(true);
        this.lstTo.setEnabled(true);
        this.lstTo.setSelectionMode(0);
        this.shtColumns.validate();
        this._rdbAscending.setEnabled(false);
        this._rdbDescending.setEnabled(false);
        this._cbxNullFirst.setEnabled(false);
        this.mdlTo.addListDataListener(this);
        this.lstTo.addListSelectionListener(this);
    }

    public void intervalAdded(ListDataEvent e) {
        this.start = e.getIndex0();
        this.end = e.getIndex1();
        ListSelectionModel m = this.lstTo.getSelectionModel();
        m.setSelectionInterval(this.start, this.end);
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    public void contentsChanged(ListDataEvent e) {
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.lstTo.getSelectedIndex() == -1 && this.mdlTo.size() > 0) {
            ListSelectionModel m = this.lstTo.getSelectionModel();
            if (this.mdlTo.size() <= this.end) {
                this.start = this.end = this.mdlTo.size() - 1;
            }
            m.setSelectionInterval(this.start, this.end);
        } else {
            this.start = this.end = this.lstTo.getSelectedIndex();
        }
        this.updateSortProperties();
    }

    public void updateSortProperties() {
        int sel = this.lstTo.getSelectedIndex();
        if (sel == -1) {
            this._rdbAscending.setEnabled(false);
            this._rdbAscending.setSelected(false);
            this._rdbDescending.setEnabled(false);
            this._rdbDescending.setSelected(false);
            this._cbxNullFirst.setEnabled(false);
            this._cbxNullFirst.setSelected(false);
        } else {
            SortCol sortCol = (SortCol)this.mdlTo.getElementAt(sel);
            this._rdbAscending.setEnabled(true);
            this._rdbAscending.setSelected(sortCol.getAscending());
            this._rdbDescending.setEnabled(true);
            this._rdbDescending.setSelected(!sortCol.getAscending());
            this._cbxNullFirst.setEnabled(true);
            this._cbxNullFirst.setSelected(sortCol.getNullFirst());
        }
    }

    public String getOrderBy() {
        if (this.mdlTo.size() == 0) {
            return null;
        }
        StringBuffer orderBy = new StringBuffer();
        for (int i = 0; i < this.mdlTo.size(); ++i) {
            if (i > 0) {
                orderBy.append(",");
            }
            SortCol sortCol = (SortCol)this.mdlTo.get(i);
            orderBy.append(sortCol.getValue());
            if (sortCol.getAscending()) {
                orderBy.append(" ASC");
            } else {
                orderBy.append(" DESC");
            }
            if (sortCol.getNullFirst()) {
                orderBy.append(" NULLS FIRST");
                continue;
            }
            orderBy.append(" NULLS LAST");
        }
        return orderBy.toString();
    }

    public ArrayList getFromList() {
        ArrayList<SortCol> ret = new ArrayList<SortCol>();
        for (int i = 0; i < this.mdlFrom.size(); ++i) {
            ret.add(new SortCol((SortCol)this.mdlFrom.get(i)));
        }
        return ret;
    }

    public ArrayList getToList() {
        ArrayList<SortCol> ret = new ArrayList<SortCol>();
        for (int i = 0; i < this.mdlTo.size(); ++i) {
            ret.add(new SortCol((SortCol)this.mdlTo.get(i)));
        }
        return ret;
    }

    public void setFromList(ArrayList list) {
        this.mdlFrom.removeAllElements();
        for (int i = 0; i < list.size(); ++i) {
            this.mdlFrom.addElement((SortCol)list.get(i));
        }
    }

    public void setToList(ArrayList list) {
        this.mdlTo.removeAllElements();
        for (int i = 0; i < list.size(); ++i) {
            this.mdlTo.addElement((SortCol)list.get(i));
        }
    }

    private class SortCol
    implements Element {
        private boolean _ascending;
        private boolean _nullFirst;
        private String _value;

        public SortCol(String value) {
            this._value = value;
            this._ascending = true;
            this._nullFirst = false;
        }

        public SortCol(SortCol copy) {
            this._value = copy._value;
            this._ascending = copy._ascending;
            this._nullFirst = copy._nullFirst;
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return null;
        }

        public Object getData() {
            return this.toString();
        }

        public String getShortLabel() {
            return this.toString();
        }

        public String getLongLabel() {
            return this.toString();
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return this.toString();
        }

        public String toString() {
            if (this._value == null) {
                return "";
            }
            String value = new String(this._value);
            value = this._ascending ? value + " " + CreateDialogArb.getString((int)519) : value + " " + CreateDialogArb.getString((int)520);
            return value;
        }

        public boolean getAscending() {
            return this._ascending;
        }

        public boolean getNullFirst() {
            return this._nullFirst;
        }

        public void setAscending(boolean ascending) {
            this._ascending = ascending;
        }

        public void setNullFirst(boolean nullFirst) {
            this._nullFirst = nullFirst;
        }

        public String getValue() {
            return this._value;
        }
    }
}

