/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.oviewer.xmleditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.text.Document;
import oracle.dbdev.oviewer.base.ViewerAddin;
import oracle.dbdev.oviewer.base.ViewerEditor;
import oracle.dbdev.oviewer.base.ViewerNode;
import oracle.dbdev.oviewer.xmleditor.XMLEditor;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.jdeveloper.cm.dt.browser.jdbc.DatabaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;

public class XMLBasedEditor
extends ViewerEditor
implements FindableEditor,
IDBEditor,
Controller {
    protected DBObject _dbObject;
    protected DBObject _lastdbObject;
    protected XMLEditor _editor;
    protected ResultSetTable _table;
    protected ResultSetTable _secondTable;
    protected ResultSetTable _subTable;
    private JSplitPane _sp;
    private IdeAction _refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)Translate.translate((String)"Refresh"), null, null, (Icon)IdeArb.getIcon((int)324), null, (boolean)true).newLocalAction((View)this);
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_XML_Editor");
    private IdeAction _editDBNodeAction;
    static final int EDIT_DBNODE_CMD_ID = Ide.findOrCreateCmdID((String)"Edit_DBNode_XML_Editor");
    private BasicEditorPane _codeArea = null;
    private BasicEditorPane _subCodeArea = null;
    private int _lastRow = -1;

    public XMLBasedEditor() {
        this._refreshAction.addController((Controller)this);
        this._editDBNodeAction = IdeAction.get((int)EDIT_DBNODE_CMD_ID, null, (String)Translate.translate((String)"Edit"), null, null, (Icon)RaptorImage.getIcon((String)"edit_code.png"), null, (boolean)true).newLocalAction((View)this);
        this._editDBNodeAction.addController((Controller)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(IdeAction arg0, Context arg1) {
        int cmdId = arg0.getCommandId();
        if (cmdId == REFRESH_EDITOR_CMD_ID) {
            this.updateContent(true);
            return true;
        }
        if (cmdId == EDIT_DBNODE_CMD_ID) {
            if (this.getDatabaseNode() instanceof PlSqlBaseNode) {
                Context context = Context.newIdeContext((Element)((Element)this.getDatabaseNode()));
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                openEditorOptions.setFlags(1);
                WaitCursor waitCursor = Ide.getWaitCursor();
                try {
                    waitCursor.show(0L);
                    EditorManager.getEditorManager().openEditor(openEditorOptions);
                }
                finally {
                    waitCursor.hide();
                }
                return true;
            }
            UIUtils.editNodeWizard((DatabaseNode)this.getDatabaseNode());
            return true;
        }
        return super.handleEvent(arg0, arg1);
    }

    public boolean update(IdeAction arg0, Context arg1) {
        return super.update(arg0, arg1);
    }

    protected JComponent createViewerUI() {
        Object ret = null;
        this._dbObject = this.getContext().getNode() instanceof ViewerNode ? ((ViewerNode)this.getContext().getNode()).getDBObject() : new DBObject(this.getContext().getNode());
        if (!(this._dbObject.getObjectType().equals("DATABASE LINK") || this._dbObject.getObjectType().equals("INDEX") || this._dbObject.getObjectType().equals("SYNONYM"))) {
            ((Toolbar)this.getFixedTopMargin()).add((ToggleAction)this._editDBNodeAction);
        }
        ((Toolbar)this.getFixedTopMargin()).add((ToggleAction)this._refreshAction);
        ViewerAddin viewer = (ViewerAddin)AddinManager.getAddinManager().getAddin(ViewerAddin.class);
        int num = Integer.parseInt(((Object)((Object)this)).getClass().toString().substring(((Object)((Object)this)).getClass().toString().lastIndexOf(114) + 1));
        this._editor = viewer.getXMLEditor(this._dbObject.getNode().getClass(), num);
        if (this._editor.getDisplay() != null && this._editor.getDisplay().equals("code")) {
            ret = this.createCodeDisplay();
        } else {
            this.createQueryEditor();
            ret = this._table;
            if (this._editor.getBottomQueries() != null && this._editor.getBottomQueries().size() > 0) {
                ret = this.createDoubleQueryEditor();
            } else if (this._editor.getSubQueries() != null && this._editor.getSubQueries().size() > 0) {
                ret = this.createSubQueryEditor();
            }
        }
        if (this._sp != null) {
            this._sp.setDividerLocation(0.5);
            this._sp.setOneTouchExpandable(true);
        }
        return ret;
    }

    private JComponent createDoubleQueryEditor() {
        this._sp = new JSplitPane(0);
        JScrollPane top = new JScrollPane((Component)this._table);
        top.setRowHeaderView(this._table.getTableHeader());
        this._sp.setTopComponent(top);
        this._secondTable = new ResultSetTable();
        this._secondTable.setAutoResizeMode(0);
        JScrollPane bottom = new JScrollPane((Component)this._secondTable);
        bottom.setRowHeaderView(this._secondTable.getTableHeader());
        JPanel j = new JPanel(new BorderLayout());
        j.add((Component)bottom, "Center");
        j.add((Component)new JLabel(this._editor.getSubTitle()), "North");
        this._sp.setBottomComponent(j);
        return this._sp;
    }

    private JComponent createCodeDisplay() {
        this._codeArea = EditorFactory.createIdeEditorPane();
        this._codeArea.setText("");
        this._codeArea.setDocument((Document)new BasicDocument("foo.plsql"));
        this._codeArea.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this._codeArea.setText("");
        this._codeArea.setEditable(false);
        LineGutterPlugin sqlGutter = new LineGutterPlugin();
        this._codeArea.installPlugin((EditorPlugin)sqlGutter);
        JScrollPane spSql = new JScrollPane((Component)this._codeArea, 22, 32);
        spSql.setRowHeaderView((Component)sqlGutter);
        return spSql;
    }

    private DatabaseNode getDatabaseNode() {
        if (this.getViewerNode() == null) {
            return (DatabaseNode)this.getContext().getNode();
        }
        return this.getViewerNode().getDatabaseNode();
    }

    private JComponent createSubQueryEditor() {
        this._sp = new JSplitPane(0);
        this._table.setAutoResizeMode(0);
        JScrollPane top = new JScrollPane((Component)this._table);
        top.setRowHeaderView(this._table.getTableHeader());
        this._sp.setTopComponent(top);
        this._table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    XMLBasedEditor.this.execSubTable();
                }
            }
        });
        if (this._editor.getSubQueryType() != null && this._editor.getSubQueryType().equals("code")) {
            this._subCodeArea = EditorFactory.createIdeEditorPane();
            this._subCodeArea.setText("");
            this._subCodeArea.setDocument((Document)new BasicDocument("foo.plsql"));
            this._subCodeArea.installPlugin((EditorPlugin)new LineHighlightPlugin());
            this._subCodeArea.setText("");
            this._subCodeArea.setEditable(false);
            LineGutterPlugin sqlGutter = new LineGutterPlugin();
            this._subCodeArea.installPlugin((EditorPlugin)sqlGutter);
            JScrollPane spSql = new JScrollPane((Component)this._subCodeArea, 22, 32);
            spSql.setRowHeaderView((Component)sqlGutter);
            this._sp.setBottomComponent(spSql);
        } else {
            this._subTable = new ResultSetTable();
            this._subTable.setAutoResizeMode(0);
            JScrollPane bottom = new JScrollPane((Component)this._subTable);
            bottom.setRowHeaderView(this._subTable.getTableHeader());
            this._sp.setBottomComponent(bottom);
        }
        return this._sp;
    }

    public Object getEditorAttribute(String attribute) {
        boolean scrollable = true;
        if (this._subCodeArea != null || this._subTable != null || this._codeArea != null || this._secondTable != null) {
            scrollable = false;
        }
        if ("horizontal_scrollbar_policy".equals(attribute) && !scrollable) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(attribute) && !scrollable) {
            return new Integer(21);
        }
        if ("scrollable".equals(attribute) && !scrollable) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(attribute);
    }

    public Component getScrollableTopMargin() {
        JTableHeader tableHeader = this._codeArea == null ? this._table.getTableHeader() : null;
        return this._subTable == null || this._codeArea != null ? tableHeader : null;
    }

    public void execSubTable() {
        int rowIndex = this._table.getSelectionModel().getAnchorSelectionIndex();
        if (rowIndex > -1 && this._lastRow != rowIndex) {
            HashMap<String, Object> binds = new HashMap<String, Object>();
            Query query = this._editor.getSubQuery(this._dbObject.getDatabase().getConnectionName());
            String name2 = null;
            for (int i = 0; i < this._table.getColumnCount(); ++i) {
                name2 = this._table.getRawColumnName(i);
                if (query.getSql().indexOf(":" + name2) <= 0) continue;
                binds.put(name2, this._table.getValueAt(rowIndex, i));
            }
            for (String name2 : this._dbObject.getDictionary().keySet()) {
                if (query.getSql().indexOf(":" + name2) <= 0) continue;
                binds.put(name2, (String)this._dbObject.getDictionary().get(name2));
            }
            if (this._editor.getSubQueryType() != null && this._editor.getSubQueryType().equals("code")) {
                String code = DBUtil.getInstance().executeReturnOneCol(this._dbObject.getDatabase().getConnectionName(), query.getSql(), binds);
                this._subCodeArea.setEditable(true);
                this._subCodeArea.setText(code);
                this._subCodeArea.setEditable(false);
            } else {
                this._subTable.setQuery(this._dbObject.getDatabase().getConnection(), (ResultSet)null, query.getSql(), binds);
            }
            this._lastRow = rowIndex;
        }
    }

    private void createQueryEditor() {
        this._table = new ResultSetTable();
        this._table.setAutoResizeMode(0);
    }

    protected void updateContent() {
        this.updateContent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateContent(boolean force) {
        ((ViewerNode)this.getContext().getNode()).attach(new Observer(){

            public void update(Object observed, UpdateMessage change) {
            }
        });
        this._dbObject = this.getContext().getNode() instanceof ViewerNode ? ((ViewerNode)this.getContext().getNode()).getDBObject() : new DBObject(this.getContext().getNode());
        if (force || this._lastdbObject == null || !this._dbObject.getObjectName().equals(this._lastdbObject.getObjectName()) || !this._dbObject.getDatabase().getConnectionName().equals(this._dbObject.getDatabase().getConnectionName()) || !this._dbObject.getSchemaName().equals(this._dbObject.getSchemaName()) || this._dbObject.getSchemaObject() != this._lastdbObject.getSchemaObject()) {
            Query query = this._editor.getQuery(this._dbObject.getDatabase().getConnectionName());
            if (query == null) {
                if (!(this._table.getModel() instanceof DefaultTableModel)) {
                    this._table.closeModel();
                }
                DefaultTableModel mdl = (DefaultTableModel)this._table.getModel();
                this._table.setAutoResizeMode(3);
                mdl.setRowCount(0);
                mdl.setColumnCount(0);
                mdl.addColumn("");
                mdl.addColumn("Error");
                Object[] noQuery = new String[]{"", ""};
                try {
                    noQuery[1] = "No Valid query found for Database Version:" + this._dbObject.getDatabase().getConnection().getMetaData().getDatabaseMajorVersion() + "." + this._dbObject.getDatabase().getConnection().getMetaData().getDatabaseMinorVersion();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                mdl.addRow(noQuery);
                for (int i = 0; i < this._editor.getQueries().size(); ++i) {
                    noQuery[1] = "DB  Version:" + this._editor.getQueries().get(i).getMinversion() + "-" + this._editor.getQueries().get(i).getMaxversion();
                    mdl.addRow(noQuery);
                    noQuery[1] = this._editor.getQueries().get(i).getSql();
                    mdl.addRow(noQuery);
                }
            } else {
                HashMap binds = DBUtil.getInstance().getObjectBinds(query.getSql(), this._dbObject);
                if (this._editor.getDisplay() != null && this._editor.getDisplay().equals("code")) {
                    ResultSet rs = DBUtil.getInstance().executeQuery(this._dbObject.getDatabase().getConnectionName(), query.getSql(), binds);
                    StringBuilder sb = new StringBuilder();
                    try {
                        while (rs.next()) {
                            sb.append(rs.getString(1));
                        }
                    }
                    catch (SQLException e) {
                        ExceptionHandler.handleException((Exception)e);
                    }
                    finally {
                        try {
                            rs.getStatement().close();
                        }
                        catch (SQLException e) {}
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {}
                    }
                    this._codeArea.setEditable(true);
                    this._codeArea.setText(sb.toString());
                    this._codeArea.setEditable(false);
                } else {
                    Log.startTiming((String)"_table");
                    this._table.setVerticalDisplay(this._editor.getVertical());
                    this._table.setSkipCols(query.getSkipCols());
                    this._table.setQuery(this._dbObject.getDatabase().getConnection(), (ResultSet)null, query.getSql(), binds);
                    Log.stopTiming((String)"_table");
                    if (this._secondTable != null) {
                        Log.startTiming((String)"subTable");
                        query = this._editor.getBottomQuery(this._dbObject.getDatabase().getConnectionName());
                        binds = DBUtil.getInstance().getObjectBinds(query.getSql(), this._dbObject);
                        this._secondTable.setSkipCols(query.getSkipCols());
                        this._secondTable.setQuery(this._dbObject.getDatabase().getConnection(), (ResultSet)null, query.getSql(), binds);
                        Log.stopTiming((String)"subTable");
                    } else if (this._subTable != null) {
                        Log.startTiming((String)"sub");
                        Query subQuery = this._editor.getSubQuery(this._dbObject.getDatabase().getConnectionName());
                        this._subTable.setSkipCols(subQuery.getSkipCols());
                        this.execSubTable();
                        this._sp.setDividerLocation(0.5);
                        Log.stopTiming((String)"sub");
                    }
                }
                if (this._sp != null) {
                    this._sp.setDividerLocation(this._sp.getHeight() / 2);
                }
                this._lastdbObject = this._dbObject;
            }
        }
        if (this._sp != null) {
            if (this._table != null && this._sp.getTopComponent() instanceof JScrollPane) {
                ((JScrollPane)this._sp.getTopComponent()).setViewportView((Component)this._table);
            }
            if (this._secondTable != null && this._sp.getBottomComponent() instanceof JScrollPane) {
                ((JScrollPane)this._sp.getBottomComponent()).setViewportView((Component)this._secondTable);
            }
            if (this._subTable != null && this._sp.getBottomComponent() instanceof JScrollPane) {
                ((JScrollPane)this._sp.getBottomComponent()).setViewportView((Component)this._subTable);
            }
        }
    }

    public BasicEditorPane getFocusedEditorPane() {
        return this._codeArea;
    }

    public Object getPrintable() {
        if (this._sp != null) {
            if (this._secondTable != null && this._sp.getBottomComponent() instanceof JScrollPane) {
                return this._table.hasFocus() ? this._table : this._secondTable;
            }
            if (this._subTable != null && this._sp.getBottomComponent() instanceof JScrollPane) {
                return this._table.hasFocus() ? this._table : this._subTable;
            }
            if (this._subCodeArea != null && this._sp.getBottomComponent() instanceof JScrollPane) {
                return this._table.hasFocus() ? this._table : this._subCodeArea;
            }
        } else if (this._codeArea != null) {
            return this._codeArea;
        }
        return this._table;
    }

    public Database getDatabase() {
        return this._dbObject.getDatabase();
    }

    public Connection getConnection() {
        return this._dbObject.getDatabase().getConnection();
    }

    public void cleanUp() {
        if (this._table != null && this._table.getModel() instanceof ResultSetTableModel) {
            ((ResultSetTableModel)this._table.getModel()).close();
        }
        if (this._secondTable != null && this._secondTable.getModel() instanceof ResultSetTableModel) {
            ((ResultSetTableModel)this._secondTable.getModel()).close();
        }
        if (this._subTable != null && this._subTable.getModel() instanceof ResultSetTableModel) {
            ((ResultSetTableModel)this._subTable.getModel()).close();
        }
    }
}

