/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.oviewer.xmleditor;

import java.util.ArrayList;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEditor {
    private String _title;
    private String _subTitle;
    private Class _nodeClass;
    private Class _editorClass;
    private ArrayList<Query> _queries;
    private ArrayList<Query> _subQueries;
    private String _type;
    private boolean _vertical;
    private String _display;
    private ArrayList<Query> _bottomQueries;

    public void setTitle(String title) {
        this._title = title;
    }

    public void setNode(String nodeClass) throws ClassNotFoundException {
        this._nodeClass = this.getClass().getClassLoader().loadClass("oracle.jdeveloper.cm.dt.browser.jdbc." + nodeClass);
    }

    public void setQueries(ArrayList<Query> queries) {
        this._queries = queries;
    }

    public Query getQuery(String conn) {
        for (int i = 0; i < this._queries.size(); ++i) {
            if (!DBUtil.checkVersion((String)conn, (float)this._queries.get(i).getMaxversion(), (float)this._queries.get(i).getMinversion())) continue;
            return this._queries.get(i);
        }
        return null;
    }

    public Query getSubQuery(String conn) {
        for (int i = 0; i < this._subQueries.size(); ++i) {
            if (!DBUtil.checkVersion((String)conn, (float)this._subQueries.get(i).getMaxversion(), (float)this._subQueries.get(i).getMinversion())) continue;
            return this._subQueries.get(i);
        }
        return null;
    }

    public Query getBottomQuery(String conn) {
        for (int i = 0; i < this._bottomQueries.size(); ++i) {
            if (!DBUtil.checkVersion((String)conn, (float)this._bottomQueries.get(i).getMaxversion(), (float)this._bottomQueries.get(i).getMinversion())) continue;
            return this._bottomQueries.get(i);
        }
        return null;
    }

    public ArrayList<Query> getQueries() {
        return this._queries;
    }

    public ArrayList<Query> getSubQueries() {
        return this._subQueries;
    }

    public void setSubQueries(ArrayList<Query> queries) {
        this._subQueries = queries;
    }

    public Class getNodeClass() {
        return this._nodeClass;
    }

    public String getTitle() {
        return this._title;
    }

    public void setEditorClass(String editorClass) {
        if (editorClass != null) {
            try {
                this._editorClass = this.getClass().getClassLoader().loadClass(editorClass);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public Class getEditorClass() {
        return this._editorClass;
    }

    public void setSubQueryType(String type) {
        this._type = type;
    }

    public String getSubQueryType() {
        return this._type;
    }

    public void setVertical(String vertical) {
        this._vertical = Boolean.parseBoolean(vertical);
    }

    public boolean getVertical() {
        return this._vertical;
    }

    public void setDisplay(String display) {
        this._display = display;
    }

    public String getDisplay() {
        return this._display;
    }

    public void setBottomQueries(ArrayList<Query> queries) {
        this._bottomQueries = queries;
    }

    public ArrayList<Query> getBottomQueries() {
        return this._bottomQueries;
    }

    public void setSubTitle(String value) {
        this._subTitle = value;
    }

    public String getSubTitle() {
        return this._subTitle;
    }
}

