/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.sql.SQLException;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverterGB18030
extends CharacterConverter12Byte {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    protected static int MAXLIMIT = 64000;
    static final int BMPSTART = -2127527632;
    static final int BMPEND = -2077121479;
    static final int GBBMPSTART = 1687218;
    static final int GBBMPEND = 1726637;
    static final int USURSTART = 65536;
    static final int USUREND = 0x10FFFF;
    static final int GBSURSTART = 1876218;
    static final int GBSUREND = 2924793;
    static char[][] gbMapping = new char[][]{{'\u0080', '\u00a3', '\u0000', '#'}, {'\u00a5', '\u00a6', '$', '%'}, {'\u00a9', '\u00af', '&', ','}, {'\u00b2', '\u00b6', '-', '1'}, {'\u00b8', '\u00d6', '2', 'P'}, {'\u00d8', '\u00df', 'Q', 'X'}, {'\u00e2', '\u00e7', 'Y', '^'}, {'\u00eb', '\u00eb', '_', '_'}, {'\u00ee', '\u00f1', '`', 'c'}, {'\u00f4', '\u00f6', 'd', 'f'}, {'\u00f8', '\u00f8', 'g', 'g'}, {'\u00fb', '\u00fb', 'h', 'h'}, {'\u00fd', '\u0100', 'i', 'l'}, {'\u0102', '\u0112', 'm', '}'}, {'\u0114', '\u011a', '~', '\u0084'}, {'\u011c', '\u012a', '\u0085', '\u0093'}, {'\u012c', '\u0143', '\u0094', '\u00ab'}, {'\u0145', '\u0147', '\u00ac', '\u00ae'}, {'\u0149', '\u014c', '\u00af', '\u00b2'}, {'\u014e', '\u016a', '\u00b3', '\u00cf'}, {'\u016c', '\u01cd', '\u00d0', '\u0131'}, {'\u01cf', '\u01cf', '\u0132', '\u0132'}, {'\u01d1', '\u01d1', '\u0133', '\u0133'}, {'\u01d3', '\u01d3', '\u0134', '\u0134'}, {'\u01d5', '\u01d5', '\u0135', '\u0135'}, {'\u01d7', '\u01d7', '\u0136', '\u0136'}, {'\u01d9', '\u01d9', '\u0137', '\u0137'}, {'\u01db', '\u01db', '\u0138', '\u0138'}, {'\u01dd', '\u01f8', '\u0139', '\u0154'}, {'\u01fa', '\u0250', '\u0155', '\u01ab'}, {'\u0252', '\u0260', '\u01ac', '\u01ba'}, {'\u0262', '\u02c6', '\u01bb', '\u021f'}, {'\u02c8', '\u02c8', '\u0220', '\u0220'}, {'\u02cc', '\u02d8', '\u0221', '\u022d'}, {'\u02da', '\u0390', '\u022e', '\u02e4'}, {'\u03a2', '\u03a2', '\u02e5', '\u02e5'}, {'\u03aa', '\u03b0', '\u02e6', '\u02ec'}, {'\u03c2', '\u03c2', '\u02ed', '\u02ed'}, {'\u03ca', '\u0400', '\u02ee', '\u0324'}, {'\u0402', '\u040f', '\u0325', '\u0332'}, {'\u0450', '\u0450', '\u0333', '\u0333'}, {'\u0452', '\u200f', '\u0334', '\u1ef1'}, {'\u2011', '\u2012', '\u1ef2', '\u1ef3'}, {'\u2017', '\u2017', '\u1ef4', '\u1ef4'}, {'\u201a', '\u201b', '\u1ef5', '\u1ef6'}, {'\u201e', '\u2024', '\u1ef7', '\u1efd'}, {'\u2027', '\u202f', '\u1efe', '\u1f06'}, {'\u2031', '\u2031', '\u1f07', '\u1f07'}, {'\u2034', '\u2034', '\u1f08', '\u1f08'}, {'\u2036', '\u203a', '\u1f09', '\u1f0d'}, {'\u203c', '\u20ab', '\u1f0e', '\u1f7d'}, {'\u20ad', '\u2102', '\u1f7e', '\u1fd3'}, {'\u2104', '\u2104', '\u1fd4', '\u1fd4'}, {'\u2106', '\u2108', '\u1fd5', '\u1fd7'}, {'\u210a', '\u2115', '\u1fd8', '\u1fe3'}, {'\u2117', '\u2120', '\u1fe4', '\u1fed'}, {'\u2122', '\u215f', '\u1fee', '\u202b'}, {'\u216c', '\u216f', '\u202c', '\u202f'}, {'\u217a', '\u218f', '\u2030', '\u2045'}, {'\u2194', '\u2195', '\u2046', '\u2047'}, {'\u219a', '\u2207', '\u2048', '\u20b5'}, {'\u2209', '\u220e', '\u20b6', '\u20bb'}, {'\u2210', '\u2210', '\u20bc', '\u20bc'}, {'\u2212', '\u2214', '\u20bd', '\u20bf'}, {'\u2216', '\u2219', '\u20c0', '\u20c3'}, {'\u221b', '\u221c', '\u20c4', '\u20c5'}, {'\u2221', '\u2222', '\u20c6', '\u20c7'}, {'\u2224', '\u2224', '\u20c8', '\u20c8'}, {'\u2226', '\u2226', '\u20c9', '\u20c9'}, {'\u222c', '\u222d', '\u20ca', '\u20cb'}, {'\u222f', '\u2233', '\u20cc', '\u20d0'}, {'\u2238', '\u223c', '\u20d1', '\u20d5'}, {'\u223e', '\u2247', '\u20d6', '\u20df'}, {'\u2249', '\u224b', '\u20e0', '\u20e2'}, {'\u224d', '\u2251', '\u20e3', '\u20e7'}, {'\u2253', '\u225f', '\u20e8', '\u20f4'}, {'\u2262', '\u2263', '\u20f5', '\u20f6'}, {'\u2268', '\u226d', '\u20f7', '\u20fc'}, {'\u2270', '\u2294', '\u20fd', '\u2121'}, {'\u2296', '\u2298', '\u2122', '\u2124'}, {'\u229a', '\u22a4', '\u2125', '\u212f'}, {'\u22a6', '\u22be', '\u2130', '\u2148'}, {'\u22c0', '\u2311', '\u2149', '\u219a'}, {'\u2313', '\u245f', '\u219b', '\u22e7'}, {'\u246a', '\u2473', '\u22e8', '\u22f1'}, {'\u249c', '\u24ff', '\u22f2', '\u2355'}, {'\u254c', '\u254f', '\u2356', '\u2359'}, {'\u2574', '\u2580', '\u235a', '\u2366'}, {'\u2590', '\u2592', '\u2367', '\u2369'}, {'\u2596', '\u259f', '\u236a', '\u2373'}, {'\u25a2', '\u25b1', '\u2374', '\u2383'}, {'\u25b4', '\u25bb', '\u2384', '\u238b'}, {'\u25be', '\u25c5', '\u238c', '\u2393'}, {'\u25c8', '\u25ca', '\u2394', '\u2396'}, {'\u25cc', '\u25cd', '\u2397', '\u2398'}, {'\u25d0', '\u25e1', '\u2399', '\u23aa'}, {'\u25e6', '\u2604', '\u23ab', '\u23c9'}, {'\u2607', '\u2608', '\u23ca', '\u23cb'}, {'\u260a', '\u263f', '\u23cc', '\u2401'}, {'\u2641', '\u2641', '\u2402', '\u2402'}, {'\u2643', '\u2e80', '\u2403', '\u2c40'}, {'\u2e82', '\u2e83', '\u2c41', '\u2c42'}, {'\u2e85', '\u2e87', '\u2c43', '\u2c45'}, {'\u2e89', '\u2e8a', '\u2c46', '\u2c47'}, {'\u2e8d', '\u2e96', '\u2c48', '\u2c51'}, {'\u2e98', '\u2ea6', '\u2c52', '\u2c60'}, {'\u2ea8', '\u2ea9', '\u2c61', '\u2c62'}, {'\u2eab', '\u2ead', '\u2c63', '\u2c65'}, {'\u2eaf', '\u2eb2', '\u2c66', '\u2c69'}, {'\u2eb4', '\u2eb5', '\u2c6a', '\u2c6b'}, {'\u2eb8', '\u2eba', '\u2c6c', '\u2c6e'}, {'\u2ebc', '\u2ec9', '\u2c6f', '\u2c7c'}, {'\u2ecb', '\u2fef', '\u2c7d', '\u2da1'}, {'\u2ffc', '\u2fff', '\u2da2', '\u2da5'}, {'\u3004', '\u3004', '\u2da6', '\u2da6'}, {'\u3018', '\u301c', '\u2da7', '\u2dab'}, {'\u301f', '\u3020', '\u2dac', '\u2dad'}, {'\u302a', '\u303d', '\u2dae', '\u2dc1'}, {'\u303f', '\u3040', '\u2dc2', '\u2dc3'}, {'\u3094', '\u309a', '\u2dc4', '\u2dca'}, {'\u309f', '\u30a0', '\u2dcb', '\u2dcc'}, {'\u30f7', '\u30fb', '\u2dcd', '\u2dd1'}, {'\u30ff', '\u3104', '\u2dd2', '\u2dd7'}, {'\u312a', '\u321f', '\u2dd8', '\u2ecd'}, {'\u322a', '\u3230', '\u2ece', '\u2ed4'}, {'\u3232', '\u32a2', '\u2ed5', '\u2f45'}, {'\u32a4', '\u338d', '\u2f46', '\u302f'}, {'\u3390', '\u339b', '\u3030', '\u303b'}, {'\u339f', '\u33a0', '\u303c', '\u303d'}, {'\u33a2', '\u33c3', '\u303e', '\u305f'}, {'\u33c5', '\u33cd', '\u3060', '\u3068'}, {'\u33cf', '\u33d0', '\u3069', '\u306a'}, {'\u33d3', '\u33d4', '\u306b', '\u306c'}, {'\u33d6', '\u3446', '\u306d', '\u30dd'}, {'\u3448', '\u3472', '\u30de', '\u3108'}, {'\u3474', '\u359d', '\u3109', '\u3232'}, {'\u359f', '\u360d', '\u3233', '\u32a1'}, {'\u360f', '\u3619', '\u32a2', '\u32ac'}, {'\u361b', '\u3917', '\u32ad', '\u35a9'}, {'\u3919', '\u396d', '\u35aa', '\u35fe'}, {'\u396f', '\u39ce', '\u35ff', '\u365e'}, {'\u39d1', '\u39de', '\u365f', '\u366c'}, {'\u39e0', '\u3a72', '\u366d', '\u36ff'}, {'\u3a74', '\u3b4d', '\u3700', '\u37d9'}, {'\u3b4f', '\u3c6d', '\u37da', '\u38f8'}, {'\u3c6f', '\u3cdf', '\u38f9', '\u3969'}, {'\u3ce1', '\u4055', '\u396a', '\u3cde'}, {'\u4057', '\u415e', '\u3cdf', '\u3de6'}, {'\u4160', '\u4336', '\u3de7', '\u3fbd'}, {'\u4338', '\u43ab', '\u3fbe', '\u4031'}, {'\u43ad', '\u43b0', '\u4032', '\u4035'}, {'\u43b2', '\u43dc', '\u4036', '\u4060'}, {'\u43de', '\u44d5', '\u4061', '\u4158'}, {'\u44d7', '\u464b', '\u4159', '\u42cd'}, {'\u464d', '\u4660', '\u42ce', '\u42e1'}, {'\u4662', '\u4722', '\u42e2', '\u43a2'}, {'\u4724', '\u4728', '\u43a3', '\u43a7'}, {'\u472a', '\u477b', '\u43a8', '\u43f9'}, {'\u477d', '\u478c', '\u43fa', '\u4409'}, {'\u478e', '\u4946', '\u440a', '\u45c2'}, {'\u4948', '\u4979', '\u45c3', '\u45f4'}, {'\u497b', '\u497c', '\u45f5', '\u45f6'}, {'\u497e', '\u4981', '\u45f7', '\u45fa'}, {'\u4984', '\u4984', '\u45fb', '\u45fb'}, {'\u4987', '\u499a', '\u45fc', '\u460f'}, {'\u499c', '\u499e', '\u4610', '\u4612'}, {'\u49a0', '\u49b5', '\u4613', '\u4628'}, {'\u49b8', '\u4c76', '\u4629', '\u48e7'}, {'\u4c78', '\u4c9e', '\u48e8', '\u490e'}, {'\u4ca4', '\u4d12', '\u490f', '\u497d'}, {'\u4d1a', '\u4dad', '\u497e', '\u4a11'}, {'\u4daf', '\u4dff', '\u4a12', '\u4a62'}, {'\u9fa6', '\ud7ff', '\u4a63', '\u82bc'}, {'\ue76c', '\ue76c', '\u82bd', '\u82bd'}, {'\ue7c8', '\ue7c8', '\u82be', '\u82be'}, {'\ue7e7', '\ue7f3', '\u82bf', '\u82cb'}, {'\ue815', '\ue815', '\u82cc', '\u82cc'}, {'\ue819', '\ue81d', '\u82cd', '\u82d1'}, {'\ue81f', '\ue825', '\u82d2', '\u82d8'}, {'\ue827', '\ue82a', '\u82d9', '\u82dc'}, {'\ue82d', '\ue830', '\u82dd', '\u82e0'}, {'\ue833', '\ue83a', '\u82e1', '\u82e8'}, {'\ue83c', '\ue842', '\u82e9', '\u82ef'}, {'\ue844', '\ue853', '\u82f0', '\u82ff'}, {'\ue856', '\ue863', '\u8300', '\u830d'}, {'\ue865', '\uf92b', '\u830e', '\u93d4'}, {'\uf92d', '\uf978', '\u93d5', '\u9420'}, {'\uf97a', '\uf994', '\u9421', '\u943b'}, {'\uf996', '\uf9e6', '\u943c', '\u948c'}, {'\uf9e8', '\uf9f0', '\u948d', '\u9495'}, {'\uf9f2', '\ufa0b', '\u9496', '\u94af'}, {'\ufa10', '\ufa10', '\u94b0', '\u94b0'}, {'\ufa12', '\ufa12', '\u94b1', '\u94b1'}, {'\ufa15', '\ufa17', '\u94b2', '\u94b4'}, {'\ufa19', '\ufa1e', '\u94b5', '\u94ba'}, {'\ufa22', '\ufa22', '\u94bb', '\u94bb'}, {'\ufa25', '\ufa26', '\u94bc', '\u94bd'}, {'\ufa2a', '\ufe2f', '\u94be', '\u98c3'}, {'\ufe32', '\ufe32', '\u98c4', '\u98c4'}, {'\ufe45', '\ufe48', '\u98c5', '\u98c8'}, {'\ufe53', '\ufe53', '\u98c9', '\u98c9'}, {'\ufe58', '\ufe58', '\u98ca', '\u98ca'}, {'\ufe67', '\ufe67', '\u98cb', '\u98cb'}, {'\ufe6c', '\uff00', '\u98cc', '\u9960'}, {'\uff5f', '\uffdf', '\u9961', '\u99e1'}, {'\uffe6', '\uffee', '\u99e2', '\u99ea'}};

    public CharacterConverterGB18030() {
        this.m_groupId = 9;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 4.0f;
    }

    int toUnicode(int n) throws SQLException {
        if (this.bMPLinear(n) >= 39419) {
            int n2 = 1752754 + this.bMPLinear(n) - 1876218;
            return this.surrogateUcs4ToUtf16(n2);
        }
        if (n >> 16 != 0) {
            int n3 = this.bMPOracle2Unicode(n);
            if (n3 == 0) {
                throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
            }
            return n3;
        }
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        if (this.m_ucsCharLevel1[n4] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] == -1) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        int n6 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5];
        return n6;
    }

    int toUnicodeWithReplacement(int n) {
        if (this.bMPLinear(n) >= 39419) {
            int n2 = 1752754 + this.bMPLinear(n) - 1876218;
            return this.surrogateUcs4ToUtf16(n2);
        }
        if (n >> 16 != 0) {
            int n3 = this.bMPOracle2Unicode(n);
            if (n3 == 0) {
                n3 = this.m_ucsCharReplacement;
            }
            return n3;
        }
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int n6 = this.m_ucsCharLevel1[n4] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] : this.m_ucsCharReplacement;
        return n6;
    }

    int toOracleCharacterGB(char c, char c2) throws SQLException {
        int n;
        if (c2 != '\u0000') {
            int n2 = this.surrogateUtf16ToUcs4(c, c2);
            if (n2 >= 65536 && n2 <= 0x10FFFF) {
                return this.bMPunLinear(1876218 + (n2 - 65536) - 1687218);
            }
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
        int n3 = c >> 8 & 0xFF;
        int n4 = c & 0xFF;
        if (this.m_oraCharLevel1[n3] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n4] != '\uffff') {
            n = this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n4] & 0xFFFF;
        } else {
            n = this.bMPUnicode2Oracle(c);
            if (n == 0) {
                throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
            }
        }
        return n;
    }

    int toOracleCharacterWithReplacementGB(char c, char c2) {
        int n;
        if (c2 != '\u0000') {
            int n2 = this.surrogateUtf16ToUcs4(c, c2);
            if (n2 >= 65536 && n2 <= 0x10FFFF) {
                return this.bMPunLinear(1876218 + (n2 - 65536) - 1687218);
            }
            return this.m_2ByteOraCharReplacement;
        }
        int n3 = c >> 8 & 0xFF;
        int n4 = c & 0xFF;
        if (this.m_oraCharLevel1[n3] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n4] != '\uffff') {
            n = this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n4] & 0xFFFF;
        } else {
            n = this.bMPUnicode2Oracle(c);
            if (n == 0) {
                if (c > '\u2fff') {
                    return this.m_2ByteOraCharReplacement;
                }
                return this.m_1ByteOraCharReplacement;
            }
        }
        return n;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = n;
        while (n4 < n3) {
            int n5 = byArray[n4] & 0xFF;
            if (n5 > 127) {
                if (n4 + 1 < n3) {
                    if ((byArray[n4] & 0xFF) >= 129 && (byArray[n4] & 0xFF) <= 254 && (byArray[n4 + 1] & 0xFF) >= 48 && (byArray[n4 + 1] & 0xFF) <= 57) {
                        if (n4 + 3 < n3 && (byArray[n4 + 2] & 0xFF) >= 129 && (byArray[n4 + 2] & 0xFF) <= 254 && (byArray[n4 + 3] & 0xFF) >= 48 && (byArray[n4 + 3] & 0xFF) <= 57) {
                            n5 = (byArray[n4] & 0xFF) << 24 | (byArray[n4 + 1] & 0xFF) << 16 | (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
                            n4 += 4;
                            int n6 = this.toUnicode(n5);
                            if (n6 >> 16 == 0) {
                                stringBuffer.append((char)n6);
                                continue;
                            }
                            stringBuffer.append((char)(n6 >> 16 & 0xFFFF));
                            stringBuffer.append((char)(n6 & 0xFFFF));
                            continue;
                        }
                        throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
                    }
                    n5 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
                    stringBuffer.append((char)this.toUnicode(n5));
                    n4 += 2;
                    continue;
                }
                throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
            }
            stringBuffer.append((char)this.toUnicode(n5));
            ++n4;
        }
        return stringBuffer.toString();
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = n;
        while (n4 < n3) {
            int n5 = byArray[n4] & 0xFF;
            if (n5 > 127) {
                if (n4 + 1 < n3) {
                    if ((byArray[n4] & 0xFF) >= 129 && (byArray[n4] & 0xFF) <= 254 && (byArray[n4 + 1] & 0xFF) >= 48 && (byArray[n4 + 1] & 0xFF) <= 57) {
                        if (n4 + 3 < n3 && (byArray[n4 + 2] & 0xFF) >= 129 && (byArray[n4 + 2] & 0xFF) <= 254 && (byArray[n4 + 3] & 0xFF) >= 48 && (byArray[n4 + 3] & 0xFF) <= 57) {
                            n5 = (byArray[n4] & 0xFF) << 24 | (byArray[n4 + 1] & 0xFF) << 16 | (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
                            n4 += 4;
                            int n6 = this.toUnicodeWithReplacement(n5);
                            if (n6 >> 16 == 0) {
                                stringBuffer.append((char)n6);
                                continue;
                            }
                            stringBuffer.append((char)(n6 >> 16 & 0xFFFF));
                            stringBuffer.append((char)(n6 & 0xFFFF));
                            continue;
                        }
                        stringBuffer.append((char)this.m_ucsCharReplacement);
                        n4 += 4;
                        continue;
                    }
                    n5 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
                    stringBuffer.append((char)this.toUnicodeWithReplacement(n5));
                    n4 += 2;
                    continue;
                }
                stringBuffer.append((char)this.m_ucsCharReplacement);
                ++n4;
                continue;
            }
            stringBuffer.append((char)this.toUnicodeWithReplacement(n5));
            ++n4;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            if (cArray[i] >= '\ud800' && cArray[i] < '\udc00') {
                if (i + 1 >= n || cArray[i + 1] < '\udc00' || cArray[i + 1] > '\udfff') throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
                n3 = this.toOracleCharacterWithReplacementGB(cArray[i], cArray[i + 1]);
                ++i;
            } else {
                n3 = this.toOracleCharacterGB(cArray[i], '\u0000');
            }
            if (n3 >> 16 != 0) {
                byArray[n2++] = (byte)(n3 >> 24);
                byArray[n2++] = (byte)(n3 >> 16);
                byArray[n2++] = (byte)(n3 >> 8);
                byArray[n2++] = (byte)n3;
                continue;
            }
            if (n3 >> 8 != 0) {
                byArray[n2++] = (byte)(n3 >> 8);
                byArray[n2++] = (byte)n3;
                continue;
            }
            byArray[n2++] = (byte)n3;
        }
        if (n2 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            block8: {
                if (cArray[i] >= '\ud800' && cArray[i] <= '\udbff') {
                    if (i + 1 < n && cArray[i + 1] >= '\udc00' && cArray[i + 1] <= '\udfff') {
                        n3 = this.toOracleCharacterWithReplacementGB(cArray[i], cArray[i + 1]);
                        ++i;
                        break block8;
                    } else {
                        byArray[n2++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray[n2++] = (byte)this.m_2ByteOraCharReplacement;
                        continue;
                    }
                }
                n3 = this.toOracleCharacterWithReplacementGB(cArray[i], '\u0000');
            }
            if (n3 >> 16 != 0) {
                byArray[n2++] = (byte)(n3 >> 24);
                byArray[n2++] = (byte)(n3 >> 16);
                byArray[n2++] = (byte)(n3 >> 8);
                byArray[n2++] = (byte)n3;
                continue;
            }
            if (n3 >> 8 != 0) {
                byArray[n2++] = (byte)(n3 >> 8);
                byArray[n2++] = (byte)n3;
                continue;
            }
            byArray[n2++] = (byte)n3;
        }
        if (n2 < byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    private int surrogateUtf16ToUcs4(char c, char c2) {
        return ((0x3FF & c) << 10 | c2 & 0x3FF) + 65536;
    }

    private int surrogateUcs4ToUtf16(int n) {
        return (n - 65536 >> 10 | 0xD800) << 16 | (n & 0x3FF | 0xDC00);
    }

    private int bMPUnicode2Oracle(char c) {
        int n = this.searchgbMapping(c, true);
        if (n == -1) {
            return 0;
        }
        return this.bMPunLinear(n);
    }

    private int bMPOracle2Unicode(int n) {
        int n2 = this.searchgbMapping((char)this.bMPLinear(n), false);
        if (n2 == -1) {
            return 0;
        }
        return n2;
    }

    private int bMPLinear(int n) {
        return (((n >> 24 & 0xFF) * 10 + (n >> 16 & 0xFF)) * 126 + (n >> 8 & 0xFF)) * 10 + (n & 0xFF) - 1687218;
    }

    private int bMPunLinear(int n) {
        int n2 = 0;
        n2 = 48 + n % 10 & 0xFF;
        n2 += (129 + (n /= 10) % 126 & 0xFF) << 8;
        n2 += (48 + (n /= 126) % 10 & 0xFF) << 16;
        return n2 += (129 + (n /= 10) & 0xFF) << 24;
    }

    private int searchgbMapping(char c, boolean bl) {
        int n;
        int n2;
        int n3;
        if (bl) {
            n3 = 1;
            n2 = 0;
            n = 2;
        } else {
            n3 = 3;
            n2 = 2;
            n = 0;
        }
        int n4 = gbMapping.length - 1;
        int n5 = 0;
        while (n4 >= n5) {
            int n6 = (n4 + n5) / 2;
            if (gbMapping[n6][n2] <= c && c <= gbMapping[n6][n3]) {
                return c - gbMapping[n6][n2] + gbMapping[n6][n];
            }
            if (c < gbMapping[n6][n2]) {
                n4 = n6 - 1;
                continue;
            }
            if (c <= gbMapping[n6][n3]) continue;
            n5 = n6 + 1;
        }
        return -1;
    }

    public void buildUnicodeToOracleMapping() {
        int n;
        int n2;
        int n3;
        this.m_oraCharLevel1 = new int[256];
        char[] cArray = new char[MAXLIMIT];
        int n4 = 0;
        int[][] nArray = new int[MAXLIMIT][2];
        int n5 = 0;
        for (n3 = 0; n3 < 256; ++n3) {
            this.m_oraCharLevel1[n3] = -1;
        }
        for (n3 = 0; n3 < MAXLIMIT; ++n3) {
            cArray[n3] = 65535;
        }
        for (n3 = 0; n3 < 65535; ++n3) {
            try {
                nArray[n5][0] = this.toUnicode(n3);
                nArray[n5][1] = n3;
                ++n5;
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3][0] >>> 8 & 0xFF;
            n = nArray[n3][0] & 0xFF;
            if (this.m_oraCharLevel1[n2] == -1) {
                this.m_oraCharLevel1[n2] = n4;
                n4 += 256;
            }
            if (cArray[this.m_oraCharLevel1[n2] + n] != '\uffff') continue;
            cArray[this.m_oraCharLevel1[n2] + n] = (char)(nArray[n3][1] & 0xFFFF);
        }
        if (this.extraUnicodeToOracleMapping != null) {
            int n6 = this.extraUnicodeToOracleMapping.length;
            for (n3 = 0; n3 < n6; ++n3) {
                int n7 = this.extraUnicodeToOracleMapping[n3][0];
                n2 = n7 >>> 8 & 0xFF;
                n = n7 & 0xFF;
                n2 = nArray[n3][0] >>> 8 & 0xFF;
                n = nArray[n3][0] & 0xFF;
                if (this.m_oraCharLevel1[n2] == -1) {
                    this.m_oraCharLevel1[n2] = n4;
                    n4 += 256;
                }
                if (cArray[this.m_oraCharLevel1[n2] + n] != '\uffff') continue;
                cArray[this.m_oraCharLevel1[n2] + n] = (char)(nArray[n3][1] & 0xFFFF);
            }
        }
        this.m_oraCharLevel2 = new char[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.m_oraCharLevel2[n3] = cArray[n3];
        }
    }

    public void extractCodepoints(Vector vector) {
        int n = 0;
        int n2 = 65535;
        for (int i = n; i <= n2; ++i) {
            try {
                int[] nArray = new int[]{i, (char)this.toUnicode(i)};
                vector.addElement(nArray);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        for (int i = 0; i < this.extraUnicodeToOracleMapping.length; ++i) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[i][0], this.extraUnicodeToOracleMapping[i][1]};
            vector.addElement(nArray);
        }
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    public static void main(String[] stringArray) throws SQLException {
        CharacterConverterGB18030 characterConverterGB18030 = new CharacterConverterGB18030();
        System.out.println(characterConverterGB18030.bMPLinear(-2127527632));
        System.out.println(characterConverterGB18030.bMPunLinear(characterConverterGB18030.bMPLinear(-2127527632)));
        System.out.println(characterConverterGB18030.bMPLinear(-1875869392));
        System.out.println(characterConverterGB18030.bMPunLinear(characterConverterGB18030.bMPLinear(-1875869392)));
        System.out.println(characterConverterGB18030.bMPUnicode2Oracle('\u0080'));
        System.out.println(characterConverterGB18030.bMPOracle2Unicode(-2127525063));
        System.out.println((int)characterConverterGB18030.toOracleCharacterWithReplacement('\ud800', '\udc00'));
        System.out.println((int)characterConverterGB18030.toOracleCharacterWithReplacement('\udbff', '\udfff'));
        System.out.println((int)characterConverterGB18030.toOracleCharacter('\ud800', '\udc00'));
        System.out.println((int)characterConverterGB18030.toOracleCharacter('\udbff', '\udfff'));
        System.out.println(characterConverterGB18030.toUnicode(-1875869392));
        System.out.println(characterConverterGB18030.toUnicode(-483222987));
    }
}

