/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.CharConvBuilder;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import oracle.i18n.util.CharConvBuilder.TokenParser;

public class CharDataParser
extends TokenParser {
    private static final boolean DEBUG = false;
    static final int DEFAULT_UCS_REPLACEMENT = 65533;
    String m_charSetName = null;
    int m_charSetId = 0;
    int m_oraCharReplacement = 0;
    int m_defaultMultibyteReplacementChar = 0;
    boolean m_haveExtraUnicodeMapping = false;

    CharDataParser() {
    }

    CharDataParser(FileInputStream fileInputStream) throws IOException {
        this();
        int n;
        StreamTokenizer streamTokenizer = CharDataParser.getTokenizer(fileInputStream);
        boolean bl = false;
        int n2 = 0;
        String string = "";
        int n3 = 1;
        block15: while ((n = streamTokenizer.nextToken()) != -1 && !bl) {
            switch (n2) {
                case 0: 
                case 2: {
                    if (n == -3 || n == 34) {
                        string = string + streamTokenizer.sval;
                        n2 = 1;
                        n3 = 1;
                        continue block15;
                    }
                    n2 = CharDataParser.processSyntaxError(streamTokenizer, n3);
                    string = "";
                    continue block15;
                }
                case 1: {
                    switch (n) {
                        case 95: {
                            string = string + (char)n;
                            n2 = 2;
                            continue block15;
                        }
                        case 61: {
                            n2 = 3;
                            continue block15;
                        }
                        case -3: {
                            CharDataParser.skipToEndOfDelimiter(streamTokenizer, n3);
                            n2 = 0;
                            string = "";
                            continue block15;
                        }
                    }
                    n2 = CharDataParser.processSyntaxError(streamTokenizer, n3);
                    string = "";
                    continue block15;
                }
                case 3: {
                    switch (n) {
                        case -3: 
                        case 34: {
                            if (string.compareTo("name") == 0) {
                                this.m_charSetName = streamTokenizer.sval;
                                bl = this.checkAllData();
                            }
                            CharDataParser.skipToEol(streamTokenizer);
                            n2 = 0;
                            string = "";
                            continue block15;
                        }
                        case -2: {
                            int n4 = (int)streamTokenizer.nval;
                            if (string.compareTo("id") == 0) {
                                this.m_charSetId = n4;
                                bl = this.checkAllData();
                            } else if (string.compareTo("default_replacement_char") == 0) {
                                this.m_oraCharReplacement = n4 == 0 ? CharDataParser.getInteger(streamTokenizer) : n4;
                                bl = this.checkAllData();
                            } else if (string.compareTo("default_multibyte_replacement_char") == 0) {
                                this.m_defaultMultibyteReplacementChar = n4 == 0 ? CharDataParser.getInteger(streamTokenizer) : n4;
                                bl = this.checkAllData();
                            }
                            CharDataParser.skipToEol(streamTokenizer);
                            n2 = 0;
                            string = "";
                            continue block15;
                        }
                        case 123: {
                            if (string.compareTo("replacement_chars") == 0) {
                                this.m_haveExtraUnicodeMapping = true;
                            }
                            n3 = 2;
                            CharDataParser.skipToEndOfDelimiter(streamTokenizer, n3);
                            n2 = 0;
                            string = "";
                            continue block15;
                        }
                    }
                    n2 = CharDataParser.processSyntaxError(streamTokenizer, n3);
                    string = "";
                    continue block15;
                }
            }
            n2 = CharDataParser.processSyntaxError(streamTokenizer, n3);
            string = "";
        }
    }

    boolean checkAllData() {
        return this.m_charSetName != null && this.m_charSetId != 0 && this.m_oraCharReplacement != 0 && this.m_defaultMultibyteReplacementChar != 0 && this.m_haveExtraUnicodeMapping;
    }

    String getCharSetName() {
        return this.m_charSetName;
    }

    int getCharSetId() {
        return this.m_charSetId;
    }

    String getCharSetIdHex() {
        return Integer.toHexString(this.m_charSetId);
    }

    int getUcsReplacement() {
        return 65533;
    }

    int getOraCharReplacement() {
        return this.m_oraCharReplacement;
    }

    int get2ByteOraCharReplacement() {
        if (this.m_defaultMultibyteReplacementChar == 0) {
            return this.m_oraCharReplacement;
        }
        return this.m_defaultMultibyteReplacementChar;
    }

    boolean haveExtraUnicodeMapping() {
        return this.m_haveExtraUnicodeMapping;
    }
}

