/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.util.ConverterArchive;
import oracle.i18n.util.builder.CharConvBuilder;
import oracle.i18n.util.builder.CharSetParser;
import oracle.i18n.util.builder.NLTParserException;
import oracle.sql.converter.CharacterConverters;

public class CharConv12ByteBuilder
extends CharConvBuilder {
    static final boolean DEBUG = false;
    static final int MAXCHARVALUE = 65535;
    CharacterConverter12Byte charConv12ByteObj = null;

    public CharConv12ByteBuilder() {
        this.charConv12ByteObj = new CharacterConverter12Byte();
    }

    protected CharConv12ByteBuilder(CharacterConverter12Byte characterConverter12Byte) {
        this.charConv12ByteObj = characterConverter12Byte;
    }

    public void buildGLB(CharacterConverters characterConverters, String string, String string2, String string3, boolean bl) throws IOException {
        try {
            int n;
            CharSetParser charSetParser = new CharSetParser(string3);
            String string4 = charSetParser.getName();
            this.charConv12ByteObj.m_oracleId = Integer.parseInt(charSetParser.getId());
            this.charConv12ByteObj.m_ucsCharReplacement = 65533;
            String string5 = charSetParser.getDefaultReplacementChar();
            if (string5 != null) {
                n = CharConv12ByteBuilder.stringToInt(string5);
                if (((long)n & 0xFFFFFFFFL) > 255L) {
                    throw new NLTParserException("ReplacementChar too big");
                }
                this.charConv12ByteObj.m_1ByteOraCharReplacement = (char)(n & 0xFF);
            }
            if ((string5 = charSetParser.getDefaultMultibyteReplacementChar()) != null) {
                n = CharConv12ByteBuilder.stringToInt(string5);
                if (((long)n & 0xFFFFFFFFL) > 65535L) {
                    throw new NLTParserException("ReplacementChar too big");
                }
                this.charConv12ByteObj.m_2ByteOraCharReplacement = (char)(n & 0xFFFF);
            }
            if (string4 == null || this.charConv12ByteObj.m_oracleId == 0) {
                System.err.println("Missing data in file " + string3);
                System.err.println("No output file created");
                return;
            }
            boolean bl2 = charSetParser.haveExtraUnicodeMapping();
            String string6 = CharConv12ByteBuilder.formatCharConvClassName(this.charConv12ByteObj.m_oracleId);
            if (characterConverters != null) {
                if (this.charConv12ByteObj.m_ucsCharReplacement == 0) {
                    this.charConv12ByteObj.m_ucsCharReplacement = characterConverters.getUCS2CharRep();
                }
                if (this.charConv12ByteObj.m_1ByteOraCharReplacement == '\u0000') {
                    this.charConv12ByteObj.m_1ByteOraCharReplacement = characterConverters.getOraChar1ByteRep();
                }
                if (this.charConv12ByteObj.m_2ByteOraCharReplacement == '\u0000') {
                    this.charConv12ByteObj.m_2ByteOraCharReplacement = characterConverters.getOraChar2ByteRep();
                }
            }
            if (this.charConv12ByteObj.m_1ByteOraCharReplacement == '\u0000') {
                this.charConv12ByteObj.m_1ByteOraCharReplacement = (char)63;
            }
            if (this.charConv12ByteObj.m_2ByteOraCharReplacement == '\u0000') {
                this.charConv12ByteObj.m_2ByteOraCharReplacement = this.charConv12ByteObj.m_1ByteOraCharReplacement;
            }
            this.setUcsChar(charSetParser, characterConverters);
            this.setExtraUnicodeMapping(charSetParser, characterConverters);
            if (this.charConv12ByteObj != null) {
                ConverterArchive converterArchive = new ConverterArchive();
                try {
                    if (bl) {
                        converterArchive.insertObjtoFile(string, string6 + ".glb", this.charConv12ByteObj);
                    } else {
                        converterArchive.insertSingleObj(string2, this.charConv12ByteObj, "/oracle/i18n/data/" + string6 + ".glb");
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                    return;
                }
            }
            return;
        }
        catch (NLTParserException nLTParserException) {
            System.out.println(nLTParserException.getMessage());
            return;
        }
    }

    private void setExtraUnicodeMapping(CharSetParser charSetParser, CharacterConverters characterConverters) throws NLTParserException {
        Vector vector;
        Vector vector2 = new Vector();
        if (characterConverters != null) {
            characterConverters.extractExtraMappings(vector2);
        }
        if (this.charConv12ByteObj.extraUnicodeToOracleMapping != null) {
            this.charConv12ByteObj.extractExtraMappings(vector2);
        }
        if ((vector = charSetParser.getReplacementChars()) != null) {
            int n = vector.size();
            try {
                for (int i = 0; i < n; ++i) {
                    Object[] objectArray = (Object[])vector.elementAt(i);
                    int n2 = ((int[])objectArray[0])[0];
                    int n3 = ((int[])objectArray[1])[0];
                    this.setExtraUnicodeMappingPair(n2, n3, vector2);
                }
            }
            catch (IOException iOException) {
                throw new NLTParserException("bad number");
            }
        }
        this.finishExtraUnicodeMapping(vector2);
    }

    private void setExtraUnicodeMappingPair(int n, int n2, Vector vector) throws IOException {
        int[] nArray = new int[]{n = (int)CharConv12ByteBuilder.convertUTF32toUTF16((long)n & 0xFFFFFFFFL), n2};
        vector.addElement(nArray);
    }

    private void finishExtraUnicodeMapping(Vector vector) {
        int n = 0;
        int[] nArray = null;
        int n2 = vector.size();
        this.charConv12ByteObj.extraUnicodeToOracleMapping = new int[n2][2];
        for (n = 0; n < vector.size(); ++n) {
            nArray = (int[])vector.elementAt(n);
            this.charConv12ByteObj.extraUnicodeToOracleMapping[n][0] = nArray[0];
            this.charConv12ByteObj.extraUnicodeToOracleMapping[n][1] = nArray[1];
        }
    }

    public void setUcsChar(CharSetParser charSetParser, CharacterConverters characterConverters) throws NLTParserException {
        Vector vector = new Vector();
        try {
            int n;
            Vector vector2;
            if (characterConverters != null) {
                vector2 = new Vector(65535, 28671);
                characterConverters.extractCodepoints(vector2);
                for (n = 0; n < vector2.size(); ++n) {
                    int[] nArray = (int[])vector2.elementAt(n);
                    this.setUcsCharPair(nArray[0], nArray[1], vector);
                }
            }
            vector2 = charSetParser.getCharacterData();
            int n2 = vector2.size();
            for (n = 0; n < n2; ++n) {
                Object[] objectArray = (Object[])vector2.elementAt(n);
                int n3 = ((int[])objectArray[0])[0];
                int n4 = ((int[])objectArray[1])[0];
                this.setUcsCharPair(n3, n4, vector);
            }
            this.finishUcsChar(vector);
        }
        catch (IOException iOException) {
            throw new NLTParserException("bad number");
        }
    }

    private void setUcsCharPair(int n, int n2, Vector vector) throws IOException {
        if (n > 65535) {
            System.err.println("***** Error: source code point " + Integer.toHexString(n) + " is too big for 1-2 byte converter");
            return;
        }
        if ((n2 = (int)CharConv12ByteBuilder.convertUTF32toUTF16((long)n2 & 0xFFFFFFFFL)) == 65533) {
            return;
        }
        int[] nArray = new int[]{n, n2};
        vector.addElement(nArray);
    }

    private void finishUcsChar(Vector vector) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        int n7 = 8;
        int n8 = 8;
        int n9 = (1 << n7) - 1;
        int n10 = (1 << n8) - 1;
        int n11 = 1 << n7;
        char[] cArray = new char[n11];
        char[][] cArray2 = new char[n11][2];
        for (n6 = 0; n6 < n11; ++n6) {
            cArray[n6] = 65535;
            cArray2[n6][0] = (char)n10;
            cArray2[n6][1] = '\u0000';
        }
        int n12 = vector.size();
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        for (n6 = 0; n6 < n12; ++n6) {
            nArray = (int[])vector.elementAt(n6);
            n5 = nArray[1];
            if (n5 == -1) continue;
            n4 = nArray[0];
            if (hashtable.get(new Integer(n5)) == null) {
                hashtable.put(new Integer(n5), new Integer(n4));
            } else {
                hashtable2.put(new Integer(n5), hashtable.get(new Integer(n5)));
            }
            n3 = n4 >> n8 & n9;
            cArray[n3] = '\u0001';
            n2 = n4 & n10;
            if (n2 < cArray2[n3][0]) {
                cArray2[n3][0] = (char)n2;
            }
            if (n2 <= cArray2[n3][1]) continue;
            cArray2[n3][1] = (char)n2;
        }
        int n13 = n = n10 + 1;
        int n14 = 0;
        for (n6 = 0; n6 < n11; ++n6) {
            if (cArray[n6] == '\uffff') continue;
            int n15 = cArray2[n6][0];
            cArray[n6] = (char)(n13 - (n14 < n15 ? n14 : n15));
            n13 = cArray[n6] + n;
            n14 = n - cArray2[n6][1] - 1;
        }
        int[] nArray2 = new int[n13];
        for (n6 = 0; n6 < n13; ++n6) {
            nArray2[n6] = -1;
        }
        n12 = vector.size();
        for (n6 = 0; n6 < n12; ++n6) {
            nArray = (int[])vector.elementAt(n6);
            n5 = nArray[1];
            if (n5 == -1) continue;
            n4 = nArray[0];
            n3 = n4 >> n8 & n9;
            n2 = n4 & n10;
            int n16 = cArray[n3] + n2;
            nArray2[n16] = n5;
        }
        this.setArray2(nArray2);
        this.setArray(cArray);
        this.setDuplicateMapping(hashtable2);
    }

    void setArray2(int[] nArray) {
        int n = nArray.length;
        this.charConv12ByteObj.m_ucsCharLevel2 = new int[n];
        for (int i = 0; i < n; ++i) {
            this.charConv12ByteObj.m_ucsCharLevel2[i] = nArray[i];
        }
    }

    void setArray(char[] cArray) {
        int n = cArray.length;
        this.charConv12ByteObj.m_ucsCharLevel1 = new char[n];
        for (int i = 0; i < n; ++i) {
            this.charConv12ByteObj.m_ucsCharLevel1[i] = cArray[i];
        }
    }

    void setDuplicateMapping(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        this.charConv12ByteObj.extraUnicodeToOracleMapping = new int[hashtable.size()][2];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.charConv12ByteObj.extraUnicodeToOracleMapping[n][0] = (Integer)k;
            this.charConv12ByteObj.extraUnicodeToOracleMapping[n++][1] = (Integer)hashtable.get(k);
        }
    }
}

