/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverterLCFixed;
import oracle.i18n.util.ConverterArchive;
import oracle.i18n.util.builder.CharConvBuilder;
import oracle.i18n.util.builder.CharSetParser;
import oracle.i18n.util.builder.NLTParserException;
import oracle.sql.converter.CharacterConverters;

public class CharConvLCFixedBuilder
extends CharConvBuilder {
    static final boolean DEBUG = false;
    static final int LCSHIFT = 16;
    static final int LCMASK = 65535;
    static final int INVALIDLC = 65535;
    static final long MAXCHARVALUE = 0xFFFFFFFFL;
    int m_l1BlockSize;
    char[] m_leadingCode;
    int m_lcCount;
    CharacterConverterLCFixed charConvLCFixedObj = new CharacterConverterLCFixed();

    public void buildGLB(CharacterConverters characterConverters, String string, String string2, String string3, boolean bl) throws IOException {
        try {
            CharSetParser charSetParser = new CharSetParser(string3);
            String string4 = charSetParser.getName();
            int n = 0;
            this.charConvLCFixedObj.m_oracleId = Integer.parseInt(charSetParser.getId());
            this.charConvLCFixedObj.m_ucsCharReplacement = 65533;
            String string5 = charSetParser.getDefaultMultibyteReplacementChar();
            if (string5 != null) {
                n = CharConvLCFixedBuilder.stringToInt(string5);
                if (((long)n & 0xFFFFFFFFL) > 0xFFFFFFFFL) {
                    throw new NLTParserException("ReplacementChar too big");
                }
                this.charConvLCFixedObj.m_1ByteOraCharReplacement = this.charConvLCFixedObj.m_2ByteOraCharReplacement = (char)((long)n & 0xFFFFFFFFL);
                this.charConvLCFixedObj.m_4ByteOraCharReplacement = this.charConvLCFixedObj.m_2ByteOraCharReplacement;
            }
            if (string4 == null || this.charConvLCFixedObj.m_oracleId == 0) {
                System.err.println("Missing data in file " + string3);
                System.err.println("No output file created");
                return;
            }
            boolean bl2 = charSetParser.haveExtraUnicodeMapping();
            String string6 = CharConvLCFixedBuilder.formatCharConvClassName(this.charConvLCFixedObj.m_oracleId);
            if (characterConverters != null) {
                if (this.charConvLCFixedObj.m_ucsCharReplacement == 0) {
                    this.charConvLCFixedObj.m_ucsCharReplacement = characterConverters.getUCS2CharRep();
                }
                if (this.charConvLCFixedObj.m_2ByteOraCharReplacement == '\u0000') {
                    this.charConvLCFixedObj.m_1ByteOraCharReplacement = characterConverters.getOraChar2ByteRep();
                    this.charConvLCFixedObj.m_2ByteOraCharReplacement = characterConverters.getOraChar2ByteRep();
                    this.charConvLCFixedObj.m_4ByteOraCharReplacement = characterConverters.getOraChar2ByteRep();
                }
            }
            if (this.charConvLCFixedObj.m_1ByteOraCharReplacement == '\u0000') {
                this.charConvLCFixedObj.m_1ByteOraCharReplacement = (char)63;
            }
            if (this.charConvLCFixedObj.m_2ByteOraCharReplacement == '\u0000') {
                this.charConvLCFixedObj.m_2ByteOraCharReplacement = this.charConvLCFixedObj.m_1ByteOraCharReplacement;
            }
            if (this.charConvLCFixedObj.m_4ByteOraCharReplacement == 0) {
                this.charConvLCFixedObj.m_4ByteOraCharReplacement = this.charConvLCFixedObj.m_2ByteOraCharReplacement;
            }
            this.setUcsChar(charSetParser, characterConverters);
            this.setExtraUnicodeMapping(charSetParser, characterConverters);
            if (this.charConvLCFixedObj != null) {
                ConverterArchive converterArchive = new ConverterArchive();
                try {
                    if (bl) {
                        converterArchive.insertObjtoFile(string, string6 + ".glb", this.charConvLCFixedObj);
                    } else {
                        converterArchive.insertSingleObj(string2, this.charConvLCFixedObj, "/oracle/i18n/data/" + string6 + ".glb");
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                    return;
                }
            }
            return;
        }
        catch (NLTParserException nLTParserException) {
            System.out.println(nLTParserException.getMessage());
            return;
        }
    }

    private void setExtraUnicodeMapping(CharSetParser charSetParser, CharacterConverters characterConverters) throws NLTParserException {
        Vector vector;
        Vector vector2 = new Vector();
        if (characterConverters != null) {
            characterConverters.extractExtraMappings(vector2);
        }
        if (this.charConvLCFixedObj.extraUnicodeToOracleMapping != null) {
            this.charConvLCFixedObj.extractExtraMappings(vector2);
        }
        if ((vector = charSetParser.getReplacementChars()) != null) {
            int n = vector.size();
            try {
                for (int i = 0; i < n; ++i) {
                    Object[] objectArray = (Object[])vector.elementAt(i);
                    int n2 = ((int[])objectArray[0])[0];
                    int n3 = ((int[])objectArray[1])[0];
                    this.setExtraUnicodeMappingPair(n2, n3, vector2);
                }
            }
            catch (IOException iOException) {
                throw new NLTParserException("bad number");
            }
        }
        this.finishExtraUnicodeMapping(vector2);
    }

    private void setExtraUnicodeMappingPair(int n, int n2, Vector vector) throws IOException {
        int[] nArray = new int[]{n = (int)CharConvLCFixedBuilder.convertUTF32toUTF16((long)n & 0xFFFFFFFFL), n2};
        vector.addElement(nArray);
    }

    private void finishExtraUnicodeMapping(Vector vector) {
        int n = 0;
        int[] nArray = null;
        int n2 = vector.size();
        this.charConvLCFixedObj.extraUnicodeToOracleMapping = new int[n2][2];
        for (n = 0; n < vector.size(); ++n) {
            nArray = (int[])vector.elementAt(n);
            this.charConvLCFixedObj.extraUnicodeToOracleMapping[n][0] = nArray[0];
            this.charConvLCFixedObj.extraUnicodeToOracleMapping[n][1] = nArray[1];
        }
    }

    private void setUcsChar(CharSetParser charSetParser, CharacterConverters characterConverters) throws NLTParserException {
        try {
            int n;
            Vector vector;
            this.m_l1BlockSize = 256;
            this.m_leadingCode = new char[]{'\uffff', '\uffff', '\uffff', '\uffff'};
            Vector[] vectorArray = new Vector[this.m_leadingCode.length];
            this.m_lcCount = 0;
            if (characterConverters != null) {
                vector = new Vector(65535, 28671);
                characterConverters.extractCodepoints(vector);
                for (n = 0; n < vector.size(); ++n) {
                    int[] nArray = (int[])vector.elementAt(n);
                    this.setUcsCharPair(nArray[0], nArray[1], vectorArray);
                }
            }
            vector = charSetParser.getCharacterData();
            int n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                Object[] objectArray = (Object[])vector.elementAt(n);
                int n3 = ((int[])objectArray[0])[0];
                int n4 = ((int[])objectArray[1])[0];
                this.setUcsCharPair(n3, n4, vectorArray);
            }
            this.finishUcsChar(vectorArray);
        }
        catch (IOException iOException) {
            throw new NLTParserException("bad number");
        }
    }

    private void setUcsCharPair(int n, int n2, Vector[] vectorArray) throws IOException {
        Vector<int[]> vector;
        int n3;
        if ((n2 = (int)CharConvLCFixedBuilder.convertUTF32toUTF16((long)n2 & 0xFFFFFFFFL)) == 65533) {
            return;
        }
        int n4 = n >> 16 & 0xFFFF;
        int n5 = -1;
        for (n3 = 0; n3 < this.m_lcCount; ++n3) {
            if (n4 != this.m_leadingCode[n3]) continue;
            n5 = n3;
            break;
        }
        if (n5 == -1) {
            if (n3 < this.m_leadingCode.length) {
                this.m_leadingCode[n3] = (char)n4;
                n5 = n3;
                this.m_lcCount = n3 + 1;
            } else {
                System.err.println("***** Error: too many leading codes: " + Integer.toHexString(n4));
                return;
            }
        }
        if ((vector = vectorArray[n3]) == null) {
            vectorArray[n3] = vector = new Vector<int[]>();
        }
        int[] nArray = new int[]{n, n2};
        vector.addElement(nArray);
    }

    private void finishUcsChar(Vector[] vectorArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        Vector vector;
        int n7;
        int n8;
        int n9;
        int n10 = 8;
        int n11 = 8;
        int n12 = (1 << n10) - 1;
        int n13 = (1 << n11) - 1;
        int n14 = this.m_l1BlockSize * this.m_lcCount;
        char[] cArray = new char[n14];
        char[][] cArray2 = new char[n14][2];
        for (n9 = 0; n9 < n14; ++n9) {
            cArray[n9] = 65535;
            cArray2[n9][0] = (char)n13;
            cArray2[n9][1] = '\u0000';
        }
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        for (n8 = 0; n8 < this.m_lcCount; ++n8) {
            n7 = this.m_l1BlockSize * n8;
            vector = vectorArray[n8];
            n6 = vector.size();
            for (n9 = 0; n9 < n6; ++n9) {
                nArray = (int[])vector.elementAt(n9);
                n5 = nArray[1];
                if (n5 == -1) continue;
                n4 = nArray[0];
                if (hashtable.get(new Integer(n5)) == null) {
                    hashtable.put(new Integer(n5), new Integer(n4));
                } else {
                    hashtable2.put(new Integer(n5), hashtable.get(new Integer(n5)));
                }
                n3 = (n4 >> n11 & n12) + n7;
                cArray[n3] = '\u0001';
                n2 = n4 & n13;
                if (n2 < cArray2[n3][0]) {
                    cArray2[n3][0] = (char)n2;
                }
                if (n2 <= cArray2[n3][1]) continue;
                cArray2[n3][1] = (char)n2;
            }
        }
        int n15 = n = n13 + 1;
        int n16 = 0;
        for (n9 = 0; n9 < n14; ++n9) {
            if (cArray[n9] == '\uffff') continue;
            int n17 = cArray2[n9][0];
            cArray[n9] = (char)(n15 - (n16 < n17 ? n16 : n17));
            n15 = cArray[n9] + n;
            n16 = n - cArray2[n9][1] - 1;
        }
        int[] nArray2 = new int[n15];
        for (n9 = 0; n9 < n15; ++n9) {
            nArray2[n9] = -1;
        }
        for (n8 = 0; n8 < this.m_lcCount; ++n8) {
            n7 = this.m_l1BlockSize * n8;
            vector = vectorArray[n8];
            n6 = vector.size();
            for (n9 = 0; n9 < n6; ++n9) {
                nArray = (int[])vector.elementAt(n9);
                n5 = nArray[1];
                if (n5 == -1) continue;
                n4 = nArray[0];
                n3 = (n4 >> n11 & n12) + n7;
                n2 = n4 & n13;
                int n18 = cArray[n3] + n2;
                nArray2[n18] = n5;
            }
        }
        this.setArray2(nArray2);
        this.setArray(cArray);
        this.setLCTable();
        this.setDuplicateMapping(hashtable2);
    }

    void setArray2(int[] nArray) {
        int n = nArray.length;
        this.charConvLCFixedObj.m_ucsCharLevel2 = new int[n];
        for (int i = 0; i < n; ++i) {
            this.charConvLCFixedObj.m_ucsCharLevel2[i] = nArray[i];
        }
    }

    void setArray(char[] cArray) {
        int n = cArray.length;
        this.charConvLCFixedObj.m_ucsCharLevel1 = new char[n];
        for (int i = 0; i < n; ++i) {
            this.charConvLCFixedObj.m_ucsCharLevel1[i] = cArray[i];
        }
    }

    void setLCTable() {
        this.charConvLCFixedObj.m_ucsCharLeadingCode = new char[this.m_lcCount][2];
        for (int i = 0; i < this.m_lcCount; ++i) {
            this.charConvLCFixedObj.m_ucsCharLeadingCode[i][0] = this.m_leadingCode[i];
            this.charConvLCFixedObj.m_ucsCharLeadingCode[i][1] = (char)(i * this.m_l1BlockSize);
        }
    }

    void setDuplicateMapping(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        this.charConvLCFixedObj.extraUnicodeToOracleMapping = new int[hashtable.size()][2];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.charConvLCFixedObj.extraUnicodeToOracleMapping[n][0] = (Integer)k;
            this.charConvLCFixedObj.extraUnicodeToOracleMapping[n++][1] = (Integer)hashtable.get(k);
        }
    }
}

