/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.File;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import oracle.i18n.util.builder.NLTParserException;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NLTParser {
    protected XMLDocument doc;
    protected Node topNode;
    protected final short SINGLE = 1;
    protected final short RANGE = (short)2;
    protected final short MULTI = (short)3;

    public NLTParser() {
    }

    public NLTParser(String string) throws NLTParserException {
        try {
            DOMParser dOMParser = new DOMParser();
            URL uRL = NLTParser.createURL(string);
            dOMParser.setErrorStream((OutputStream)System.err);
            dOMParser.setValidationMode(2);
            dOMParser.showWarnings(true);
            dOMParser.setDebugMode(true);
            dOMParser.parse(uRL);
            this.doc = dOMParser.getDocument();
            this.topNode = NLTParser.findNode((Node)this.doc, "NLSDATA");
            if (this.topNode == null) {
                throw new NLTParserException("Pattern NLSDATA not found!");
            }
        }
        catch (NLTParserException nLTParserException) {
            throw nLTParserException;
        }
        catch (Exception exception) {
            throw new NLTParserException(exception.getMessage());
        }
    }

    public XMLDocument getXMLDocument() {
        return this.doc;
    }

    public String getStringValue(String string) {
        int n;
        Node node = NLTParser.findNode(this.topNode, string);
        if (node == null) {
            return null;
        }
        if ((node = node.getFirstChild()) == null) {
            return null;
        }
        String string2 = node.getNodeValue();
        if (string2.substring(0, 1).equals("\"") && string2.substring(string2.length() - 1).equals("\"")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        String string3 = "";
        int n2 = 0;
        while ((n = string2.indexOf("\\u", n2)) != -1) {
            string3 = string3 + string2.substring(n2, n);
            string3 = string3 + String.valueOf((char)Integer.parseInt(string2.substring(n + 2, n + 6), 16));
            n2 = n + 6;
        }
        string3 = string3 + string2.substring(n2);
        return string3;
    }

    public HashMap getPHashMap(String string) throws NLTParserException {
        HashMap hashMap = null;
        Node node = NLTParser.findNode(this.topNode, string);
        if (node == null) {
            return null;
        }
        NodeList nodeList = NLTParser.findNodes(node, "P");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            hashMap = this.getValueOfPHashMap(nodeList.item(i), hashMap);
        }
        return hashMap;
    }

    public Vector getPBlockVector(String string) throws NLTParserException {
        Vector vector = null;
        Node node = NLTParser.findNode(this.topNode, string);
        if (node == null) {
            return null;
        }
        NodeList nodeList = NLTParser.findNodes(node, "P");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            vector = this.getValueOfPVector(nodeList.item(i), vector);
        }
        vector.trimToSize();
        return vector;
    }

    public static Node findNode(Node node, String string) {
        NodeList nodeList = ((XMLElement)node).getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }

    public static NodeList findNodes(Node node, String string) {
        NodeList nodeList = ((XMLElement)node).getElementsByTagName(string);
        return nodeList;
    }

    public Vector getValueOfPVector(Node node, Vector vector) throws NLTParserException {
        int n;
        Object[] objectArray;
        int n2;
        Object object;
        int n3;
        NodeList nodeList;
        if (vector == null) {
            vector = new Vector<Object>();
        }
        if ((nodeList = node.getChildNodes()) == null) {
            this.throwBadFormatException(node, "Element P");
        }
        if ((n3 = nodeList.getLength()) <= 0) {
            this.throwBadFormatException(node, "Element P");
        }
        Node node2 = nodeList.item(0);
        String string = node2.getNodeName();
        int n4 = 1;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        Object var13_13 = null;
        boolean bl = false;
        Object var15_15 = null;
        int[] nArray = null;
        int n10 = 1;
        if (string.equals("F")) {
            n6 = this.getValueOfHex(node2, "Element F");
            node2 = nodeList.item(n10++);
            string = node2.getNodeName();
        } else if (string.equals("FS")) {
            n4 = 2;
            n6 = this.getValueOfHex(node2, "Element FS");
            node2 = nodeList.item(n10++);
            string = node2.getNodeName();
            n7 = this.getValueOfHex(node2, "Element FE");
            node2 = nodeList.item(n10++);
            string = node2.getNodeName();
        } else {
            this.throwBadFormatException(node2, "Element P");
        }
        if (string.equals("T")) {
            object = new int[1];
            nArray = object;
            object[0] = this.getValueOfHex(node2, "Element T");
            if (n10 < n3) {
                node2 = nodeList.item(n10++);
                string = node2.getNodeName();
            } else {
                node2 = null;
            }
        } else if (string.equals("TL")) {
            object = new String[1];
            nArray = object;
            object[0] = (int)this.getValueOfString(node2, "Element TL");
            if (n10 < n3) {
                node2 = nodeList.item(n10++);
                string = node2.getNodeName();
            } else {
                node2 = null;
            }
        } else if (string.equals("TM")) {
            n5 = 3;
            object = NLTParser.findNodes(node, "TM");
            n2 = object.getLength();
            objectArray = new int[n2];
            nArray = objectArray;
            for (n = 0; n < n2; ++n) {
                objectArray[n] = this.getValueOfHex(object.item(n), "Element TM");
            }
        } else if (string.equals("TLM")) {
            n5 = 3;
            object = NLTParser.findNodes(node, "TLM");
            n2 = object.getLength();
            objectArray = new String[n2];
            nArray = objectArray;
            for (n = 0; n < n2; ++n) {
                objectArray[n] = (int)this.getValueOfString(object.item(n), "Element TLM");
            }
        } else if (string.equals("TS")) {
            n5 = 2;
            n8 = this.getValueOfHex(node2, "Element TS");
            node2 = nodeList.item(n10++);
            string = node2.getNodeName();
            n9 = this.getValueOfHex(node2, "Element TE");
            if (n10 < n3) {
                node2 = nodeList.item(n10++);
                string = node2.getNodeName();
            } else {
                node2 = null;
            }
        } else {
            this.throwBadFormatException(node2, "Element P");
        }
        object = new Object[4];
        object[1] = nArray;
        node2 = NLTParser.findNode(node, "OP");
        if (node2 != null) {
            object[2] = this.getValueOfString(node2, "Element OP");
        }
        if ((node2 = NLTParser.findNode(node, "LEV")) != null) {
            object[3] = new Integer(this.getValueOfHex(node2, "Element LEV"));
        }
        if (n4 == 1) {
            object[0] = new int[]{n6};
            if (n5 == 1) {
                vector.addElement(object);
            } else if (n5 == 3) {
                vector.addElement(object);
            } else {
                this.throwBadFormatException(node, "Element P");
            }
        } else if (n4 == 2) {
            Object[] objectArray2 = null;
            if (n5 == 1) {
                int n11 = n6;
                while (n11 <= n7) {
                    objectArray2 = new Object[4];
                    for (n = 1; n < 4; ++n) {
                        objectArray2[n] = object[n];
                    }
                    objectArray2[0] = new int[]{n11++};
                    vector.addElement(objectArray2);
                }
            } else if (n5 == 2) {
                int n12 = n6;
                n = n8;
                while (n12 <= n7 && n <= n9) {
                    objectArray2 = new Object[4];
                    for (int i = 2; i < 4; ++i) {
                        objectArray2[i] = object[i];
                    }
                    objectArray2[1] = new int[]{n++};
                    objectArray2[0] = new int[]{n12++};
                    vector.addElement(objectArray2);
                }
            } else if (n5 == 3) {
                int n13 = n6;
                while (n13 <= n7) {
                    objectArray2 = new Object[4];
                    for (n = 1; n < 4; ++n) {
                        objectArray2[n] = object[n];
                    }
                    objectArray2[0] = new int[]{n13++};
                    vector.addElement(objectArray2);
                }
            } else {
                this.throwBadFormatException(node, "Element P");
            }
        } else {
            this.throwBadFormatException(node, "Element P");
        }
        return vector;
    }

    public HashMap getValueOfPHashMap(Node node, HashMap hashMap) throws NLTParserException {
        int n;
        Object object;
        int n2;
        NodeList nodeList;
        if (hashMap == null) {
            hashMap = new HashMap<Object, Object[]>();
        }
        if ((nodeList = node.getChildNodes()) == null) {
            this.throwBadFormatException(node, "Element P");
        }
        if ((n2 = nodeList.getLength()) <= 0) {
            this.throwBadFormatException(node, "Element P");
        }
        Node node2 = nodeList.item(0);
        String string = node2.getNodeName();
        int n3 = 1;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        Object var13_13 = null;
        int n9 = 0;
        Object object2 = null;
        Object var16_16 = null;
        Object[] objectArray = null;
        int n10 = 1;
        if (string.equals("F")) {
            object2 = this.getValueOfObject(node2, "Element F");
            node2 = nodeList.item(n10++);
            string = node2.getNodeName();
        } else if (string.equals("FL")) {
            object2 = this.getValueOfString(node2, "Element FL");
            node2 = nodeList.item(n10++);
            string = node2.getNodeName();
        } else if (string.equals("FS")) {
            n3 = 2;
            n5 = this.getValueOfHex(node2, "Element FS");
            node2 = nodeList.item(n10++);
            string = node2.getNodeName();
            n6 = this.getValueOfHex(node2, "Element FE");
            node2 = nodeList.item(n10++);
            string = node2.getNodeName();
        } else {
            this.throwBadFormatException(node2, "Element P");
        }
        if (string.equals("T")) {
            int[] nArray;
            objectArray = nArray = new int[1];
            nArray[0] = this.getValueOfHex(node2, "Element T");
            if (n10 < n2) {
                node2 = nodeList.item(n10++);
                string = node2.getNodeName();
            } else {
                node2 = null;
            }
        } else if (string.equals("TL")) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = this.getValueOfString(node2, "Element TL");
            if (n10 < n2) {
                node2 = nodeList.item(n10++);
                string = node2.getNodeName();
            } else {
                node2 = null;
            }
        } else if (string.equals("TM")) {
            n4 = 3;
            int n11 = 0;
            while (n10 + n11 < n2 && string.equals("TM")) {
                object = nodeList.item(n10 + n11);
                string = object.getNodeName();
                ++n11;
            }
            object = new int[n11 + 1];
            objectArray = object;
            for (n = 0; n <= n11; ++n) {
                object[n] = this.getValueOfHex(node2, "Element TM");
                node2 = nodeList.item(n10++);
            }
        } else if (string.equals("TLM")) {
            n4 = 3;
            int n12 = 0;
            while (n10 + n12 < n2 && string.equals("TLM")) {
                object = nodeList.item(n10 + n12);
                string = object.getNodeName();
                ++n12;
            }
            object = new String[n12 + 1];
            objectArray = object;
            for (n = 0; n <= n12; ++n) {
                object[n] = this.getValueOfString(node2, "Element TLM");
                node2 = nodeList.item(n10++);
            }
        } else if (string.equals("TS")) {
            n4 = 2;
            n7 = this.getValueOfHex(node2, "Element TS");
            node2 = nodeList.item(n10++);
            string = node2.getNodeName();
            n8 = this.getValueOfHex(node2, "Element TE");
            if (n10 < n2) {
                node2 = nodeList.item(n10++);
                string = node2.getNodeName();
            } else {
                node2 = null;
            }
        } else {
            this.throwBadFormatException(node2, "Element P");
        }
        Object[] objectArray2 = new Object[]{objectArray, var13_13, new Integer(n9)};
        if (n3 == 1) {
            if (n4 == 1) {
                hashMap.put(object2, objectArray2);
            } else if (n4 == 3) {
                hashMap.put(object2, objectArray2);
            } else {
                this.throwBadFormatException(node2, "Element P");
            }
        } else if (n3 == 2) {
            if (n4 == 1) {
                for (int i = n5; i <= n6; ++i) {
                    hashMap.put(new Integer(i), objectArray2);
                }
            } else if (n4 == 2) {
                n = n7;
                for (int i = n5; i <= n6 && n <= n8; ++i) {
                    objectArray2[0] = new int[]{n++};
                    hashMap.put(new Integer(i), objectArray2);
                }
            } else if (n4 == 3) {
                for (int i = n5; i <= n6; ++i) {
                    hashMap.put(new Integer(i), objectArray2);
                }
            } else {
                this.throwBadFormatException(node2, "Element P");
            }
        } else {
            this.throwBadFormatException(node2, "Element P");
        }
        return hashMap;
    }

    public String[] getStringArrayLE(String string) throws NLTParserException {
        Node node = NLTParser.findNode(this.topNode, string);
        if (node == null) {
            return new String[0];
        }
        NodeList nodeList = NLTParser.findNodes(node, "LE");
        int n = nodeList.getLength();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getValueOfString(nodeList.item(i), "Element LE");
        }
        return stringArray;
    }

    public int getValueOfHex(Node node, String string) throws NLTParserException {
        if (node == null) {
            this.throwBadFormatException(node, string);
        }
        if ((node = node.getFirstChild()) == null) {
            this.throwBadFormatException(node, string);
        }
        String string2 = node.getNodeValue();
        try {
            BigInteger bigInteger = null;
            bigInteger = string2.length() > 2 && (string2.substring(0, 2).equals("0x") || string2.substring(0, 2).equals("0X") || string2.substring(0, 2).equals("\\x") || string2.substring(0, 2).equals("\\u")) ? new BigInteger(string2.substring(2), 16) : new BigInteger(string2);
            return NLTParser.lxu4ToUTF16(bigInteger.intValue());
        }
        catch (NumberFormatException numberFormatException) {
            this.throwBadFormatException(node, string);
            throw new NLTParserException();
        }
    }

    public Object getValueOfObject(Node node, String string) throws NLTParserException {
        if (node == null) {
            this.throwBadFormatException(node, string);
        }
        if ((node = node.getFirstChild()) == null) {
            return null;
        }
        String string2 = node.getNodeValue();
        try {
            BigInteger bigInteger = null;
            bigInteger = string2.length() > 2 && (string2.substring(0, 2).equals("0x") || string2.substring(0, 2).equals("0X") || string2.substring(0, 2).equals("\\x") || string2.substring(0, 2).equals("\\u")) ? new BigInteger(string2.substring(2), 16) : new BigInteger(string2);
            return new Integer(NLTParser.lxu4ToUTF16(bigInteger.intValue()));
        }
        catch (NumberFormatException numberFormatException) {
            return string2;
        }
    }

    public String getValueOfString(Node node, String string) throws NLTParserException {
        if (node == null) {
            this.throwBadFormatException(node, string);
        }
        if ((node = node.getFirstChild()) == null) {
            return null;
        }
        String string2 = node.getNodeValue();
        if (string2.startsWith("\\u")) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = string2.length();
            while (n + 5 < n2) {
                if (!string2.substring(n, n + 2).equals("\\u")) {
                    this.throwBadFormatException(node, string);
                }
                try {
                    stringBuffer.append(String.valueOf((char)Integer.parseInt(string2.substring(n + 2, n + 6), 16)));
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwBadFormatException(node, string);
                }
                n += 6;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private static int lxu4ToUTF16(int n) {
        if (((long)n & 0xFFFFFFFFL) > 65535L) {
            if (((long)n & 0xFFFFFFFFL) > 1048575L || ((long)n & 0xFFFFFFFFL) > 0xD8000000L && ((long)n & 0xFFFFFFFFL) < 0xDFFFFFFFL) {
                return n;
            }
        } else {
            return n;
        }
        int n2 = 0xD8 | n - 65536 >> 18 & 0xFF;
        n2 = n - 65536 >> 10 & 0xFF | n2 << 8;
        n2 = 0xDC | (n & 0x3FF) >> 8 & 0xFF | n2 << 8;
        n2 = n & 0xFF | n2 << 8;
        return n2;
    }

    protected void throwBadFormatException(Node node, String string) throws NLTParserException {
        throw new NLTParserException(((XMLNode)node).getLineNumber(), ((XMLNode)node).getColumnNumber(), "Bad Format Exception " + string);
    }

    protected static URL createURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = '/' + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("Cannot create url for: " + string);
                System.exit(0);
            }
        }
        return uRL;
    }

    protected static void printHashMap(HashMap hashMap) {
        if (hashMap == null) {
            System.out.println("Null HashMap");
            return;
        }
        Set set = hashMap.keySet();
        if (set.isEmpty()) {
            System.out.println("Empty HashMap");
            return;
        }
        Object[] objectArray = set.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = (Object[])hashMap.get(objectArray[i]);
            System.out.println(objectArray[i] + " :");
            for (int j = 0; j < objectArray2.length; ++j) {
                int n;
                Object[] objectArray3;
                if (objectArray2[j] instanceof int[]) {
                    objectArray3 = (int[])objectArray2[j];
                    for (n = 0; n < objectArray3.length; ++n) {
                        System.out.print(objectArray3[n] + " :");
                    }
                } else if (objectArray2[j] instanceof String[]) {
                    objectArray3 = (String[])objectArray2[j];
                    for (n = 0; n < objectArray3.length; ++n) {
                        System.out.print((String)objectArray3[n] + " :");
                    }
                } else {
                    System.out.print(objectArray2[j] + " :");
                }
                System.out.println();
            }
            System.out.println("----------------------");
        }
    }

    protected static void printVector(Vector vector) {
        if (vector == null) {
            System.out.println("Null Vector!");
            return;
        }
        vector.trimToSize();
        int n = vector.size();
        if (n == 0) {
            System.out.println("Empty Vector!");
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])vector.elementAt(i);
            for (int j = 0; j < objectArray.length; ++j) {
                int n2;
                Object[] objectArray2;
                if (objectArray[j] instanceof int[]) {
                    objectArray2 = (int[])objectArray[j];
                    for (n2 = 0; n2 < objectArray2.length; ++n2) {
                        System.out.print(objectArray2[n2] + " :");
                    }
                } else if (objectArray[j] instanceof String[]) {
                    objectArray2 = (String[])objectArray[j];
                    for (n2 = 0; n2 < objectArray2.length; ++n2) {
                        System.out.print((String)objectArray2[n2] + " :");
                    }
                } else {
                    System.out.print(objectArray[j] + " :");
                }
                System.out.println();
            }
            System.out.println("----------------------");
        }
    }

    public static void printElements(Node node) {
        if (node != null) {
            System.out.print(node.getNodeName() + " : ");
            System.out.print(node.getNodeValue() + " ");
            System.out.println();
            NodeList nodeList = node.getChildNodes();
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    NLTParser.printElements(nodeList.item(i));
                }
            }
        } else {
            System.out.println("Empty Node");
        }
    }
}

