/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jsp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.ResourceBundle;
import oracle.jdevimpl.jsp.JspOjcCompilerRes;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.provider.JspCompileException;
import oracle.jsp.provider.JspCompiler;
import oracle.jsp.provider.JspResourceProvider;
import oracle.jsp.util.JspUtil;
import oracle.ojc.compiler.Compiler;
import oracle.ojc.compiler.SystemLog;
import oracle.ojc.interfaces.Log;
import sqlj.tools.Sqlj;

public class JspOjcCompiler
implements JspCompiler {
    public static final String COMPILE_PATH = "classpath";
    private String classPath;
    private boolean needsInit = true;
    private static final ResourceBundle m_JspOjcCompilerResourceBundle = ResourceBundle.getBundle(JspOjcCompilerRes.class.getName());

    public void init(Hashtable hashtable) {
        if (this.needsInit) {
            this.classPath = (String)hashtable.get(COMPILE_PATH);
            this.needsInit = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long compile(String string, int n, String string2, JspResourceProvider jspResourceProvider, JspResourceProvider jspResourceProvider2, Jsp2JavaParms jsp2JavaParms) throws JspCompileException {
        String[] stringArray;
        int n2;
        if (n != 0 && n != 1) {
            throw new JspCompileException(m_JspOjcCompilerResourceBundle.getString("bad_lang"));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if ((string = jspResourceProvider.translateToAbsolutePath(string)) == null) {
            throw new JspCompileException(m_JspOjcCompilerResourceBundle.getString("no_files_rep"));
        }
        String string3 = this.generateAppClassPath(jspResourceProvider2);
        String string4 = null;
        if (jsp2JavaParms != null && jsp2JavaParms.tagFileRepository != null) {
            string4 = jsp2JavaParms.tagFileRepository.getRepositoryRoot();
            string3 = string3 == null ? string4 : string3 + File.pathSeparator + string4;
        }
        if (n == 1 || string.endsWith(".sqlj")) {
            n2 = 0;
            stringArray = new String[string2 != null ? 3 : 2];
            stringArray[n2++] = "-compile=false";
            if (string2 != null) {
                stringArray[n2++] = "-encoding=" + string2;
            }
            stringArray[n2] = string;
            try {
                Class<?> clazz = Class.forName("sqlj.tools.Sqlj");
                synchronized (clazz) {
                    Sqlj.statusMain((String[])stringArray);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JspCompileException(classNotFoundException.toString());
            }
            string = JspUtil.replaceTargetExtension((String)string, (String)".java");
        }
        n2 = 0;
        stringArray = new String[string2 != null ? 7 : 5];
        if (string2 != null) {
            stringArray[n2++] = "-encoding";
            stringArray[n2++] = string2;
        }
        stringArray[n2++] = "-g";
        stringArray[n2++] = "-classpath";
        stringArray[n2] = System.getProperty("java.class.path");
        if (this.classPath != null) {
            int n3 = n2;
            stringArray[n3] = stringArray[n3] + File.pathSeparator + this.classPath;
        }
        if (string3 != null) {
            int n4 = n2;
            stringArray[n4] = stringArray[n4] + File.pathSeparator + string3;
        }
        int n5 = ++n2;
        ++n2;
        stringArray[n5] = string;
        PrintStream printStream = System.out;
        System.setOut(new PrintStream(byteArrayOutputStream, true));
        try {
            Compiler.main((String[])stringArray, (Log)new SystemLog());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.setOut(printStream);
        String string5 = byteArrayOutputStream.toString();
        if (string5.indexOf(m_JspOjcCompilerResourceBundle.getString("error")) != -1) {
            throw new JspCompileException(JspOjcCompiler.formatCompilerErrors(string, string5));
        }
        return new File(JspOjcCompiler.stripExtension(string) + ".class").lastModified();
    }

    public long compile(String string, int n, String string2, JspResourceProvider jspResourceProvider, JspResourceProvider jspResourceProvider2) throws JspCompileException {
        return this.compile(string, n, string2, jspResourceProvider, jspResourceProvider2, null);
    }

    private static String stripExtension(String string) {
        return string.substring(0, string.lastIndexOf(46));
    }

    private String generateAppClassPath(JspResourceProvider jspResourceProvider) {
        String string = null;
        try {
            string = jspResourceProvider.getAbsolutePath("/WEB-INF/classes");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String[] stringArray = jspResourceProvider.listClassRepositories("/WEB-INF/lib");
        if (stringArray == null) {
            return string;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = null;
            try {
                string2 = jspResourceProvider.getAbsolutePath("/WEB-INF/lib/" + stringArray[n]);
                string = string == null ? string2 : string + File.pathSeparator + string2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        return string;
    }

    private static String formatCompilerErrors(String string, String string2) {
        int n;
        int n2 = 2 * string2.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append("<H3>");
        stringBuffer.append(m_JspOjcCompilerResourceBundle.getString("compile_error_hdr"));
        stringBuffer.append(string);
        stringBuffer.append("</H3>\n<TABLE BORDER=1><TR><TH>");
        stringBuffer.append(m_JspOjcCompilerResourceBundle.getString("line_number_heading"));
        stringBuffer.append("</TH><TH>");
        stringBuffer.append(m_JspOjcCompilerResourceBundle.getString("error_heading"));
        stringBuffer.append("</TH></TR>\n");
        int n3 = 0;
        String string3 = m_JspOjcCompilerResourceBundle.getString("error");
        String string4 = m_JspOjcCompilerResourceBundle.getString("errors");
        while ((n = JspOjcCompiler.findEndOfErrorStatement(string2, n3)) != -1) {
            if (n != n3) {
                int n4 = string2.indexOf(58, n3);
                while (n4 != -1 && !Character.isDigit(string2.charAt(n4 + 1))) {
                    n4 = string2.indexOf(58, n4 + 1);
                }
                if (n4 != -1) {
                    int n5 = string2.indexOf(58, n4 + 1);
                    String string5 = string2.substring(n4 + 1, n5);
                    int n6 = string2.indexOf(58, n5 + 1);
                    String string6 = JspOjcCompiler.formatErrorMessage(string2.substring(n6 + 1, n).trim());
                    stringBuffer.append("<TR><TD VALIGN=TOP><CENTER>");
                    stringBuffer.append(string5);
                    stringBuffer.append("<CENTER></TD><TD VALIGN=TOP><PRE>");
                    stringBuffer.append(string6);
                    stringBuffer.append("</PRE></TD></TR>\n");
                } else {
                    String string7 = JspOjcCompiler.formatErrorMessage(string2.substring(n3, n).trim());
                    int n7 = string7.length();
                    int n8 = 0;
                    while (n8 < n7 && Character.isDigit(string7.charAt(n8))) {
                        ++n8;
                    }
                    while (n8 < n7 && Character.isWhitespace(string7.charAt(n8))) {
                        ++n8;
                    }
                    String string8 = string7.substring(n8);
                    if (!string8.equals(string3) && !string8.equals(string4)) {
                        stringBuffer.append("<TR><TD COLSPAN=2 VALIGN=TOP><PRE>");
                        stringBuffer.append(string7);
                        stringBuffer.append("</PRE></TD></TR>\n");
                    }
                }
            }
            n3 = n + 1;
        }
        stringBuffer.append("</TABLE>\n");
        return stringBuffer.toString();
    }

    private static int findEndOfErrorStatement(String string, int n) {
        int n2 = string.indexOf(94, n);
        if (n2 != -1) {
            return string.indexOf(10, n2);
        }
        return string.indexOf(10, n);
    }

    private static String formatErrorMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            String string2 = null;
            switch (c) {
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                }
            }
            if (string2 != null) {
                stringBuffer.replace(n, n + 1, string2);
                n += string2.length() - 1;
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

