/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.Bookmarks;
import ice.browser.HintDisplayer;
import ice.browser.ListDialog;
import ice.browser.Main;
import ice.browser.PrintPreview;
import ice.browser.SearchDialog;
import ice.browser.SourceFrame;
import ice.browser.Tooltip;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.ProgressDetail;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.Hint;
import ice.storm.HistoryManager;
import ice.storm.Pilot;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.storm.ViewportGuiParams;
import ice.util.Defs;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;

class BrowserFrame
extends Frame
implements ActionListener,
WindowListener,
PropertyChangeListener {
    private Tooltip tooltip = null;
    private Bookmarks bookmarksDialog;
    static Frame theFrame = null;
    private StormBase base;
    private String viewportId;
    private Panel panel;
    private TextField loc;
    private Label status;
    private Label stats;
    private Button back;
    private Button forward;
    private Button info;
    private Button gc;
    private Button printButton;
    private Button stopButton;
    private Button home;
    private Button reload;
    private Button bookmarks;
    private Button addBookmark;
    private Button viewSource;
    private Button zoomIn;
    private Button zoomOut;
    private Button zoomNormal;
    private String prevLoc = "";
    private MenuItem mnew;
    private MenuItem mprint;
    private MenuItem mclose;
    private MenuItem mexit;
    private MenuItem mcopy;
    private MenuItem mfind;
    private MenuItem maddbookmark;
    private MenuItem mbookmarks;
    private MenuItem mzoomin;
    private MenuItem mzoomout;
    private MenuItem mzoom100;
    private MenuItem mencoding;
    private MenuItem msource;
    private MenuItem mabout;
    private MenuItem mlist;
    private MenuItem mviewdom;
    private MenuItem mgc;
    static boolean verbose = false;
    private char[] sourceBuffer;
    private String sourceEnc;
    private int lastProgress = 0;

    public BrowserFrame(StormBase stormBase, Viewport viewport) {
        super("ICE Storm - " + viewport.getName());
        this.base = stormBase;
        this.viewportId = viewport.getId();
        this.setLayout(new BorderLayout());
        this.addWindowListener(this);
        this.base.addPropertyChangeListener(this, this.viewportId);
        Font font = new Font("SansSerif", 0, 11);
        Font font2 = new Font("SansSerif", 0, 12);
        this.back = this.createButton("<<", font);
        this.back.setEnabled(false);
        this.forward = this.createButton(">>", font);
        this.forward.setEnabled(false);
        this.reload = this.createButton("reload", font);
        this.stopButton = this.createButton("stop", font);
        this.home = this.createButton("home", font);
        this.addBookmark = this.createButton("add", font);
        this.bookmarks = this.createButton("bookmarks", font);
        this.viewSource = this.createButton("source", font);
        this.info = this.createButton("info", font);
        this.printButton = this.createButton("print", font);
        this.gc = this.createButton("gc", font);
        this.zoomIn = this.createButton("zoom in", font);
        this.zoomOut = this.createButton("zoom out", font);
        this.zoomNormal = this.createButton("100%", font);
        this.loc = new TextField("", 30);
        this.loc.setFont(font);
        this.loc.setBackground(Color.white);
        this.loc.setForeground(Color.blue);
        this.loc.addActionListener(this);
        this.status = new Label("", 0);
        this.status.setFont(font);
        this.status.setForeground(Color.white);
        this.status.setBackground(Color.black);
        this.stats = new Label("", 2);
        this.stats.setFont(font);
        this.stats.setForeground(Color.white);
        this.stats.setBackground(Color.black);
        boolean bl = Defs.sysPropertyBoolean("ice.browser.pjava");
        int n = Main.reqWidth;
        int n2 = Main.reqHeight;
        int n3 = -1;
        int n4 = -1;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = true;
        ViewportGuiParams viewportGuiParams = viewport.getGuiParams();
        if (viewportGuiParams != null) {
            if (viewportGuiParams.width >= 0) {
                n = viewportGuiParams.width + 4;
            }
            if (viewportGuiParams.height >= 0) {
                n2 = viewportGuiParams.height + 28;
            }
            n3 = viewportGuiParams.left;
            n4 = viewportGuiParams.top;
            bl2 = viewportGuiParams.resizable;
            bl3 = viewportGuiParams.location;
            bl4 = viewportGuiParams.menubar;
            bl5 = viewportGuiParams.status;
            bl6 = viewportGuiParams.toolbar;
        }
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        if (bl6) {
            gridBagConstraints.fill = 0;
            gridBagLayout.setConstraints(this.back, gridBagConstraints);
            panel.add(this.back);
            gridBagLayout.setConstraints(this.forward, gridBagConstraints);
            panel.add(this.forward);
            gridBagLayout.setConstraints(this.stopButton, gridBagConstraints);
            panel.add(this.stopButton);
            gridBagLayout.setConstraints(this.reload, gridBagConstraints);
            panel.add(this.reload);
            if (bl) {
                gridBagLayout.setConstraints(this.gc, gridBagConstraints);
                panel.add(this.gc);
            }
        }
        if (bl3) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.loc, gridBagConstraints);
            panel.add(this.loc);
        }
        Panel panel2 = new Panel();
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        panel2.setLayout(gridBagLayout);
        if (bl5) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.status, gridBagConstraints);
            panel2.add(this.status);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.stats, gridBagConstraints);
            panel2.add(this.stats);
        }
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        if (bl3 || bl6) {
            panel3.add((Component)panel, "South");
        }
        if (bl5) {
            panel3.add((Component)panel2, "North");
        }
        if (bl3 || bl6 || bl5) {
            this.add((Component)panel3, "South");
        }
        this.panel = new Panel();
        this.panel.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.panel, "Center");
        this.runUpdateStatsLoop();
        if (theFrame == null) {
            theFrame = this;
        }
        if (!bl) {
            this.tooltip = new Tooltip(this, this.base);
            this.bookmarksDialog = new Bookmarks((Frame)this, this.base, this.viewportId);
            if (bl4) {
                this.buildMenu();
            }
        }
        ((Component)this).setSize(n, n2);
        if (n3 >= 0 && n4 >= 0) {
            ((Component)this).setLocation(n3, n4);
        }
        if (!bl2) {
            this.setResizable(false);
        }
    }

    private void buildMenu() {
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        Menu menu = new Menu("File");
        Menu menu2 = new Menu("Edit");
        Menu menu3 = new Menu("View");
        Menu menu4 = new Menu("Debug");
        menuBar.add(menu);
        menuBar.add(menu2);
        menuBar.add(menu3);
        menuBar.add(menu4);
        this.mnew = this.createMenuItem("New Window");
        this.mprint = this.createMenuItem("Print...");
        this.mclose = this.createMenuItem("Close");
        this.mexit = this.createMenuItem("Exit");
        menu.add(this.mnew);
        menu.add(new MenuItem("-"));
        menu.add(this.mprint);
        menu.add(new MenuItem("-"));
        menu.add(this.mclose);
        menu.add(this.mexit);
        this.mcopy = this.createMenuItem("Copy");
        this.mfind = this.createMenuItem("Find...");
        menu2.add(this.mfind);
        this.maddbookmark = this.createMenuItem("Add Bookmark");
        this.mbookmarks = this.createMenuItem("Bookmarks...");
        this.mzoomin = this.createMenuItem("Zoom In");
        this.mzoomout = this.createMenuItem("Zoom Out");
        this.mzoom100 = this.createMenuItem("Zoom 100%");
        this.mencoding = this.createMenuItem("Encoding");
        this.msource = this.createMenuItem("Page Source");
        menu3.add(this.maddbookmark);
        menu3.add(this.mbookmarks);
        menu3.add(new MenuItem("-"));
        menu3.add(this.mzoomin);
        menu3.add(this.mzoomout);
        menu3.add(this.mzoom100);
        menu3.add(new MenuItem("-"));
        menu3.add(this.msource);
        this.mabout = this.createMenuItem("About");
        this.mlist = this.createMenuItem("Pilot List");
        this.mviewdom = this.createMenuItem("View DOM");
        this.mgc = this.createMenuItem("Force GC");
        menu4.add(this.mabout);
        menu4.add(this.mlist);
        menu4.add(this.mviewdom);
        menu4.add(this.mgc);
    }

    private Button createButton(String string, Font font) {
        Button button = new Button(string);
        button.setFont(font);
        button.setBackground(Color.lightGray);
        button.addActionListener(this);
        return button;
    }

    private MenuItem createMenuItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        return menuItem;
    }

    Panel getPanel() {
        return this.panel;
    }

    final void runUpdateStatsLoop() {
        this.updateStats();
        this.base.runOnEventThreadLater(new Runnable(){

            public void run() {
                BrowserFrame.this.runUpdateStatsLoop();
            }
        }, 2000L);
    }

    private void updateStats() {
        int n = (int)(Runtime.getRuntime().freeMemory() >> 10);
        int n2 = (int)(Runtime.getRuntime().totalMemory() >> 10);
        int n3 = Thread.activeCount();
        String string = " mem: " + (n2 - n) + "k/" + n2 + "k, threads: " + n3 + "  ";
        this.stats.setText(string);
    }

    private void updateProgress(String string, int n, int n2) {
        if (n2 > 0) {
            this.status.setText("loading " + string + " (" + n * 100 / n2 + "%)");
        } else {
            this.status.setText("loading " + string + " (" + n + " bytes)");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Viewport viewport;
        Pilot pilot;
        Object object = actionEvent.getSource();
        if (object == this.loc) {
            int n;
            String string = this.viewportId;
            String string2 = this.loc.getText();
            int n2 = string2.indexOf(124);
            if (n2 == 0 && (n2 = string2.indexOf(124, 1)) >= 1) {
                string = string2.substring(1, n2);
                string2 = string2.substring(n2 + 1);
            }
            if ((n = string2.indexOf(58)) < 0) {
                int n3 = string2.indexOf(47);
                string2 = n3 == 0 ? "file://localhost" + string2 : "http://" + string2;
            }
            this.base.renderContent(string2, null, string);
            if (!string.equals(this.viewportId)) {
                this.loc.setText(this.prevLoc);
            }
        } else if (object == this.reload) {
            this.base.getHistoryManager().reload(this.viewportId);
        } else if (object == this.gc || object == this.mgc) {
            System.gc();
            this.updateStats();
        } else if (object == this.back) {
            this.base.getHistoryManager().goBack(this.viewportId);
        } else if (object == this.forward) {
            this.base.getHistoryManager().goForward(this.viewportId);
        } else if (object == this.info || object == this.mlist) {
            ListDialog listDialog = new ListDialog((Frame)this, this.base);
            ((Component)listDialog).setVisible(true);
        } else if (object == this.printButton || object == this.mprint) {
            PrintPreview printPreview = new PrintPreview((Frame)this, this.base, this.viewportId);
            ((Component)printPreview).setVisible(true);
        } else if (object == this.stopButton) {
            this.base.stopLoading(this.viewportId);
        } else if (object == this.home) {
            this.base.renderContent("http://www.icesoft.com/", null, this.viewportId);
        } else if (object == this.zoomNormal || object == this.mzoom100) {
            Viewport viewport2 = this.base.findViewportByName(this.viewportId);
            viewport2.setZoom(256);
        } else if (object == this.zoomIn || object == this.mzoomin) {
            Viewport viewport3 = this.base.findViewportByName(this.viewportId);
            viewport3.setZoom(viewport3.getZoom() + 16);
        } else if (object == this.zoomOut || object == this.mzoomout) {
            Viewport viewport4 = this.base.findViewportByName(this.viewportId);
            viewport4.setZoom(viewport4.getZoom() - 16);
        } else if ((object == this.addBookmark || object == this.maddbookmark) && this.bookmarksDialog != null) {
            Viewport viewport5 = this.base.findViewportByName(this.viewportId);
            Pilot pilot2 = viewport5.getPilot();
            if (pilot2 != null) {
                String string = this.prevLoc;
                String string3 = this.prevLoc;
                if (pilot2 instanceof ThePilot) {
                    ThePilot thePilot = (ThePilot)pilot2;
                    string3 = ((DDocument)thePilot.getDocument()).getTitle();
                }
                if (string3 == null || string3.length() == 0) {
                    string3 = string;
                }
                this.bookmarksDialog.addBookmark(string3, string);
            }
        } else if ((object == this.bookmarks || object == this.mbookmarks) && this.bookmarksDialog != null) {
            ((Component)this.bookmarksDialog).setVisible(!this.bookmarksDialog.isVisible());
        } else if (object == this.viewSource || object == this.msource) {
            new SourceFrame(this, this.sourceBuffer, this.sourceEnc);
        } else if (object == this.mnew) {
            this.base.clearContent("text/html", "_blank");
        } else if (object == this.mabout) {
            this.base.renderContent("about:", null, "_about");
        } else if (object == this.mviewdom) {
            this.base.renderContent("dom:" + this.viewportId, null, "dom");
        } else if (object == this.mclose) {
            this.base.closeViewport(this.viewportId);
        } else if (object == this.mexit) {
            System.exit(0);
        } else if (object == this.mfind && (pilot = (viewport = this.base.findViewportByName(this.viewportId)).getPilot()) instanceof ThePilot) {
            ThePilot thePilot = (ThePilot)pilot;
            new SearchDialog((Frame)this, thePilot.getSearch());
        }
    }

    private void resetSource() {
        this.sourceBuffer = null;
        this.sourceEnc = null;
        this.lastProgress = 0;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Viewport viewport = (Viewport)propertyChangeEvent.getSource();
        boolean bl = viewport.getId().equals(this.viewportId);
        String string = propertyChangeEvent.getPropertyName();
        if (string == "hint") {
            Hint hint = (Hint)propertyChangeEvent.getNewValue();
            HintDisplayer.display(hint, this.base, viewport);
        } else if (string == "history") {
            String string2 = (String)propertyChangeEvent.getNewValue();
            if (string2 == "modified") {
                HistoryManager historyManager = this.base.getHistoryManager();
                this.back.setEnabled(historyManager.canGoBack(this.viewportId));
                this.forward.setEnabled(historyManager.canGoForward(this.viewportId));
            }
        } else if (string == "title") {
            if (bl) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                this.setTitle("ICE Storm - " + viewport.getName() + " - " + string3);
            }
        } else if (string == "location") {
            if (bl) {
                String string4 = (String)propertyChangeEvent.getNewValue();
                this.loc.setText(string4);
                this.prevLoc = this.loc.getText();
            }
        } else if (string == "statusLine") {
            String string5 = (String)propertyChangeEvent.getNewValue();
            this.status.setText(string5);
        } else if (string == "contentLoadingProgress") {
            int n;
            String string6 = (String)propertyChangeEvent.getNewValue();
            int n2 = 0;
            try {
                int n3 = string6.indexOf(32);
                int n4 = string6.indexOf(32, n3 + 1);
                n2 = Integer.parseInt(string6.substring(n3 + 1, n4));
                n = Integer.parseInt(string6.substring(n4 + 1));
                this.updateProgress(string6.substring(0, n3), n2, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl && n2 != this.lastProgress) {
                this.lastProgress = n2;
                ProgressDetail progressDetail = (ProgressDetail)propertyChangeEvent.getOldValue();
                if (progressDetail == null) {
                    return;
                }
                char[] cArray = new char[progressDetail.getNumCharacters()];
                progressDetail.copyCharacters(cArray);
                this.sourceEnc = progressDetail.getEncoding();
                if (this.sourceBuffer == null) {
                    this.sourceBuffer = cArray;
                } else {
                    n = this.sourceBuffer.length;
                    int n5 = cArray.length;
                    char[] cArray2 = new char[n + n5];
                    System.arraycopy(this.sourceBuffer, 0, cArray2, 0, n);
                    System.arraycopy(cArray, 0, cArray2, n, n5);
                    this.sourceBuffer = cArray2;
                }
            }
        } else if (string == "outstandingImages") {
            String string7 = (String)propertyChangeEvent.getNewValue();
            if (string7.equals("0")) {
                this.status.setText("loading images: done");
            } else {
                this.status.setText("loading images: " + string7 + " left");
            }
        } else if (string == "contentLoading") {
            String string8 = (String)propertyChangeEvent.getNewValue();
            if (string8 == "error") {
                IOException iOException;
                String string9 = "loading error";
                ContentLoader contentLoader = (ContentLoader)propertyChangeEvent.getOldValue();
                if (contentLoader != null && verbose && (iOException = contentLoader.getException()) != null) {
                    iOException.printStackTrace();
                    string9 = iOException.toString();
                }
                this.status.setText(viewport.getName() + ": " + string9);
            } else {
                if (string8 == "begin" && bl) {
                    this.resetSource();
                }
                this.status.setText(string + ": " + string8);
            }
        } else if (string == "pilotLoading") {
            Pilot pilot;
            String string10 = (String)propertyChangeEvent.getNewValue();
            if (string10 == "end" && this.tooltip != null && (pilot = viewport.getPilot()) instanceof ThePilot) {
                ThePilot thePilot = (ThePilot)pilot;
                thePilot.addPersistentDOMEventListener("mouseover", this.tooltip, true);
                thePilot.addPersistentDOMEventListener("mouseout", this.tooltip, true);
            }
            this.status.setText(string + ": " + string10);
        } else if (string != "contentRendering") {
            String string11 = (String)propertyChangeEvent.getNewValue();
            this.status.setText(viewport.getName() + ": " + string + " " + string11);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.base.closeViewport(this.viewportId);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    static {
        String string = Defs.sysProperty("ice.debug.printstacktrace");
        if (string != null && string.equals("true")) {
            verbose = true;
        }
    }
}

