/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.CallbackImplBase;
import ice.browser.IBModule;
import ice.browser.ParseTreePrinter;
import ice.browser.VisitedLinks;
import ice.debug.Debug;
import ice.storm.ScripterCallback;
import ice.storm.StormBase;
import ice.storm.ViewportCallback;
import ice.util.Defs;
import ice.util.net.URLStreamHandlerFactory;
import ice.util.security.SecurityKit;
import java.io.File;
import java.net.URL;
import java.util.Vector;

public class Main {
    static final String HOME_URL = "http://www.icesoft.com/";
    static final String helpMsg = "\n  ICEBrowser 5.x supports several options which might be useful.\n\n  This list summarises a few of those options:\n\n--help  prints this help\n-p    prints the DOM tree to ice_output.txt in current directory\n-t:XXX  names toolkit to use.  Default is awt, another option is swing\n-nosm   specifies that there should be no security manager\n-hNUM   specifies height of window\n-wNUM   specifies width of window\n-c:XXX  names compatibility mode.  Default is icebrowser. Other options are\n      'ie' for Internet Explorer 5, and 'ns6' for Netscape 6.";
    static Vector modules = new Vector();
    static int reqWidth = 600;
    static int reqHeight = 600;

    public static final void main(String[] stringArray) {
        Object object;
        Class<?> clazz;
        String string;
        String string2 = "ib";
        String string3 = "awt";
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-t:")) {
                string3 = stringArray[n].substring(3);
            } else if (stringArray[n].startsWith("-c:")) {
                string2 = stringArray[n].substring(3);
            } else if (stringArray[n].equals("-nosm")) {
                bl = false;
            } else if (stringArray[n].equals("--help")) {
                System.out.println(helpMsg);
                return;
            }
            ++n;
        }
        if (bl && !SecurityKit.usesJava2Security()) {
            SecurityKit.installDefaultSecurityManager();
        }
        URLStreamHandlerFactory uRLStreamHandlerFactory = new URLStreamHandlerFactory();
        URL.setURLStreamHandlerFactory(uRLStreamHandlerFactory);
        String string4 = null;
        if (string2 != null) {
            if (string2.equals("ns")) {
                string4 = "ns";
                string2 = "Mozilla/4.7 [en] (Win98; I)";
            } else if (string2.equals("ns+")) {
                string4 = "ns";
                string2 = "Mozilla/4.7 [en] ( X11 ; U; " + Defs.sysProperty("os.name") + ' ' + Defs.sysProperty("os.version") + ' ' + Defs.sysProperty("os.arch") + " )";
            } else if (string2.equals("ns6")) {
                string4 = "ns6";
                string2 = "Mozilla/5.0 (Windows; N; Win98; en-US; m14) Netscape6/6.0b1";
            } else if (string2.equals("ie")) {
                string4 = "ie";
                string2 = "Mozilla/4.0 (compatible; MSIE 5.0; Windows 98)";
            } else {
                string2 = null;
            }
        }
        if (string2 != null) {
            Defs.setProperty("ice.browser.http.agent", string2);
            Defs.setProperty("ice.browser.emulation", string4);
        }
        StormBase stormBase = new StormBase();
        int n2 = 0;
        while (n2 < stringArray.length) {
            block46: {
                if (stringArray[n2].startsWith("-m:")) {
                    string = stringArray[n2].substring(3);
                    try {
                        clazz = Class.forName("ice.browser." + string);
                        object = (IBModule)clazz.newInstance();
                        object.initModule(stormBase);
                        modules.addElement(object);
                    }
                    catch (Exception exception) {
                        if (Debug.trace) {
                            Debug.trace("Could not load module \"" + string + "\"");
                        }
                        if (!Debug.ex) break block46;
                        Debug.ex(exception);
                    }
                }
            }
            ++n2;
        }
        string = Defs.sysProperty("ice.browser.parseTreeOutput");
        stormBase.addPropertyChangeListener(new VisitedLinks(), null);
        stormBase.setComponentToolkitName(string3);
        try {
            clazz = Class.forName("ice.browser.MyCallback_" + string3);
            object = (CallbackImplBase)clazz.newInstance();
            stormBase.setViewportCallback((ViewportCallback)object);
            stormBase.setScripterCallback((ScripterCallback)object);
        }
        catch (Exception exception) {
            System.out.println("Could not run browser for toolkit \"" + string3 + "\"");
            return;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            if (stringArray[n4].startsWith("-p") || string != null) {
                try {
                    stormBase.addPropertyChangeListener(new ParseTreePrinter(string), null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (stringArray[n4].startsWith("-w")) {
                try {
                    reqWidth = Integer.parseInt(stringArray[n4].substring(2));
                }
                catch (Exception exception) {}
            } else if (stringArray[n4].startsWith("-h")) {
                try {
                    reqHeight = Integer.parseInt(stringArray[n4].substring(2));
                }
                catch (Exception exception) {}
            } else if (!stringArray[n4].startsWith("-")) {
                String string5;
                block47: {
                    string5 = stringArray[n4];
                    if (string5.indexOf(":") < 0) {
                        File file = new File(string5);
                        if (file.exists()) {
                            try {
                                String string6 = file.getAbsolutePath();
                                if (File.separatorChar == '\\') {
                                    string5 = "file://localhost/" + string6.replace('\\', '/');
                                    break block47;
                                }
                                string5 = "file://localhost" + string6;
                            }
                            catch (RuntimeException runtimeException) {}
                        } else {
                            string5 = "http://" + string5;
                        }
                    }
                }
                stormBase.renderContent(string5, null, "icemain" + n3);
                ++n3;
            }
            ++n4;
        }
        if (n3 == 0) {
            stormBase.renderContent(HOME_URL, null, "icemain0");
        }
    }
}

