/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.BrowserDialog;
import ice.browser.BrowserFrame;
import ice.browser.CallbackImplBase;
import ice.browser.MultiLabel;
import ice.storm.Viewport;
import ice.storm.ViewportGuiParams;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;

public class MyCallback_awt
extends CallbackImplBase {
    public String okText = "Ok";
    public String cancelText = "Cancel";
    protected Hashtable windows = new Hashtable();
    static final int ACTION_CLOSE = 1;
    static final int ACTION_SET_TRUE = 2;

    public Container createTopLevelContainer(Viewport viewport) {
        boolean bl = false;
        ViewportGuiParams viewportGuiParams = viewport.getGuiParams();
        if (viewportGuiParams != null) {
            bl = viewportGuiParams.dialog;
        }
        if (bl) {
            BrowserDialog browserDialog = new BrowserDialog(this.base, viewport);
            this.windows.put(viewport.getId(), browserDialog);
            return browserDialog.getPanel();
        }
        BrowserFrame browserFrame = new BrowserFrame(this.base, viewport);
        this.windows.put(viewport.getId(), browserFrame);
        ((Component)browserFrame).setVisible(true);
        return browserFrame.getPanel();
    }

    public void disposeTopLevelContainer(Viewport viewport) {
        Window window = (Window)this.windows.get(viewport.getId());
        if (window != null) {
            this.windows.remove(viewport.getId());
            ((Component)window).setVisible(false);
            window.dispose();
            if (this.windows.isEmpty()) {
                System.exit(0);
            }
        }
    }

    private Frame findFrame(Viewport viewport) {
        Container container = viewport.getTopLevelContainer();
        if (container instanceof Frame) {
            return (Frame)container;
        }
        Viewport viewport2 = null;
        Viewport viewport3 = viewport.getParent();
        while (viewport3 != null) {
            viewport2 = viewport3;
            viewport3 = viewport2.getParent();
        }
        container = viewport2.getTopLevelContainer();
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return null;
    }

    private Dialog createDialog(Frame frame, String string) {
        Dialog dialog = new Dialog(frame, string, true);
        return dialog;
    }

    private void packAndShow(Dialog dialog, Frame frame) {
        int n;
        dialog.pack();
        Point point = frame.getLocation();
        Dimension dimension = frame.getSize();
        Dimension dimension2 = dialog.getSize();
        int n2 = point.x + (dimension.width - dimension2.width) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = point.y + (dimension.height - dimension2.height) / 2) < 0) {
            n = 0;
        }
        ((Component)dialog).setLocation(n2, n);
        dialog.show();
        dialog.dispose();
    }

    void showMessage(Viewport viewport, String string, String string2) {
        Frame frame = this.findFrame(viewport);
        if (frame == null) {
            return;
        }
        Dialog dialog = this.createDialog(frame, string);
        Panel panel = new Panel();
        panel.add(new MultiLabel(string2, 100));
        Button button = new Button(this.okText);
        button.addActionListener(new Action(dialog, 1, null));
        dialog.add((Component)panel, "North");
        dialog.add((Component)button, "South");
        this.packAndShow(dialog, frame);
    }

    boolean showConfirmation(Viewport viewport, String string, String string2) {
        boolean[] blArray = new boolean[]{false};
        Frame frame = this.findFrame(viewport);
        if (frame == null) {
            return false;
        }
        Dialog dialog = this.createDialog(frame, string);
        Panel panel = new Panel();
        panel.add(new MultiLabel(string2, 100));
        Button button = new Button(this.okText);
        button.addActionListener(new Action(dialog, 2, blArray));
        Button button2 = new Button(this.cancelText);
        button2.addActionListener(new Action(dialog, 1, null));
        Panel panel2 = new Panel();
        panel2.add(button);
        panel2.add(button2);
        dialog.add((Component)panel, "North");
        dialog.add((Component)panel2, "South");
        this.packAndShow(dialog, frame);
        return blArray[0];
    }

    String showPrompt(Viewport viewport, String string, String string2, String string3) {
        boolean[] blArray = new boolean[]{false};
        Frame frame = this.findFrame(viewport);
        if (frame == null) {
            return "";
        }
        Dialog dialog = this.createDialog(frame, string);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(new MultiLabel(string2, 100));
        TextField textField = new TextField(string3, 30);
        textField.addActionListener(new Action(dialog, 2, blArray));
        panel.add(textField);
        Button button = new Button(this.okText);
        button.addActionListener(new Action(dialog, 2, blArray));
        Button button2 = new Button(this.cancelText);
        button2.addActionListener(new Action(dialog, 1, null));
        Panel panel2 = new Panel();
        panel2.add(button);
        panel2.add(button2);
        dialog.add((Component)panel, "North");
        dialog.add((Component)panel2, "South");
        this.packAndShow(dialog, frame);
        return blArray[0] ? textField.getText() : string3;
    }

    private static final class Action
    implements ActionListener {
        private Dialog dialog;
        private int actionId;
        private Object result;

        Action(Dialog dialog, int n, Object object) {
            this.dialog = dialog;
            this.actionId = n;
            this.result = object;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.actionId) {
                case 1: {
                    ((Component)this.dialog).setVisible(false);
                    break;
                }
                case 2: {
                    ((boolean[])this.result)[0] = true;
                    ((Component)this.dialog).setVisible(false);
                }
            }
        }
    }
}

