/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.BrowserDialog_swing;
import ice.browser.BrowserFrame_swing;
import ice.browser.CallbackImplBase;
import ice.browser.ListDialog;
import ice.browser.Main;
import ice.browser.MultiLabel;
import ice.browser.PrintPreview;
import ice.browser.Tooltip;
import ice.storm.Viewport;
import ice.storm.ViewportGuiParams;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MyCallback_swing
extends CallbackImplBase
implements ActionListener,
WindowListener {
    public String okText = "Ok";
    public String cancelText = "Cancel";
    private Hashtable windows = new Hashtable();
    private JFrame frame = new JFrame("ICE Browser 5 - swing");
    private JDesktopPane desktop;
    private JButton gc;
    private JButton info;
    private JButton printBut;
    private JLabel stats;
    boolean reportScriptExceptions;
    static final int ACTION_CLOSE = 1;
    static final int ACTION_SET_TRUE = 2;

    public MyCallback_swing() {
        this.frame.addWindowListener(this);
        this.desktop = new JDesktopPane();
        this.info = new JButton("info");
        this.info.addActionListener(this);
        this.gc = new JButton("gc");
        this.gc.addActionListener(this);
        this.printBut = new JButton("print");
        this.printBut.addActionListener(this);
        this.stats = new JLabel("press gc to update", 4);
        JPanel jPanel = new JPanel();
        jPanel.add(this.info);
        jPanel.add(this.printBut);
        jPanel.add(this.gc);
        jPanel.add(this.stats);
        Container container = this.frame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.desktop, "Center");
        container.add((Component)jPanel, "South");
        ((Component)this.frame).setSize(Main.reqWidth, Main.reqHeight);
        ((Component)this.frame).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.gc) {
            System.gc();
            System.gc();
            this.updateStats();
        } else if (object == this.info) {
            ListDialog listDialog = new ListDialog((Frame)this.frame, this.base);
            ((Component)listDialog).setVisible(true);
        } else if (object == this.printBut) {
            PrintPreview printPreview = new PrintPreview((Frame)this.frame, this.base, "icemain0");
            ((Component)printPreview).setVisible(true);
        }
    }

    private void updateStats() {
        int n = (int)(Runtime.getRuntime().freeMemory() >> 10);
        int n2 = (int)(Runtime.getRuntime().totalMemory() >> 10);
        int n3 = Thread.activeCount();
        String string = " mem: " + (n2 - n) + "k/" + n2 + "k, threads: " + n3 + "  ";
        this.stats.setText(string);
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this.frame).setVisible(false);
        this.frame.dispose();
        System.exit(0);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public Container createTopLevelContainer(Viewport viewport) {
        boolean bl = false;
        ViewportGuiParams viewportGuiParams = viewport.getGuiParams();
        if (viewportGuiParams != null) {
            bl = viewportGuiParams.dialog;
        }
        if (bl) {
            BrowserDialog_swing browserDialog_swing = new BrowserDialog_swing(this.base, viewport);
            this.windows.put(viewport.getId(), browserDialog_swing);
            return browserDialog_swing.getPanel();
        }
        BrowserFrame_swing browserFrame_swing = new BrowserFrame_swing(this, viewport);
        browserFrame_swing.setTooltip(new Tooltip(this.frame, this.base));
        browserFrame_swing.setSize(500, 500);
        this.desktop.add(browserFrame_swing);
        this.desktop.moveToFront(browserFrame_swing);
        browserFrame_swing.setVisible(true);
        this.windows.put(viewport.getId(), browserFrame_swing);
        return browserFrame_swing.getPanel();
    }

    public void disposeTopLevelContainer(Viewport viewport) {
        Object v = this.windows.get(viewport.getId());
        if (v instanceof BrowserFrame_swing) {
            BrowserFrame_swing browserFrame_swing = (BrowserFrame_swing)v;
            this.windows.remove(viewport.getId());
            browserFrame_swing.setVisible(false);
            browserFrame_swing.dispose();
        } else if (v instanceof BrowserDialog_swing) {
            BrowserDialog_swing browserDialog_swing = (BrowserDialog_swing)v;
            this.windows.remove(viewport.getId());
            ((Component)browserDialog_swing).setVisible(false);
            browserDialog_swing.dispose();
        }
    }

    private Frame findFrame(Viewport viewport) {
        Container container = viewport.getTopLevelContainer();
        if (container instanceof Frame) {
            return (Frame)container;
        }
        Viewport viewport2 = null;
        Viewport viewport3 = viewport.getParent();
        while (viewport3 != null) {
            viewport2 = viewport3;
            viewport3 = viewport2.getParent();
        }
        container = viewport2.getTopLevelContainer();
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return null;
    }

    private JDialog createDialog(Frame frame, String string) {
        JDialog jDialog = new JDialog(frame, string, true);
        return jDialog;
    }

    private void packAndShow(JDialog jDialog, Frame frame) {
        jDialog.pack();
        if (frame != null) {
            int n;
            Point point = frame.getLocation();
            Dimension dimension = frame.getSize();
            Dimension dimension2 = jDialog.getSize();
            int n2 = point.x + (dimension.width - dimension2.width) / 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = point.y + (dimension.height - dimension2.height) / 2) < 0) {
                n = 0;
            }
            ((Component)jDialog).setLocation(n2, n);
        }
        jDialog.show();
        jDialog.dispose();
    }

    void showMessage(Viewport viewport, String string, String string2) {
        Frame frame = this.findFrame(viewport);
        JDialog jDialog = this.createDialog(frame, string);
        JPanel jPanel = new JPanel();
        jPanel.add(new MultiLabel(string2, 100));
        JButton jButton = new JButton(this.okText);
        jButton.addActionListener(new Action(jDialog, 1, null));
        Container container = jDialog.getContentPane();
        container.add((Component)jPanel, "North");
        container.add((Component)jButton, "South");
        this.packAndShow(jDialog, frame);
    }

    boolean showConfirmation(Viewport viewport, String string, String string2) {
        boolean[] blArray = new boolean[]{false};
        Frame frame = this.findFrame(viewport);
        JDialog jDialog = this.createDialog(frame, string);
        JPanel jPanel = new JPanel();
        jPanel.add(new MultiLabel(string2, 100));
        JButton jButton = new JButton(this.okText);
        jButton.addActionListener(new Action(jDialog, 2, blArray));
        JButton jButton2 = new JButton(this.cancelText);
        jButton2.addActionListener(new Action(jDialog, 1, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        Container container = jDialog.getContentPane();
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "South");
        this.packAndShow(jDialog, frame);
        return blArray[0];
    }

    String showPrompt(Viewport viewport, String string, String string2, String string3) {
        boolean[] blArray = new boolean[]{false};
        Frame frame = this.findFrame(viewport);
        JDialog jDialog = this.createDialog(frame, string);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(new MultiLabel(string2, 100));
        JTextField jTextField = new JTextField(string3, 30);
        jTextField.addActionListener(new Action(jDialog, 2, blArray));
        jPanel.add(jTextField);
        JButton jButton = new JButton(this.okText);
        jButton.addActionListener(new Action(jDialog, 2, blArray));
        JButton jButton2 = new JButton(this.cancelText);
        jButton2.addActionListener(new Action(jDialog, 1, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        Container container = jDialog.getContentPane();
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "South");
        this.packAndShow(jDialog, frame);
        return blArray[0] ? jTextField.getText() : string3;
    }

    private static final class Action
    implements ActionListener {
        private JDialog dialog;
        private int actionId;
        private Object result;

        Action(JDialog jDialog, int n, Object object) {
            this.dialog = jDialog;
            this.actionId = n;
            this.result = object;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.actionId) {
                case 1: {
                    ((Component)this.dialog).setVisible(false);
                    break;
                }
                case 2: {
                    ((boolean[])this.result)[0] = true;
                    ((Component)this.dialog).setVisible(false);
                }
            }
        }
    }
}

