/*
 * Decompiled with CFR 0.152.
 */
package ice.debug;

import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class Debug
extends RuntimeException {
    private static final int PRINT_TO_STDOUT = 0;
    private static final int PRINT_TO_FILE = 1;
    private static int printDestination;
    private static String EOL;
    private static PrintStream ps;
    private static String dumpFileName;
    public static final boolean all;
    public static final boolean trace;
    public static final boolean ex;
    public static final boolean chk;
    public static final boolean extra;
    public static final boolean check = true;

    private static String sysProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private static boolean debugProperty(String string) {
        String string2 = Debug.sysProperty(string);
        if (string2 != null) {
            return string2.equals("yes") || string2.equals("true");
        }
        return false;
    }

    private Debug(String string) {
        super(string);
    }

    private static char[] getStackPrintout(Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return charArrayWriter.toCharArray();
    }

    private static String getStackPrintoutAsString(Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return charArrayWriter.toString();
    }

    private static boolean getMethodAndSourcePositions(char[] cArray, int n, int n2, int[] nArray) {
        while (n != n2) {
            if (cArray[n2 - 1] > ' ') break;
            --n2;
        }
        if (n != n2 && cArray[n2 - 1] == ')') {
            int n3;
            int n4;
            int n5 = n4 = n2 - 1;
            block1: while (n != n5 && (n3 = cArray[--n5]) != 41) {
                if (n3 != 40) continue;
                int n6 = n3 = n5++;
                while (n != n6) {
                    char c;
                    if ((c = cArray[--n6]) > ' ') {
                        if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.' || c == '<' || c == '>') continue;
                        break block1;
                    }
                    if (++n6 == n3) break block1;
                    nArray[0] = n6;
                    nArray[1] = n3;
                    nArray[2] = n5;
                    nArray[3] = n4;
                    return true;
                }
                break block1;
            }
        }
        return false;
    }

    private static String getStackMethod(RuntimeException runtimeException, int n) {
        char[] cArray = Debug.getStackPrintout(runtimeException);
        int n2 = 0;
        int n3 = cArray.length;
        int[] nArray = new int[4];
        do {
            int n4;
            int n5 = n2;
            int n6 = n3;
            while (n2 != n3) {
                n4 = cArray[n2];
                ++n2;
                if (n4 != 10 && n4 != 13) continue;
                n6 = n2;
                break;
            }
            if (!Debug.getMethodAndSourcePositions(cArray, n5, n6, nArray)) continue;
            if (n == 0) {
                n4 = nArray[0];
                int n7 = nArray[1];
                return new String(cArray, n4, n7 - n4);
            }
            --n;
        } while (n2 != n3);
        return null;
    }

    public static void p(String string) {
        Debug.doOutput(string);
    }

    public static void s() {
        Debug.s("STACK TRACE");
    }

    public static void s(String string) {
        Debug debug = new Debug(string);
        debug.fillInStackTrace();
        Debug.doOutput(Debug.getStackPrintoutAsString(debug));
    }

    public static void trace(String string) {
        if (trace) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            String string2 = Debug.getStackMethod(runtimeException, 1);
            Debug.doOutput('[' + string2 + ']' + EOL + "  " + string);
        }
    }

    public static void traceStack(String string) {
        if (trace) {
            Debug debug = new Debug(string);
            debug.fillInStackTrace();
            Debug.doOutput(Debug.getStackPrintoutAsString(debug));
        }
    }

    public static void ex(Throwable throwable) {
        if (ex) {
            Debug.doOutput("EXCEPTION: " + throwable + EOL + Debug.getStackPrintoutAsString(throwable));
        }
    }

    private static void doOutput(String string) {
        if (printDestination == 0) {
            if (!string.endsWith(EOL)) {
                ps.println(string);
            } else {
                ps.print(string);
                ps.flush();
            }
        } else {
            Debug.doOutput_file(string);
        }
    }

    private static final void doOutput_file(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(dumpFileName, true);
            try {
                fileOutputStream.write(byArray);
                if (!string.endsWith(EOL)) {
                    int n = 0;
                    int n2 = EOL.length();
                    while (n != n2) {
                        fileOutputStream.write(EOL.charAt(n));
                        ++n;
                    }
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                fileOutputStream.close();
                throw throwable;
            }
            fileOutputStream.close();
            {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void bug() {
        throw new RuntimeException("***BUG***: SEE SOURCE FOR DETAILS");
    }

    public static void checkOrderLE(int n, int n2, int n3) {
        if (n > n2) {
            Debug.bug();
        }
        if (n2 > n3) {
            Debug.bug();
        }
    }

    public static void checkOrderLE(int n, int n2, int n3, int n4) {
        if (n > n2) {
            Debug.bug();
        }
        if (n2 > n3) {
            Debug.bug();
        }
        if (n3 > n4) {
            Debug.bug();
        }
    }

    static {
        String string;
        all = Debug.debugProperty("ice.debug.debug");
        trace = all || Debug.debugProperty("ice.debug.trace");
        ex = all || Debug.debugProperty("ice.debug.exception");
        chk = all || Debug.debugProperty("ice.debug.check");
        extra = all || Debug.debugProperty("ice.debug.extra");
        EOL = Debug.sysProperty("line.separator");
        if (EOL == null) {
            EOL = "\n";
        }
        if ((string = Debug.sysProperty("ice.debug.file")) == null) {
            printDestination = 0;
            boolean bl = "/".equals(Debug.sysProperty("file.separator"));
            ps = bl ? System.err : System.out;
        } else {
            printDestination = 1;
            dumpFileName = string;
            String string2 = new Date().toString();
            Debug.doOutput(EOL + EOL + "************************" + string2 + "************************" + EOL + EOL);
        }
        if (trace) {
            Debug.doOutput("JVM: " + Debug.sysProperty("java.version") + ", " + Debug.sysProperty("java.vendor") + ", " + Debug.sysProperty("os.name") + ", " + Debug.sysProperty("os.version"));
        }
    }
}

