/*
 * Decompiled with CFR 0.152.
 */
package ice.dombase;

import ice.dombase.LexCallbackBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public abstract class LexBase
extends InputStream {
    protected static final char[] EMPTY_CHAR_ARRAY = new char[0];
    protected LexCallbackBase callback;
    protected static final IOException lexer_eof = new IOException();
    protected InputStream sourceInputStream;
    protected int inputReadProgress;
    protected Reader reader;
    protected char[] char_buf;
    protected int mark;
    protected int bufEnd;
    protected static final int TEXT_STATE = 0;
    protected static final int MARKUP_START_STATE = 1;
    protected static final int META_MARKUP_START_STATE = 2;
    protected static final int IN_XML_COMMENTS_STATE = 3;
    protected static final int SCRIPT_STATE = 4;
    protected static final int CDATA_STATE = 5;
    protected static final int EMBEDDED_XML_STATE = 6;
    protected int lexerState;
    private static final int XML_COMMENTS_START = 0;
    private static final int XML_COMMENTS_BODY = 1;
    private static final int XML_COMMENTS_END_MINUS = 2;
    private static final int XML_COMMENTS_END_MINUS_MINUS = 3;
    private int commentState;
    protected boolean done;
    protected int lexerNestingLevel;
    public int lineNumber;

    protected LexBase(LexCallbackBase lexCallbackBase) {
        this.callback = lexCallbackBase;
    }

    public void close() throws IOException {
        this.sourceInputStream.close();
    }

    public int available() throws IOException {
        return this.sourceInputStream.available();
    }

    public int read() throws IOException {
        return this.sourceInputStream.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.sourceInputStream.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        return this.sourceInputStream.skip(l);
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public void reqCdata() {
        this.lexerState = 5;
    }

    public void reqEmbeddedXml() {
        this.lexerState = 6;
    }

    public void reqScriptCdata() {
        this.lexerState = 4;
    }

    protected void restoreBuffer(char[] cArray, int n, int n2) {
        if (this.mark != this.bufEnd) {
            int n3 = this.bufEnd - this.mark;
            if (n3 <= n) {
                System.arraycopy(this.char_buf, this.mark, cArray, n -= n3, n3);
            } else {
                int n4 = n2 - n;
                int n5 = n3 + n4;
                int n6 = this.char_buf.length;
                if (n5 <= n6) {
                    System.arraycopy(cArray, n, cArray, n3, n4);
                    System.arraycopy(this.char_buf, this.mark, cArray, 0, n3);
                } else {
                    if (n5 > (n6 *= 2)) {
                        n6 = n5;
                    }
                    char[] cArray2 = new char[n6];
                    System.arraycopy(cArray, n, cArray2, n3, n4);
                    System.arraycopy(this.char_buf, this.mark, cArray2, 0, n3);
                    cArray = cArray2;
                }
                n = 0;
                n2 = n5;
            }
        }
        this.char_buf = cArray;
        this.mark = n;
        this.bufEnd = n2;
    }

    private int fillBuffer(int n) throws IOException {
        return this.ensureAvailable(n, 1);
    }

    private int ensureAvailable(int n, int n2) throws IOException {
        int n3 = n + n2 - this.bufEnd;
        if (n3 > 0) {
            if (this.lexerNestingLevel > 1 || this.sourceInputStream == null && this.reader == null) {
                throw lexer_eof;
            }
            if (this.mark != 0) {
                System.arraycopy(this.char_buf, this.mark, this.char_buf, 0, this.bufEnd - this.mark);
                n -= this.mark;
                this.bufEnd -= this.mark;
                this.mark = 0;
            }
            this.readAtLeast(n3);
        }
        return n;
    }

    protected void readAtLeast(int n) throws IOException {
        int n2;
        int n3 = this.bufEnd + n;
        int n4 = this.char_buf.length;
        if (n3 > n4) {
            if (n3 > (n4 *= 2)) {
                n4 = n3;
            }
            char[] cArray = new char[n4];
            System.arraycopy(this.char_buf, 0, cArray, 0, this.bufEnd);
            this.char_buf = cArray;
        }
        do {
            if ((n2 = this.reader.read(this.char_buf, this.bufEnd, n4 - this.bufEnd)) < 0) {
                throw lexer_eof;
            }
            this.bufEnd += n2;
            this.inputReadProgress += n2;
        } while ((n -= n2) > 0);
    }

    void stopParsing() {
        this.done = true;
    }

    public final void parse() throws IOException {
        this.parse(true, true);
    }

    public void parse(boolean bl, boolean bl2) throws IOException {
        try {
            ++this.lexerNestingLevel;
            if (this.lexerNestingLevel == 1 && bl) {
                this.callback.startDocument();
            }
            this.do_parse(bl2);
            if (this.done && this.lexerNestingLevel == 1 && bl2) {
                this.callback.endDocument();
            }
            Object var4_3 = null;
            --this.lexerNestingLevel;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            --this.lexerNestingLevel;
            throw throwable;
        }
    }

    private void do_parse(boolean bl) throws IOException {
        block13: {
            try {
                while (!this.done) {
                    if (!this.callback.isStopRequested()) {
                        switch (this.lexerState) {
                            case 0: {
                                this.parseChars();
                                break;
                            }
                            case 1: {
                                this.parseMarkup();
                                break;
                            }
                            case 2: {
                                this.parseMetaMarkup();
                                break;
                            }
                            case 3: {
                                this.parseComments();
                                break;
                            }
                            case 4: 
                            case 5: 
                            case 6: {
                                this.parseCData();
                            }
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                if (iOException != lexer_eof) {
                    iOException.printStackTrace();
                    throw iOException;
                }
                if (this.lexerNestingLevel != 1 || !bl) break block13;
                if (this.lexerState != 3) {
                    this.onTextChars(this.char_buf, this.mark, this.bufEnd, 0);
                }
                this.done = true;
            }
        }
    }

    private int updateLineNumber(int n, int n2) throws IOException {
        if (this.lexerNestingLevel == 1) {
            if (n == 13) {
                if (n2 + 1 == this.bufEnd) {
                    n2 = this.ensureAvailable(n2, 2);
                }
                if (this.char_buf[n2 + 1] == '\n') {
                    return n2;
                }
            }
            ++this.lineNumber;
        }
        return n2;
    }

    private void parseChars() throws IOException {
        int n;
        int n2 = this.mark;
        int n3 = -1;
        while (true) {
            if (n2 == this.bufEnd) {
                n2 = this.fillBuffer(n2);
            }
            if ((n = this.char_buf[n2]) == 13 || n == 10) {
                n2 = this.updateLineNumber(n, n2);
            }
            ++n2;
            if (n == 60) {
                if (n2 == this.bufEnd) {
                    n2 = this.fillBuffer(n2);
                }
                if ((n = this.char_buf[n2]) == 13 || n == 10) {
                    n2 = this.updateLineNumber(n, n2);
                }
                if (!LexBase.isWhiteSpace(n) && n != 37 && n != 45 && n != 60) break;
                continue;
            }
            if (n != 38 || n3 >= 0) continue;
            n3 = n2 - this.mark - 1;
        }
        n = this.mark;
        int n4 = n2 - 1;
        this.mark = n2;
        this.lexerState = 1;
        this.onTextChars(this.char_buf, n, n4, n3);
    }

    private void onTextChars(char[] cArray, int n, int n2, int n3) {
        if (n != n2) {
            if (n3 >= 0) {
                n2 = this.resolveEntities(cArray, n + n3, n2);
            }
            this.callback.textCharacters(cArray, n, n2 - n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseCData() throws IOException {
        int n;
        int n2;
        int n3 = this.mark;
        int n4 = 0;
        block9: while (true) {
            if (n3 == this.bufEnd) {
                n3 = this.fillBuffer(n3);
            }
            if ((n2 = this.char_buf[n3]) == 13 || n2 == 10) {
                n3 = this.updateLineNumber(n2, n3);
            }
            ++n3;
            switch (n4) {
                case 0: {
                    if (n2 != 60) break;
                    n4 = 1;
                    break;
                }
                case 1: {
                    if (n2 == 47) {
                        char[] cArray;
                        n = 1;
                        if (this.lexerState == 6) {
                            cArray = this.char_buf;
                            n2 = cArray[n3 = this.ensureAvailable(n3, 5)];
                            n = !(n2 != 120 && n2 != 88 || (n2 = cArray[n3 + 1]) != 109 && n2 != 77 || (n2 = cArray[n3 + 2]) != 108 && n2 != 76 || (n2 = cArray[n3 + 3]) != 62) ? 1 : 0;
                        } else if (this.lexerState == 4) {
                            cArray = this.char_buf;
                            n2 = cArray[n3 = this.ensureAvailable(n3, 7)];
                            int n5 = n = !(n2 != 115 && n2 != 83 || (n2 = cArray[n3 + 1]) != 99 && n2 != 67 || (n2 = cArray[n3 + 2]) != 114 && n2 != 82 || (n2 = cArray[n3 + 3]) != 105 && n2 != 73 || (n2 = cArray[n3 + 4]) != 112 && n2 != 80 || (n2 = cArray[n3 + 5]) != 116 && n2 != 84 || (n2 = cArray[n3 + 6]) != 62 && !LexBase.isWhiteSpace(n2)) ? 1 : 0;
                        }
                        if (n == 0) break;
                        break block9;
                    }
                    if (n2 == 33) {
                        n4 = 2;
                        break;
                    }
                    --n3;
                    n4 = 0;
                    break;
                }
                case 2: {
                    if (n2 == 45) {
                        n4 = 3;
                        break;
                    }
                    --n3;
                    n4 = 0;
                    break;
                }
                case 3: {
                    if (n2 == 45) {
                        n4 = 4;
                        break;
                    }
                    --n3;
                    n4 = 0;
                    break;
                }
                case 4: {
                    if (n2 != 45) break;
                    n4 = 5;
                    break;
                }
                case 5: {
                    if (n2 == 45) {
                        n4 = 6;
                        break;
                    }
                    n4 = 4;
                    break;
                }
                case 6: {
                    if (n2 == 62) {
                        n4 = 0;
                        break;
                    }
                    if (n2 == 45) break;
                    n4 = 4;
                }
            }
        }
        n2 = this.mark;
        n = (n3 -= 2) - this.mark;
        this.lexerState = 0;
        this.mark = n3;
        this.callback.cdataBody(this.char_buf, n2, n);
    }

    private void parseMarkup() throws IOException {
        char c;
        int n = this.mark;
        if (n == this.bufEnd) {
            n = this.fillBuffer(n);
        }
        if ((c = this.char_buf[n]) == '!') {
            this.mark = n + 1;
            this.lexerState = 2;
        } else {
            this.parseElement();
        }
    }

    private void parseMetaMarkup() throws IOException {
        int n = this.ensureAvailable(this.mark, 2);
        if (this.char_buf[n] == '-' && this.char_buf[n + 1] == '-') {
            this.mark = n + 2;
            this.lexerState = 3;
            this.commentState = 0;
        } else {
            this.mark = n = this.parseMetaMarkup2(n);
            this.lexerState = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int parseMetaMarkup2(int n) throws IOException {
        int n2 = 0;
        while (true) {
            char c;
            if (n == this.bufEnd) {
                n = this.fillBuffer(n);
            }
            if ((c = this.char_buf[n]) == '\r' || c == '\n') {
                n = this.updateLineNumber(c, n);
            }
            ++n;
            switch (n2) {
                case 0: {
                    if (c == '>') {
                        return n;
                    }
                    if (c != '-') break;
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (c == '>') {
                        return n;
                    }
                    if (c == '-') {
                        n2 = 2;
                        break;
                    }
                    n2 = 0;
                    break;
                }
                case 2: {
                    if (c == '>') {
                        return n;
                    }
                    if (c == '-') break;
                    n2 = 3;
                    break;
                }
                case 3: {
                    if (c != '-') break;
                    n2 = 4;
                    break;
                }
                case 4: {
                    if (c == '-') {
                        n2 = 5;
                        break;
                    }
                    n2 = 3;
                    break;
                }
                case 5: {
                    if (c == '>') {
                        return n;
                    }
                    if (c == '-') break;
                    n2 = 0;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseComments() throws IOException {
        int n = this.mark;
        block6: while (true) {
            char c;
            if (n == this.bufEnd) {
                this.mark = n;
                n = this.fillBuffer(n);
            }
            if ((c = this.char_buf[n]) == '\r' || c == '\n') {
                n = this.updateLineNumber(c, n);
            }
            ++n;
            switch (this.commentState) {
                case 0: {
                    if (c == '>') break block6;
                    if (c == '-') break;
                    this.commentState = 1;
                    break;
                }
                case 1: {
                    if (c != '-') break;
                    this.commentState = 2;
                    break;
                }
                case 2: {
                    if (c == '-') {
                        this.commentState = 3;
                        break;
                    }
                    this.commentState = 1;
                    break;
                }
                case 3: {
                    if (c == '>') break block6;
                    if (c == '-') break;
                    this.commentState = 1;
                }
            }
        }
        this.mark = n;
        this.lexerState = 0;
    }

    private void parseElement() throws IOException {
        int n;
        int n2 = this.mark;
        int n3 = 0;
        while (true) {
            if (n2 == this.bufEnd) {
                n2 = this.fillBuffer(n2);
            }
            if ((n = this.char_buf[n2]) == 13 || n == 10) {
                n2 = this.updateLineNumber(n, n2);
            }
            if (n == 39 || n == 34) {
                char c;
                if (n3 == n) {
                    n3 = 0;
                } else if (n3 == 0 && (LexBase.isWhiteSpace(c = this.char_buf[n2 - 1]) || c == '=')) {
                    n3 = n;
                }
            } else if (n == 62 && n3 == 0) break;
            ++n2;
        }
        n = this.mark;
        this.mark = ++n2;
        this.lexerState = 0;
        char[] cArray = this.char_buf;
        int n4 = this.mark;
        int n5 = this.bufEnd;
        this.char_buf = EMPTY_CHAR_ARRAY;
        this.mark = 0;
        this.bufEnd = 0;
        try {
            if (cArray[n] != '/') {
                this.doElementCallback(cArray, n, n2 - n - 1);
            } else {
                int n6 = 0;
                int n7 = ++n;
                while (n7 < n2) {
                    char c = cArray[n7];
                    ++n7;
                    if (c == ':') {
                        n6 = n7 - n;
                    }
                    if (LexBase.isWhiteSpace(c)) break;
                }
                this.callback.endElement(this, cArray, n, n7 - n - 1, n6);
            }
            Object var11_11 = null;
            this.restoreBuffer(cArray, n4, n5);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.restoreBuffer(cArray, n4, n5);
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doElementCallback(char[] var1_1, int var2_2, int var3_3) {
        block32: {
            var4_4 = '\u0000';
            var5_5 = false;
            var4_4 = var1_1[var2_2 + var3_3 - 1];
            if (var4_4 == '/') {
                var5_5 = true;
                --var3_3;
                var4_4 = var1_1[var2_2];
                var6_6 = var1_1[var2_2 + 1];
                if (!((var4_4 != 'a' && var4_4 != 'A' || var6_6 != 32) && (var4_4 != 'b' && var4_4 != 'B' || var6_6 != 97 && var6_6 != 65 || var1_1[var2_2 + 4] != ' ') && (var4_4 != 'o' && var4_4 != 'O' || var6_6 != 112 && var6_6 != 80 || var1_1[var2_2 + 6] != ' ') && (var4_4 != 'f' && var4_4 != 'F' || var6_6 != 111 && var6_6 != 79 || var1_1[var2_2 + 4] != ' '))) {
                    var5_5 = false;
                    ++var3_3;
                }
            } else if (var4_4 == '?') {
                --var3_3;
            }
            var6_6 = var2_2;
            var7_7 = var2_2 + var3_3;
            var8_8 = 0;
            while (var6_6 < var7_7) {
                var4_4 = var1_1[var6_6];
                if (LexBase.isWhiteSpace(var4_4)) break;
                if (var4_4 == ':') {
                    var8_8 = var6_6 - var2_2 + 1;
                }
                ++var6_6;
            }
            var9_9 = var2_2;
            var10_10 = var6_6 - var2_2;
            break block32;
            while (LexBase.isWhiteSpace(var4_4 = var1_1[var6_6])) {
                ++var6_6;
lbl30:
                // 2 sources

                ** while (var6_6 >= var7_7)
lbl31:
                // 1 sources

            }
lbl32:
            // 2 sources

            var11_11 = var6_6;
            var12_12 = 0;
            while (var6_6 < var7_7) {
                var4_4 = var1_1[var6_6];
                if (LexBase.isWhiteSpace(var4_4) || var4_4 == '=') break;
                if (var4_4 == ':') {
                    var12_12 = var6_6 - var11_11 + 1;
                }
                ++var6_6;
            }
            var13_13 = var6_6 - var11_11;
            var14_14 = false;
            while (var6_6 < var7_7) {
                var4_4 = var1_1[var6_6];
                if (var4_4 == '=') {
                    var14_14 = true;
                } else if (!LexBase.isWhiteSpace(var4_4)) break;
                ++var6_6;
            }
            if (!var14_14) {
                if (var13_13 > 0) {
                    this.callback.elementAttribute(var1_1, var11_11, var13_13, var12_12, var11_11, var13_13);
                }
            } else {
                var15_15 = var6_6;
                var16_16 = 0;
                var17_17 = '\u0000';
                if (var4_4 == '\'' || var4_4 == '\"') {
                    var17_17 = var4_4;
                }
                if (var17_17 == '\u0000') {
                    while (var6_6 < var7_7) {
                        var4_4 = var1_1[var6_6];
                        if (!LexBase.isWhiteSpace(var4_4)) {
                            if (var4_4 == '&') {
                                var16_16 = 1;
                            }
                            ++var6_6;
                            continue;
                        }
                        break;
                    }
                } else {
                    ++var6_6;
                    while (var6_6 < var7_7) {
                        var4_4 = var1_1[var6_6];
                        if (var4_4 == var17_17) {
                            ++var6_6;
                            break;
                        }
                        if (var4_4 == '&' || var4_4 == '\n' || var4_4 == '\r' || var4_4 == '\t') {
                            var16_16 = 1;
                        }
                        ++var6_6;
                    }
                }
                var18_18 = false;
                if (!(var16_16 <= 0 || var13_13 <= 2 || var1_1[var11_11] != 'o' && var1_1[var11_11] != 'O' || var1_1[var11_11 + 1] != 'n' && var1_1[var11_11 + 1] != 'N')) {
                    var18_18 = true;
                }
                var19_19 = var6_6 - var15_15;
                if (var17_17 != '\u0000') {
                    if (var19_19 >= 2) {
                        if (var16_16 > 0) {
                            var16_16 = this.substWeirdChars(var1_1, var15_15 + 1, var19_19 - 2, var18_18);
                        }
                        this.callback.elementAttribute(var1_1, var11_11, var13_13, var12_12, var15_15 + 1, var19_19 - 2 - var16_16);
                    }
                } else {
                    if (var16_16 > 0) {
                        var16_16 = this.substWeirdChars(var1_1, var15_15, var19_19, var18_18);
                    }
                    this.callback.elementAttribute(var1_1, var11_11, var13_13, var12_12, var15_15, var19_19 - var16_16);
                }
            }
        }
        if (var6_6 < var7_7) ** GOTO lbl30
        this.callback.startElement(this, var1_1, var9_9, var10_10, var8_8, var5_5);
    }

    /*
     * Unable to fully structure code
     */
    private int substWeirdChars(char[] var1_1, int var2_2, int var3_3, boolean var4_4) {
        var5_5 = new char[var3_3];
        System.arraycopy(var1_1, var2_2, var5_5, 0, var3_3);
        var6_6 = 0;
        var7_7 = 0;
        while (var7_7 < var3_3) {
            var8_8 = var5_5[var7_7];
            if (var4_4) ** GOTO lbl-1000
            if (var8_8 == '\r' || var8_8 == '\n') {
                ++var6_6;
            } else if (var8_8 == '\t') {
                var1_1[var2_2++] = 32;
            } else if (var8_8 == '&') {
                var9_9 = var7_7 + 1;
                while (var9_9 <= var3_3) {
                    if ((var9_9 == var3_3 || var5_5[var9_9] == ';') && (var11_11 = this.entityToChar(var5_5, var7_7 + 1, var10_10 = var9_9 - var7_7 - 1)) >= 0) {
                        var7_7 = var9_9;
                        var1_1[var2_2++] = (char)var11_11;
                        var6_6 += var10_10;
                        if (var9_9 >= var3_3) break;
                        ++var6_6;
                        break;
                    }
                    ++var9_9;
                }
                if (var9_9 > var3_3) {
                    var1_1[var2_2++] = var8_8;
                }
            } else {
                var1_1[var2_2++] = var8_8;
            }
            ++var7_7;
        }
        return var6_6;
    }

    private static boolean isWhiteSpace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13 || n == 12;
    }

    private boolean isBadEntityTerminator(int n) {
        return LexBase.isWhiteSpace(n) || n == 38 || n == 60 || n == 34 || n == 39;
    }

    private int resolveEntities(char[] cArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = -1;
        int n7 = -1;
        int n8 = n;
        while (n8 != n2) {
            n5 = cArray[n8];
            ++n8;
            if (n5 != 38) continue;
            n4 = n2;
            n3 = n8;
            while (n3 != n2) {
                n5 = cArray[n3];
                if (n5 == 59) {
                    n4 = n3++;
                    break;
                }
                if (this.isBadEntityTerminator(n5)) {
                    n4 = n3;
                    break;
                }
                ++n3;
            }
            n7 = this.entityToChar(cArray, n8, n4 - n8);
            if (n7 < 0) continue;
            n6 = n8 - 1;
            n8 = n3;
            break;
        }
        if (n7 >= 0) {
            cArray[n6] = (char)n7;
            ++n6;
            while (n8 != n2) {
                n5 = cArray[n8];
                ++n8;
                if (n5 == 38) {
                    n4 = n2;
                    n3 = n8;
                    while (n3 != n2) {
                        n5 = cArray[n3];
                        if (n5 == 59) {
                            n4 = n3++;
                            break;
                        }
                        if (this.isBadEntityTerminator(n5)) {
                            n4 = n3;
                            break;
                        }
                        ++n3;
                    }
                    n5 = this.entityToChar(cArray, n8, n4 - n8);
                    if (n5 < 0) {
                        n5 = 38;
                    } else {
                        n8 = n3;
                    }
                }
                cArray[n6] = (char)n5;
                ++n6;
            }
            n2 = n6;
        }
        return n2;
    }

    private int entityToChar(char[] cArray, int n, int n2) {
        int n3 = -1;
        if (n2 > 1) {
            if (cArray[n] == '#') {
                String string = new String(cArray, n + 1, n2 - 1);
                try {
                    n3 = (char)Integer.parseInt(string);
                }
                catch (Exception exception) {}
            } else {
                n3 = LexBase.entityNameToChar(cArray, n, n2);
            }
            switch (n3) {
                case 9: {
                    n3 = 32;
                    break;
                }
                case 128: {
                    n3 = 8364;
                    break;
                }
                case 130: {
                    n3 = 44;
                    break;
                }
                case 132: {
                    n3 = 8222;
                    break;
                }
                case 133: {
                    n3 = 8230;
                    break;
                }
                case 134: {
                    n3 = 8224;
                    break;
                }
                case 135: {
                    n3 = 8225;
                    break;
                }
                case 136: {
                    n3 = 94;
                    break;
                }
                case 137: {
                    n3 = 8240;
                    break;
                }
                case 139: {
                    n3 = 60;
                    break;
                }
                case 145: 
                case 146: {
                    n3 = 39;
                    break;
                }
                case 147: 
                case 148: {
                    n3 = 34;
                    break;
                }
                case 149: {
                    n3 = 42;
                    break;
                }
                case 150: 
                case 151: {
                    n3 = 45;
                    break;
                }
                case 152: {
                    n3 = 126;
                    break;
                }
                case 153: {
                    n3 = 8482;
                    break;
                }
                case 155: {
                    n3 = 62;
                }
            }
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int entityNameToChar(char[] cArray, int n, int n2) {
        switch (n2) {
            case 2: {
                char c = cArray[n + 1];
                switch (cArray[n]) {
                    case 'M': {
                        if (c != 'u') return -1;
                        return 924;
                    }
                    case 'N': {
                        if (c != 'u') return -1;
                        return 925;
                    }
                    case 'P': {
                        if (c != 'i') return -1;
                        return 928;
                    }
                    case 'X': {
                        if (c != 'i') return -1;
                        return 926;
                    }
                    case 'g': {
                        if (c == 'e') {
                            return 8805;
                        }
                        if (c != 't') return -1;
                        return 62;
                    }
                    case 'l': {
                        if (c == 'e') {
                            return 8804;
                        }
                        if (c != 't') return -1;
                        return 60;
                    }
                    case 'm': {
                        if (c != 'u') return -1;
                        return 956;
                    }
                    case 'n': {
                        if (c == 'e') {
                            return 8800;
                        }
                        if (c == 'i') {
                            return 8715;
                        }
                        if (c != 'u') return -1;
                        return 957;
                    }
                    case 'o': {
                        if (c != 'r') return -1;
                        return 8744;
                    }
                    case 'p': {
                        if (c != 'i') return -1;
                        return 960;
                    }
                    case 'x': {
                        if (c != 'i') return -1;
                        return 958;
                    }
                }
                return -1;
            }
            case 3: {
                char c = cArray[n + 1];
                char c2 = cArray[n + 2];
                switch (cArray[n]) {
                    case 'C': {
                        if (0 != (c ^ 0x68 | c2 ^ 0x69)) return -1;
                        return 935;
                    }
                    case 'E': {
                        if (c == 'T') {
                            if (c2 != 'H') return -1;
                            return 208;
                        }
                        if (c != 't' || c2 != 'a') return -1;
                        return 919;
                    }
                    case 'P': {
                        if (c2 != 'i') return -1;
                        if (c == 'h') {
                            return 934;
                        }
                        if (c != 's') return -1;
                        return 936;
                    }
                    case 'R': {
                        if (0 != (c ^ 0x68 | c2 ^ 0x6F)) return -1;
                        return 929;
                    }
                    case 'T': {
                        if (0 != (c ^ 0x61 | c2 ^ 0x75)) return -1;
                        return 932;
                    }
                    case 'a': {
                        if (c2 == 'p') {
                            if (c != 'm') return -1;
                            return 38;
                        }
                        if (c2 == 'd') {
                            if (c != 'n') return -1;
                            return 8743;
                        }
                        if (c2 != 'g' || c != 'n') return -1;
                        return 8736;
                    }
                    case 'c': {
                        if (c == 'a') {
                            if (c2 != 'p') return -1;
                            return 8745;
                        }
                        if (c == 'h') {
                            if (c2 != 'i') return -1;
                            return 967;
                        }
                        if (c != 'u' || c2 != 'p') return -1;
                        return 8746;
                    }
                    case 'd': {
                        if (0 != (c ^ 0x65 | c2 ^ 0x67)) return -1;
                        return 176;
                    }
                    case 'e': {
                        if (c != 't') return -1;
                        if (c2 == 'a') {
                            return 951;
                        }
                        if (c2 != 'h') return -1;
                        return 240;
                    }
                    case 'i': {
                        if (0 != (c ^ 0x6E | c2 ^ 0x74)) return -1;
                        return 8747;
                    }
                    case 'l': {
                        if (c == 'o') {
                            if (c2 != 'z') return -1;
                            return 9674;
                        }
                        if (c != 'r' || c2 != 'm') return -1;
                        return 8206;
                    }
                    case 'n': {
                        if (0 != (c ^ 0x6F | c2 ^ 0x74)) return -1;
                        return 172;
                    }
                    case 'p': {
                        if (c == 'h') {
                            if (c2 != 'i') return -1;
                            return 966;
                        }
                        if (c == 'i') {
                            if (c2 != 'v') return -1;
                            return 982;
                        }
                        if (c != 's' || c2 != 'i') return -1;
                        return 968;
                    }
                    case 'r': {
                        if (c == 'e') {
                            if (c2 != 'g') return -1;
                            return 174;
                        }
                        if (c == 'h') {
                            if (c2 != 'o') return -1;
                            return 961;
                        }
                        if (c != 'l' || c2 != 'm') return -1;
                        return 8207;
                    }
                    case 's': {
                        if (c == 'h') {
                            if (c2 != 'y') return -1;
                            return 173;
                        }
                        if (c == 'i') {
                            if (c2 != 'm') return -1;
                            return 8764;
                        }
                        if (c != 'u') return -1;
                        if (c2 == 'b') {
                            return 8834;
                        }
                        if (c2 == 'm') {
                            return 8721;
                        }
                        if (c2 != 'p') return -1;
                        return 8835;
                    }
                    case 't': {
                        if (0 != (c ^ 0x61 | c2 ^ 0x75)) return -1;
                        return 964;
                    }
                    case 'u': {
                        if (0 != (c ^ 0x6D | c2 ^ 0x6C)) return -1;
                        return 168;
                    }
                    case 'y': {
                        if (0 != (c ^ 0x65 | c2 ^ 0x6E)) return -1;
                        return 165;
                    }
                    case 'z': {
                        if (0 != (c ^ 0x77 | c2 ^ 0x6A)) return -1;
                        return 8205;
                    }
                }
                return -1;
            }
            case 4: {
                char c = cArray[n + 1];
                char c3 = cArray[n + 2];
                char c4 = cArray[n + 3];
                switch (cArray[n]) {
                    case 'A': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) return -1;
                        return 196;
                    }
                    case 'B': {
                        if (0 != (c ^ 0x65 | c3 ^ 0x74 | c4 ^ 0x61)) return -1;
                        return 914;
                    }
                    case 'E': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) return -1;
                        return 203;
                    }
                    case 'I': {
                        if (c == 'o') {
                            if (0 != (c3 ^ 0x74 | c4 ^ 0x61)) return -1;
                            return 921;
                        }
                        if (c != 'u' || 0 != (c3 ^ 0x6D | c4 ^ 0x6C)) return -1;
                        return 207;
                    }
                    case 'O': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) return -1;
                        return 214;
                    }
                    case 'U': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) return -1;
                        return 220;
                    }
                    case 'Y': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) return -1;
                        return 376;
                    }
                    case 'Z': {
                        if (0 != (c ^ 0x65 | c3 ^ 0x74 | c4 ^ 0x61)) return -1;
                        return 918;
                    }
                    case 'a': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) return -1;
                        return 228;
                    }
                    case 'b': {
                        if (c == 'e') {
                            if (0 != (c3 ^ 0x74 | c4 ^ 0x61)) return -1;
                            return 946;
                        }
                        if (c != 'u' || 0 != (c3 ^ 0x6C | c4 ^ 0x6C)) return -1;
                        return 8226;
                    }
                    case 'c': {
                        switch (c4) {
                            case 't': {
                                if (0 != (c ^ 0x65 | c3 ^ 0x6E)) return -1;
                                return 162;
                            }
                            case 'c': {
                                if (0 != (c ^ 0x69 | c3 ^ 0x72)) return -1;
                                return 710;
                            }
                            case 'g': {
                                if (0 != (c ^ 0x6F | c3 ^ 0x6E)) return -1;
                                return 8773;
                            }
                            case 'y': {
                                if (0 != (c ^ 0x6F | c3 ^ 0x70)) return -1;
                                return 169;
                            }
                        }
                        return -1;
                    }
                    case 'd': {
                        if (0 != (c3 ^ 0x72 | c4 ^ 0x72)) return -1;
                        if (c == 'A') {
                            return 8659;
                        }
                        if (c != 'a') return -1;
                        return 8595;
                    }
                    case 'e': {
                        if (c == 'm') {
                            if (0 != (c3 ^ 0x73 | c4 ^ 0x70)) return -1;
                            return 8195;
                        }
                        if (c == 'n') {
                            if (0 != (c3 ^ 0x73 | c4 ^ 0x70)) return -1;
                            return 8194;
                        }
                        if (c != 'u') return -1;
                        if (c3 == 'm') {
                            if (c4 != 'l') return -1;
                            return 235;
                        }
                        if (c3 != 'r' || c4 != 'o') return -1;
                        return 8364;
                    }
                    case 'f': {
                        if (0 != (c ^ 0x6E | c3 ^ 0x6F | c4 ^ 0x66)) return -1;
                        return 402;
                    }
                    case 'h': {
                        if (0 != (c3 ^ 0x72 | c4 ^ 0x72)) return -1;
                        if (c == 'A') {
                            return 8660;
                        }
                        if (c != 'a') return -1;
                        return 8596;
                    }
                    case 'i': {
                        if (c == 'o') {
                            if (0 != (c3 ^ 0x74 | c4 ^ 0x61)) return -1;
                            return 953;
                        }
                        if (c == 's') {
                            if (0 != (c3 ^ 0x69 | c4 ^ 0x6E)) return -1;
                            return 8712;
                        }
                        if (c != 'u' || 0 != (c3 ^ 0x6D | c4 ^ 0x6C)) return -1;
                        return 239;
                    }
                    case 'l': {
                        if (c4 == 'r') {
                            if (c3 != 'r') return -1;
                            if (c == 'A') {
                                return 8656;
                            }
                            if (c != 'a') return -1;
                            return 8592;
                        }
                        if (c4 != 'g' || 0 != (c ^ 0x61 | c3 ^ 0x6E)) return -1;
                        return 9001;
                    }
                    case 'm': {
                        if (0 != (c ^ 0x61 | c3 ^ 0x63 | c4 ^ 0x72)) return -1;
                        return 175;
                    }
                    case 'n': {
                        if (c == 'b') {
                            if (0 != (c3 ^ 0x73 | c4 ^ 0x70)) return -1;
                            return 160;
                        }
                        if (c != 's' || 0 != (c3 ^ 0x75 | c4 ^ 0x62)) return -1;
                        return 8836;
                    }
                    case 'o': {
                        if (c4 == 'f') {
                            if (0 != (c ^ 0x72 | c3 ^ 0x64)) return -1;
                            return 170;
                        }
                        if (c4 == 'l') {
                            if (0 != (c ^ 0x75 | c3 ^ 0x6D)) return -1;
                            return 246;
                        }
                        if (c4 != 'm' || 0 != (c ^ 0x72 | c3 ^ 0x64)) return -1;
                        return 186;
                    }
                    case 'p': {
                        if (c == 'a') {
                            if (c3 != 'r') return -1;
                            if (c4 == 'a') {
                                return 182;
                            }
                            if (c4 != 't') return -1;
                            return 8706;
                        }
                        if (c == 'e') {
                            if (0 != (c3 ^ 0x72 | c4 ^ 0x70)) return -1;
                            return 8869;
                        }
                        if (c != 'r' || c3 != 'o') return -1;
                        if (c4 == 'd') {
                            return 8719;
                        }
                        if (c4 != 'p') return -1;
                        return 8733;
                    }
                    case 'q': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6F | c4 ^ 0x74)) return -1;
                        return 34;
                    }
                    case 'r': {
                        if (c == 'A') {
                            if (0 != (c3 ^ 0x72 | c4 ^ 0x72)) return -1;
                            return 8658;
                        }
                        if (c == 'a') {
                            if (c3 == 'n') {
                                if (c4 != 'g') return -1;
                                return 9002;
                            }
                            if (c3 != 'r' || c4 != 'r') return -1;
                            return 8594;
                        }
                        if (c != 'e' || 0 != (c3 ^ 0x61 | c4 ^ 0x6C)) return -1;
                        return 8476;
                    }
                    case 's': {
                        switch (c3) {
                            case 'o': {
                                if (0 != (c ^ 0x64 | c4 ^ 0x74)) return -1;
                                return 8901;
                            }
                            case 'c': {
                                if (0 != (c ^ 0x65 | c4 ^ 0x74)) return -1;
                                return 167;
                            }
                            case 'b': {
                                if (0 != (c ^ 0x75 | c4 ^ 0x65)) return -1;
                                return 8838;
                            }
                            case 'p': {
                                if (c != 'u') return -1;
                                switch (c4) {
                                    case '1': {
                                        return 185;
                                    }
                                    case '2': {
                                        return 178;
                                    }
                                    case '3': {
                                        return 179;
                                    }
                                    case 'e': {
                                        return 8839;
                                    }
                                }
                                return -1;
                            }
                        }
                        return -1;
                    }
                    case 'u': {
                        if (c == 'A') {
                            if (0 != (c3 ^ 0x72 | c4 ^ 0x72)) return -1;
                            return 8657;
                        }
                        if (c == 'a') {
                            if (0 != (c3 ^ 0x72 | c4 ^ 0x72)) return -1;
                            return 8593;
                        }
                        if (c != 'u' || 0 != (c3 ^ 0x6D | c4 ^ 0x6C)) return -1;
                        return 252;
                    }
                    case 'y': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) return -1;
                        return 255;
                    }
                    case 'z': {
                        if (c == 'e') {
                            if (0 != (c3 ^ 0x74 | c4 ^ 0x61)) return -1;
                            return 950;
                        }
                        if (c != 'w' || 0 != (c3 ^ 0x6E | c4 ^ 0x6A)) return -1;
                        return 8204;
                    }
                }
                return -1;
            }
            case 5: {
                char c = cArray[n + 1];
                char c5 = cArray[n + 2];
                char c6 = cArray[n + 3];
                char c7 = cArray[n + 4];
                switch (cArray[n]) {
                    case 'A': {
                        switch (c) {
                            case 'E': {
                                if (0 != (c5 ^ 0x6C | c6 ^ 0x69 | c7 ^ 0x67)) return -1;
                                return 198;
                            }
                            case 'c': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) return -1;
                                return 194;
                            }
                            case 'l': {
                                if (0 != (c5 ^ 0x70 | c6 ^ 0x68 | c7 ^ 0x61)) return -1;
                                return 913;
                            }
                            case 'r': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x6E | c7 ^ 0x67)) return -1;
                                return 197;
                            }
                        }
                        return -1;
                    }
                    case 'D': {
                        if (0 != (c ^ 0x65 | c5 ^ 0x6C | c6 ^ 0x74 | c7 ^ 0x61)) return -1;
                        return 916;
                    }
                    case 'E': {
                        if (0 != (c ^ 0x63 | c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) return -1;
                        return 202;
                    }
                    case 'G': {
                        if (0 != (c ^ 0x61 | c5 ^ 0x6D | c6 ^ 0x6D | c7 ^ 0x61)) return -1;
                        return 915;
                    }
                    case 'I': {
                        if (0 != (c ^ 0x63 | c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) return -1;
                        return 206;
                    }
                    case 'K': {
                        if (0 != (c ^ 0x61 | c5 ^ 0x70 | c6 ^ 0x70 | c7 ^ 0x61)) return -1;
                        return 922;
                    }
                    case 'O': {
                        if (c == 'E') {
                            if (0 != (c5 ^ 0x6C | c6 ^ 0x69 | c7 ^ 0x67)) return -1;
                            return 338;
                        }
                        if (c == 'c') {
                            if (0 != (c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) return -1;
                            return 212;
                        }
                        if (c != 'm' || 0 != (c5 ^ 0x65 | c6 ^ 0x67 | c7 ^ 0x61)) return -1;
                        return 937;
                    }
                    case 'P': {
                        if (0 != (c ^ 0x72 | c5 ^ 0x69 | c6 ^ 0x6D | c7 ^ 0x65)) return -1;
                        return 8243;
                    }
                    case 'S': {
                        if (0 != (c ^ 0x69 | c5 ^ 0x67 | c6 ^ 0x6D | c7 ^ 0x61)) return -1;
                        return 931;
                    }
                    case 'T': {
                        if (c == 'H') {
                            if (0 != (c5 ^ 0x4F | c6 ^ 0x52 | c7 ^ 0x4E)) return -1;
                            return 222;
                        }
                        if (c != 'h' || 0 != (c5 ^ 0x65 | c6 ^ 0x74 | c7 ^ 0x61)) return -1;
                        return 920;
                    }
                    case 'U': {
                        if (0 != (c ^ 0x63 | c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) return -1;
                        return 219;
                    }
                    case 'a': {
                        switch (c6) {
                            case 'i': {
                                if (0 != (c ^ 0x65 | c5 ^ 0x6C | c7 ^ 0x67)) return -1;
                                return 230;
                            }
                            case 'h': {
                                if (0 != (c ^ 0x6C | c5 ^ 0x70 | c7 ^ 0x61)) return -1;
                                return 945;
                            }
                            case 'n': {
                                if (0 != (c ^ 0x72 | c5 ^ 0x69 | c7 ^ 0x67)) return -1;
                                return 229;
                            }
                            case 'r': {
                                if (0 != (c ^ 0x63 | c5 ^ 0x69 | c7 ^ 0x63)) return -1;
                                return 226;
                            }
                            case 'm': {
                                if (0 != (c ^ 0x73 | c5 ^ 0x79 | c7 ^ 0x70)) return -1;
                                return 8776;
                            }
                            case 't': {
                                if (0 != (c ^ 0x63 | c5 ^ 0x75 | c7 ^ 0x65)) return -1;
                                return 180;
                            }
                        }
                        return -1;
                    }
                    case 'b': {
                        if (0 != (c ^ 0x64 | c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) return -1;
                        return 8222;
                    }
                    case 'c': {
                        if (c == 'e') {
                            if (0 != (c5 ^ 0x64 | c6 ^ 0x69 | c7 ^ 0x6C)) return -1;
                            return 184;
                        }
                        if (c == 'l') {
                            if (0 != (c5 ^ 0x75 | c6 ^ 0x62 | c7 ^ 0x73)) return -1;
                            return 9827;
                        }
                        if (c != 'r' || 0 != (c5 ^ 0x61 | c6 ^ 0x72 | c7 ^ 0x72)) return -1;
                        return 8629;
                    }
                    case 'd': {
                        if (c == 'e' && 0 == (c5 ^ 0x6C | c6 ^ 0x74 | c7 ^ 0x61)) {
                            return 948;
                        }
                        if (c != 'i' || 0 != (c5 ^ 0x61 | c6 ^ 0x6D | c7 ^ 0x73)) return -1;
                        return 9830;
                    }
                    case 'e': {
                        switch (c) {
                            case 'c': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) return -1;
                                return 234;
                            }
                            case 'm': {
                                if (0 != (c5 ^ 0x70 | c6 ^ 0x74 | c7 ^ 0x79)) return -1;
                                return 8709;
                            }
                            case 'q': {
                                if (0 != (c5 ^ 0x75 | c6 ^ 0x69 | c7 ^ 0x76)) return -1;
                                return 8801;
                            }
                            case 'x': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x73 | c7 ^ 0x74)) return -1;
                                return 8707;
                            }
                        }
                        return -1;
                    }
                    case 'f': {
                        if (0 != (c ^ 0x72 | c5 ^ 0x61 | c6 ^ 0x73 | c7 ^ 0x6C)) return -1;
                        return 8260;
                    }
                    case 'g': {
                        if (0 != (c ^ 0x61 | c5 ^ 0x6D | c6 ^ 0x6D | c7 ^ 0x61)) return -1;
                        return 947;
                    }
                    case 'i': {
                        switch (c) {
                            case 'c': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) return -1;
                                return 238;
                            }
                            case 'e': {
                                if (0 != (c5 ^ 0x78 | c6 ^ 0x63 | c7 ^ 0x6C)) return -1;
                                return 161;
                            }
                            case 'm': {
                                if (0 != (c5 ^ 0x61 | c6 ^ 0x67 | c7 ^ 0x65)) return -1;
                                return 8465;
                            }
                            case 'n': {
                                if (0 != (c5 ^ 0x66 | c6 ^ 0x69 | c7 ^ 0x6E)) return -1;
                                return 8734;
                            }
                        }
                        return -1;
                    }
                    case 'k': {
                        if (0 != (c ^ 0x61 | c5 ^ 0x70 | c6 ^ 0x70 | c7 ^ 0x61)) return -1;
                        return 954;
                    }
                    case 'l': {
                        switch (c) {
                            case 'a': {
                                if (0 != (c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) return -1;
                                return 171;
                            }
                            case 'c': {
                                if (0 != (c5 ^ 0x65 | c6 ^ 0x69 | c7 ^ 0x6C)) return -1;
                                return 8968;
                            }
                            case 'd': {
                                if (0 != (c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) return -1;
                                return 8220;
                            }
                            case 's': {
                                if (0 != (c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) return -1;
                                return 8216;
                            }
                        }
                        return -1;
                    }
                    case 'm': {
                        if (c5 == 'a') {
                            if (0 != (c ^ 0x64 | c6 ^ 0x73 | c7 ^ 0x68)) return -1;
                            return 8212;
                        }
                        if (c5 == 'c') {
                            if (0 != (c ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x6F)) return -1;
                            return 181;
                        }
                        if (c5 != 'n' || 0 != (c ^ 0x69 | c6 ^ 0x75 | c7 ^ 0x73)) return -1;
                        return 8722;
                    }
                    case 'n': {
                        if (c == 'a') {
                            if (0 != (c5 ^ 0x62 | c6 ^ 0x6C | c7 ^ 0x61)) return -1;
                            return 8711;
                        }
                        if (c == 'd') {
                            if (0 != (c5 ^ 0x61 | c6 ^ 0x73 | c7 ^ 0x68)) return -1;
                            return 8211;
                        }
                        if (c != 'o' || 0 != (c5 ^ 0x74 | c6 ^ 0x69 | c7 ^ 0x6E)) return -1;
                        return 8713;
                    }
                    case 'o': {
                        switch (c) {
                            case 'c': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) return -1;
                                return 244;
                            }
                            case 'e': {
                                if (0 != (c5 ^ 0x6C | c6 ^ 0x69 | c7 ^ 0x67)) return -1;
                                return 339;
                            }
                            case 'l': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x6E | c7 ^ 0x65)) return -1;
                                return 8254;
                            }
                            case 'm': {
                                if (0 != (c5 ^ 0x65 | c6 ^ 0x67 | c7 ^ 0x61)) return -1;
                                return 969;
                            }
                            case 'p': {
                                if (0 != (c5 ^ 0x6C | c6 ^ 0x75 | c7 ^ 0x73)) return -1;
                                return 8853;
                            }
                        }
                        return -1;
                    }
                    case 'p': {
                        if (c == 'o') {
                            if (0 != (c5 ^ 0x75 | c6 ^ 0x6E | c7 ^ 0x64)) return -1;
                            return 163;
                        }
                        if (c != 'r' || 0 != (c5 ^ 0x69 | c6 ^ 0x6D | c7 ^ 0x65)) return -1;
                        return 8242;
                    }
                    case 'r': {
                        switch (c) {
                            case 'a': {
                                if (c5 == 'q') {
                                    if (0 != (c6 ^ 0x75 | c7 ^ 0x6F)) return -1;
                                    return 187;
                                }
                                if (c5 != 'd' || 0 != (c6 ^ 0x69 | c7 ^ 0x63)) return -1;
                                return 8730;
                            }
                            case 'c': {
                                if (0 != (c5 ^ 0x65 | c6 ^ 0x69 | c7 ^ 0x6C)) return -1;
                                return 8969;
                            }
                            case 'd': {
                                if (0 != (c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) return -1;
                                return 8221;
                            }
                            case 's': {
                                if (0 != (c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) return -1;
                                return 8217;
                            }
                        }
                        return -1;
                    }
                    case 's': {
                        if (c == 'b') {
                            if (0 != (c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) return -1;
                            return 8218;
                        }
                        if (c == 'i') {
                            if (0 != (c5 ^ 0x67 | c6 ^ 0x6D | c7 ^ 0x61)) return -1;
                            return 963;
                        }
                        if (c != 'z' || 0 != (c5 ^ 0x6C | c6 ^ 0x69 | c7 ^ 0x67)) return -1;
                        return 223;
                    }
                    case 't': {
                        switch (c5) {
                            case 'e': {
                                if (0 != (c ^ 0x68 | c6 ^ 0x74 | c7 ^ 0x61)) return -1;
                                return 952;
                            }
                            case 'o': {
                                if (0 != (c ^ 0x68 | c6 ^ 0x72 | c7 ^ 0x6E)) return -1;
                                return 254;
                            }
                            case 'l': {
                                if (0 != (c ^ 0x69 | c6 ^ 0x64 | c7 ^ 0x65)) return -1;
                                return 732;
                            }
                            case 'm': {
                                if (0 != (c ^ 0x69 | c6 ^ 0x65 | c7 ^ 0x73)) return -1;
                                return 215;
                            }
                            case 'a': {
                                if (0 != (c ^ 0x72 | c6 ^ 0x64 | c7 ^ 0x65)) return -1;
                                return 8482;
                            }
                        }
                        return -1;
                    }
                    case 'u': {
                        if (c == 'c') {
                            if (0 != (c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) return -1;
                            return 251;
                        }
                        if (c != 'p' || 0 != (c5 ^ 0x73 | c6 ^ 0x69 | c7 ^ 0x68)) return -1;
                        return 978;
                    }
                }
                return -1;
            }
            case 6: {
                char c = cArray[n + 1];
                char c8 = cArray[n + 2];
                char c9 = cArray[n + 3];
                char c10 = cArray[n + 4];
                char c11 = cArray[n + 5];
                switch (cArray[n]) {
                    case 'A': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) return -1;
                            return 193;
                        }
                        if (c == 'g') {
                            if (0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) return -1;
                            return 192;
                        }
                        if (c != 't' || 0 != (c8 ^ 0x69 | c9 ^ 0x6C | c10 ^ 0x64 | c11 ^ 0x65)) return -1;
                        return 195;
                    }
                    case 'C': {
                        if (0 != (c ^ 0x63 | c8 ^ 0x65 | c9 ^ 0x64 | c10 ^ 0x69 | c11 ^ 0x6C)) return -1;
                        return 199;
                    }
                    case 'D': {
                        if (0 != (c ^ 0x61 | c8 ^ 0x67 | c9 ^ 0x67 | c10 ^ 0x65 | c11 ^ 0x72)) return -1;
                        return 8225;
                    }
                    case 'E': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) return -1;
                            return 201;
                        }
                        if (c != 'g' || 0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) return -1;
                        return 200;
                    }
                    case 'I': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) return -1;
                            return 205;
                        }
                        if (c != 'g' || 0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) return -1;
                        return 204;
                    }
                    case 'L': {
                        if (0 != (c ^ 0x61 | c8 ^ 0x6D | c9 ^ 0x62 | c10 ^ 0x64 | c11 ^ 0x61)) return -1;
                        return 923;
                    }
                    case 'N': {
                        if (0 != (c ^ 0x74 | c8 ^ 0x69 | c9 ^ 0x6C | c10 ^ 0x64 | c11 ^ 0x65)) return -1;
                        return 209;
                    }
                    case 'O': {
                        switch (c) {
                            case 'a': {
                                if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) return -1;
                                return 211;
                            }
                            case 'g': {
                                if (0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) return -1;
                                return 210;
                            }
                            case 's': {
                                if (0 != (c8 ^ 0x6C | c9 ^ 0x61 | c10 ^ 0x73 | c11 ^ 0x68)) return -1;
                                return 216;
                            }
                            case 't': {
                                if (0 != (c8 ^ 0x69 | c9 ^ 0x6C | c10 ^ 0x64 | c11 ^ 0x65)) return -1;
                                return 213;
                            }
                        }
                        return -1;
                    }
                    case 'S': {
                        if (0 != (c ^ 0x63 | c8 ^ 0x61 | c9 ^ 0x72 | c10 ^ 0x6F | c11 ^ 0x6E)) return -1;
                        return 352;
                    }
                    case 'U': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) return -1;
                            return 218;
                        }
                        if (c != 'g' || 0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) return -1;
                        return 217;
                    }
                    case 'Y': {
                        if (0 != (c ^ 0x61 | c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) return -1;
                        return 221;
                    }
                    case 'a': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) return -1;
                            return 225;
                        }
                        if (c == 'g') {
                            if (0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) return -1;
                            return 224;
                        }
                        if (c != 't' || 0 != (c8 ^ 0x69 | c9 ^ 0x6C | c10 ^ 0x64 | c11 ^ 0x65)) return -1;
                        return 227;
                    }
                    case 'b': {
                        if (0 != (c ^ 0x72 | c8 ^ 0x76 | c9 ^ 0x62 | c10 ^ 0x61 | c11 ^ 0x72)) return -1;
                        return 166;
                    }
                    case 'c': {
                        if (c == 'c') {
                            if (0 != (c8 ^ 0x65 | c9 ^ 0x64 | c10 ^ 0x69 | c11 ^ 0x6C)) return -1;
                            return 231;
                        }
                        if (c != 'u' || 0 != (c8 ^ 0x72 | c9 ^ 0x72 | c10 ^ 0x65 | c11 ^ 0x6E)) return -1;
                        return 164;
                    }
                    case 'd': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x67 | c9 ^ 0x67 | c10 ^ 0x65 | c11 ^ 0x72)) return -1;
                            return 8224;
                        }
                        if (c != 'i' || 0 != (c8 ^ 0x76 | c9 ^ 0x69 | c10 ^ 0x64 | c11 ^ 0x65)) return -1;
                        return 247;
                    }
                    case 'e': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) return -1;
                            return 233;
                        }
                        if (c != 'g' || 0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) return -1;
                        return 232;
                    }
                    case 'f': {
                        if (c11 == 'l') {
                            if (0 != (c ^ 0x6F | c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x6C)) return -1;
                            return 8704;
                        }
                        if (c11 == '2') {
                            if (0 != (c ^ 0x72 | c8 ^ 0x61 | c9 ^ 0x63 | c10 ^ 0x31)) return -1;
                            return 189;
                        }
                        if (c11 != '4' || 0 != (c ^ 0x72 | c8 ^ 0x61 | c9 ^ 0x63)) return -1;
                        if (c10 == '1') {
                            return 188;
                        }
                        if (c10 != '3') return -1;
                        return 190;
                    }
                    case 'h': {
                        if (c8 == 'a') {
                            if (0 != (c ^ 0x65 | c9 ^ 0x72 | c10 ^ 0x74 | c11 ^ 0x73)) return -1;
                            return 9829;
                        }
                        if (c8 != 'l' || 0 != (c ^ 0x65 | c9 ^ 0x6C | c10 ^ 0x69 | c11 ^ 0x70)) return -1;
                        return 8230;
                    }
                    case 'i': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) return -1;
                            return 237;
                        }
                        if (c == 'g') {
                            if (0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) return -1;
                            return 236;
                        }
                        if (c != 'q' || 0 != (c8 ^ 0x75 | c9 ^ 0x65 | c10 ^ 0x73 | c11 ^ 0x74)) return -1;
                        return 191;
                    }
                    case 'l': {
                        switch (c) {
                            case 'a': {
                                if (0 != (c8 ^ 0x6D | c9 ^ 0x62 | c10 ^ 0x64 | c11 ^ 0x61)) return -1;
                                return 955;
                            }
                            case 'f': {
                                if (0 != (c8 ^ 0x6C | c9 ^ 0x6F | c10 ^ 0x6F | c11 ^ 0x72)) return -1;
                                return 8970;
                            }
                            case 'o': {
                                if (0 != (c8 ^ 0x77 | c9 ^ 0x61 | c10 ^ 0x73 | c11 ^ 0x74)) return -1;
                                return 8727;
                            }
                            case 's': {
                                if (0 != (c8 ^ 0x61 | c9 ^ 0x71 | c10 ^ 0x75 | c11 ^ 0x6F)) return -1;
                                return 8249;
                            }
                        }
                        return -1;
                    }
                    case 'm': {
                        if (0 != (c ^ 0x69 | c8 ^ 0x64 | c9 ^ 0x64 | c10 ^ 0x6F | c11 ^ 0x74)) return -1;
                        return 183;
                    }
                    case 'n': {
                        if (0 != (c ^ 0x74 | c8 ^ 0x69 | c9 ^ 0x6C | c10 ^ 0x64 | c11 ^ 0x65)) return -1;
                        return 241;
                    }
                    case 'o': {
                        switch (c) {
                            case 'a': {
                                if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) return -1;
                                return 243;
                            }
                            case 'g': {
                                if (0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) return -1;
                                return 242;
                            }
                            case 's': {
                                if (0 != (c8 ^ 0x6C | c9 ^ 0x61 | c10 ^ 0x73 | c11 ^ 0x68)) return -1;
                                return 248;
                            }
                            case 't': {
                                if (c11 == 'e') {
                                    if (0 != (c8 ^ 0x69 | c9 ^ 0x6C | c10 ^ 0x64)) return -1;
                                    return 245;
                                }
                                if (c11 != 's' || 0 != (c8 ^ 0x69 | c9 ^ 0x6D | c10 ^ 0x65)) return -1;
                                return 8855;
                            }
                        }
                        return -1;
                    }
                    case 'p': {
                        if (c == 'e') {
                            if (0 != (c8 ^ 0x72 | c9 ^ 0x6D | c10 ^ 0x69 | c11 ^ 0x6C)) return -1;
                            return 8240;
                        }
                        if (c != 'l' || 0 != (c8 ^ 0x75 | c9 ^ 0x73 | c10 ^ 0x6D | c11 ^ 0x6E)) return -1;
                        return 177;
                    }
                    case 'r': {
                        if (c == 'f') {
                            if (0 != (c8 ^ 0x6C | c9 ^ 0x6F | c10 ^ 0x6F | c11 ^ 0x72)) return -1;
                            return 8971;
                        }
                        if (c != 's' || 0 != (c8 ^ 0x61 | c9 ^ 0x71 | c10 ^ 0x75 | c11 ^ 0x6F)) return -1;
                        return 8250;
                    }
                    case 's': {
                        if (c == 'c') {
                            if (0 != (c8 ^ 0x61 | c9 ^ 0x72 | c10 ^ 0x6F | c11 ^ 0x6E)) return -1;
                            return 353;
                        }
                        if (c == 'i') {
                            if (0 != (c8 ^ 0x67 | c9 ^ 0x6D | c10 ^ 0x61 | c11 ^ 0x66)) return -1;
                            return 962;
                        }
                        if (c != 'p' || 0 != (c8 ^ 0x61 | c9 ^ 0x64 | c10 ^ 0x65 | c11 ^ 0x73)) return -1;
                        return 9824;
                    }
                    case 't': {
                        if (c11 == '4') {
                            if (0 != (c ^ 0x68 | c8 ^ 0x65 | c9 ^ 0x72 | c10 ^ 0x65)) return -1;
                            return 8756;
                        }
                        if (c11 != 'p' || 0 != (c ^ 0x68 | c8 ^ 0x69 | c9 ^ 0x6E | c10 ^ 0x73)) return -1;
                        return 8201;
                    }
                    case 'u': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) return -1;
                            return 250;
                        }
                        if (c != 'g' || 0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) return -1;
                        return 249;
                    }
                    case 'w': {
                        if (0 != (c ^ 0x65 | c8 ^ 0x69 | c9 ^ 0x65 | c10 ^ 0x72 | c11 ^ 0x70)) return -1;
                        return 8472;
                    }
                    case 'y': {
                        if (0 != (c ^ 0x61 | c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) return -1;
                        return 253;
                    }
                }
                return -1;
            }
            case 7: {
                char c = cArray[n + 1];
                char c12 = cArray[n + 2];
                char c13 = cArray[n + 3];
                char c14 = cArray[n + 4];
                char c15 = cArray[n + 5];
                char c16 = cArray[n + 6];
                switch (cArray[n]) {
                    case 'E': {
                        if (0 != (c ^ 0x70 | c12 ^ 0x73 | c13 ^ 0x69 | c14 ^ 0x6C | c15 ^ 0x6F | c16 ^ 0x6E)) break;
                        return 917;
                    }
                    case 'O': {
                        if (0 != (c ^ 0x6D | c12 ^ 0x69 | c13 ^ 0x63 | c14 ^ 0x72 | c15 ^ 0x6F | c16 ^ 0x6E)) break;
                        return 927;
                    }
                    case 'U': {
                        if (0 != (c ^ 0x70 | c12 ^ 0x73 | c13 ^ 0x69 | c14 ^ 0x6C | c15 ^ 0x6F | c16 ^ 0x6E)) break;
                        return 933;
                    }
                    case 'a': {
                        if (0 != (c ^ 0x6C | c12 ^ 0x65 | c13 ^ 0x66 | c14 ^ 0x73 | c15 ^ 0x79 | c16 ^ 0x6D)) break;
                        return 8501;
                    }
                    case 'e': {
                        if (0 != (c ^ 0x70 | c12 ^ 0x73 | c13 ^ 0x69 | c14 ^ 0x6C | c15 ^ 0x6F | c16 ^ 0x6E)) break;
                        return 949;
                    }
                    case 'o': {
                        if (0 != (c ^ 0x6D | c12 ^ 0x69 | c13 ^ 0x63 | c14 ^ 0x72 | c15 ^ 0x6F | c16 ^ 0x6E)) break;
                        return 959;
                    }
                    case 'u': {
                        if (0 != (c ^ 0x70 | c12 ^ 0x73 | c13 ^ 0x69 | c14 ^ 0x6C | c15 ^ 0x6F | c16 ^ 0x6E)) break;
                        return 965;
                    }
                }
                return -1;
            }
            case 8: {
                char c = cArray[n + 1];
                char c17 = cArray[n + 2];
                char c18 = cArray[n + 3];
                char c19 = cArray[n + 4];
                char c20 = cArray[n + 5];
                char c21 = cArray[n + 6];
                char c22 = cArray[n + 7];
                switch (cArray[n]) {
                    case 't': {
                        if (0 != (c ^ 0x68 | c17 ^ 0x65 | c18 ^ 0x74 | c19 ^ 0x61 | c20 ^ 0x73 | c21 ^ 0x79 | c22 ^ 0x6D)) return -1;
                        return 977;
                    }
                }
            }
        }
        return -1;
    }
}

