/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.applet;

import ice.debug.Debug;
import ice.pilots.applet.AppletEvent;
import ice.pilots.applet.AudioClipCallback;
import ice.pilots.applet.ThePilot;
import ice.pilots.html4.DAppletElement;
import ice.pilots.html4.DElement;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.Viewport;
import ice.util.Defs;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AppletViewer
implements AppletStub,
AppletContext,
AudioClip {
    private Thread handlerThread;
    private final Object eventQueueLock = new Object();
    private AppletEvent eventQueueFirst;
    private AppletEvent eventQueueLast;
    private boolean status_loaded;
    private boolean status_inited;
    private boolean status_running;
    private boolean status_destroyed;
    private boolean status_disposed;
    private Hashtable paramList = new Hashtable();
    ThePilot pilot;
    private Container appletPanel;
    private Applet applet;
    private String apname;
    private String baseTargetFrame = "_self";
    private ClassLoader loader = null;
    private URL[] loader_urls;
    private static final Object loaderAccessLock = new Object();
    private URL docBase;
    private URL appletCodeBase;
    private Hashtable streams = new Hashtable();
    private static final int APPLET_DISPOSE = 0;
    private static final int APPLET_LOAD = 1;
    private static final int APPLET_INIT = 2;
    private static final int APPLET_START = 3;
    private static final int APPLET_STOP = 4;
    private static final int APPLET_DESTROY = 5;
    private static final int APPLET_QUIT = 6;
    private static final int APPLET_ERROR = 7;
    private static final int APPLET_RESIZE = 8;
    private static final int APPLET_LOADING_COMPLETED = 9;
    private static final int APPLET_SHOW_DOCUMENT = 10;
    private boolean need_validate = true;
    private boolean in_resize = false;

    static AppletViewer create() {
        AppletViewer appletViewer = null;
        if (Defs.getClass("java.util.Iterator") != null) {
            appletViewer = (AppletViewer)Defs.newClassInstance("ice.pilots.applet.jdk12.AppletViewer_jdk12");
        }
        if (appletViewer == null) {
            appletViewer = (AppletViewer)Defs.newClassInstance("ice.pilots.applet.jdk11.AppletViewer_jdk11");
        }
        return appletViewer;
    }

    void init(ThePilot thePilot, Container container) {
        this.pilot = thePilot;
        this.appletPanel = container;
    }

    Applet getAppletComponent() {
        return this.applet;
    }

    void loadApplet(ContentLoader contentLoader) {
        block14: {
            String string;
            Hashtable hashtable;
            this.paramList = hashtable = contentLoader.getParams();
            this.apname = contentLoader.getLocation();
            int n = this.apname.lastIndexOf(47);
            if (n > 0) {
                this.apname = this.apname.substring(n + 1);
            }
            if (hashtable != null && (string = (String)hashtable.get("docbase")) != null) {
                try {
                    this.docBase = new URL(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.docBase == null) {
                this.docBase = contentLoader.getURL();
            }
            if (this.apname.endsWith(".class") || this.apname.endsWith(".CLASS")) {
                this.apname = this.apname.substring(0, this.apname.lastIndexOf(46));
            }
            if (hashtable != null && (string = (String)hashtable.get("codebase")) != null) {
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                try {
                    this.appletCodeBase = new URL(this.docBase, string);
                }
                catch (MalformedURLException malformedURLException) {
                    this.appletCodeBase = null;
                }
            }
            if (this.appletCodeBase == null) {
                int n2;
                this.appletCodeBase = this.docBase;
                string = this.appletCodeBase.getFile();
                if (!string.endsWith("/") && (n2 = string.lastIndexOf(47)) >= 0) {
                    string = string.substring(0, n2 + 1);
                    try {
                        this.appletCodeBase = new URL(this.appletCodeBase, string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (!Debug.ex) break block14;
                        Debug.ex(malformedURLException);
                    }
                }
            }
        }
        this.runLoader();
        this.initHandler();
    }

    void doStart() {
        this.queueEvent(2);
    }

    void doStop() {
        this.queueEvent(4);
        this.queueEvent(5);
        this.queueEvent(0);
    }

    private void initHandler() {
        if (this.status_inited) {
            return;
        }
        this.handlerThread = new Thread(new Runnable(){

            public void run() {
                AppletViewer.this.run_handler();
            }
        }, this.apname + "-handler");
        this.handlerThread.start();
    }

    private void queueEvent(int n) {
        this.queueEvent(new AppletEvent(n));
    }

    private void queueEvent(AppletEvent appletEvent) {
        Object object = this.eventQueueLock;
        synchronized (object) {
            if (this.eventQueueLast == null) {
                this.eventQueueFirst = appletEvent;
            } else {
                this.eventQueueLast.next = appletEvent;
            }
            this.eventQueueLast = appletEvent;
            this.eventQueueLock.notify();
        }
    }

    private AppletEvent getNextEvent() throws InterruptedException {
        Object object = this.eventQueueLock;
        synchronized (object) {
            while (this.eventQueueLast == null && !this.status_disposed) {
                this.eventQueueLock.wait(100L);
            }
            if (this.status_disposed) {
                AppletEvent appletEvent = null;
                return appletEvent;
            }
            AppletEvent appletEvent = this.eventQueueFirst;
            this.eventQueueFirst = appletEvent.next;
            if (this.eventQueueFirst == null) {
                this.eventQueueLast = null;
            }
            AppletEvent appletEvent2 = appletEvent;
            return appletEvent2;
        }
    }

    void run_handler() {
        while (true) {
            AppletEvent appletEvent;
            try {
                appletEvent = this.getNextEvent();
                if (appletEvent == null || this.status_disposed) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            try {
                switch (appletEvent.id) {
                    case 2: {
                        if (this.status_inited) break;
                        if (!this.status_loaded) {
                            this.showStatus("init: applet not loaded.");
                            break;
                        }
                        this.appletPanel.setVisible(false);
                        this.appletPanel.add((Component)this.applet, "Center");
                        this.appletPanel.validate();
                        this.applet.init();
                        this.status_inited = true;
                    }
                    case 3: {
                        if (!this.status_inited) {
                            this.showStatus("Start: applet <" + this.apname + "> not initialized.");
                            break;
                        }
                        if (this.status_running) break;
                        this.applet.start();
                        this.appletPanel.validate();
                        this.appletPanel.setVisible(true);
                        this.status_running = true;
                        this.showStatus("Applet <" + this.apname + "> started.");
                        break;
                    }
                    case 4: {
                        this.stopApplet();
                        break;
                    }
                    case 10: {
                        String string = this.mapViewportName(appletEvent.targetFrame);
                        this.pilot.renderContent(appletEvent.url.toString(), null, string);
                        break;
                    }
                    case 5: {
                        if (!this.status_inited) {
                            this.showStatus("Destroy: applet not stopped.");
                            break;
                        }
                        this.applet.setVisible(false);
                        this.applet.destroy();
                        this.status_running = false;
                        this.status_destroyed = true;
                        this.showStatus("Applet destroyed.");
                        break;
                    }
                    case 0: {
                        if (!this.status_destroyed) {
                            this.showStatus("Dispose: applet not destroyed.");
                            break;
                        }
                        this.status_loaded = false;
                        this.status_running = false;
                        this.status_disposed = true;
                        this.showStatus("Applet disposed.");
                        return;
                    }
                    case 8: {
                        break;
                    }
                    case 6: {
                        return;
                    }
                    case 9: {
                        this.showStatus("Applet Loading Completed");
                    }
                }
                continue;
            }
            catch (Exception exception) {
                if (!Debug.ex) continue;
                Debug.ex(exception);
                continue;
            }
            catch (Throwable throwable) {
                if (!Debug.ex) continue;
                Debug.ex(throwable);
                continue;
            }
            break;
        }
    }

    private final String mapViewportName(String string) {
        Viewport viewport;
        if (string == null) {
            string = "_self";
        }
        if ((viewport = this.pilot.getPilotViewport()) == null) {
            return string;
        }
        if ((viewport = viewport.getParent()) == null) {
            return string;
        }
        if (string.equals("_self")) {
            return viewport.getId();
        }
        if (string.equals("_parent")) {
            if (viewport.getParent() != null) {
                viewport = viewport.getParent();
            }
            return viewport.getId();
        }
        return string;
    }

    private void stopApplet() {
        if (!this.status_running) {
            this.showStatus("Stop: applet not running.");
            return;
        }
        this.applet.setVisible(false);
        this.applet.stop();
        this.status_running = false;
        this.showStatus("Applet stopped.");
    }

    /*
     * Unable to fully structure code
     */
    private void runLoader() {
        if (this.status_loaded) {
            return;
        }
        this.status_disposed = false;
        this.status_destroyed = false;
        var1_1 = 0;
        block14: while (var1_1 < 2) {
            try {
                var2_2 = null;
                if (this.paramList != null) {
                    var2_2 = (String)this.paramList.get("archive");
                }
                this.initAppletClassLoader(this.getCodeBase(), (String)var2_2);
            }
            catch (IOException var2_3) {
                this.status_disposed = true;
                this.showStatus("Error: IO Error creating ClassLoader");
                this.queueEvent(9);
                return;
            }
            if (this.apname == null) {
                this.status_disposed = true;
            } else {
                this.apname = this.apname.endsWith(".class") != false ? this.apname.substring(0, this.apname.length() - 6).replace('/', '.') : (this.apname.endsWith(".java") != false ? this.apname.substring(0, this.apname.length() - 5).replace('/', '.') : this.apname.substring(0, this.apname.length()).replace('/', '.'));
            }
            try {
                try {
                    var2_2 = this.loader.loadClass(this.apname);
                    this.applet = (Applet)var2_2.newInstance();
                    this.notifyAboutAppletCreation();
                    if (Thread.interrupted()) {
                        this.status_disposed = true;
                        this.applet = null;
                        this.showStatus("killed");
                        var7_11 = null;
                        this.queueEvent(9);
                        return;
                    }
                    var7_11 = null;
                    this.queueEvent(9);
                }
                catch (ClassNotFoundException var2_4) {
                    switch (++var1_1) {
                        case 1: {
                            this.appletCodeBase = this.docBase;
                            var3_5 = this.appletCodeBase.getFile();
                            if (var3_5.endsWith("/") || (var4_7 = var3_5.lastIndexOf(47)) < 0) ** GOTO lbl51
                            var3_5 = var3_5.substring(0, var4_7 + 1);
                            try {
                                this.appletCodeBase = new URL(this.appletCodeBase, var3_5);
                            }
                            catch (Exception var5_9) {
                                if (!Debug.ex) ** GOTO lbl51
                                Debug.ex(var5_9);
                            }
lbl51:
                            // 4 sources

                            this.loader = null;
                            var7_11 = null;
                            this.queueEvent(9);
                            continue block14;
                        }
                        default: {
                            this.status_disposed = true;
                            this.showStatus("load: class " + this.apname + " not found");
                            var7_11 = null;
                            this.queueEvent(9);
                            return;
                        }
                    }
                }
                catch (Exception var3_6) {
                    if (Debug.ex) {
                        Debug.ex(var3_6);
                    }
                    this.status_disposed = true;
                    this.showStatus("load: error loading " + this.apname);
                    var7_11 = null;
                    this.queueEvent(9);
                    return;
                }
                catch (ThreadDeath var4_8) {
                    if (Debug.ex) {
                        Debug.ex(var4_8);
                    }
                    this.status_disposed = true;
                    this.showStatus("load: killed");
                    var7_11 = null;
                    this.queueEvent(9);
                    return;
                }
                catch (Throwable var5_10) {
                    if (Debug.ex) {
                        Debug.ex(var5_10);
                    }
                    this.status_disposed = true;
                    this.showStatus("load: error: " + var5_10.getMessage());
                    var7_11 = null;
                    this.queueEvent(9);
                    return;
                }
            }
            catch (Throwable var6_12) {
                var7_11 = null;
                this.queueEvent(9);
                throw var6_12;
            }
            var1_1 = 10;
        }
        this.applet.setStub(this);
        this.status_loaded = true;
    }

    private void notifyAboutAppletCreation() {
        DAppletElement dAppletElement;
        Viewport viewport = this.pilot.getPilotViewport();
        DElement dElement = DElement.getEmbeddedViewHolder(viewport);
        if (dElement instanceof DAppletElement && (dAppletElement = (DAppletElement)dElement) != null) {
            dAppletElement.setApplet(this.applet);
        }
    }

    private void initAppletClassLoader(URL uRL, String string) throws IOException {
        Object object = loaderAccessLock;
        synchronized (object) {
            URL[] uRLArray;
            Object object2;
            if (string != null) {
                object2 = new StringTokenizer(string.replace(',', ' '));
                int n = ((StringTokenizer)object2).countTokens();
                uRLArray = new URL[n + 1];
                uRLArray[0] = uRL;
                if (n > 0) {
                    while (((StringTokenizer)object2).hasMoreTokens() && n > 0) {
                        block15: {
                            String string2 = ((StringTokenizer)object2).nextToken();
                            try {
                                uRLArray[uRLArray.length - n] = new URL(uRL, string2);
                            }
                            catch (Exception exception) {
                                if (Debug.ex) {
                                    Debug.ex(exception);
                                }
                                if (!Debug.trace) break block15;
                                Debug.trace("Could not make " + uRL + " + " + string2);
                            }
                        }
                        --n;
                    }
                }
            } else {
                uRLArray = new URL[]{uRL};
            }
            if ((object2 = this.searchForCodeBase(uRLArray)) != null) {
                this.loader = ((AppletViewer)object2).loader;
                this.loader_urls = ((AppletViewer)object2).loader_urls;
                this.streams = ((AppletViewer)object2).streams;
                if (Debug.trace) {
                    Viewport viewport = ((AppletViewer)object2).pilot.getPilotViewport();
                    if (Debug.trace) {
                        Debug.trace("Reusing " + this.loader + " from " + viewport);
                    }
                }
            } else {
                this.loader = this.pilot.createURLClassLoader(uRLArray);
                this.loader_urls = uRLArray;
                if (Debug.trace) {
                    Debug.trace("New loader: " + this.loader);
                }
            }
        }
    }

    private AppletViewer searchForCodeBase(URL[] uRLArray) {
        Vector vector = new Vector();
        this.pilot.getAllPilotInstances(vector);
        int n = vector.size() - 1;
        while (n >= 0) {
            URL[] uRLArray2;
            AppletViewer appletViewer;
            ThePilot thePilot = (ThePilot)vector.elementAt(n);
            if (thePilot != this.pilot && (appletViewer = thePilot.viewer) != null && (uRLArray2 = appletViewer.loader_urls) != null && AppletViewer.sameUrlArrays(uRLArray, uRLArray2)) {
                return appletViewer;
            }
            --n;
        }
        return null;
    }

    private static boolean sameUrlArrays(URL[] uRLArray, URL[] uRLArray2) {
        if (uRLArray.length != uRLArray2.length) {
            return false;
        }
        int n = uRLArray.length - 1;
        while (n >= 0) {
            if (!uRLArray[n].equals(uRLArray2[n])) {
                return false;
            }
            --n;
        }
        return true;
    }

    private synchronized void stopLoading() {
        this.showStatus("Interrupting applet loader thread");
    }

    void addParam(String string, String string2) {
        if (this.status_inited) {
            return;
        }
        this.paramList.put(string.trim().toLowerCase(), string2);
    }

    private void doResize() {
    }

    void setTargetFrame(String string) {
        this.baseTargetFrame = string;
    }

    public boolean isActive() {
        return this.status_running;
    }

    public URL getDocumentBase() {
        return this.docBase;
    }

    public URL getCodeBase() {
        return this.appletCodeBase;
    }

    public String getParameter(String string) {
        Object v = this.paramList.get(string.toLowerCase());
        if (v instanceof String) {
            return (String)v;
        }
        return null;
    }

    public void appletResize(int n, int n2) {
        if (this.in_resize) {
            return;
        }
    }

    public AppletContext getAppletContext() {
        return this;
    }

    public AudioClip getAudioClip(URL uRL) {
        AudioClipCallback audioClipCallback = ThePilot.getAudioClipCallback();
        if (audioClipCallback != null) {
            return audioClipCallback.getAudioClip(uRL);
        }
        try {
            Class<?> clazz = Class.forName("sun.applet.AppletAudioClip");
            Class[] classArray = new Class[]{Class.forName("java.net.URL")};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{uRL};
            AudioClip audioClip = (AudioClip)constructor.newInstance(objectArray);
            return audioClip;
        }
        catch (Exception exception) {
            if (Debug.ex) {
                Debug.ex(exception);
            }
            return this;
        }
    }

    public Image getImage(URL uRL) {
        Image image = null;
        if (this.loader != null) {
            image = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        return image;
    }

    public Applet getApplet(String string) {
        if (string == null) {
            return this.getAppletComponent();
        }
        Viewport viewport = this.pilot.findViewportByName(this.pilot.getViewportId());
        viewport = viewport.getParent();
        Enumeration enumeration = viewport.getChildren();
        while (enumeration.hasMoreElements()) {
            ThePilot thePilot;
            String string2;
            viewport = (Viewport)enumeration.nextElement();
            Pilot pilot = viewport.getPilot();
            if (pilot == null || !(pilot instanceof ThePilot) || (string2 = (String)(thePilot = (ThePilot)pilot).getViewportProperty("name")) == null || !string2.equals(string)) continue;
            return thePilot.getApplet();
        }
        return null;
    }

    public Enumeration getApplets() {
        Vector<Applet> vector = new Vector<Applet>();
        Viewport viewport = this.pilot.findViewportByName(this.pilot.getViewportId());
        viewport = viewport.getParent();
        Enumeration enumeration = viewport.getChildren();
        while (enumeration.hasMoreElements()) {
            ThePilot thePilot;
            Applet applet;
            viewport = (Viewport)enumeration.nextElement();
            Pilot pilot = viewport.getPilot();
            if (pilot == null || !(pilot instanceof ThePilot) || (applet = (thePilot = (ThePilot)pilot).getApplet()) == null) continue;
            vector.addElement(applet);
        }
        return vector.elements();
    }

    public void showDocument(URL uRL) {
        this.showDocument(uRL, this.baseTargetFrame);
    }

    public void showDocument(URL uRL, String string) {
        this.queueEvent(new AppletEvent(10, uRL, string));
    }

    public void showStatus(String string) {
        this.pilot.firePropertyChange("statusLine", null, string);
    }

    public InputStream getStream(String string) {
        return (InputStream)this.streams.get(string);
    }

    public void setStream(String string, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4097];
        int n2 = 0;
        while ((n = inputStream.read(byArray, n2, byArray.length - n2)) != -1) {
            if ((n2 += n) != byArray.length) continue;
            throw new IOException();
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray = byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.streams.put(string, byteArrayInputStream);
    }

    protected final Hashtable getStreams() {
        return this.streams;
    }

    public void loop() {
    }

    public void play() {
    }

    public void stop() {
    }
}

