/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.dombase.Nbrs;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.Names;
import ice.util.alg.CharKit;

class AttributeSelector
implements Nbrs {
    static final int MATCH_EXACT = 0;
    static final int MATCH_IN_SPACE_SEPARATED_LIST = 1;
    static final int MATCH_IN_HYPHEN_SEPARATED_LIST = 2;
    Names names;
    private int attributeNameId;
    private String value;
    private int mode;
    private boolean caseInsensitive = false;

    AttributeSelector(Names names, int n, String string, int n2) {
        this.names = names;
        this.attributeNameId = n;
        this.value = string;
        this.mode = n2;
        if (!DDocument.STRICT && string != null && names.getAttrNamespaceId(n) == 3) {
            this.caseInsensitive = true;
            this.value = CharKit.toLowerCase(string);
        }
    }

    String getClassKey() {
        if (this.attributeNameId == 21) {
            return this.value;
        }
        return null;
    }

    boolean match(DElement dElement) {
        String string = dElement.getAttribute(this.attributeNameId);
        if (string != null) {
            if (this.value == null) {
                return true;
            }
            if (this.caseInsensitive) {
                string = CharKit.toLowerCase(string);
            }
            if (this.mode == 0) {
                if (string.equals(this.value)) {
                    return true;
                }
            } else if (this.mode == 1) {
                int n = string.indexOf(this.value);
                boolean bl = true;
                boolean bl2 = true;
                if (n > 0) {
                    char c = string.charAt(n - 1);
                    bl = c == ' ' || c == '\t' || c == '\n' || c == '\r';
                } else if (n >= 0 && n + this.value.length() < string.length()) {
                    char c = string.charAt(n + this.value.length());
                    boolean bl3 = bl2 = c == ' ' || c == '\t' || c == '\n' || c == '\r';
                }
                if (n >= 0 && bl && bl2) {
                    return true;
                }
            } else if (this.mode == 2 && string.startsWith(this.value) && this.value.length() < string.length() && string.charAt(this.value.length()) == '-') {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String string = this.names.getAttrName(this.attributeNameId);
        if (this.value == null) {
            return "[" + string + "]";
        }
        if (this.mode == 0) {
            if (this.attributeNameId == 21) {
                return "." + this.value;
            }
            return "[" + string + "=" + this.value + "]";
        }
        if (this.mode == 1) {
            return "[" + string + "~=" + this.value + "]";
        }
        if (this.mode == 2) {
            return "[" + string + "|=" + this.value + "]";
        }
        return "";
    }
}

