/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSBuilder;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DOM;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.StormData;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class CSSManager {
    CSSManager() {
    }

    static DStyleSheet getUaStyle(DDocument dDocument) {
        StormData stormData = dDocument.pilot.sdata;
        if (stormData.uaStyle == null) {
            Object object = stormData.styleLock;
            synchronized (object) {
                if (stormData.uaStyle == null) {
                    stormData.uaStyle = CSSManager.newUaStyle(dDocument);
                }
            }
        }
        return stormData.uaStyle;
    }

    private static DStyleSheet newUaStyle(DDocument dDocument) {
        DStyleSheet dStyleSheet;
        block9: {
            dStyleSheet = dDocument.getDom().createDStyleSheet(3, null, null, null);
            CSSBuilder cSSBuilder = new CSSBuilder(dDocument);
            InputStream inputStream = cSSBuilder.getClass().getResourceAsStream("ua.css");
            if (inputStream == null) {
                if (Debug.trace) {
                    Debug.trace("WARNING: can not find ua.css");
                }
            } else {
                try {
                    try {
                        InputStreamReader inputStreamReader = null;
                        try {
                            inputStreamReader = new InputStreamReader(inputStream, "UTF8");
                        }
                        catch (Exception exception) {
                            inputStreamReader = new InputStreamReader(inputStream);
                        }
                        cSSBuilder.build(dStyleSheet, inputStreamReader, null);
                        Object var7_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    {
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.ex) break block9;
                    Debug.ex(iOException);
                }
            }
        }
        return dStyleSheet;
    }

    static DStyleSheet getUserStyle(StormData stormData) {
        if (stormData.userStyle == null) {
            Object object = stormData.styleLock;
            synchronized (object) {
                if (stormData.userStyle == null) {
                    stormData.userStyle = DOM.getInstance(stormData).createDStyleSheet(3, null, null, null);
                }
            }
        }
        return stormData.userStyle;
    }
}

