/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.PositionedBox;
import ice.pilots.html4.TableCellBox;
import java.awt.Point;

class FloatBox
extends CSSBox {
    private CSSBox block;

    FloatBox(DElement dElement, CSSBox cSSBox) {
        super(dElement, new CSSAttribs(cSSBox.cssLayout.sdata, cSSBox.css), cSSBox.cssLayout);
        if (cSSBox.getType() == 1) {
            this.block = cSSBox;
        } else {
            this.block = new BlockBox(dElement, cSSBox.css, cSSBox.cssLayout, 0);
            this.block = this.block.addChild(cSSBox);
        }
        this.block.setParentBox(this);
        this.height = 0;
        this.width = 0;
        this.maxWidth = 0;
        this.minWidth = 0;
        this.numBreaks = 0;
        this.totalWidth = 0;
        this.totalWidth = 1;
    }

    void propagateVisibility(byte by, boolean bl) {
        this.block.propagateVisibility(by, bl);
    }

    void findAbsolutePosition(Point point) {
        CSSBox cSSBox = this.parentBox;
        while (cSSBox != null) {
            if (cSSBox instanceof TableCellBox) {
                point.x += cSSBox.ox;
                point.y += cSSBox.oy + ((TableCellBox)cSSBox).vadd;
                if (cSSBox.parentBox == null) break;
                cSSBox.parentBox.findAbsolutePosition(point);
                break;
            }
            if (cSSBox instanceof PositionedBox) {
                cSSBox.findAbsolutePosition(point);
                break;
            }
            cSSBox = cSSBox.parentBox;
        }
    }

    void dispose() {
        super.dispose();
        this.element = null;
        if (this.block != null) {
            this.block.dispose();
            this.block = null;
        }
    }

    CSSBox getBlock() {
        return this.block;
    }

    DNode getDomNode() {
        return this.element;
    }

    int getType() {
        return 2;
    }

    int getChunkDescentAscent(int n, int n2) {
        CSSBox cSSBox = this.parentBox;
        while (cSSBox != null && cSSBox.getType() != 1) {
            cSSBox = cSSBox.parentBox;
        }
        if (cSSBox != null) {
            ((BlockBox)cSSBox).addFloater(this.block);
        }
        return 0;
    }

    public String toString() {
        DNode dNode = this.getDomNode();
        String string = "NoNode";
        if (dNode != null) {
            string = dNode.toString();
        }
        return "floatbox[" + string + "]";
    }
}

