/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DMapElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.ImageObjectPainter;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class ObjectBox
extends CSSBox {
    private ObjectPainter painter;
    private boolean breakBefore = true;
    private boolean breakAfter = false;
    private int width = 0;
    private int height = 0;
    private int dy = 0;
    private DAreaElement focusedArea = null;

    public boolean checkIfVisible() {
        CSSBox cSSBox = this;
        boolean bl = true;
        while (cSSBox != null) {
            if ((cSSBox.css.misc & 1) == 0) {
                bl = false;
                break;
            }
            cSSBox = cSSBox.parentBox;
        }
        if (bl && this.parentBox instanceof InlineBox) {
            int n = 0;
            cSSBox = ((InlineBox)this.parentBox).first;
            while (cSSBox != null) {
                n = Math.max(n, cSSBox.css.z_index);
                cSSBox = cSSBox.next;
            }
            if (n > this.css.z_index) {
                bl = false;
            }
        }
        return bl;
    }

    ObjectBox(ObjectPainter objectPainter, CSSLayout cSSLayout) {
        super(cSSLayout);
        this.painter = objectPainter;
    }

    void setParentBox(CSSBox cSSBox) {
        super.setParentBox(cSSBox);
        this.css = cSSBox.css;
        Color color = cSSBox.css.color;
        if (color != null) {
            this.painter.setForeground(color);
        }
        if ((color = cSSBox.css.background_color) != null) {
            this.painter.setBackground(color);
        }
    }

    void onBoxFocusChange(DNode dNode, int n) {
        if (dNode instanceof DAreaElement) {
            if (n == 22) {
                this.focusedArea = null;
                this.reqRepaint();
            } else if (n == 21) {
                this.focusedArea = (DAreaElement)dNode;
                this.reqRepaint();
            }
        }
    }

    private DMapElement getUsemap() {
        DElement dElement;
        String string;
        DNode dNode = this.getDomNode();
        if (dNode instanceof DElement && (string = (dElement = (DElement)dNode).getAttribute(112)) != null && string.length() > 1) {
            int n = string.indexOf("#");
            string = n > 0 ? string.substring(n + 1) : string.substring(1);
            DMapElement dMapElement = null;
            try {
                dMapElement = (DMapElement)dElement.doc.getMaps().namedItem(string);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return dMapElement;
        }
        return null;
    }

    DNode getDomNode() {
        if (this.parentBox == null) {
            return null;
        }
        return this.parentBox.getDomNode();
    }

    DNode getDomNode(int n, int n2) {
        DMapElement dMapElement = this.getUsemap();
        if (dMapElement != null) {
            int n3 = 0;
            while (n3 < dMapElement.getAreas().getLength()) {
                DAreaElement dAreaElement = (DAreaElement)dMapElement.getAreas().item(n3);
                if (dAreaElement.isInside(n, n2, this.width, this.height)) {
                    return dAreaElement;
                }
                ++n3;
            }
        }
        return this.getDomNode();
    }

    public void findAbsolutePosition(Point point) {
        point.y += this.dy;
        if (this.parentBox != null) {
            this.parentBox.findAbsolutePosition(point);
        }
    }

    void findBoundingBox(Rectangle rectangle) {
        Point point = new Point();
        this.findAbsolutePosition(point);
        rectangle.x = point.x;
        rectangle.y = point.y;
        rectangle.width = this.width;
        rectangle.height = this.height;
    }

    CSSBox getBoxAt(int n, int n2, Point point) {
        point.x = n;
        point.y = n2 - this.css.padding_top;
        return this;
    }

    void dispose() {
        super.dispose();
        this.focusedArea = null;
        if (this.painter != null && this.painter.getBox() == this) {
            this.painter.setBox(null);
            this.painter = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    int calcBreaks() {
        block18: {
            block17: {
                block16: {
                    block15: {
                        if (this.painter instanceof Component && (var1_1 = ((Component)this.painter).getFont()) != this.css.getFont()) {
                            ((Component)this.painter).setFont(this.css.getFont());
                        }
                        var1_1 = this.parentBox;
                        while (var1_1 != null && !(var1_1 instanceof BlockBox)) {
                            var1_1 = var1_1.parentBox;
                        }
                        var2_2 = this.painter.getPrefWidth();
                        var3_3 = this.painter.getPrefHeight();
                        if (this.css.width < 0) break block15;
                        if (var1_1 == null) ** GOTO lbl-1000
                        if ((this.css.percentage_flag & 0x100000) != 0) {
                            this.totalWidth = this.width = this.css.width * var1_1.width / 100;
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.totalWidth = this.width = this.css.width;
                        }
                        break block16;
                    }
                    if (var2_2 > 0) {
                        this.totalWidth = this.width = var2_2 * this.cssLayout.zoom >> 8;
                    } else {
                        this.width = 50;
                        this.totalWidth = 50;
                    }
                }
                if (this.css.height < 0) break block17;
                if (var1_1 == null) ** GOTO lbl-1000
                if ((this.css.percentage_flag & 8) != 0) {
                    this.height = var1_1.height >= 0 ? this.css.height * var1_1.height / 100 : (var3_3 > 0 ? var3_3 * this.cssLayout.zoom >> 8 : 10);
                } else lbl-1000:
                // 2 sources

                {
                    this.height = this.css.height;
                }
                break block18;
            }
            this.height = var3_3 > 0 ? var3_3 * this.cssLayout.zoom >> 8 : 50;
        }
        if (this.painter instanceof ImageObjectPainter) {
            if (this.css.height >= 0 && this.css.width < 0 && var3_3 != 0) {
                this.totalWidth = this.width = this.height * var2_2 / var3_3;
            } else if (this.css.width >= 0 && this.css.height < 0 && var2_2 != 0) {
                this.height = this.width * var3_3 / var2_2;
            }
        }
        this.painter.setPainterSize(this.width, this.height);
        this.numBreaks = 0;
        if ((this.css.misc & 4) != 0) {
            this.breakAfter = false;
            this.breakBefore = false;
        }
        if (this.breakBefore) {
            ++this.numBreaks;
        }
        if (this.breakAfter) {
            ++this.numBreaks;
        }
        return this.numBreaks;
    }

    int getBreaks(int[] nArray, int n) {
        if (this.breakBefore) {
            nArray[n++] = 0;
        }
        if (this.breakAfter) {
            nArray[n++] = this.width;
        }
        return this.numBreaks;
    }

    int getChunkDescentAscent(int n, int n2) {
        int n3 = this.css.padding_top + this.height;
        int n4 = this.css.padding_bottom;
        return (n4 << 16) + n3;
    }

    void paintChunk(Graphics graphics, int n, int n2, int n3, int n4) {
        CSSAttribs cSSAttribs = this.parentBox.css;
        if ((cSSAttribs.misc & 1) == 0) {
            return;
        }
        this.dy = n4 - this.height;
        if (cSSAttribs.vertical_align_type == 16) {
            this.dy = 0;
        } else if (cSSAttribs.vertical_align_type == 17) {
            this.dy = n4 + n3 - this.height;
        }
        Graphics graphics2 = graphics.create(n, this.dy, this.width, this.height);
        this.cssLayout.paintCallback(graphics2, this.painter);
        if (this.focusedArea != null) {
            this.drawUsemapArea(graphics2, this.focusedArea);
        }
        graphics2.dispose();
        if ((cSSAttribs.misc & 2) != 0) {
            this.cssLayout.outlinePainter.addRectangle(this, n, this.dy, this.width, this.height);
        }
    }

    public void invalidate() {
        super.invalidate();
    }

    public void reqReflow() {
        super.reqReflow();
    }

    public void reqRepaint() {
        Point point = new Point();
        this.findAbsolutePosition(point);
        if (this.cssLayout != null && this.cssLayout.docPane != null) {
            int n = this.cssLayout.maxOutlineWidth;
            this.cssLayout.docPane.reqRepaint(point.x - n, point.y - n, this.width + 2 * n, this.height + 2 * n);
        }
    }

    public ScrollBox getAncestorScrollBox() {
        CSSBox cSSBox = this.parentBox;
        if (cSSBox != null) {
            cSSBox = cSSBox.parentBox;
        }
        while (cSSBox != null) {
            if (cSSBox instanceof ScrollBox) {
                return (ScrollBox)cSSBox;
            }
            cSSBox = cSSBox.parentBox;
        }
        return null;
    }

    public ScrollBox getScrollBox() {
        CSSBox cSSBox = this.parentBox;
        if (cSSBox instanceof ScrollBox) {
            return (ScrollBox)cSSBox;
        }
        return null;
    }

    public ObjectPainter getObjectPainter() {
        return this.painter;
    }

    private void drawUsemapArea(Graphics graphics, DAreaElement dAreaElement) {
        if (!dAreaElement.checkCoords()) {
            return;
        }
        int[] nArray = dAreaElement.coords;
        String string = dAreaElement.getShape();
        graphics.setColor(Color.red);
        if (string == null || string.equalsIgnoreCase("rect")) {
            int n;
            int n2;
            int n3;
            int n4 = nArray[0];
            if (n4 < 0) {
                n4 = -n4 * this.width / 100;
            }
            if ((n3 = nArray[1]) < 0) {
                n3 = -n3 * this.height / 100;
            }
            if ((n2 = nArray[2]) < 0) {
                n2 = -n2 * this.width / 100;
            }
            if ((n = nArray[3]) < 0) {
                n = -n * this.height / 100;
            }
            graphics.drawRect(n4, n3, n2 - n4, n - n3);
        } else if (string.equalsIgnoreCase("circle")) {
            int n;
            int n5;
            int n6 = nArray[0];
            if (n6 < 0) {
                n6 = -n6 * this.width / 100;
            }
            if ((n5 = nArray[1]) < 0) {
                n5 = -n5 * this.height / 100;
            }
            if ((n = nArray[2]) < 0) {
                n = this.width < this.height ? -n * this.width / 100 : -n * this.width / 100;
            }
            graphics.drawOval(n6 - n, n5 - n, n * 2, n * 2);
        } else if (string.equalsIgnoreCase("poly")) {
            int n;
            int n7;
            int n8 = 0;
            if ((n7 = nArray[n8++]) < 0) {
                n7 = -n7 * this.width / 100;
            }
            if ((n = nArray[n8++]) < 0) {
                n = -n * this.height / 100;
            }
            int n9 = n7;
            int n10 = n;
            while (n8 < nArray.length) {
                int n11;
                int n12;
                if ((n12 = nArray[n8++]) < 0) {
                    n12 = -n12 * this.width / 100;
                }
                if ((n11 = nArray[n8++]) < 0) {
                    n11 = -n11 * this.height / 100;
                }
                graphics.drawLine(n9, n10, n12, n11);
                n9 = n12;
                n10 = n11;
            }
            graphics.drawLine(n9, n10, n7, n);
        }
    }

    void findBoundingBox(Rectangle rectangle, DAreaElement dAreaElement) {
        if (!dAreaElement.checkCoords()) {
            return;
        }
        String string = dAreaElement.getShape();
        if (string == null || string.equalsIgnoreCase("rect")) {
            int n;
            int n2;
            int n3;
            int n4 = dAreaElement.coords[0];
            if (n4 < 0) {
                n4 = -n4 * this.width / 100;
            }
            if ((n3 = dAreaElement.coords[1]) < 0) {
                n3 = -n3 * this.height / 100;
            }
            if ((n2 = dAreaElement.coords[2]) < 0) {
                n2 = -n2 * this.width / 100;
            }
            if ((n = dAreaElement.coords[3]) < 0) {
                n = -n * this.height / 100;
            }
            this.findBoundingBox(rectangle);
            rectangle.x += n4;
            rectangle.y += n3;
            rectangle.width = n2 - n4;
            rectangle.height = n - n3;
        } else if (string.equalsIgnoreCase("circle")) {
            int n;
            int n5;
            int n6 = dAreaElement.coords[0];
            if (n6 < 0) {
                n6 = -n6 * this.width / 100;
            }
            if ((n5 = dAreaElement.coords[1]) < 0) {
                n5 = -n5 * this.height / 100;
            }
            if ((n = dAreaElement.coords[2]) < 0) {
                n = this.width < this.height ? -n * this.width / 100 : -n * this.height / 100;
            }
            this.findBoundingBox(rectangle);
            rectangle.x += n6 - n;
            rectangle.y += n5 - n;
            rectangle.width = 2 * n;
            rectangle.height = 2 * n;
        } else if (string.equalsIgnoreCase("poly") || string.equalsIgnoreCase("polygon")) {
            int n;
            int n7;
            int n8;
            int n9;
            int n10 = 0;
            if ((n9 = dAreaElement.coords[n10++]) < 0) {
                n9 = -n9 * this.width / 100;
            }
            if ((n8 = dAreaElement.coords[n10++]) < 0) {
                n8 = -n8 * this.height / 100;
            }
            int n11 = n7 = n9;
            int n12 = n = n8;
            while (n10 < dAreaElement.coords.length) {
                if ((n9 = dAreaElement.coords[n10++]) < 0) {
                    n9 = -n9 * this.width / 100;
                }
                if ((n8 = dAreaElement.coords[n10++]) < 0) {
                    n8 = -n8 * this.height / 100;
                }
                if (n9 < n11) {
                    n11 = n9;
                } else if (n9 > n7) {
                    n7 = n9;
                }
                if (n8 < n12) {
                    n12 = n8;
                    continue;
                }
                if (n8 <= n) continue;
                n = n8;
            }
            this.findBoundingBox(rectangle);
            rectangle.x += n11;
            rectangle.y += n12;
            rectangle.width = n7 - n11;
            rectangle.height = n - n12;
        }
    }
}

