/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.util.alg.Bidi;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class TextBox
extends CSSBox {
    private DTextNode textNode;
    private int[] breakOffsetInPixels;
    private int spaceWidthInPixels = 0;
    private int textDescent = 0;
    private int textAscent = 0;
    private boolean reverseText = false;

    TextBox(DTextNode dTextNode, CSSLayout cSSLayout) {
        super(cSSLayout);
        this.textNode = dTextNode;
    }

    void dispose() {
        super.dispose();
        this.breakOffsetInPixels = null;
        this.textNode = null;
    }

    boolean isEmpty() {
        return this.textNode.isEmpty();
    }

    DNode getDomNode() {
        return this.textNode;
    }

    int calcBreaks() {
        if (this.spaceWidthInPixels == 0) {
            this.initBreaks();
        }
        return this.numBreaks;
    }

    int getBreaks(int[] nArray, int n) {
        System.arraycopy(this.breakOffsetInPixels, 0, nArray, n, this.numBreaks);
        return this.numBreaks;
    }

    int getChunkDescentAscent(int n, int n2) {
        return (this.textDescent << 16) + this.textAscent;
    }

    private final void initBreaks() {
        int n;
        DElement dElement = this.parentBox.element;
        if (dElement != null && dElement.tagId == 10) {
            byte by = this.parentBox.css.directionFlag;
            byte by2 = this.parentBox.parentBox.css.directionFlag;
            if (by == 1 && by != by2) {
                this.reverseText = true;
            } else if (by == 2 && by2 == 1) {
                this.reverseText = true;
            }
        }
        this.css = this.parentBox.css;
        this.numBreaks = (this.css.misc & 4) != 0 ? 0 : this.textNode.numBreaks;
        this.breakOffsetInPixels = new int[this.numBreaks];
        char[] cArray = this.textNode.text;
        int[] nArray = this.textNode.breakOffset;
        FontMetrics fontMetrics = this.css.getFontMetrics();
        this.textDescent = fontMetrics.getDescent();
        this.textAscent = fontMetrics.getHeight() - this.textDescent;
        if (this.css.line_height != 0) {
            if ((this.css.percentage_flag & 0x200000) != 0) {
                this.textDescent = this.textDescent * this.css.line_height / 100;
                this.textAscent = this.textAscent * this.css.line_height / 100;
            } else {
                n = this.css.line_height - fontMetrics.getHeight() >> 1;
                this.textAscent += n;
                this.textDescent += n;
            }
        }
        this.spaceWidthInPixels = fontMetrics.charWidth(' ');
        n = 0;
        int n2 = 0;
        int[] nArray2 = this.css.getFontCharWidths();
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.numBreaks) {
            int n5 = nArray[n4];
            if (n5 < 0) {
                n5 = -n5;
            }
            while (n3 < n5) {
                n2 = cArray[n3] >= nArray2.length ? (n2 += fontMetrics.charWidth(cArray[n3])) : (cArray[n3] == '\n' ? ++n2 : (n2 += nArray2[cArray[n3]]));
                ++n3;
            }
            this.breakOffsetInPixels[n4] = nArray[n4] < 0 ? -n2 : n2;
            ++n4;
        }
        while (n3 < cArray.length) {
            n2 = cArray[n3] >= nArray2.length ? (n2 += fontMetrics.charWidth(cArray[n3])) : (n2 += nArray2[cArray[n3]]);
            ++n3;
        }
        this.totalWidth = n2;
    }

    void paintChunk(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        char[] cArray;
        int n7;
        this.css = this.parentBox.css;
        if ((this.css.misc & 1) == 0) {
            return;
        }
        int n8 = 0;
        int n9 = this.textNode.text.length;
        int n10 = 0;
        int n11 = 0;
        if (n != 0) {
            n10 = 0;
            while (n10 < this.numBreaks) {
                n11 = this.breakOffsetInPixels[n10];
                if (n11 < 0 && n11 == -n || n11 >= 0 && n11 == n) {
                    n8 = this.textNode.breakOffset[n10];
                    if (n8 >= 0) break;
                    n8 = -n8;
                    break;
                }
                ++n10;
            }
        }
        if (n10 == this.numBreaks) {
            n10 = 0;
        }
        if (n + n2 != this.totalWidth) {
            while (n10 < this.numBreaks) {
                n11 = this.breakOffsetInPixels[n10];
                if (n11 < 0 && n11 == -(n + n2) || n11 >= 0 && n11 == n + n2) {
                    char c;
                    n9 = this.textNode.breakOffset[n10];
                    if (n9 < 0) {
                        n9 = -n9;
                    }
                    if ((c = this.textNode.text[n9 - 1]) == ' ' || c == '\n') {
                        --n9;
                    }
                    break;
                }
                ++n10;
            }
        } else if (this.numBreaks > 0 && this.breakOffsetInPixels[this.numBreaks - 1] == -this.totalWidth) {
            --n9;
        }
        if (n8 >= n9) {
            return;
        }
        Font font = this.css.getFont();
        if (graphics.getFont() != font) {
            graphics.setFont(font);
        }
        boolean bl = false;
        if (this.cssLayout.somethingSelected && this.cssLayout.selection.isInside(this.textNode)) {
            if (this.cssLayout.selection.startContainer == this.textNode || this.cssLayout.selection.endContainer == this.textNode) {
                bl = true;
                graphics.setColor(this.css.color);
            } else {
                graphics.setColor(Color.blue);
                graphics.fillRect(n, 0, n2, n4 + n3);
                graphics.setColor(Color.white);
            }
        } else {
            graphics.setColor(this.css.color);
        }
        if (this.css.vertical_align_type == 16) {
            n4 = this.textAscent;
        } else if (this.css.vertical_align_type == 17) {
            n4 = n4 + n3 - this.textDescent;
        }
        if (this.reverseText) {
            n7 = n9 - n8;
            cArray = new char[n7];
            int n12 = 0;
            n6 = n9 - 1;
            while (n6 >= n8) {
                cArray[n12++] = this.textNode.text[n6];
                --n6;
            }
            graphics.drawChars(cArray, 0, n7, n, n4);
        } else if (this.textNode.doc.charsetId != 0) {
            Bidi bidi = Bidi.createBidi(this.textNode.doc.charsetId, this.textNode.text, n8, n9);
            cArray = bidi.getChars();
            if (cArray != null) {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                n6 = n;
                n5 = 0;
                while (n5 < cArray.length) {
                    graphics.drawChars(cArray, n5, 1, n6, n4);
                    n6 += fontMetrics.charWidth(cArray[n5]);
                    ++n5;
                }
            }
        } else {
            graphics.drawChars(this.textNode.text, n8, n9 - n8, n, n4);
        }
        if ((this.css.text_decoration & 1) != 0) {
            n7 = n4 + n3 - 2;
            graphics.drawLine(n, n7, n + n2, n7);
        }
        if ((this.css.text_decoration & 4) != 0) {
            n7 = n4 + n3 - this.textAscent - this.textDescent + 1;
            graphics.drawLine(n, n7, n + n2, n7);
        }
        if ((this.css.text_decoration & 2) != 0) {
            n7 = n4 + n3 - 2;
            int n13 = n4 + n3 - this.textAscent - this.textDescent + 1;
            n7 += (n13 - n7) / 2;
            graphics.drawLine(n, n7, n + n2, n7);
        }
        if ((this.css.misc & 2) != 0) {
            this.cssLayout.outlinePainter.addRectangle(this, n, 0, n2, n4 + n3);
        }
        if (bl) {
            int n14;
            int n15;
            n7 = n8;
            int n16 = n9;
            int n17 = n;
            n5 = n6 = n + n2;
            int n18 = n17;
            int n19 = 0;
            FontMetrics fontMetrics = this.css.getFontMetrics();
            if (this.cssLayout.selection.startContainer == this.textNode) {
                n7 = this.cssLayout.selection.startOffset;
                if (n7 >= n9) {
                    return;
                }
                if (n7 > n8) {
                    n10 = 0;
                    while (n10 < this.numBreaks) {
                        n19 = this.textNode.breakOffset[n10];
                        if (n19 < 0) {
                            n19 = -n19;
                        }
                        if (n19 >= n7) {
                            n17 = this.breakOffsetInPixels[n10];
                            if (n17 < 0) {
                                n17 = -n17;
                            }
                            if ((n15 = this.textNode.breakOffset[n10]) < 0) {
                                n15 = -n15;
                            }
                            n14 = n15 - n7;
                            n18 = n17;
                            while (n14 > 0) {
                                n18 -= fontMetrics.charWidth(this.textNode.text[n19 - n14]);
                                --n14;
                            }
                            break;
                        }
                        ++n10;
                    }
                    if (n10 == this.numBreaks) {
                        n18 = n17;
                        n15 = 0;
                        if (n10 > 0) {
                            n15 = this.textNode.breakOffset[n10 - 1];
                            if (n15 < 0) {
                                n15 = -n15;
                            }
                            if ((n18 = this.breakOffsetInPixels[n10 - 1]) < 0) {
                                n18 = -n18;
                            }
                        }
                        n14 = n15;
                        while (n14 < n7) {
                            n18 += fontMetrics.charWidth(this.textNode.text[n14]);
                            ++n14;
                        }
                    }
                } else {
                    n7 = n8;
                }
            }
            if (this.cssLayout.selection.endContainer == this.textNode) {
                n16 = this.cssLayout.selection.endOffset;
                if (n16 <= n8) {
                    return;
                }
                if (n16 < n9) {
                    n10 = 0;
                    while (n10 < this.numBreaks) {
                        n19 = this.textNode.breakOffset[n10];
                        if (n19 < 0) {
                            n19 = -n19;
                        }
                        if (n19 >= n16) {
                            n6 = this.breakOffsetInPixels[n10];
                            if (n6 < 0) {
                                n6 = -n6;
                            }
                            n15 = n19 - n16;
                            n5 = n6;
                            while (n15 > 0) {
                                n5 -= fontMetrics.charWidth(this.textNode.text[n19 - n15]);
                                --n15;
                            }
                            break;
                        }
                        ++n10;
                    }
                    if (n10 == this.numBreaks) {
                        n15 = this.textNode.text.length - n16;
                        n5 = n6;
                        n14 = 0;
                        while (n14 < n15) {
                            n5 -= fontMetrics.charWidth(this.textNode.text[this.textNode.text.length - n14 - 1]);
                            ++n14;
                        }
                    }
                } else {
                    n16 = n9;
                }
            }
            if (n7 < n16) {
                graphics.setColor(Color.blue);
                graphics.fillRect(n18, 0, n5 - n18, n4 + n3);
                graphics.setColor(Color.white);
                graphics.drawChars(this.textNode.text, n7, n16 - n7, n18, n4);
            }
            n7 -= 15;
        }
    }

    public int getRenderedLineNumber(int n) {
        int n2 = 0;
        if (this.textDescent > 0 && this.textAscent > 0) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.breakOffsetInPixels.length) {
                if (n < (n3 = n3 + this.textDescent + this.textAscent)) break;
                ++n2;
                ++n4;
            }
        }
        return n2;
    }

    int getCharacterIndex(int n, boolean bl) {
        int n2;
        int n3;
        FontMetrics fontMetrics = this.css.getFontMetrics();
        if (bl) {
            int n4;
            int n5 = 0;
            while (n5 < this.numBreaks) {
                n4 = this.breakOffsetInPixels[n5];
                if (n4 < 0) {
                    n4 = -n4;
                }
                if (n < n4) {
                    n4 = n5 == 0 ? 0 : this.textNode.breakOffset[n5 - 1];
                    int n6 = this.textNode.breakOffset[n5];
                    int n7 = this.breakOffsetInPixels[n5];
                    if (n7 < 0) {
                        n7 = -n7;
                    }
                    if (n4 < 0) {
                        n4 = -n4;
                    }
                    if (n6 < 0) {
                        n6 = -n6;
                    }
                    String string = new String(this.textNode.text).substring(n4, n6);
                    int n8 = string.length() - 1;
                    while (n8 >= 0) {
                        if ((n7 -= fontMetrics.charWidth(string.charAt(n8))) < n) {
                            return n4 + n8;
                        }
                        --n8;
                    }
                    return n4;
                }
                ++n5;
            }
            n4 = 0;
            String string = new String(this.textNode.text);
            int n9 = 0;
            if (this.numBreaks > 0) {
                n4 = this.breakOffsetInPixels[this.breakOffsetInPixels.length - 1];
                if (n4 < 0) {
                    n4 = -n4;
                }
                if ((n9 = this.textNode.breakOffset[this.textNode.breakOffset.length - 1]) < 0) {
                    n9 = -n9;
                }
            }
            int n10 = n9;
            while (n10 < string.length()) {
                if ((n4 += fontMetrics.charWidth(string.charAt(n10))) > n) {
                    return n10;
                }
                ++n10;
            }
            return 0;
        }
        int n11 = 0;
        while (n11 < this.numBreaks) {
            n3 = this.breakOffsetInPixels[n11];
            if (n3 < 0) {
                n3 = -n3;
            }
            if (n < n3) {
                n3 = this.textNode.breakOffset[n11];
                int n12 = 0;
                int n13 = 0;
                if (n11 > 0) {
                    n12 = this.textNode.breakOffset[n11 - 1];
                    n13 = this.breakOffsetInPixels[n11 - 1];
                }
                if (n13 < 0) {
                    n13 = -n13;
                }
                if (n3 < 0) {
                    n3 = -n3;
                }
                if (n12 < 0) {
                    n12 = -n12;
                }
                String string = new String(this.textNode.text).substring(n12, n3 - 1);
                int n14 = 0;
                while (n14 < string.length()) {
                    if (n < (n13 += fontMetrics.charWidth(string.charAt(n14)))) {
                        return n12 + n14 + 1;
                    }
                    ++n14;
                }
                return n3;
            }
            ++n11;
        }
        n3 = 0;
        int n15 = 0;
        String string = "";
        if (this.breakOffsetInPixels.length > 0) {
            n3 = this.breakOffsetInPixels[this.breakOffsetInPixels.length - 1];
            if (n3 < 0) {
                n3 = -n3;
            }
            if ((n15 = this.textNode.breakOffset[this.textNode.breakOffset.length - 1]) < 0) {
                n15 = -n15;
            }
            if ((n2 = this.textNode.breakOffset[this.textNode.breakOffset.length - 1]) < 0) {
                n2 = -n2;
            }
            string = new String(this.textNode.text).substring(n2, this.textNode.text.length - 1);
        } else {
            string = new String(this.textNode.text);
        }
        n2 = 0;
        while (n2 < string.length()) {
            if (n < (n3 += fontMetrics.charWidth(string.charAt(n2)))) {
                return n15 + n2 + 1;
            }
            ++n2;
        }
        return this.textNode.getLength();
    }

    void findBoundingBox(Rectangle rectangle) {
        BlockBox blockBox = null;
        int n = this.ox;
        CSSBox cSSBox = this.parentBox;
        while (cSSBox.parentBox != null) {
            if (cSSBox.getType() == 0) {
                n += cSSBox.css.margin_left + cSSBox.css.border_left_width + cSSBox.css.padding_left;
                n += cSSBox.ox;
            } else {
                n += cSSBox.css.text_indent;
            }
            if (cSSBox.getType() == 1) {
                blockBox = (BlockBox)cSSBox;
                blockBox.recordBoundingBoxForInline(rectangle, n, this.totalWidth);
                if (rectangle.width == 0) {
                    rectangle.height = 0;
                    rectangle.width = 0;
                    rectangle.y = 0;
                    rectangle.x = 0;
                    blockBox.findBoundingBox(rectangle);
                    break;
                }
                if (cSSBox.css.position == 126 || cSSBox.css.position == 6) break;
                Point point = new Point();
                cSSBox = cSSBox.parentBox;
                if (cSSBox != null) {
                    cSSBox.findAbsolutePosition(point);
                }
                rectangle.x += point.x;
                rectangle.y += point.y;
                break;
            }
            cSSBox = cSSBox.parentBox;
        }
    }
}

