/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class FormInputUpload
extends JPanel
implements ObjectPainter,
DocumentListener,
Movable,
ActionListener {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    private JTextField tfield = null;
    private JButton button = null;
    private JInternalFrame fileframe = null;
    private JFileChooser dialog = null;
    private int maxLength = 100;
    private String startValue;

    FormInputUpload(DocView docView, DElement dElement) {
        this.docView = docView;
        this.element = (DInputElement)dElement;
        this.tfield = new JTextField();
        this.button = new JButton("Browse");
        this.dialog = new JFileChooser(".");
        this.fileframe = new JInternalFrame();
        this.checkAttributes();
        int n = this.element.getAttributeAsInt("size");
        if (n <= 0) {
            n = 20;
        }
        this.tfield.setColumns(n);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tfield, "Center");
        this.add((Component)this.button, "East");
        this.tfield.setBackground(Color.white);
        this.tfield.setFont(new Font("Monospaced", 0, 12));
        this.enableEvents(28L);
        this.button.addActionListener(this);
        this.tfield.getDocument().addDocumentListener(this);
    }

    private void checkAttributes() {
        String string;
        this.tfield.setEditable(!this.element.getReadOnly());
        this.tfield.setEnabled(!this.element.getDisabled());
        int n = this.element.getMaxLength();
        if (n != 0) {
            this.maxLength = n;
        }
        if ((string = this.element.getValue()) != null && !string.equals(this.tfield.getText())) {
            this.tfield.setText(string);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.element.setValue(this.tfield.getText());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.element.setValue(this.tfield.getText());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.element.setValue(this.tfield.getText());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.checkAttributes();
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics graphics) {
        if (this.isVisible()) {
            return;
        }
        graphics.setColor(Color.lightGray);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        if (!this.isValid()) {
            this.validate();
        }
        this.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.dialog.showDialog(this.fileframe, "Choose");
        String string = this.dialog.getSelectedFile().toString();
        this.tfield.setText(string);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.docView.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        int n = focusEvent.getID();
        if (n == 1004) {
            this.processFocusGained(focusEvent);
        } else if (n == 1005) {
            this.processFocusLost(focusEvent);
        }
        super.processFocusEvent(focusEvent);
    }

    private void processFocusGained(FocusEvent focusEvent) {
        if (this.startValue == null) {
            this.startValue = this.tfield.getText();
        }
    }

    private void processFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        String string = this.tfield.getText();
        if (!string.equals(this.startValue)) {
            this.element.dispatchChange();
        }
        this.startValue = null;
    }
}

