/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.pilots.html4.swing.MyTextArea;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class FormTextArea
extends JScrollPane
implements ObjectPainter,
DocumentListener,
CaretListener,
Movable {
    private DocView docView;
    private DTextAreaElement text;
    private ObjectBox box;
    private JTextArea textArea;

    FormTextArea(DocView docView, DElement dElement) {
        this.docView = docView;
        this.text = (DTextAreaElement)dElement;
        int n = dElement.getAttributeAsInt("rows");
        int n2 = dElement.getAttributeAsInt("cols");
        if (n < 0) {
            n = 3;
        }
        if (n2 < 0) {
            n2 = 20;
        }
        this.textArea = new MyTextArea(n, n2, docView, this.text);
        this.setViewportView(this.textArea);
        this.checkAttributes();
        this.textArea.setCaretPosition(0);
        this.textArea.getDocument().addDocumentListener(this);
        this.textArea.addCaretListener(this);
        this.setOpaque(true);
    }

    private void checkAttributes() {
        this.textArea.setEditable(!this.text.getReadOnly());
        this.textArea.setEnabled(!this.text.getDisabled());
        String string = this.text.getValue();
        if (string != null && !string.equals(this.textArea.getText())) {
            this.textArea.setText(string);
            this.textArea.setCaretPosition(string.length());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.text.setValue(this.textArea.getText());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.text.setValue(this.textArea.getText());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.text.setValue(this.textArea.getText());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.checkAttributes();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        int n;
        int n2 = caretEvent.getDot();
        if (n2 != (n = caretEvent.getMark())) {
            int n3;
            int n4;
            if (n2 < n) {
                n4 = n2;
                n3 = n;
            } else {
                n3 = n2;
                n4 = n;
            }
            this.text.dispatchSelection(n4, n3);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.textArea != null) {
            this.textArea.setFont(font);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.textArea != null) {
            this.textArea.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.textArea != null) {
            this.textArea.setForeground(color);
        }
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics graphics) {
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }
}

