/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.jmf;

import ice.storm.ContentLoader;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Pilot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;

public class ThePilot
extends Pilot
implements ControllerListener {
    protected Player player = null;
    protected Component visualComponent = null;
    protected Component controlComponent = null;
    protected Component progressBar = null;
    protected int controlPanelHeight = 0;
    protected int videoWidth = 0;
    protected int videoHeight = 0;
    protected String mediaFile;
    protected boolean deallocateSync = false;
    protected Panel panel;

    public Object getDynamicValueOnWindow(DynamicObject dynamicObject, String string, DynEnv dynEnv) {
        if (string.equals("pilot")) {
            return this;
        }
        return super.getDynamicValueOnWindow(dynamicObject, string, dynEnv);
    }

    public Component createComponent() {
        this.panel = new Panel();
        this.panel.setLayout(new BorderLayout());
        return this.panel;
    }

    public void parse(ContentLoader contentLoader) {
        if (this.player != null) {
            this.dispose();
            this.player = null;
        }
        MediaLocator mediaLocator = null;
        this.mediaFile = contentLoader.getLocation();
        int n = this.mediaFile.indexOf("//localhost");
        if (n > 0) {
            int n2 = n + 11;
            this.mediaFile = this.mediaFile.substring(0, n) + this.mediaFile.substring(n2);
        }
        this.firePropertyChange("location", null, this.mediaFile);
        this.firePropertyChange("title", null, "Loading " + this.mediaFile);
        try {
            mediaLocator = new MediaLocator(this.mediaFile);
            if (mediaLocator == null) {
                this.Fatal("Can't build URL for " + this.mediaFile);
            }
            try {
                this.player = Manager.createPlayer((MediaLocator)mediaLocator);
            }
            catch (NoPlayerException noPlayerException) {
                this.Fatal("Could not create player for " + mediaLocator);
            }
            this.player.addControllerListener((ControllerListener)this);
        }
        catch (MalformedURLException malformedURLException) {
            this.Fatal("Invalid media file URL!");
        }
        catch (IOException iOException) {
            this.Fatal("IO exception creating player for " + mediaLocator);
        }
        if (this.player != null) {
            this.player.start();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.player != null) {
            this.deallocateSync = true;
            this.player.stop();
            this.player.deallocate();
            this.deallocateSync = false;
            this.player.close();
            this.controlComponent = null;
            this.visualComponent = null;
            this.progressBar = null;
        }
    }

    protected void Fatal(String string) {
        throw new Error(string);
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (this.player == null) {
            return;
        }
        if (controllerEvent instanceof RealizeCompleteEvent) {
            if (this.progressBar != null) {
                this.panel.remove(this.progressBar);
                this.progressBar = null;
            }
            int n = 320;
            int n2 = 0;
            if (this.controlComponent == null && (this.controlComponent = this.player.getControlPanelComponent()) != null) {
                this.controlPanelHeight = this.controlComponent.getPreferredSize().height;
                this.panel.add(this.controlComponent, "South");
                n2 += this.controlPanelHeight;
            }
            if (this.visualComponent == null && (this.visualComponent = this.player.getVisualComponent()) != null) {
                this.panel.add(this.visualComponent, "Center");
                Dimension dimension = this.visualComponent.getPreferredSize();
                this.videoWidth = dimension.width;
                this.videoHeight = dimension.height;
                n = this.videoWidth;
                n2 += this.videoHeight;
                this.visualComponent.setSize(this.videoWidth, this.videoHeight);
            }
            this.panel.setSize(n, n2);
            if (this.controlComponent != null) {
                this.controlComponent.setBounds(0, this.videoHeight, n, this.controlPanelHeight);
                this.controlComponent.invalidate();
            }
            if (this.panel.getParent() != null) {
                this.panel.getParent().validate();
            }
            this.firePropertyChange("jmfEvent", this.mediaFile, "playerRealized");
        } else if (!(controllerEvent instanceof PrefetchCompleteEvent)) {
            if (controllerEvent instanceof StartEvent) {
                this.firePropertyChange("title", null, "Playing " + this.mediaFile);
            } else if (controllerEvent instanceof CachingControlEvent) {
                CachingControlEvent cachingControlEvent = (CachingControlEvent)controllerEvent;
                CachingControl cachingControl = cachingControlEvent.getCachingControl();
                long l = cachingControl.getContentProgress();
                long l2 = cachingControl.getContentLength();
                String string = "loading ";
                string = l2 == Long.MAX_VALUE || l2 == 0L ? string + "(" + l + " bytes)" : (l2 == l ? string + "done" : string + "(" + l * 100L / l2 + "%)");
                this.firePropertyChange("statusLine", null, string);
            } else if (controllerEvent instanceof EndOfMediaEvent) {
                this.firePropertyChange("jmfEvent", this.mediaFile, "endOfMedia");
            } else if (controllerEvent instanceof ControllerErrorEvent) {
                this.player = null;
                this.Fatal(((ControllerErrorEvent)controllerEvent).getMessage());
            } else if (controllerEvent instanceof ControllerClosedEvent) {
                this.panel.removeAll();
            } else {
                try {
                    Class<?> clazz = Class.forName("com.sun.media.SizeChangeEvent");
                    if (controllerEvent instanceof SizeChangeEvent) {
                        SizeChangeEvent sizeChangeEvent = (SizeChangeEvent)controllerEvent;
                        int n = sizeChangeEvent.getWidth();
                        int n3 = sizeChangeEvent.getHeight();
                        if (n != this.videoWidth || n3 != this.videoHeight) {
                            this.videoWidth = n;
                            this.videoHeight = n3;
                        }
                        this.panel.setSize(this.videoWidth, this.videoHeight + this.controlPanelHeight);
                        this.visualComponent.setBounds(0, 0, this.videoWidth, this.videoHeight);
                        if (this.controlComponent != null) {
                            this.controlComponent.setBounds(0, this.videoHeight, this.videoWidth, this.controlPanelHeight);
                            this.controlComponent.invalidate();
                        }
                        this.panel.validate();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public void playerStart() {
        this.player.start();
    }

    public void playerStop() {
        this.player.stop();
    }
}

