/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.text;

import ice.pilots.text.ThePrinter;
import ice.pilots.text.VisualComponent;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.StormPrinter;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class ThePilot
extends Pilot {
    private VisualComponent vis = null;
    private Vector lines = null;
    private int zoomFactor = 256;
    private static Font defaultFont;

    public static Font getDefaultFont() {
        Font font = defaultFont;
        if (font == null) {
            defaultFont = font = new Font("Monospaced", 0, 12);
        }
        return font;
    }

    public static void setDefaultFont(Font font) {
        defaultFont = font;
    }

    public void init(String string) {
        super.init(string);
        String string2 = "ice.pilots.text." + string + ".TextArea";
        try {
            Object obj = Class.forName(string2).newInstance();
            this.vis = (VisualComponent)obj;
            this.vis.setTheFont(ThePilot.getDefaultFont());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Component createComponent() {
        return (Component)((Object)this.vis);
    }

    public Vector getLines() {
        return this.lines;
    }

    public void clear(String string) {
        this.vis.setTheText("");
    }

    public void parse(ContentLoader contentLoader) throws IOException {
        this.lines = new Vector();
        this.firePropertyChange("location", null, contentLoader.getLocation());
        this.firePropertyChange("title", null, contentLoader.getLocation());
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(contentLoader.getInputStream()));
        String string = bufferedReader.readLine();
        try {
            while (string != null) {
                this.lines.addElement(string);
                stringBuffer.append(string);
                stringBuffer.append('\n');
                string = bufferedReader.readLine();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            stringBuffer = null;
            throw new OutOfMemoryError();
        }
        bufferedReader.close();
        this.vis.setTheText(stringBuffer.toString());
    }

    public void setZoom(int n) {
        if (n != this.zoomFactor) {
            this.zoomFactor = n;
            Font font = this.vis.getTheFont();
            if (font != null) {
                int n2 = font.getSize();
                int n3 = n2 * n >> 8;
                if (n3 < 4) {
                    n3 = 4;
                }
                if (n2 != n3) {
                    this.vis.setTheFont(new Font(font.getName(), font.getStyle(), n3));
                }
            }
        }
    }

    public void setFont(Font font) {
        int n = font.getSize() * this.zoomFactor >> 8;
        if (n < 4) {
            n = 4;
        }
        if (!(font = new Font(font.getName(), font.getStyle(), n)).equals(this.vis.getTheFont())) {
            this.vis.setTheFont(font);
        }
    }

    public StormPrinter createPrinter() {
        ThePrinter thePrinter = new ThePrinter(this);
        return thePrinter;
    }
}

