/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.PilotInfo;
import ice.storm.ScripterInfo;
import ice.storm.StormPropertiesLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Cache {
    private Vector pilotInfos = new Vector();
    private Vector scripterInfos = new Vector();
    private Hashtable hashByScripterAlias = new Hashtable();
    Hashtable fileExtToContentType = new Hashtable();

    Cache() {
    }

    void addPilotInfo(PilotInfo pilotInfo) {
        this.pilotInfos.addElement(pilotInfo);
    }

    void removePilotInfo(PilotInfo pilotInfo) {
        this.pilotInfos.removeElement(pilotInfo);
    }

    void addScripterInfo(ScripterInfo scripterInfo) {
        if (scripterInfo.aliases != null && scripterInfo.aliases.length > 0) {
            this.scripterInfos.addElement(scripterInfo);
            int n = 0;
            while (n < scripterInfo.aliases.length) {
                this.hashByScripterAlias.put(scripterInfo.aliases[n], scripterInfo);
                ++n;
            }
        }
    }

    void removeScripterInfo(ScripterInfo scripterInfo) {
        if (this.scripterInfos.removeElement(scripterInfo)) {
            int n = 0;
            while (n < scripterInfo.aliases.length) {
                this.hashByScripterAlias.remove(scripterInfo.aliases[n]);
                ++n;
            }
        }
    }

    Enumeration getAllPilotInfos() {
        return this.pilotInfos.elements();
    }

    Enumeration getAllScripterInfos() {
        return this.scripterInfos.elements();
    }

    ScripterInfo getScripterInfo(String string) {
        ScripterInfo scripterInfo = (ScripterInfo)this.hashByScripterAlias.get(string.toLowerCase());
        if (scripterInfo != null && !scripterInfo.enabled) {
            scripterInfo = null;
        }
        return scripterInfo;
    }

    PilotInfo[] getPilotInfos(String string) {
        Vector vector = new Vector();
        this.addInfosByContentType(vector, string);
        Object[] objectArray = new PilotInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    PilotInfo[] getPilotInfos(ContentLoader contentLoader) {
        Vector vector = new Vector();
        this.addInfosByContentType(vector, this.extractContentType(contentLoader));
        Object[] objectArray = new PilotInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private String extractContentType(ContentLoader contentLoader) {
        String string = contentLoader.getContentType();
        String string2 = null;
        if (string == null) {
            string2 = this.getExtensionBasedType(contentLoader.getLocation());
        } else {
            int n = (string = string.toLowerCase()).indexOf(59);
            if (n >= 0) {
                string = string.substring(0, n).trim();
            } else if (string.indexOf("unknown") >= 0) {
                string2 = this.getExtensionBasedType(contentLoader.getLocation());
            } else if (string.equalsIgnoreCase("text/html") || string.equalsIgnoreCase("text/plain")) {
                // empty if block
            }
        }
        if (string2 != null) {
            string = string2;
            contentLoader.setContentType(string2);
        }
        return string;
    }

    private String getExtensionBasedType(String string) {
        String string2;
        String string3 = "content/unknown";
        String string4 = this.extractFileExtension(string);
        if (string4 != null && (string2 = (String)this.fileExtToContentType.get(string4)) != null) {
            string3 = string2;
        }
        return string3;
    }

    private String extractFileExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(47)) >= 0) {
            int n2 = string.indexOf(35, n + 1);
            int n3 = string.indexOf(63, n + 1);
            int n4 = n2 < 0 || n3 < 0 ? string.length() : (n2 < 0 || n2 > n3 ? n3 : n2);
            int n5 = string.lastIndexOf(46, n4 - 1);
            if (n5 > n && n5 != n4 - 1) {
                return string.substring(n5, n4);
            }
        }
        return null;
    }

    private void addInfosByContentType(Vector vector, String string) {
        int n = string.indexOf(59);
        if (n > 0) {
            string = string.substring(0, n);
        }
        int n2 = 0;
        while (n2 < this.pilotInfos.size()) {
            PilotInfo pilotInfo = (PilotInfo)this.pilotInfos.elementAt(n2);
            if (pilotInfo.enabled) {
                int n3 = 0;
                while (n3 < pilotInfo.supportedContentTypes.length) {
                    String string2 = pilotInfo.supportedContentTypes[n3];
                    if (this.matchContentType(string2, string)) {
                        vector.addElement(pilotInfo);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private boolean matchContentType(String string, String string2) {
        if (string.indexOf(42) < 0) {
            return string.equals(string2);
        }
        int n = string.indexOf(47);
        if (n < 0) {
            return string.length() == 1;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        return !(!string3.equals("*") && !string2.startsWith(string3) || !string4.equals("*") && !string2.endsWith(string4));
    }

    boolean isContentTypeSupported(Pilot pilot, ContentLoader contentLoader, String string) {
        String string2 = pilot.getClass().getName();
        if (string == null) {
            string = this.extractContentType(contentLoader);
        }
        int n = 0;
        int n2 = this.pilotInfos.size() - 1;
        while (n != n2) {
            PilotInfo pilotInfo = (PilotInfo)this.pilotInfos.elementAt(n);
            if (pilotInfo.enabled && string2.equals(pilotInfo.className)) {
                String[] stringArray = pilotInfo.supportedContentTypes;
                int n3 = 0;
                int n4 = stringArray.length;
                while (n3 != n4) {
                    if (this.matchContentType(stringArray[n3], string)) {
                        return true;
                    }
                    ++n3;
                }
            }
            ++n;
        }
        return false;
    }

    void loadInfos(InputStream inputStream) throws IOException {
        StormPropertiesLoader stormPropertiesLoader = new StormPropertiesLoader();
        stormPropertiesLoader.loadProperties(inputStream, this.fileExtToContentType);
        this.recordPilotInfos(stormPropertiesLoader.infos);
        this.recordScripterInfos(stormPropertiesLoader.scripters);
    }

    private void recordScripterInfos(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            ScripterInfo scripterInfo = (ScripterInfo)vector.elementAt(n);
            this.addScripterInfo(scripterInfo);
            ++n;
        }
    }

    private void recordPilotInfos(Vector vector) {
        Object e = null;
        int n = this.pilotInfos.size();
        if (n > 0) {
            e = this.pilotInfos.elementAt(n - 1);
            this.pilotInfos.removeElementAt(n - 1);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            this.pilotInfos.addElement(vector.elementAt(n2));
            ++n2;
        }
        if (e != null) {
            this.pilotInfos.addElement(e);
        }
    }
}

