/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ImageConnection;
import ice.util.net.URLStreamHandlerFactory;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class ImageCache {
    private static ImageCache instance;
    private int toUnload;
    protected int numEntries;
    protected Entry first;
    protected Hashtable uriToEntry;
    protected Hashtable imageToEntry;
    protected int timeout;
    private int theCounter;
    static final int NUMBER_OF_LOADER_THREADS = 4;
    private int animImageCounter;
    private boolean doNotUseImageConnection;

    public static void setInstance(ImageCache imageCache) {
        if (instance == null) {
            instance = imageCache;
        }
    }

    public static ImageCache getInstance() {
        if (instance == null) {
            instance = new ImageCache();
        }
        return instance;
    }

    protected ImageCache() {
        block3: {
            this.toUnload = 0;
            this.numEntries = 0;
            this.timeout = 30;
            this.theCounter = 0;
            this.animImageCounter = 0;
            this.doNotUseImageConnection = false;
            this.uriToEntry = new Hashtable();
            this.imageToEntry = new Hashtable();
            try {
                URLStreamHandlerFactory.addStreamHandler("image", "ice.storm.ImageHandler");
            }
            catch (Throwable throwable) {
                if (Debug.ex) {
                    Debug.ex(throwable);
                }
                if (!Debug.trace) break block3;
                Debug.trace("URLStreamHandlerFactory not set. Cannot install ImageConnection: " + throwable);
            }
        }
    }

    public void setExpire(int n) {
        this.timeout = n;
    }

    public int getExpire() {
        return this.timeout;
    }

    public void dispose() {
        this.flushImages(true);
        instance = null;
    }

    private URL map(String string) {
        if (!this.doNotUseImageConnection) {
            int n = this.theCounter++;
            try {
                return new URL("image:" + this.theCounter);
            }
            catch (MalformedURLException malformedURLException) {
                this.doNotUseImageConnection = true;
            }
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    String getRealUrl(URL uRL, ImageConnection imageConnection) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            Entry entry = this.first;
            while (entry != null) {
                if (entry.mapped == uRL) {
                    entry.ic = imageConnection;
                    if (entry.stopped) {
                        entry.flushBeforeReload = true;
                        String string = null;
                        return string;
                    }
                    String string = entry.url;
                    return string;
                }
                entry = entry.next;
            }
        }
        return null;
    }

    public Image getImage(URL uRL) {
        return this.getImage(uRL.toExternalForm());
    }

    public Image getImage(String string) {
        Entry entry = this.findEntry(string);
        if (entry == null) {
            ImageCache imageCache = this;
            synchronized (imageCache) {
                URL uRL = this.map(string);
                Image image = ImageCache.getImageFromToolkit(Toolkit.getDefaultToolkit(), uRL);
                if (image == null) {
                    Image image2 = null;
                    return image2;
                }
                entry = new Entry(image, string, uRL);
                this.addEntry(entry);
                this.addEntrylater(entry);
            }
        } else {
            entry.stopped = false;
            if (entry.flushBeforeReload) {
                entry.flushBeforeReload = false;
                Image image = entry.image;
                image.flush();
            }
            if (entry.ref == 0) {
                --this.toUnload;
            }
        }
        ++entry.ref;
        return entry.image;
    }

    private static Image getImageFromToolkit(final Toolkit toolkit, final URL uRL) {
        ImageCache imageCache = instance;
        synchronized (imageCache) {
            --ImageCache.instance.animImageCounter;
            if (ImageCache.instance.animImageCounter < 0) {
                ImageCache.instance.animImageCounter = 0;
            }
        }
        return (Image)SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                Image image = null;
                try {
                    image = toolkit.getImage(uRL);
                }
                catch (Throwable throwable) {
                    image = null;
                }
                return image;
            }
        });
    }

    public void stopLoading(Image image) {
        Entry entry = this.findEntry(image);
        if (entry == null) {
            return;
        }
        ImageConnection imageConnection = entry.ic;
        entry.ic = null;
        if (imageConnection != null) {
            entry.flushBeforeReload = imageConnection.reqToStop();
        } else {
            entry.stopped = true;
        }
    }

    public void release(Image image) {
        Entry entry = this.findEntry(image);
        if (entry != null) {
            --entry.ref;
            if (entry.ref == 0) {
                ++this.toUnload;
                entry.dieTime = System.currentTimeMillis() + (long)(this.timeout * 1000);
            }
        }
    }

    public void flushImages(boolean bl) {
        int n;
        if (!bl && this.toUnload == 0) {
            return;
        }
        Vector<Image> vector = null;
        ImageCache imageCache = this;
        synchronized (imageCache) {
            n = this.toUnload;
            long l = System.currentTimeMillis();
            Entry entry = this.first;
            Entry entry2 = null;
            while (entry != null) {
                if (entry.ref == 0 && entry.dieTime <= l || bl) {
                    if (vector == null) {
                        vector = new Vector<Image>();
                    }
                    vector.addElement(entry.image);
                    this.uriToEntry.remove(entry.url);
                    this.imageToEntry.remove(entry.image);
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        this.first = entry.next;
                    }
                    if (entry.ref == 0) {
                        --this.toUnload;
                    }
                    --this.numEntries;
                    entry = entry.next;
                    continue;
                }
                entry2 = entry;
                entry = entry.next;
            }
        }
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                Image image = (Image)vector.elementAt(n);
                image.flush();
                ++n;
            }
        }
    }

    public void checkForAnimatedImagesBug() {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            ++this.animImageCounter;
            if (Debug.trace) {
                Debug.trace("animImageCounter==" + this.animImageCounter);
            }
            if (this.animImageCounter >= 4) {
                block9: {
                    try {
                        if (Debug.trace) {
                            Debug.trace("--> Initiating recovery");
                        }
                        URL uRL = this.getClass().getResource("resources/dummyimage.gif");
                        Image image = ImageCache.getImageFromToolkit(Toolkit.getDefaultToolkit(), uRL);
                        Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, null);
                        image.flush();
                    }
                    catch (Exception exception) {
                        if (!Debug.ex) break block9;
                        Debug.ex(exception);
                    }
                }
                if (Debug.trace) {
                    Debug.trace("--> --> Recovery done");
                }
            }
        }
    }

    protected synchronized Entry findEntry(Image image) {
        return (Entry)this.imageToEntry.get(image);
    }

    protected synchronized Entry findEntry(String string) {
        return (Entry)this.uriToEntry.get(string);
    }

    protected synchronized void addEntry(Entry entry) {
        entry.next = this.first;
        this.first = entry;
        this.uriToEntry.put(entry.url, entry);
        ++this.numEntries;
    }

    protected synchronized void addEntrylater(Entry entry) {
        this.imageToEntry.put(entry.image, entry);
    }

    class Entry {
        Entry next;
        Image image;
        String url;
        int ref;
        long dieTime;
        URL mapped;
        ImageConnection ic;
        boolean flushBeforeReload = false;
        boolean stopped = false;

        Entry(Image image, String string, URL uRL) {
            this.image = image;
            this.url = string;
            this.mapped = uRL;
        }
    }
}

