/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.debug.Debug;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;

public class Defs {
    public static final Object NOT_FOUND = new Object();
    public static final Object NO_SYNCHRONIZATION = null;
    public static final String EMPTY_STRING = "";
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static Object[] newObjectArray(int n) {
        return n != 0 ? new Object[n] : EMPTY_OBJECT_ARRAY;
    }

    public static String property(String string) {
        return Defs.property(string, null);
    }

    public static String property(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    public static int intProperty(String string, int n) {
        String string2 = Defs.property(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static boolean booleanProperty(String string) {
        return Defs.booleanProperty(string, false);
    }

    public static boolean booleanProperty(String string, boolean bl) {
        String string2 = Defs.sysProperty(string);
        if (string2 != null) {
            switch (string2.length()) {
                case 2: {
                    if (!"no".equals(string2)) break;
                    return false;
                }
                case 3: {
                    if (!"yes".equals(string2)) break;
                    return true;
                }
                case 4: {
                    if (!"true".equals(string2)) break;
                    return true;
                }
                case 5: {
                    if (!"false".equals(string2)) break;
                    return false;
                }
            }
        }
        return bl;
    }

    public static String sysProperty(String string) {
        return Defs.property(string);
    }

    public static String sysProperty(String string, String string2) {
        return Defs.property(string, string2);
    }

    public static int sysPropertyInt(String string, int n) {
        return Defs.intProperty(string, n);
    }

    public static boolean sysPropertyBoolean(String string) {
        return Defs.booleanProperty(string);
    }

    public static boolean sysPropertyBoolean(String string, boolean bl) {
        return Defs.booleanProperty(string, bl);
    }

    public static void setProperty(String string, String string2) {
        try {
            Properties properties = System.getProperties();
            if (string2 == null) {
                ((Hashtable)properties).remove(string);
            } else {
                ((Hashtable)properties).put(string, string2);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void setSystemProperty(String string, String string2) {
        block5: {
            try {
                Properties properties = System.getProperties();
                if (string2 == null) {
                    ((Hashtable)properties).remove(string);
                } else {
                    ((Hashtable)properties).put(string, string2);
                }
            }
            catch (SecurityException securityException) {
                if (Debug.ex) {
                    Debug.ex(securityException);
                }
                if (!Debug.trace) break block5;
                Debug.trace("Failed to set system property " + string + ": " + securityException.getMessage());
            }
        }
    }

    public static Class getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static Object newClassInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static Object newClassInstance(String string) {
        Class clazz = Defs.getClass(string);
        return clazz == null ? null : Defs.newClassInstance(clazz);
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static Method getMethod(String string, String string2, Class[] classArray) {
        Class clazz = Defs.getClass(string);
        if (clazz != null) {
            return Defs.getMethod(clazz, string2, classArray);
        }
        return null;
    }

    public static void badArg() throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }
}

