/*
 * Decompiled with CFR 0.152.
 */
package ice.util.awt;

import ice.debug.Debug;
import ice.util.awt.AwtQueueKit;

public class TimedAWTExecutor {
    private final AwtQueueKit awtKit = AwtQueueKit.newInstance();
    private final Object queueMonitor = new Object();
    private volatile Thread scheduleThread = new Thread("Timer queue for AWT thread"){

        public void run() {
            TimedAWTExecutor.this.runScheduler();
        }
    };
    private QueueElem queueFirst;
    private QueueElem queueLast;
    private long prev_sys_time = 0L;
    private long time_to_add = 0L;

    public TimedAWTExecutor() {
        this.scheduleThread.setDaemon(true);
        this.scheduleThread.start();
    }

    public boolean isEventThread() {
        return this.awtKit.isDispatchThread();
    }

    private long currentTimeMillis() {
        long l = System.currentTimeMillis();
        if (l < this.prev_sys_time) {
            int n;
            if (Debug.trace) {
                Debug.trace("TIME BUG");
            }
            if ((l = this.prev_sys_time | (long)(n = (int)System.currentTimeMillis())) < this.prev_sys_time) {
                long l2 = this.prev_sys_time - l;
                this.time_to_add += l2;
                if (Debug.trace) {
                    Debug.trace("!!!!!BAD System.currentTimeMillis, negative offset: " + (double)l2 / 1000.0 + "s !!!!!");
                }
            }
        }
        this.prev_sys_time = l;
        return this.time_to_add + l;
    }

    public void shutdown() {
        Thread thread = this.scheduleThread;
        if (thread != null) {
            this.scheduleThread = null;
            this.clearQueue();
            thread.interrupt();
        }
    }

    public void invokeLater(Runnable runnable, long l) {
        if (this.scheduleThread != null) {
            if (l == 0L) {
                this.awtKit.invokeLater(runnable);
            } else {
                QueueElem queueElem = new QueueElem();
                queueElem.code = runnable;
                Object object = this.queueMonitor;
                synchronized (object) {
                    queueElem.deliveryTime = this.currentTimeMillis() + l;
                    this.insertElem(queueElem);
                    this.queueMonitor.notify();
                }
            }
        }
    }

    public void clearQueue() {
        Object object = this.queueMonitor;
        synchronized (object) {
            QueueElem queueElem = this.queueFirst;
            this.queueFirst = null;
            this.queueLast = null;
            while (queueElem != null) {
                QueueElem queueElem2 = queueElem.next;
                queueElem.prev = null;
                queueElem.next = null;
                queueElem = queueElem2;
            }
            this.queueMonitor.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private QueueElem nextElem() {
        Object object = this.queueMonitor;
        synchronized (object) {
            while (this.scheduleThread != null) {
                QueueElem queueElem = this.getEarliestElem();
                if (queueElem == null) {
                    if (this.scheduleThread == null) break;
                    try {
                        this.queueMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                long l = this.currentTimeMillis();
                long l2 = queueElem.deliveryTime - l;
                if (l2 <= 0L) {
                    queueElem = this.removeEarliestElem();
                    return queueElem;
                }
                try {
                    this.queueMonitor.wait(l2);
                }
                catch (InterruptedException interruptedException) {}
            }
            return null;
        }
    }

    void runScheduler() {
        while (this.scheduleThread != null) {
            QueueElem queueElem = this.nextElem();
            if (queueElem == null) break;
            this.awtKit.invokeLater(queueElem.code);
        }
    }

    private void insertElem(QueueElem queueElem) {
        QueueElem queueElem2 = this.queueLast;
        if (queueElem2 == null) {
            this.queueLast = queueElem;
            this.queueFirst = queueElem;
        } else {
            long l = queueElem.deliveryTime;
            if (queueElem2.deliveryTime <= l) {
                queueElem.prev = queueElem2;
                queueElem2.next = queueElem;
                this.queueLast = queueElem;
            } else {
                QueueElem queueElem3 = queueElem2.prev;
                while (queueElem3 != null) {
                    if (queueElem3.deliveryTime <= l) break;
                    queueElem3 = queueElem3.prev;
                }
                if (queueElem3 != null) {
                    queueElem.next = queueElem3.next;
                    queueElem.prev = queueElem3;
                    queueElem3.next.prev = queueElem;
                    queueElem3.next = queueElem;
                } else {
                    queueElem.next = this.queueFirst;
                    this.queueFirst.prev = queueElem;
                    this.queueFirst = queueElem;
                }
            }
        }
    }

    private QueueElem getEarliestElem() {
        return this.queueFirst;
    }

    private QueueElem removeEarliestElem() {
        QueueElem queueElem = this.queueFirst;
        if (queueElem != null) {
            this.queueFirst = queueElem.next;
            if (this.queueFirst == null) {
                this.queueLast = null;
            } else {
                this.queueFirst.prev = null;
            }
            queueElem.prev = null;
            queueElem.next = null;
        }
        return queueElem;
    }

    private static final class QueueElem {
        Runnable code;
        QueueElem prev;
        QueueElem next;
        long deliveryTime;

        private QueueElem() {
        }
    }
}

