/*
 * Decompiled with CFR 0.152.
 */
package ice.util.awt.jdk11;

import ice.debug.Debug;
import ice.util.awt.AwtQueueKit;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;

public final class AwtQueueKit_jdk11
extends AwtQueueKit {
    private ProxyComponent proxy = new ProxyComponent();

    public void invokeLater(Runnable runnable) {
        this.proxy.invokeLater(runnable);
    }

    public boolean isDispatchThread() {
        Thread thread = Thread.currentThread();
        String string = thread.getClass().getName();
        if (string.equals("java.awt.EventDispatchThread")) {
            return true;
        }
        return thread == this.proxy.awtThread;
    }

    private static final class ProxyComponent
    extends Component
    implements Runnable {
        Thread awtThread;
        private EventQueue awtQueue;
        private ProxyEvent first;
        private ProxyEvent last;

        ProxyComponent() {
            block2: {
                this.enableEvents(-1L);
                try {
                    this.awtQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                catch (RuntimeException runtimeException) {
                    if (!Debug.ex) break block2;
                    Debug.ex(runtimeException);
                }
            }
            this.invokeLater(this);
        }

        public void run() {
            this.awtThread = Thread.currentThread();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void processEvent(AWTEvent aWTEvent) {
            ProxyEvent proxyEvent;
            if (this.awtQueue != null) {
                if (!(aWTEvent instanceof ProxyEvent)) return;
                try {
                    ((ProxyEvent)aWTEvent).code.run();
                    return;
                }
                catch (RuntimeException runtimeException) {
                    if (!Debug.ex) return;
                    Debug.ex(runtimeException);
                    return;
                }
            }
            ProxyComponent proxyComponent = this;
            synchronized (proxyComponent) {
                proxyEvent = this.first;
                this.last = null;
                this.first = null;
            }
            while (proxyEvent != null) {
                block8: {
                    try {
                        proxyEvent.code.run();
                    }
                    catch (RuntimeException runtimeException) {
                        if (!Debug.ex) break block8;
                        Debug.ex(runtimeException);
                    }
                }
                proxyEvent = proxyEvent.next;
            }
        }

        void invokeLater(Runnable runnable) {
            ProxyEvent proxyEvent = new ProxyEvent(this, runnable);
            if (this.awtQueue != null) {
                this.awtQueue.postEvent(proxyEvent);
            } else {
                ProxyComponent proxyComponent = this;
                synchronized (proxyComponent) {
                    if (this.last == null) {
                        this.first = this.last = proxyEvent;
                    } else {
                        this.last.next = proxyEvent;
                        this.last = proxyEvent;
                    }
                }
                this.setVisible(true);
                this.setVisible(false);
            }
        }
    }

    private static final class ProxyEvent
    extends AWTEvent {
        Runnable code;
        ProxyEvent next;

        ProxyEvent(ProxyComponent proxyComponent, Runnable runnable) {
            super(proxyComponent, 2000);
            this.code = runnable;
        }
    }
}

