/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.snippet;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.raptor.snippet.Snippet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxHandler
extends DefaultHandler {
    private String _name;
    private String _category;
    private String _language;
    private String _description;
    private String _code;
    private String _current;
    private HashMap _languages;

    public SaxHandler(HashMap languages) {
        this._languages = languages;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this._current = qName;
        if ("snippet".equals(qName)) {
            this._description = null;
            this._code = null;
        }
        this.set(qName, null);
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            String qName_i = attributes.getQName(i);
            String value = attributes.getValue(i);
            this.set(qName_i, value);
        }
    }

    private void set(String name, String value) {
        if ("name".equals(name)) {
            this._name = value;
        } else if ("category".equals(name)) {
            this._category = value;
        } else if ("language".equals(name)) {
            this._language = value;
        } else if ("description".equals(name)) {
            this._description = value != null ? (this._description == null ? value : this._description + value) : null;
        } else if ("code".equals(name) || "snippet".equals(name)) {
            this._code = value != null ? (this._code == null ? value : this._code + value) : null;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("snippet".equals(qName)) {
            this.addSnippet(this._name, this._category, this._language, this._description, this._code);
        }
        this._current = null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._current != null) {
            String chars = new String(ch, start, length);
            this.set(this._current, chars);
        }
    }

    public void addSnippet(String name, String category, String language, String description, String code) {
        ArrayList<Snippet> snippets;
        if (name == null) {
            throw new IllegalArgumentException("Snippet must have a name");
        }
        HashMap categories = (HashMap)this._languages.get(language);
        if (categories == null) {
            categories = new HashMap();
            this._languages.put(language, categories);
        }
        if ((snippets = (ArrayList<Snippet>)categories.get(category)) == null) {
            snippets = new ArrayList<Snippet>();
            categories.put(category, snippets);
        }
        Snippet snippet = new Snippet(name, code, description);
        boolean add = true;
        for (int i = 0; i < snippets.size(); ++i) {
            if (!((Snippet)snippets.get(i)).getName().equals(name)) continue;
            snippets.remove(i);
            snippets.add(i, snippet);
            add = false;
        }
        if (add) {
            snippets.add(snippet);
        }
    }
}

