/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleImplicitConnectionCache;

public class OracleDataSource
implements DataSource,
Serializable,
Referenceable {
    protected static int unnamedInstanceCount = 0;
    protected static final String dms_root_name = "JDBC";
    protected static final String dms_default_data_source_name = "OracleDataSource";
    protected PrintWriter m_pw = null;
    protected int m_loginTimeout = 0;
    protected String m_databaseName = null;
    protected String m_serviceName = null;
    protected String m_dataSourceName = "OracleDataSource";
    protected String m_description = null;
    protected String m_networkProtocol = "tcp";
    protected int m_portNumber = 0;
    protected String m_user = null;
    protected String m_password = null;
    protected String m_serverName = null;
    protected String m_url = null;
    protected String m_driverType = null;
    protected String m_tnsentry = null;
    protected int m_maxStatements = 0;
    protected boolean m_implicitCachingEnabled = false;
    protected boolean m_explicitCachingEnabled = false;
    protected OracleImplicitConnectionCache m_odsCache = null;
    protected OracleConnectionCacheManager m_occmi = null;
    protected String m_connCacheName = null;
    protected Properties m_connCacheProperties = null;
    protected Properties m_connectionProperties = null;
    protected boolean m_connCachingEnabled = false;
    protected boolean m_fastConnFailover = false;
    public boolean isOracleDataSource = true;
    private static final boolean fastConnectionFailoverSysProperty = "true".equalsIgnoreCase(OracleDriver.getSystemProperty("oracle.jdbc.FastConnectionFailover", "false"));
    private boolean m_url_explicit = false;
    private boolean m_use_defConn = false;
    protected transient OracleDriver m_od = new OracleDriver();
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    protected static String dms_data_source_type() {
        return "JDBC_DataSource";
    }

    public OracleDataSource() throws SQLException {
        this.processFastConnectionFailoverSysProperty();
    }

    void processFastConnectionFailoverSysProperty() {
        if (this.isOracleDataSource && fastConnectionFailoverSysProperty) {
            this.m_connCachingEnabled = true;
            if (this.m_occmi == null) {
                try {
                    this.m_occmi = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.m_fastConnFailover = true;
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.m_user, this.m_password);
    }

    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        Properties properties;
        if (this.m_connCachingEnabled) {
            return this.getConnection(string, string2, null);
        }
        this.makeURL();
        Connection connection = null;
        Properties properties2 = properties = this.m_connectionProperties == null ? new Properties() : (Properties)this.m_connectionProperties.clone();
        if (string != null) {
            properties.put("user", string);
        }
        if (string2 != null) {
            properties.put("password", string2);
        }
        if (this.m_loginTimeout != 0) {
            properties.put("oracle.net.CONNECT_TIMEOUT", "" + this.m_loginTimeout * 1000);
        }
        String string3 = this.m_dataSourceName == null || this.m_dataSourceName.length() == 0 ? "OracleDataSource_" + unnamedInstanceCount++ : this.m_dataSourceName;
        properties.setProperty("DMSName", string3);
        properties.setProperty("DMSType", OracleDataSource.dms_data_source_type());
        if (this.m_od == null) {
            this.m_od = new OracleDriver();
        }
        if ((connection = this.m_use_defConn ? this.m_od.defaultConnection() : this.m_od.connect(this.m_url, properties)) == null) {
            DatabaseError.throwSqlException(67);
        }
        ((OracleConnection)connection).setStatementCacheSize(this.m_maxStatements);
        ((OracleConnection)connection).setImplicitCachingEnabled(this.m_implicitCachingEnabled);
        ((OracleConnection)connection).setExplicitCachingEnabled(this.m_explicitCachingEnabled);
        return connection;
    }

    public synchronized Connection getConnection(Properties properties) throws SQLException {
        if (!this.m_connCachingEnabled) {
            DatabaseError.throwSqlException(137);
        }
        return this.getConnection(this.m_user, this.m_password, properties);
    }

    public synchronized Connection getConnection(String string, String string2, Properties properties) throws SQLException {
        if (!this.m_connCachingEnabled) {
            DatabaseError.throwSqlException(137);
        }
        if (this.m_odsCache == null) {
            this.cacheInitialize();
        }
        return this.m_odsCache.getConnection(string, string2, properties);
    }

    private void cacheInitialize() throws SQLException {
        if (this.m_connCacheName != null) {
            this.m_occmi.createCache(this.m_connCacheName, this, this.m_connCacheProperties);
        } else {
            this.m_connCacheName = this.m_occmi.createCache(this, this.m_connCacheProperties);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.m_connCachingEnabled && this.m_odsCache != null) {
            this.m_occmi.removeCache(this.m_odsCache.m_cacheName, 0L);
            this.m_odsCache = null;
        }
    }

    public synchronized void setConnectionCachingEnabled(boolean bl) throws SQLException {
        if (this.isOracleDataSource) {
            if (bl) {
                this.m_connCachingEnabled = true;
                if (this.m_occmi == null) {
                    this.m_occmi = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
                }
            } else if (this.m_odsCache == null) {
                this.m_connCachingEnabled = false;
                this.m_fastConnFailover = false;
                this.m_connCacheName = null;
                this.m_connCacheProperties = null;
            }
        } else {
            DatabaseError.throwSqlException(137);
        }
    }

    public boolean getConnectionCachingEnabled() throws SQLException {
        return this.m_connCachingEnabled;
    }

    public synchronized void setConnectionCacheName(String string) throws SQLException {
        if (this.m_connCachingEnabled) {
            if (string == null) {
                DatabaseError.throwSqlException(138);
            } else {
                this.m_connCacheName = string;
            }
        }
    }

    public String getConnectionCacheName() throws SQLException {
        if (this.m_connCachingEnabled && this.m_odsCache != null) {
            return this.m_odsCache.m_cacheName;
        }
        return this.m_connCacheName;
    }

    public synchronized void setConnectionCacheProperties(Properties properties) throws SQLException {
        if (this.m_connCachingEnabled) {
            this.m_connCacheProperties = properties;
        }
    }

    public Properties getConnectionCacheProperties() throws SQLException {
        if (this.m_connCachingEnabled && this.m_odsCache != null) {
            return this.m_odsCache.getConnectionCacheProperties();
        }
        return this.m_connCacheProperties;
    }

    public synchronized void setFastConnectionFailoverEnabled(boolean bl) throws SQLException {
        if (this.m_connCachingEnabled && !this.m_fastConnFailover) {
            this.m_fastConnFailover = bl;
        } else {
            DatabaseError.throwSqlException(137);
        }
    }

    public boolean getFastConnectionFailoverEnabled() throws SQLException {
        return this.m_fastConnFailover;
    }

    public synchronized int getLoginTimeout() {
        return this.m_loginTimeout;
    }

    public synchronized void setLoginTimeout(int n) {
        this.m_loginTimeout = n;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) {
        this.m_pw = printWriter;
        OracleLog.setLogWriter(printWriter);
    }

    public synchronized PrintWriter getLogWriter() {
        return this.m_pw;
    }

    public synchronized void setTNSEntryName(String string) {
        this.m_tnsentry = string;
    }

    public synchronized String getTNSEntryName() {
        return this.m_tnsentry;
    }

    public synchronized void setDataSourceName(String string) {
        this.m_dataSourceName = string;
    }

    public synchronized String getDataSourceName() {
        return this.m_dataSourceName;
    }

    public synchronized String getDatabaseName() {
        return this.m_databaseName;
    }

    public synchronized void setDatabaseName(String string) {
        this.m_databaseName = string;
    }

    public synchronized void setServiceName(String string) {
        this.m_serviceName = string;
    }

    public synchronized String getServiceName() {
        return this.m_serviceName;
    }

    public synchronized void setServerName(String string) {
        this.m_serverName = string;
    }

    public synchronized String getServerName() {
        return this.m_serverName;
    }

    public synchronized void setURL(String string) {
        this.m_url = string;
        if (this.m_url != null) {
            this.m_url_explicit = true;
        }
    }

    public synchronized String getURL() throws SQLException {
        if (!this.m_url_explicit) {
            this.makeURL();
        }
        return this.m_url;
    }

    public synchronized void setUser(String string) {
        this.m_user = string;
    }

    public String getUser() {
        return this.m_user;
    }

    public synchronized void setPassword(String string) {
        this.m_password = string;
    }

    protected String getPassword() {
        return this.m_password;
    }

    public synchronized String getDescription() {
        return this.m_description;
    }

    public synchronized void setDescription(String string) {
        this.m_description = string;
    }

    public synchronized String getDriverType() {
        return this.m_driverType;
    }

    public synchronized void setDriverType(String string) {
        this.m_driverType = string;
    }

    public synchronized String getNetworkProtocol() {
        return this.m_networkProtocol;
    }

    public synchronized void setNetworkProtocol(String string) {
        this.m_networkProtocol = string;
    }

    public synchronized void setPortNumber(int n) {
        this.m_portNumber = n;
    }

    public synchronized int getPortNumber() {
        return this.m_portNumber;
    }

    public synchronized Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        this.addRefProperties(reference);
        return reference;
    }

    protected void addRefProperties(Reference reference) {
        if (this.m_url != null) {
            reference.add(new StringRefAddr("url", this.m_url));
        }
        if (this.m_user != null) {
            reference.add(new StringRefAddr("userName", this.m_user));
        }
        if (this.m_password != null) {
            reference.add(new StringRefAddr("passWord", this.m_password));
        }
        if (this.m_description != null) {
            reference.add(new StringRefAddr("description", this.m_description));
        }
        if (this.m_driverType != null) {
            reference.add(new StringRefAddr("driverType", this.m_driverType));
        }
        if (this.m_serverName != null) {
            reference.add(new StringRefAddr("serverName", this.m_serverName));
        }
        if (this.m_databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.m_databaseName));
        }
        if (this.m_serviceName != null) {
            reference.add(new StringRefAddr("serviceName", this.m_serviceName));
        }
        if (this.m_networkProtocol != null) {
            reference.add(new StringRefAddr("networkProtocol", this.m_networkProtocol));
        }
        if (this.m_portNumber != 0) {
            reference.add(new StringRefAddr("portNumber", Integer.toString(this.m_portNumber)));
        }
        if (this.m_tnsentry != null) {
            reference.add(new StringRefAddr("tnsentryname", this.m_tnsentry));
        }
        if (this.m_maxStatements != 0) {
            reference.add(new StringRefAddr("maxStatements", Integer.toString(this.m_maxStatements)));
        }
        if (this.m_implicitCachingEnabled) {
            reference.add(new StringRefAddr("implicitCachingEnabled", "true"));
        }
        if (this.m_explicitCachingEnabled) {
            reference.add(new StringRefAddr("explicitCachingEnabled", "true"));
        }
        if (this.m_connCachingEnabled) {
            reference.add(new StringRefAddr("connectionCachingEnabled", "true"));
        }
        if (this.m_connCacheName != null) {
            reference.add(new StringRefAddr("connectionCacheName", this.m_connCacheName));
        }
        if (this.m_connCacheProperties != null) {
            reference.add(new StringRefAddr("connectionCacheProperties", this.m_connCacheProperties.toString()));
        }
        if (this.m_fastConnFailover) {
            reference.add(new StringRefAddr("fastConnectionFailoverEnabled", "true"));
        }
    }

    void makeURL() throws SQLException {
        if (this.m_url_explicit) {
            return;
        }
        if (this.m_driverType == null || !this.m_driverType.equals("oci8") && !this.m_driverType.equals("oci") && !this.m_driverType.equals("thin") && !this.m_driverType.equals("kprb")) {
            DatabaseError.check_error(67, "OracleDataSource.makeURL");
        }
        if (this.m_driverType.equals("kprb")) {
            this.m_use_defConn = true;
            this.m_url = "jdbc:oracle:kprb:@";
            return;
        }
        if ((this.m_driverType.equals("oci8") || this.m_driverType.equals("oci")) && this.m_networkProtocol != null && this.m_networkProtocol.equals("ipc")) {
            this.m_url = "jdbc:oracle:oci:@";
            return;
        }
        if (this.m_tnsentry != null) {
            this.m_url = "jdbc:oracle:" + this.m_driverType + ":@" + this.m_tnsentry;
            return;
        }
        if (this.m_serviceName != null) {
            this.m_url = "jdbc:oracle:" + this.m_driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.m_networkProtocol + ")(PORT=" + this.m_portNumber + ")(HOST=" + this.m_serverName + "))(CONNECT_DATA=(SERVICE_NAME=" + this.m_serviceName + ")))";
        } else {
            this.m_url = "jdbc:oracle:" + this.m_driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.m_networkProtocol + ")(PORT=" + this.m_portNumber + ")(HOST=" + this.m_serverName + "))(CONNECT_DATA=(SID=" + this.m_databaseName + ")))";
            DatabaseError.addSqlWarning(null, new SQLWarning("URL with SID jdbc:subprotocol:@host:port:sid will be deprecated in 10i\nPlease use URL with SERVICE_NAME as jdbc:subprotocol:@//host:port/service_name"));
            if (this.m_fastConnFailover) {
                DatabaseError.check_error(67, "OracleDataSource.makeURL");
            }
        }
    }

    protected void trace(String string) {
        if (this.m_pw != null) {
            OracleLog.print(this, 1, 512, 32, "OracleDataSource.trace(s): m_pw is not null");
        }
    }

    protected void copy(OracleDataSource oracleDataSource) throws SQLException {
        oracleDataSource.setUser(this.m_user);
        oracleDataSource.setPassword(this.m_password);
        oracleDataSource.setTNSEntryName(this.m_tnsentry);
        this.makeURL();
        oracleDataSource.setURL(this.m_url);
    }

    public void setMaxStatements(int n) throws SQLException {
        this.m_maxStatements = n;
    }

    public int getMaxStatements() throws SQLException {
        return this.m_maxStatements;
    }

    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        this.m_implicitCachingEnabled = bl;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.m_implicitCachingEnabled;
    }

    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        this.m_explicitCachingEnabled = bl;
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.m_explicitCachingEnabled;
    }

    public void setConnectionProperties(Properties properties) throws SQLException {
        this.m_connectionProperties = properties;
    }

    public Properties getConnectionProperties() throws SQLException {
        return this.m_connectionProperties;
    }
}

