/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.sql.PooledConnection;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.StateIntf;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleConnectionCacheEntry;
import oracle.jdbc.pool.OracleConnectionCacheEventListener;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleImplicitConnectionCacheThread;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.client.OracleXADataSource;

class OracleImplicitConnectionCache {
    protected OracleDataSource m_cacheEnabledDS = null;
    protected String m_cacheName = null;
    protected OracleConnectionPoolDataSource m_cpds = null;
    protected boolean m_FCFEnabled = false;
    protected String m_defaultUser = null;
    protected String m_defaultPassword = null;
    protected static final int DEFAULT_MIN_LIMIT = 0;
    protected static final int DEFAULT_MAX_LIMIT = Integer.MAX_VALUE;
    protected static final int DEFAULT_INITIAL_LIMIT = 0;
    protected static final int DEFAULT_MAX_STATEMENTS_LIMIT = 0;
    protected static final int DEFAULT_INACTIVITY_TIMEOUT = 0;
    protected static final int DEFAULT_TIMETOLIVE_TIMEOUT = 0;
    protected static final int DEFAULT_ABANDONED_CONN_TIMEOUT = 0;
    protected static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 0;
    protected static final String DEFAULT_ATTRIBUTE_WEIGHT = "0";
    protected static final int DEFAULT_LOWER_THRESHOLD_LIMIT = 20;
    protected static final int DEFAULT_PROPERTY_CHECK_INTERVAL = 900;
    protected static final int CLOSE_AND_REMOVE_ALL_CONNECTIONS = 1;
    protected static final int CLOSE_AND_REMOVE_FAILOVER_CONNECTIONS = 2;
    protected static final int PROCESS_INACTIVITY_TIMEOUT = 4;
    protected static final int CLOSE_AND_REMOVE_N_CONNECTIONS = 8;
    protected static final int DISABLE_STATEMENT_CACHING = 16;
    protected static final int RESET_STATEMENT_CACHE_SIZE = 18;
    private static final String ATTRKEY_DELIM = "0xffff";
    protected int m_cacheMinLimit = 0;
    protected int m_cacheMaxLimit = Integer.MAX_VALUE;
    protected int m_cacheInitialLimit = 0;
    protected int m_cacheMaxStatementsLimit = 0;
    protected Properties m_cacheAttributeWeights = null;
    protected int m_cacheInactivityTimeout = 0;
    protected int m_cacheTimeToLiveTimeout = 0;
    protected int m_cacheAbandonedConnectionTimeout = 0;
    protected int m_cacheLowerThresholdLimit = 20;
    protected int m_cachePropertyCheckInterval = 900;
    protected boolean m_cacheClosestConnectionMatch = false;
    protected boolean m_cacheValidateConnection = false;
    protected int m_cacheConnectionWaitTimeout = 0;
    static final String m_minLimit = "MinLimit";
    static final String m_maxLimit = "MaxLimit";
    static final String m_initialLimit = "InitialLimit";
    static final String m_maxStmtsLimit = "MaxStatementsLimit";
    static final String m_attributeWeights = "AttributeWeights";
    static final String m_inactivityTimeout = "InactivityTimeout";
    static final String m_ttlTimeout = "TimeToLiveTimeout";
    static final String m_abandonedConnTimeout = "AbandonedConnectionTimeout";
    static final String m_lwrThresholdLimit = "LowerThresholdLimit";
    static final String m_propertyCheckInterval = "PropertyCheckInterval";
    static final String m_validateConnection = "ValidateConnection";
    static final String m_closestConnMatch = "ClosestConnectionMatch";
    static final String m_connWaitTimeout = "ConnectionWaitTimeout";
    protected OracleConnectionCacheManager m_occm = null;
    protected boolean m_disableConnectionRequest = false;
    protected OracleImplicitConnectionCacheThread m_timeoutThread = null;
    protected int m_connectionsToRemove = 0;
    private HashMap m_userMap = null;
    Vector m_checkedOutConnectionList = null;
    int m_cacheSize = 0;
    protected static final String EVENT_DELIMITER = " ";
    protected boolean m_isEntireServiceDownProcessed = false;
    protected int m_defaultUserPreFailureSize = 0;
    protected String m_dataSourceServiceName = null;
    protected OracleFailoverWorkerThread m_failoverWorkerThread = null;
    protected Random rand = null;
    protected int m_downEventCount = 0;
    protected int m_upEventCount = 0;
    protected int connectionClosedCount = 0;
    protected int connectionCreatedCount = 0;
    static final String dms_size_name = "CacheSize";
    static final String dms_size_description = "number of physical connections in the cache";
    static final String dms_size_units = "connections";
    static final String dms_freeSize_name = "CacheFreeSize";
    static final String dms_freeSize_description = "number of additional connections that can be added to the cache before it reaches capacity";
    static final String dms_freeSize_units = "connections";
    static final String dms_hitCount_name = "CacheHit";
    static final String dms_hitCount_description = "a  connection was found in the cache";
    static final String dms_missCount_name = "CacheMiss";
    static final String dms_missCount_description = "no connection was found in the cache";
    static final String dms_getConnection_name = "CacheGetConnection";
    static final String dms_getConnection_description = "time required to get a connection";
    NounIntf m_dmsParent = null;
    StateIntf m_dmsSize = null;
    StateIntf m_dmsFreeSize = null;
    EventIntf m_dmsHitCount = null;
    EventIntf m_dmsMissCount = null;
    PhaseEventIntf m_dmsGetCachedConn = null;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    protected static String dms_data_source_type() {
        return "JDBC_ImplicitConnectionCache";
    }

    OracleImplicitConnectionCache(OracleDataSource oracleDataSource, Properties properties) throws SQLException {
        this.m_cacheEnabledDS = oracleDataSource;
        this.initializeConnectionCache();
        this.setConnectionCacheProperties(properties);
        this.createDMSSensors();
        this.defaultUserPrePopulateCache(this.m_cacheInitialLimit);
    }

    private void defaultUserPrePopulateCache(int n) throws SQLException {
        if (n > 0) {
            String string = this.m_defaultUser;
            String string2 = this.m_defaultPassword;
            this.validateUser(string, string2);
            PooledConnection pooledConnection = null;
            for (int i = 0; i < n; ++i) {
                if (this.getTotalCachedConnections() >= this.m_cacheMaxLimit || (pooledConnection = this.makeCacheConnection(string, string2)) == null) continue;
                this.storeCacheConnection(string, null, pooledConnection);
            }
        }
    }

    protected void initializeConnectionCache() throws SQLException {
        this.m_userMap = new HashMap();
        this.m_checkedOutConnectionList = new Vector();
        if (this.m_occm == null) {
            this.m_occm = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
        }
        this.m_defaultUser = this.m_cacheEnabledDS.m_user;
        this.m_defaultPassword = this.m_cacheEnabledDS.m_password;
        this.m_FCFEnabled = this.m_cacheEnabledDS.getFastConnectionFailoverEnabled();
        if (this.m_FCFEnabled) {
            this.rand = new Random();
        }
    }

    private void validateUser(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            DatabaseError.throwSqlException(79);
        }
    }

    protected void createDMSSensors() {
        this.m_dmsParent = DMSFactory.createNoun(null, "JDBC", null);
        this.m_dmsParent = DMSFactory.createNoun(this.m_dmsParent, this.m_cacheEnabledDS.m_dataSourceName, "JDBC_ConnectionSource");
        this.m_dmsSize = DMSFactory.createState(this.m_dmsParent, dms_size_name, "connections", dms_size_description, this.m_cacheSize);
        this.m_dmsSize.deriveMetric(14);
        this.m_dmsFreeSize = DMSFactory.createState(this.m_dmsParent, dms_freeSize_name, "connections", dms_freeSize_description, this.m_cacheMaxLimit - this.m_cacheSize);
        this.m_dmsFreeSize.deriveMetric(14);
        this.m_dmsHitCount = DMSFactory.createEvent(this.m_dmsParent, dms_hitCount_name, dms_hitCount_description);
        this.m_dmsMissCount = DMSFactory.createEvent(this.m_dmsParent, dms_missCount_name, dms_missCount_description);
        this.m_dmsGetCachedConn = DMSFactory.createPhaseEvent(this.m_dmsParent, dms_getConnection_name, dms_getConnection_description);
        this.m_dmsGetCachedConn.deriveMetric(511);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Connection getConnection(String string, String string2, Properties properties) throws SQLException {
        long l;
        block13: {
            Connection connection;
            l = this.m_dmsGetCachedConn.start();
            try {
                Connection connection2;
                if (this.m_disableConnectionRequest) {
                    DatabaseError.throwSqlException(142);
                }
                this.validateUser(string, string2);
                string = string.toLowerCase();
                string2 = string2.toLowerCase();
                PooledConnection pooledConnection = null;
                if (this.getNumberOfCheckedOutConnections() < this.m_cacheMaxLimit) {
                    pooledConnection = this.getCacheConnection(string, string2, properties);
                }
                if (pooledConnection == null) {
                    this.processConnectionCacheCallback();
                    if (this.m_cacheSize > 0) {
                        pooledConnection = this.getCacheConnection(string, string2, properties);
                    }
                    if (pooledConnection == null && this.m_cacheConnectionWaitTimeout > 0) {
                        long l2 = (long)this.m_cacheConnectionWaitTimeout * 1000L;
                        long l3 = System.currentTimeMillis();
                        long l4 = 0L;
                        do {
                            this.processConnectionWaitTimeout(l2);
                            if (this.m_cacheSize > 0) {
                                pooledConnection = this.getCacheConnection(string, string2, properties);
                            }
                            l4 = System.currentTimeMillis();
                            l3 = l4;
                        } while (pooledConnection == null && (l2 -= System.currentTimeMillis() - l3) > 0L);
                    }
                }
                if (pooledConnection == null || ((OraclePooledConnection)pooledConnection).m_physicalConn == null || (connection2 = pooledConnection.getConnection()) == null) break block13;
                if (this.m_cacheValidateConnection && this.testDatabaseConnection((OracleConnection)connection2) != 0) {
                    ((OracleConnection)connection2).close(4096);
                    DatabaseError.throwSqlException(143);
                }
                if (this.m_cacheAbandonedConnectionTimeout > 0) {
                    ((OracleConnection)connection2).setAbandonedTimeoutEnabled(true);
                }
                if (this.m_cacheTimeToLiveTimeout > 0) {
                    ((OracleConnection)connection2).setStartTime(System.currentTimeMillis());
                }
                this.m_checkedOutConnectionList.addElement(pooledConnection);
                connection = connection2;
                Object var14_11 = null;
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                this.m_dmsSize.update(this.m_cacheSize);
                this.m_dmsFreeSize.update(this.m_cacheMaxLimit - this.m_cacheSize);
                this.m_dmsGetCachedConn.stop(l);
                throw throwable;
            }
            this.m_dmsSize.update(this.m_cacheSize);
            this.m_dmsFreeSize.update(this.m_cacheMaxLimit - this.m_cacheSize);
            this.m_dmsGetCachedConn.stop(l);
            return connection;
        }
        Object var14_12 = null;
        this.m_dmsSize.update(this.m_cacheSize);
        this.m_dmsFreeSize.update(this.m_cacheMaxLimit - this.m_cacheSize);
        this.m_dmsGetCachedConn.stop(l);
        return null;
    }

    private PooledConnection getCacheConnection(String string, String string2, Properties properties) throws SQLException {
        OraclePooledConnection oraclePooledConnection = this.retrieveCacheConnection(string, string2, properties);
        if (oraclePooledConnection == null && this.getTotalCachedConnections() < this.m_cacheMaxLimit) {
            oraclePooledConnection = (OraclePooledConnection)this.makeCacheConnection(string, string2);
            if (properties != null && !properties.isEmpty()) {
                this.setUnMatchedAttributes(properties, oraclePooledConnection);
            }
            this.m_dmsMissCount.occurred();
        } else {
            this.m_dmsHitCount.occurred();
        }
        return oraclePooledConnection;
    }

    protected int getTotalCachedConnections() throws SQLException {
        return this.m_cacheSize + this.getNumberOfCheckedOutConnections();
    }

    protected int getNumberOfCheckedOutConnections() {
        return this.m_checkedOutConnectionList.size();
    }

    private synchronized OraclePooledConnection retrieveCacheConnection(String string, String string2, Properties properties) throws SQLException {
        PooledConnection pooledConnection = null;
        OracleConnectionCacheEntry oracleConnectionCacheEntry = (OracleConnectionCacheEntry)this.m_userMap.get(string + string2.toUpperCase());
        if (oracleConnectionCacheEntry != null) {
            if (properties == null || properties != null && properties.isEmpty()) {
                if (oracleConnectionCacheEntry.userConnList != null) {
                    pooledConnection = this.retrieveFromConnectionList(oracleConnectionCacheEntry.userConnList);
                }
            } else if (oracleConnectionCacheEntry.attrConnMap != null) {
                String string3 = this.buildAttrKey(properties);
                Vector vector = (Vector)oracleConnectionCacheEntry.attrConnMap.get(string3);
                if (vector != null) {
                    pooledConnection = this.retrieveFromConnectionList(vector);
                }
                if (pooledConnection == null && this.m_cacheClosestConnectionMatch) {
                    pooledConnection = this.retrieveClosestConnectionMatch(oracleConnectionCacheEntry.attrConnMap, properties);
                }
                if (pooledConnection == null && oracleConnectionCacheEntry.userConnList != null) {
                    pooledConnection = this.retrieveFromConnectionList(oracleConnectionCacheEntry.userConnList);
                }
            }
        }
        if (pooledConnection != null) {
            if (properties != null && !properties.isEmpty()) {
                this.setUnMatchedAttributes(properties, (OraclePooledConnection)pooledConnection);
            }
            --this.m_cacheSize;
            this.m_dmsSize.update(this.m_cacheSize);
            this.m_dmsFreeSize.update(this.m_cacheMaxLimit - this.m_cacheSize);
        }
        return (OraclePooledConnection)pooledConnection;
    }

    private PooledConnection retrieveClosestConnectionMatch(HashMap hashMap, Properties properties) throws SQLException {
        OraclePooledConnection oraclePooledConnection = null;
        int n = properties.size();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        OraclePooledConnection oraclePooledConnection2 = null;
        if (this.m_cacheAttributeWeights != null) {
            n2 = this.getAttributesWeightCount(properties, null);
        }
        if (hashMap != null && !hashMap.isEmpty()) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Vector vector = (Vector)entry.getValue();
                Object[] objectArray = vector.toArray();
                int n7 = vector.size();
                for (int i = 0; i < n7; ++i) {
                    oraclePooledConnection = (OraclePooledConnection)objectArray[i];
                    if (oraclePooledConnection.cachedConnectionAttributes == null || oraclePooledConnection.cachedConnectionAttributes.isEmpty() || oraclePooledConnection.cachedConnectionAttributes.size() > n) continue;
                    if (n2 > 0) {
                        n4 = this.getAttributesWeightCount(properties, oraclePooledConnection.cachedConnectionAttributes);
                        if (n4 <= n3) continue;
                        oraclePooledConnection2 = oraclePooledConnection;
                        n3 = n4;
                        continue;
                    }
                    n6 = this.getAttributesMatchCount(properties, oraclePooledConnection.cachedConnectionAttributes);
                    if (n6 <= n5) continue;
                    oraclePooledConnection2 = oraclePooledConnection;
                    n5 = n6;
                }
            }
        }
        return oraclePooledConnection2;
    }

    private int getAttributesMatchCount(Properties properties, Properties properties2) throws SQLException {
        int n = 0;
        Map.Entry<Object, Object> entry = null;
        Object object = null;
        Object object2 = null;
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            object = entry.getKey();
            object2 = entry.getValue();
            if (!properties2.containsKey(object) || !object2.equals(properties2.get(object))) continue;
            ++n;
        }
        return n;
    }

    private int getAttributesWeightCount(Properties properties, Properties properties2) throws SQLException {
        Map.Entry<Object, Object> entry = null;
        Object object = null;
        Object object2 = null;
        int n = 0;
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            object = entry.getKey();
            object2 = entry.getValue();
            if (properties2 == null) {
                if (!this.m_cacheAttributeWeights.containsKey(object)) continue;
                n += Integer.parseInt((String)this.m_cacheAttributeWeights.get(object));
                continue;
            }
            if (!properties2.containsKey(object) || !object2.equals(properties2.get(object))) continue;
            if (this.m_cacheAttributeWeights.containsKey(object)) {
                n += Integer.parseInt((String)this.m_cacheAttributeWeights.get(object));
                continue;
            }
            ++n;
        }
        return n;
    }

    private void setUnMatchedAttributes(Properties properties, OraclePooledConnection oraclePooledConnection) throws SQLException {
        if (oraclePooledConnection.unMatchedCachedConnAttr == null) {
            oraclePooledConnection.unMatchedCachedConnAttr = new Properties();
        } else {
            oraclePooledConnection.unMatchedCachedConnAttr.clear();
        }
        if (!this.m_cacheClosestConnectionMatch) {
            oraclePooledConnection.unMatchedCachedConnAttr.putAll((Map<?, ?>)properties);
        } else {
            Properties properties2 = oraclePooledConnection.cachedConnectionAttributes;
            Map.Entry<Object, Object> entry = null;
            Object object = null;
            Object object2 = null;
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                object = entry.getKey();
                object2 = entry.getValue();
                if (properties2.containsKey(object) || object2.equals(properties2.get(object))) continue;
                oraclePooledConnection.unMatchedCachedConnAttr.put(object, object2);
            }
        }
    }

    private PooledConnection retrieveFromConnectionList(Vector vector) throws SQLException {
        if (vector.isEmpty()) {
            return null;
        }
        PooledConnection pooledConnection = null;
        if (this.m_FCFEnabled) {
            int n = vector.size();
            int n2 = this.rand.nextInt(n);
            for (int i = 0; i < n; ++i) {
                pooledConnection = (PooledConnection)vector.get((n2++ + n) % n);
                if (((OraclePooledConnection)pooledConnection).m_connectionMarkedDown) continue;
                vector.remove(pooledConnection);
                break;
            }
        } else {
            pooledConnection = (PooledConnection)vector.remove(0);
        }
        return pooledConnection;
    }

    private void removeCacheConnection(PooledConnection pooledConnection) throws SQLException {
        boolean bl = false;
        String string = ((OraclePooledConnection)pooledConnection).m_pcUser;
        OracleConnectionCacheEntry oracleConnectionCacheEntry = ((OraclePooledConnection)pooledConnection).removeFromImplictCache(this.m_userMap);
        if (oracleConnectionCacheEntry != null) {
            String string2;
            Vector vector;
            Properties properties = ((OraclePooledConnection)pooledConnection).cachedConnectionAttributes;
            if (properties == null || properties != null && properties.isEmpty()) {
                if (oracleConnectionCacheEntry.userConnList != null) {
                    bl = oracleConnectionCacheEntry.userConnList.removeElement(pooledConnection);
                }
            } else if (oracleConnectionCacheEntry.attrConnMap != null && (vector = (Vector)oracleConnectionCacheEntry.attrConnMap.get(string2 = this.buildAttrKey(properties))) != null) {
                if (((OraclePooledConnection)pooledConnection).unMatchedCachedConnAttr != null) {
                    ((OraclePooledConnection)pooledConnection).unMatchedCachedConnAttr.clear();
                    ((OraclePooledConnection)pooledConnection).unMatchedCachedConnAttr = null;
                }
                if (((OraclePooledConnection)pooledConnection).cachedConnectionAttributes != null) {
                    ((OraclePooledConnection)pooledConnection).cachedConnectionAttributes.clear();
                    ((OraclePooledConnection)pooledConnection).cachedConnectionAttributes = null;
                }
                properties = null;
                bl = vector.removeElement(pooledConnection);
            }
        }
        if (bl) {
            --this.m_cacheSize;
            this.m_dmsSize.update(this.m_cacheSize);
            this.m_dmsFreeSize.update(this.m_cacheMaxLimit - this.m_cacheSize);
        }
    }

    protected synchronized void doForEveryCachedConnection(int n) throws SQLException {
        int n2 = 0;
        if (this.m_userMap != null && !this.m_userMap.isEmpty()) {
            Iterator iterator = this.m_userMap.entrySet().iterator();
            while (iterator.hasNext()) {
                OraclePooledConnection oraclePooledConnection;
                Object object;
                Object object2;
                Map.Entry entry = iterator.next();
                OracleConnectionCacheEntry oracleConnectionCacheEntry = (OracleConnectionCacheEntry)entry.getValue();
                if (oracleConnectionCacheEntry.userConnList != null && !oracleConnectionCacheEntry.userConnList.isEmpty()) {
                    object2 = oracleConnectionCacheEntry.userConnList;
                    object = ((Vector)object2).toArray();
                    for (int i = 0; i < ((Object[])object).length; ++i) {
                        oraclePooledConnection = (OraclePooledConnection)object[i];
                        if (oraclePooledConnection == null || !this.performPooledConnectionTask(oraclePooledConnection, n)) continue;
                        ++n2;
                    }
                }
                if (oracleConnectionCacheEntry.attrConnMap == null || oracleConnectionCacheEntry.attrConnMap.isEmpty()) continue;
                object2 = oracleConnectionCacheEntry.attrConnMap.entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    Vector vector = (Vector)object.getValue();
                    Object[] objectArray = vector.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        oraclePooledConnection = (OraclePooledConnection)objectArray[i];
                        if (oraclePooledConnection == null || !this.performPooledConnectionTask(oraclePooledConnection, n)) continue;
                        ++n2;
                    }
                }
                if (n != 1) continue;
                oracleConnectionCacheEntry.attrConnMap.clear();
            }
            if (n == 1) {
                this.m_userMap.clear();
                this.m_cacheSize = 0;
                this.m_dmsSize.update(this.m_cacheSize);
                this.m_dmsFreeSize.update(this.m_cacheMaxLimit - this.m_cacheSize);
            } else if (n2 > 0) {
                this.defaultUserPrePopulateCache(n2);
            }
        }
    }

    private boolean performPooledConnectionTask(OraclePooledConnection oraclePooledConnection, int n) throws SQLException {
        boolean bl = false;
        switch (n) {
            case 2: {
                if (!oraclePooledConnection.m_connectionMarkedDown) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                break;
            }
            case 8: {
                if (this.m_connectionsToRemove <= 0) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                --this.m_connectionsToRemove;
                break;
            }
            case 4096: {
                Connection connection = oraclePooledConnection.getLogicalHandle();
                if (connection == null && (connection = oraclePooledConnection.getPhysicalHandle()) == null || this.testDatabaseConnection((OracleConnection)connection) == 0) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                bl = true;
                break;
            }
            case 8192: {
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                bl = true;
                break;
            }
            case 1: {
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                break;
            }
            case 4: {
                this.processInactivityTimeout(oraclePooledConnection);
                break;
            }
            case 16: {
                this.setStatementCaching(oraclePooledConnection, this.m_cacheMaxStatementsLimit, false);
                break;
            }
            case 18: {
                this.setStatementCaching(oraclePooledConnection, this.m_cacheMaxStatementsLimit, true);
                break;
            }
        }
        return bl;
    }

    protected synchronized void doForEveryCheckedOutConnection(int n) throws SQLException {
        if (n == 1) {
            int n2 = this.m_checkedOutConnectionList.size();
            for (int i = 0; i < n2; ++i) {
                this.closeCheckedOutConnection((OraclePooledConnection)this.m_checkedOutConnectionList.get(i), false);
            }
            this.m_checkedOutConnectionList.removeAllElements();
        }
    }

    protected void closeCheckedOutConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        if (oraclePooledConnection != null) {
            OracleConnection oracleConnection = (OracleConnection)oraclePooledConnection.getLogicalHandle();
            try {
                if (!oracleConnection.getAutoCommit() && !oraclePooledConnection.isHostDown) {
                    oracleConnection.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (bl) {
                try {
                    oracleConnection.close();
                }
                catch (SQLException sQLException) {}
            } else {
                try {
                    ++this.connectionClosedCount;
                    oraclePooledConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized void storeCacheConnection(String string, Properties properties, PooledConnection pooledConnection) throws SQLException {
        OracleConnectionCacheEntry oracleConnectionCacheEntry;
        if (pooledConnection == null || ((OraclePooledConnection)pooledConnection).m_physicalConn == null) {
            return;
        }
        if (this.m_cacheInactivityTimeout > 0) {
            ((OraclePooledConnection)pooledConnection).setLastAccessedTime(System.currentTimeMillis());
        }
        if (((OraclePooledConnection)pooledConnection).unMatchedCachedConnAttr != null) {
            ((OraclePooledConnection)pooledConnection).unMatchedCachedConnAttr.clear();
            ((OraclePooledConnection)pooledConnection).unMatchedCachedConnAttr = null;
        }
        if (!string.startsWith("\"")) {
            string = string.toLowerCase();
        }
        if ((oracleConnectionCacheEntry = ((OraclePooledConnection)pooledConnection).removeFromImplictCache(this.m_userMap)) != null) {
            if (properties == null || properties != null && properties.isEmpty()) {
                if (oracleConnectionCacheEntry.userConnList == null) {
                    oracleConnectionCacheEntry.userConnList = new Vector();
                }
                oracleConnectionCacheEntry.userConnList.add(pooledConnection);
            } else {
                String string2;
                Vector<PooledConnection> vector;
                ((OraclePooledConnection)pooledConnection).cachedConnectionAttributes = properties;
                if (oracleConnectionCacheEntry.attrConnMap == null) {
                    oracleConnectionCacheEntry.attrConnMap = new HashMap();
                }
                if ((vector = (Vector<PooledConnection>)oracleConnectionCacheEntry.attrConnMap.get(string2 = this.buildAttrKey(properties))) != null) {
                    vector.add(pooledConnection);
                } else {
                    vector = new Vector<PooledConnection>();
                    vector.add(pooledConnection);
                    oracleConnectionCacheEntry.attrConnMap.put(string2, vector);
                }
            }
        } else {
            oracleConnectionCacheEntry = new OracleConnectionCacheEntry();
            this.m_userMap.put(string, oracleConnectionCacheEntry);
            ((OraclePooledConnection)pooledConnection).addToImplicitCache(this.m_userMap, oracleConnectionCacheEntry);
            if (properties == null || properties != null && properties.isEmpty()) {
                Vector<PooledConnection> vector = new Vector<PooledConnection>();
                vector.add(pooledConnection);
                oracleConnectionCacheEntry.userConnList = vector;
            } else {
                String string3 = this.buildAttrKey(properties);
                ((OraclePooledConnection)pooledConnection).cachedConnectionAttributes = properties;
                HashMap hashMap = new HashMap();
                Vector<PooledConnection> vector = new Vector<PooledConnection>();
                vector.add(pooledConnection);
                hashMap.put(string3, vector);
                oracleConnectionCacheEntry.attrConnMap = hashMap;
            }
        }
        ++this.m_cacheSize;
        this.m_dmsSize.update(this.m_cacheSize);
        this.m_dmsFreeSize.update(this.m_cacheMaxLimit - this.m_cacheSize);
        if (this.m_cacheConnectionWaitTimeout > 0) {
            this.notify();
        }
    }

    private String buildAttrKey(Properties properties) throws SQLException {
        int n;
        int n2 = properties.keySet().size();
        Object[] objectArray = properties.keySet().toArray();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        while (bl) {
            bl = false;
            for (n = 0; n < n2 - 1; ++n) {
                if (((String)objectArray[n]).compareTo((String)objectArray[n + 1]) <= 0) continue;
                bl = true;
                Object object = objectArray[n];
                objectArray[n] = objectArray[n + 1];
                objectArray[n + 1] = object;
            }
        }
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(objectArray[n] + ATTRKEY_DELIM + properties.get(objectArray[n]));
        }
        return stringBuffer.toString();
    }

    protected PooledConnection makeCacheConnection(String string, String string2) throws SQLException {
        OraclePooledConnection oraclePooledConnection;
        if (this.m_cpds == null) {
            this.m_cpds = this.m_cacheEnabledDS instanceof OracleXADataSource ? new OracleXADataSource() : new OracleConnectionPoolDataSource();
            this.m_cacheEnabledDS.copy(this.m_cpds);
        }
        if ((oraclePooledConnection = (OraclePooledConnection)this.m_cpds.getPooledConnection(string, string2)) != null) {
            if (this.m_cacheMaxStatementsLimit > 0) {
                this.setStatementCaching(oraclePooledConnection, this.m_cacheMaxStatementsLimit, true);
            }
            oraclePooledConnection.registerImplicitCacheConnectionEventListener(new OracleConnectionCacheEventListener(this));
            oraclePooledConnection.cachedConnectionAttributes = new Properties();
            if (this.m_FCFEnabled) {
                this.initFailoverParameters(oraclePooledConnection);
            }
            ++this.connectionCreatedCount;
        }
        return oraclePooledConnection;
    }

    private void setStatementCaching(OraclePooledConnection oraclePooledConnection, int n, boolean bl) throws SQLException {
        if (n > 0) {
            oraclePooledConnection.setStatementCacheSize(n);
        }
        oraclePooledConnection.setImplicitCachingEnabled(bl);
        oraclePooledConnection.setExplicitCachingEnabled(bl);
    }

    protected synchronized void reusePooledConnection(PooledConnection pooledConnection) throws SQLException {
        if (pooledConnection != null && ((OraclePooledConnection)pooledConnection).m_physicalConn != null) {
            this.storeCacheConnection(((OraclePooledConnection)pooledConnection).m_pcUser, ((OraclePooledConnection)pooledConnection).cachedConnectionAttributes, pooledConnection);
            this.m_checkedOutConnectionList.removeElement(pooledConnection);
        }
    }

    protected void closePooledConnection(PooledConnection pooledConnection) throws SQLException {
        if (pooledConnection != null) {
            try {
                ++this.connectionClosedCount;
                pooledConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (((OraclePooledConnection)pooledConnection).m_closeOption == 4096) {
                this.m_checkedOutConnectionList.removeElement(pooledConnection);
            }
            pooledConnection = null;
        }
    }

    protected void refreshCacheConnections(int n) throws SQLException {
        this.doForEveryCachedConnection(n);
    }

    protected synchronized void reinitializeCacheConnections(Properties properties) throws SQLException {
        this.m_defaultUser = this.m_cacheEnabledDS.m_user;
        this.m_defaultPassword = this.m_cacheEnabledDS.m_password;
        this.m_FCFEnabled = this.m_cacheEnabledDS.getFastConnectionFailoverEnabled();
        this.cleanupTimeoutThread();
        this.doForEveryCheckedOutConnection(1);
        int n = this.m_cacheInitialLimit;
        int n2 = this.m_cacheMaxLimit;
        int n3 = this.m_cacheMaxStatementsLimit;
        this.setConnectionCacheProperties(properties);
        if (this.m_cacheInitialLimit > n) {
            int n4 = this.m_cacheInitialLimit - n;
            this.defaultUserPrePopulateCache(n4);
        }
        if (n2 != Integer.MAX_VALUE && this.m_cacheMaxLimit < n2 && this.m_cacheSize > this.m_cacheMaxLimit) {
            this.m_connectionsToRemove = this.m_cacheSize - this.m_cacheMaxLimit;
            this.doForEveryCachedConnection(8);
            this.m_connectionsToRemove = 0;
        }
        if (this.m_cacheMaxStatementsLimit != n3) {
            if (this.m_cacheMaxStatementsLimit == 0) {
                this.doForEveryCachedConnection(16);
            } else {
                this.doForEveryCachedConnection(18);
            }
        }
        this.m_dmsSize.update(this.m_cacheSize);
        this.m_dmsFreeSize.update(this.m_cacheMaxLimit - this.m_cacheSize);
    }

    protected synchronized void setConnectionCacheProperties(Properties properties) throws SQLException {
        try {
            if (properties != null) {
                Properties properties2;
                String string = null;
                string = properties.getProperty(m_minLimit);
                if (string != null && (this.m_cacheMinLimit = Integer.parseInt(string)) < 0) {
                    this.m_cacheMinLimit = 0;
                }
                if ((string = properties.getProperty(m_maxLimit)) != null && (this.m_cacheMaxLimit = Integer.parseInt(string)) < 0) {
                    this.m_cacheMaxLimit = Integer.MAX_VALUE;
                }
                if (this.m_cacheMaxLimit < this.m_cacheMinLimit) {
                    this.m_cacheMaxLimit = this.m_cacheMinLimit;
                }
                if ((string = properties.getProperty(m_initialLimit)) != null && (this.m_cacheInitialLimit = Integer.parseInt(string)) < 0) {
                    this.m_cacheInitialLimit = 0;
                }
                if ((string = properties.getProperty(m_maxStmtsLimit)) != null && (this.m_cacheMaxStatementsLimit = Integer.parseInt(string)) < 0) {
                    this.m_cacheMaxStatementsLimit = 0;
                }
                if ((properties2 = (Properties)properties.get(m_attributeWeights)) != null) {
                    Map.Entry<Object, Object> entry = null;
                    int n = 0;
                    Object object = null;
                    Iterator<Map.Entry<Object, Object>> iterator = properties2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        object = entry.getKey();
                        string = (String)properties2.get(object);
                        if (string == null || (n = Integer.parseInt(string)) >= 0) continue;
                        properties2.put(object, DEFAULT_ATTRIBUTE_WEIGHT);
                    }
                    if (this.m_cacheAttributeWeights == null) {
                        this.m_cacheAttributeWeights = new Properties();
                    }
                    this.m_cacheAttributeWeights.putAll((Map<?, ?>)properties2);
                }
                if ((string = properties.getProperty(m_inactivityTimeout)) != null && (this.m_cacheInactivityTimeout = Integer.parseInt(string)) < 0) {
                    this.m_cacheInactivityTimeout = 0;
                }
                if ((string = properties.getProperty(m_ttlTimeout)) != null && (this.m_cacheTimeToLiveTimeout = Integer.parseInt(string)) < 0) {
                    this.m_cacheTimeToLiveTimeout = 0;
                }
                if ((string = properties.getProperty(m_abandonedConnTimeout)) != null && (this.m_cacheAbandonedConnectionTimeout = Integer.parseInt(string)) < 0) {
                    this.m_cacheAbandonedConnectionTimeout = 0;
                }
                if ((string = properties.getProperty(m_lwrThresholdLimit)) != null) {
                    this.m_cacheLowerThresholdLimit = Integer.parseInt(string);
                    if (this.m_cacheLowerThresholdLimit < 0 || this.m_cacheLowerThresholdLimit > 100) {
                        this.m_cacheLowerThresholdLimit = 20;
                    }
                }
                if ((string = properties.getProperty(m_propertyCheckInterval)) != null && (this.m_cachePropertyCheckInterval = Integer.parseInt(string)) < 0) {
                    this.m_cachePropertyCheckInterval = 900;
                }
                if ((string = properties.getProperty(m_validateConnection)) != null) {
                    this.m_cacheValidateConnection = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty(m_closestConnMatch)) != null) {
                    this.m_cacheClosestConnectionMatch = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty(m_connWaitTimeout)) != null && (this.m_cacheConnectionWaitTimeout = Integer.parseInt(string)) < 0) {
                    this.m_cacheConnectionWaitTimeout = 0;
                }
            } else {
                this.m_cacheMinLimit = 0;
                this.m_cacheMaxLimit = Integer.MAX_VALUE;
                this.m_cacheInitialLimit = 0;
                this.m_cacheMaxStatementsLimit = 0;
                this.m_cacheAttributeWeights = null;
                this.m_cacheInactivityTimeout = 0;
                this.m_cacheTimeToLiveTimeout = 0;
                this.m_cacheAbandonedConnectionTimeout = 0;
                this.m_cacheLowerThresholdLimit = 20;
                this.m_cachePropertyCheckInterval = 900;
                this.m_cacheClosestConnectionMatch = false;
                this.m_cacheValidateConnection = false;
                this.m_cacheConnectionWaitTimeout = 0;
            }
            if (this.m_cacheInactivityTimeout > 0 || this.m_cacheTimeToLiveTimeout > 0 || this.m_cacheAbandonedConnectionTimeout > 0) {
                if (this.m_timeoutThread == null) {
                    this.m_timeoutThread = new OracleImplicitConnectionCacheThread(this);
                }
                this.m_occm.checkAndStartThread(this.m_timeoutThread);
            }
        }
        catch (NumberFormatException numberFormatException) {
            DatabaseError.throwSqlException(139);
        }
    }

    protected Properties getConnectionCacheProperties() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty(m_minLimit, String.valueOf(this.m_cacheMinLimit));
        properties.setProperty(m_maxLimit, String.valueOf(this.m_cacheMaxLimit));
        properties.setProperty(m_initialLimit, String.valueOf(this.m_cacheInitialLimit));
        properties.setProperty(m_maxStmtsLimit, String.valueOf(this.m_cacheMaxStatementsLimit));
        if (this.m_cacheAttributeWeights != null) {
            properties.put(m_attributeWeights, this.m_cacheAttributeWeights);
        } else {
            properties.setProperty(m_attributeWeights, "NULL");
        }
        properties.setProperty(m_inactivityTimeout, String.valueOf(this.m_cacheInactivityTimeout));
        properties.setProperty(m_ttlTimeout, String.valueOf(this.m_cacheTimeToLiveTimeout));
        properties.setProperty(m_abandonedConnTimeout, String.valueOf(this.m_cacheAbandonedConnectionTimeout));
        properties.setProperty(m_lwrThresholdLimit, String.valueOf(this.m_cacheLowerThresholdLimit));
        properties.setProperty(m_propertyCheckInterval, String.valueOf(this.m_cachePropertyCheckInterval));
        properties.setProperty(m_connWaitTimeout, String.valueOf(this.m_cacheConnectionWaitTimeout));
        properties.setProperty(m_validateConnection, String.valueOf(this.m_cacheValidateConnection));
        properties.setProperty(m_closestConnMatch, String.valueOf(this.m_cacheClosestConnectionMatch));
        return properties;
    }

    protected int testDatabaseConnection(OracleConnection oracleConnection) throws SQLException {
        return oracleConnection.pingDatabase(0);
    }

    protected synchronized void closeConnectionCache() throws SQLException {
        this.cleanupTimeoutThread();
        this.purgeCacheConnections(true);
        this.m_dmsParent.destroy();
        this.m_dmsParent = null;
        this.m_cpds = null;
        this.m_cacheEnabledDS = null;
        this.m_checkedOutConnectionList = null;
        this.m_userMap = null;
        this.m_occm = null;
    }

    protected synchronized void disableConnectionCache() throws SQLException {
        this.m_disableConnectionRequest = true;
    }

    protected synchronized void enableConnectionCache() throws SQLException {
        this.m_disableConnectionRequest = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initFailoverParameters(OraclePooledConnection oraclePooledConnection) throws SQLException {
        OracleStatement oracleStatement;
        block11: {
            oracleStatement = null;
            ResultSet resultSet = null;
            String string = "select sys_context('userenv', 'instance_name'),sys_context('userenv', 'server_host'),sys_context('userenv', 'service_name'),sys_context('userenv', 'db_unique_name') from dual";
            try {
                try {
                    oracleStatement = (OracleStatement)oraclePooledConnection.getPhysicalHandle().createStatement();
                    resultSet = oracleStatement.executeQuery(string);
                    while (resultSet.next()) {
                        String string2 = null;
                        string2 = resultSet.getString(1);
                        if (string2 != null) {
                            oraclePooledConnection.m_dataSourceInstanceName = string2.trim();
                        }
                        if ((string2 = resultSet.getString(2)) != null) {
                            oraclePooledConnection.m_dataSourceHostName = string2.trim();
                        }
                        if ((string2 = resultSet.getString(3)) != null) {
                            this.m_dataSourceServiceName = string2.trim();
                        }
                        if ((string2 = resultSet.getString(4)) == null) continue;
                        oraclePooledConnection.m_dataSourceDbUniqName = string2.trim();
                    }
                    Object var7_7 = null;
                    if (resultSet == null) break block11;
                }
                catch (SQLException sQLException) {
                    Object var7_8 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (oracleStatement == null) return;
                    oracleStatement.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (oracleStatement == null) throw throwable;
                oracleStatement.close();
                throw throwable;
            }
            resultSet.close();
        }
        if (oracleStatement == null) return;
        oracleStatement.close();
    }

    protected void processFailoverEvent(int n, String string, String string2, String string3, String string4, int n2) {
        if (n == 256) {
            if (string4.equalsIgnoreCase("down") || string4.equalsIgnoreCase("not_restarting") || string4.equalsIgnoreCase("restart_failed")) {
                ++this.m_downEventCount;
                this.markDownLostConnections(true, false, string, string2, string3, string4);
                this.cleanupFailoverConnections(true, false, string, string2, string3, string4);
            } else if (string4.equalsIgnoreCase("up")) {
                if (this.m_downEventCount > 0) {
                    ++this.m_upEventCount;
                }
                try {
                    this.processUpEvent(n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_isEntireServiceDownProcessed = false;
            }
        } else if (n == 512 && string4.equalsIgnoreCase("nodedown")) {
            this.markDownLostConnections(false, true, string, string2, string3, string4);
            this.cleanupFailoverConnections(false, true, string, string2, string3, string4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void processUpEvent(int n) throws SQLException {
        double d;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getTotalCachedConnections();
        boolean bl = false;
        if (n <= 1) {
            n = 2;
        }
        if (this.m_downEventCount == 0 && this.m_upEventCount == 0 && this.getNumberOfDefaultUserConnections() > 0) {
            d = (double)this.m_cacheSize * 0.25;
            n2 = (int)d;
        } else {
            n2 = this.m_defaultUserPreFailureSize;
        }
        if (n2 <= 0) {
            if (this.getNumberOfDefaultUserConnections() <= 0) return;
            d = (double)this.m_cacheSize * 0.25;
            n3 = (int)d;
            bl = true;
        } else {
            d = (double)n2 / (double)n;
            n3 = (int)d;
            if (n3 + n4 > this.m_cacheMaxLimit) {
                bl = true;
            }
        }
        this.loadBalanceConnections(n3, bl);
        if (this.m_downEventCount != this.m_upEventCount) return;
        this.m_defaultUserPreFailureSize = 0;
        this.m_downEventCount = 0;
        this.m_upEventCount = 0;
    }

    private void loadBalanceConnections(int n, boolean bl) throws SQLException {
        if (bl) {
            this.m_connectionsToRemove = n;
            this.doForEveryCachedConnection(8);
            this.m_connectionsToRemove = 0;
        }
        if (n <= 10) {
            try {
                this.defaultUserPrePopulateCache(n);
            }
            catch (Exception exception) {}
        } else {
            double d = (double)n * 0.25;
            for (int i = 0; i < 4; ++i) {
                try {
                    this.defaultUserPrePopulateCache((int)d);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private int getNumberOfDefaultUserConnections() {
        OracleConnectionCacheEntry oracleConnectionCacheEntry;
        int n = 0;
        if (this.m_userMap != null && !this.m_userMap.isEmpty() && (oracleConnectionCacheEntry = (OracleConnectionCacheEntry)this.m_userMap.get(this.m_defaultUser + this.m_defaultPassword.toUpperCase())) != null && oracleConnectionCacheEntry.userConnList != null && !oracleConnectionCacheEntry.userConnList.isEmpty()) {
            n = oracleConnectionCacheEntry.userConnList.size();
        }
        return n;
    }

    synchronized void markDownLostConnections(boolean bl, boolean bl2, String string, String string2, String string3, String string4) {
        if (!this.m_isEntireServiceDownProcessed) {
            if (this.m_userMap != null && !this.m_userMap.isEmpty()) {
                Iterator iterator = this.m_userMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object object2;
                    OracleConnectionCacheEntry oracleConnectionCacheEntry;
                    boolean bl3 = false;
                    Map.Entry entry = iterator.next();
                    if (this.m_defaultUser != null && this.m_defaultUser.equalsIgnoreCase((String)entry.getKey())) {
                        bl3 = true;
                    }
                    if ((oracleConnectionCacheEntry = (OracleConnectionCacheEntry)entry.getValue()) != null && oracleConnectionCacheEntry.userConnList != null && !oracleConnectionCacheEntry.userConnList.isEmpty()) {
                        boolean bl4 = false;
                        object2 = oracleConnectionCacheEntry.userConnList.iterator();
                        while (object2.hasNext()) {
                            object = (OraclePooledConnection)object2.next();
                            if (bl) {
                                bl4 = this.markDownConnectionsForServiceEvent(string, string2, (OraclePooledConnection)object);
                            } else if (bl2) {
                                bl4 = this.markDownConnectionsForHostEvent(string3, (OraclePooledConnection)object);
                            }
                            if (!bl4 || !bl3) continue;
                            ++this.m_defaultUserPreFailureSize;
                        }
                    }
                    if (oracleConnectionCacheEntry == null || oracleConnectionCacheEntry.attrConnMap == null || oracleConnectionCacheEntry.attrConnMap.isEmpty()) continue;
                    Iterator iterator2 = oracleConnectionCacheEntry.attrConnMap.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        object2 = iterator2.next();
                        object = ((Vector)object2.getValue()).iterator();
                        while (object.hasNext()) {
                            OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)object.next();
                            if (bl) {
                                this.markDownConnectionsForServiceEvent(string, string2, oraclePooledConnection);
                                continue;
                            }
                            if (!bl2) continue;
                            this.markDownConnectionsForHostEvent(string3, oraclePooledConnection);
                        }
                    }
                }
            }
            if (string == null) {
                this.m_isEntireServiceDownProcessed = true;
            }
        }
    }

    private boolean markDownConnectionsForServiceEvent(String string, String string2, OraclePooledConnection oraclePooledConnection) {
        boolean bl = false;
        if ((string == null || string.equalsIgnoreCase(oraclePooledConnection.m_dataSourceInstanceName)) && string2.equalsIgnoreCase(oraclePooledConnection.m_dataSourceDbUniqName)) {
            oraclePooledConnection.m_connectionMarkedDown = true;
            bl = true;
        }
        return bl;
    }

    private boolean markDownConnectionsForHostEvent(String string, OraclePooledConnection oraclePooledConnection) {
        boolean bl = false;
        if (string.equalsIgnoreCase(oraclePooledConnection.m_dataSourceHostName)) {
            oraclePooledConnection.m_connectionMarkedDown = true;
            oraclePooledConnection.isHostDown = true;
            bl = true;
        }
        return bl;
    }

    synchronized void cleanupFailoverConnections(boolean bl, boolean bl2, String string, String string2, String string3, String string4) {
        int n;
        OraclePooledConnection oraclePooledConnection = null;
        Object[] objectArray = this.m_checkedOutConnectionList.toArray();
        int n2 = this.m_checkedOutConnectionList.size();
        OraclePooledConnection[] oraclePooledConnectionArray = new OraclePooledConnection[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            try {
                oraclePooledConnection = (OraclePooledConnection)objectArray[n];
                if ((!bl || string != null && !string.equalsIgnoreCase(oraclePooledConnection.m_dataSourceInstanceName) || !string2.equalsIgnoreCase(oraclePooledConnection.m_dataSourceDbUniqName)) && (!bl2 || !string3.equalsIgnoreCase(oraclePooledConnection.m_dataSourceHostName))) continue;
                if (this.m_defaultUser != null && this.m_defaultUser.equalsIgnoreCase(oraclePooledConnection.m_pcUser) && oraclePooledConnection.cachedConnectionAttributes != null && oraclePooledConnection.cachedConnectionAttributes.isEmpty()) {
                    ++this.m_defaultUserPreFailureSize;
                }
                this.m_checkedOutConnectionList.removeElement(oraclePooledConnection);
                this.abortConnection(oraclePooledConnection);
                oraclePooledConnection.isHostDown = true;
                oraclePooledConnectionArray[n3++] = oraclePooledConnection;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n = 0; n < n3; ++n) {
            try {
                this.closeCheckedOutConnection(oraclePooledConnectionArray[n], false);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.m_checkedOutConnectionList.size() < n2 && this.m_cacheConnectionWaitTimeout > 0) {
            this.notify();
        }
        try {
            this.doForEveryCachedConnection(2);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected synchronized void closeAndRemovePooledConnection(PooledConnection pooledConnection) throws SQLException {
        if (pooledConnection != null) {
            try {
                if (((OraclePooledConnection)pooledConnection).isHostDown) {
                    this.abortConnection((OraclePooledConnection)pooledConnection);
                } else {
                    ++this.connectionClosedCount;
                    ((OraclePooledConnection)pooledConnection).close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.removeCacheConnection(pooledConnection);
        }
    }

    private void abortConnection(OraclePooledConnection oraclePooledConnection) {
        try {
            ((OracleConnection)oraclePooledConnection.getPhysicalHandle()).abort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int getCacheTimeToLiveTimeout() {
        return this.m_cacheTimeToLiveTimeout;
    }

    protected int getCacheInactivityTimeout() {
        return this.m_cacheInactivityTimeout;
    }

    protected int getCachePropertyCheckInterval() {
        return this.m_cachePropertyCheckInterval;
    }

    protected int getCacheAbandonedTimeout() {
        return this.m_cacheAbandonedConnectionTimeout;
    }

    private void processConnectionCacheCallback() throws SQLException {
        double d = (double)this.m_cacheMaxLimit / 100.0;
        double d2 = (double)this.m_cacheLowerThresholdLimit * d;
        int n = (int)d2;
        this.releaseBasedOnPriority(1024, n);
        if (this.m_cacheSize < n) {
            this.releaseBasedOnPriority(512, n);
        }
    }

    private void releaseBasedOnPriority(int n, int n2) throws SQLException {
        Object[] objectArray = this.m_checkedOutConnectionList.toArray();
        for (int i = 0; i < objectArray.length && this.m_cacheSize < n2; ++i) {
            OracleConnectionCacheCallback oracleConnectionCacheCallback;
            OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)objectArray[i];
            OracleConnection oracleConnection = null;
            if (oraclePooledConnection != null) {
                oracleConnection = (OracleConnection)oraclePooledConnection.getLogicalHandle();
            }
            if (oracleConnection == null || (oracleConnectionCacheCallback = oracleConnection.getConnectionCacheCallbackObj()) == null || oracleConnection.getConnectionCacheCallbackFlag() != 2 && oracleConnection.getConnectionCacheCallbackFlag() != 4 || n != oracleConnection.getConnectionReleasePriority()) continue;
            Object object = oracleConnection.getConnectionCacheCallbackPrivObj();
            oracleConnectionCacheCallback.releaseConnection(oracleConnection, object);
        }
    }

    private void processConnectionWaitTimeout(long l) throws SQLException {
        try {
            this.wait(this.m_cacheConnectionWaitTimeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void processInactivityTimeout(OraclePooledConnection oraclePooledConnection) throws SQLException {
        long l = oraclePooledConnection.getLastAccessedTime();
        long l2 = System.currentTimeMillis();
        if (this.getTotalCachedConnections() > this.m_cacheMinLimit && l2 - l > (long)(this.m_cacheInactivityTimeout * 1000)) {
            this.closeAndRemovePooledConnection(oraclePooledConnection);
        }
    }

    private void cleanupTimeoutThread() throws SQLException {
        if (this.m_timeoutThread != null) {
            this.m_timeoutThread.m_timeToLive = false;
            if (this.m_timeoutThread.m_isSleeping) {
                this.m_timeoutThread.interrupt();
            }
            this.m_timeoutThread = null;
        }
    }

    protected void purgeCacheConnections(boolean bl) {
        try {
            if (bl) {
                this.doForEveryCheckedOutConnection(1);
            }
            this.doForEveryCachedConnection(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    Map getStatistics() throws SQLException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(2);
        hashMap.put("PhysicalConnectionClosedCount", new Integer(this.connectionClosedCount));
        hashMap.put("PhysicalConnectionCreatedCount", new Integer(this.connectionCreatedCount));
        return hashMap;
    }
}

