/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.Serializable;
import java.util.Locale;
import oracle.i18n.text.OraLanguage;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.OraLocaleInfo;

public final class OraDateFormatSymbols
implements Serializable,
Cloneable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private String[] amPmStrings;
    private char decimalSeparator;
    private String[] eras;
    private char groupingSeparator;
    private String[] months;
    private String[] shortMonths;
    private String[] weekdays;
    private String[] shortWeekdays;
    private boolean capMonth;
    private boolean capShortMonth;
    private boolean capDay;
    private boolean capShortDay;
    private boolean upperEra;
    private boolean upperAmPm;
    private int monthLength;
    private int shortMonthLength;
    private int weekdayLength;
    private int shortWeekdayLength;
    private int amPmLength;
    private int eraLength;

    public OraDateFormatSymbols() {
        this.initialize(OraLocaleInfo.getDefault());
    }

    public OraDateFormatSymbols(Locale locale) {
        this.initialize(OraLocaleInfo.getInstance(locale));
    }

    public OraDateFormatSymbols(OraLocaleInfo oraLocaleInfo) {
        this.initialize(oraLocaleInfo);
    }

    public String[] getEras() {
        return this.upperEra ? this.duplicateArrayToUpper(this.eras) : this.duplicateArray(this.eras);
    }

    String[] getErasRaw() {
        return this.duplicateArray(this.eras);
    }

    public void setEras(String[] stringArray) {
        this.eras = this.duplicateArray(stringArray);
        this.upperEra = false;
        this.eraLength = this.getMaxLength(this.eras);
    }

    public String[] getMonths() {
        return this.capMonth ? this.duplicateArrayToCap(this.months) : this.duplicateArray(this.months);
    }

    String[] getMonthsRaw() {
        return this.duplicateArray(this.months);
    }

    public void setMonths(String[] stringArray) {
        this.months = this.duplicateArray(stringArray);
        this.capMonth = false;
        this.monthLength = this.getMaxLength(this.months);
    }

    public String[] getShortMonths() {
        return this.capShortMonth ? this.duplicateArrayToCap(this.shortMonths) : this.duplicateArray(this.shortMonths);
    }

    String[] getShortMonthsRaw() {
        return this.duplicateArray(this.shortMonths);
    }

    public void setShortMonths(String[] stringArray) {
        this.shortMonths = this.duplicateArray(stringArray);
        this.capShortMonth = false;
        this.shortMonthLength = this.getMaxLength(this.shortMonths);
    }

    public String[] getWeekdays() {
        return this.capDay ? this.duplicateArrayToCap(this.weekdays) : this.duplicateArray(this.weekdays);
    }

    String[] getWeekdaysRaw() {
        return this.duplicateArray(this.weekdays);
    }

    public void setWeekdays(String[] stringArray) {
        this.weekdays = this.duplicateArray(stringArray);
        this.capDay = false;
        this.weekdayLength = this.getMaxLength(this.weekdays);
    }

    public String[] getShortWeekdays() {
        return this.capShortDay ? this.duplicateArrayToCap(this.shortWeekdays) : this.duplicateArray(this.shortWeekdays);
    }

    String[] getShortWeekdaysRaw() {
        return this.duplicateArray(this.shortWeekdays);
    }

    public void setShortWeekdays(String[] stringArray) {
        this.shortWeekdays = this.duplicateArray(stringArray);
        this.capShortDay = false;
        this.shortWeekdayLength = this.getMaxLength(this.shortWeekdays);
    }

    public String[] getAmPmStrings() {
        return this.upperAmPm ? this.duplicateArrayToUpper(this.amPmStrings) : this.duplicateArray(this.amPmStrings);
    }

    String[] getAmPmStringsRaw() {
        return this.duplicateArray(this.amPmStrings);
    }

    public void setAmPmStrings(String[] stringArray) {
        this.amPmStrings = this.duplicateArray(stringArray);
        this.upperAmPm = false;
        this.amPmLength = this.getMaxLength(this.amPmStrings);
    }

    char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    void setDecimalSeparator(char c) {
        this.decimalSeparator = c;
    }

    char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    void setGroupingSeparator(char c) {
        this.groupingSeparator = c;
    }

    int getMonthLength() {
        return this.monthLength;
    }

    int getShortMonthLength() {
        return this.shortMonthLength;
    }

    int getWeekdayLength() {
        return this.weekdayLength;
    }

    int getShortWeekdayLength() {
        return this.shortWeekdayLength;
    }

    public Object clone() {
        try {
            OraDateFormatSymbols oraDateFormatSymbols = (OraDateFormatSymbols)super.clone();
            oraDateFormatSymbols.amPmStrings = this.duplicateArray(this.amPmStrings);
            oraDateFormatSymbols.eras = this.duplicateArray(this.eras);
            oraDateFormatSymbols.months = this.duplicateArray(this.months);
            oraDateFormatSymbols.shortMonths = this.duplicateArray(this.shortMonths);
            oraDateFormatSymbols.weekdays = this.duplicateArray(this.weekdays);
            oraDateFormatSymbols.shortWeekdays = this.duplicateArray(this.shortWeekdays);
            return oraDateFormatSymbols;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OraDateFormatSymbols)) {
            return false;
        }
        OraDateFormatSymbols oraDateFormatSymbols = (OraDateFormatSymbols)object;
        return this.arrayEquals(this.amPmStrings, oraDateFormatSymbols.amPmStrings) && this.arrayEquals(this.eras, oraDateFormatSymbols.eras) && this.arrayEquals(this.months, oraDateFormatSymbols.months) && this.arrayEquals(this.shortMonths, oraDateFormatSymbols.shortMonths) && this.arrayEquals(this.weekdays, oraDateFormatSymbols.weekdays) && this.arrayEquals(this.shortWeekdays, oraDateFormatSymbols.shortWeekdays) && this.capMonth == oraDateFormatSymbols.capMonth && this.capShortMonth == oraDateFormatSymbols.capShortMonth && this.capDay == oraDateFormatSymbols.capDay && this.capShortDay == oraDateFormatSymbols.capShortDay && this.upperEra == oraDateFormatSymbols.upperEra && this.upperAmPm == oraDateFormatSymbols.upperAmPm;
    }

    public int hashCode() {
        return this.months[0].hashCode() + this.weekdays[0].hashCode();
    }

    static String toTitleCase(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c)) {
                stringBuffer.append(c);
                if (bl) continue;
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer.append(Character.toTitleCase(c));
                bl = false;
                continue;
            }
            stringBuffer.append(Character.toLowerCase(c));
        }
        return stringBuffer.toString();
    }

    private void initialize(OraLocaleInfo oraLocaleInfo) {
        OraLanguage oraLanguage = oraLocaleInfo.getOraLanguage();
        OraTerritory oraTerritory = oraLocaleInfo.getOraTerritory();
        String[] stringArray = new String[]{oraLanguage.getBCString(), oraLanguage.getADString()};
        this.capShortMonth = this.capMonth = oraLanguage.getCapitalizeMonthInitialChar().equalsIgnoreCase("1");
        this.capShortDay = this.capDay = oraLanguage.getCapitalizeDayInitialChar().equalsIgnoreCase("1");
        this.upperAmPm = this.upperEra = oraLanguage.getName().equalsIgnoreCase("AMERICAN");
        String[] stringArray2 = new String[]{oraLanguage.getMonth01Fullname(), oraLanguage.getMonth02Fullname(), oraLanguage.getMonth03Fullname(), oraLanguage.getMonth04Fullname(), oraLanguage.getMonth05Fullname(), oraLanguage.getMonth06Fullname(), oraLanguage.getMonth07Fullname(), oraLanguage.getMonth08Fullname(), oraLanguage.getMonth09Fullname(), oraLanguage.getMonth10Fullname(), oraLanguage.getMonth11Fullname(), oraLanguage.getMonth12Fullname()};
        String[] stringArray3 = new String[]{oraLanguage.getMonth01Abbreviation(), oraLanguage.getMonth02Abbreviation(), oraLanguage.getMonth03Abbreviation(), oraLanguage.getMonth04Abbreviation(), oraLanguage.getMonth05Abbreviation(), oraLanguage.getMonth06Abbreviation(), oraLanguage.getMonth07Abbreviation(), oraLanguage.getMonth08Abbreviation(), oraLanguage.getMonth09Abbreviation(), oraLanguage.getMonth10Abbreviation(), oraLanguage.getMonth11Abbreviation(), oraLanguage.getMonth12Abbreviation()};
        String[] stringArray4 = new String[]{oraLanguage.getSundayFullname(), oraLanguage.getMondayFullname(), oraLanguage.getTuesdayFullname(), oraLanguage.getWednesdayFullname(), oraLanguage.getThursdayFullname(), oraLanguage.getFridayFullname(), oraLanguage.getSaturdayFullname()};
        String[] stringArray5 = new String[]{oraLanguage.getSundayAbbreviation(), oraLanguage.getMondayAbbreviation(), oraLanguage.getTuesdayAbbreviation(), oraLanguage.getWednesdayAbbreviation(), oraLanguage.getThursdayAbbreviation(), oraLanguage.getFridayAbbreviation(), oraLanguage.getSaturdayAbbreviation()};
        String[] stringArray6 = new String[]{oraLanguage.getAMString(), oraLanguage.getPMString()};
        this.eras = stringArray;
        this.months = stringArray2;
        this.shortMonths = stringArray3;
        this.weekdays = stringArray4;
        this.shortWeekdays = stringArray5;
        this.amPmStrings = stringArray6;
        this.decimalSeparator = oraTerritory.getDecimalCharacter().charAt(0);
        this.groupingSeparator = oraTerritory.getGroupSeparator().charAt(0);
        this.monthLength = this.getMaxLength(this.months);
        this.shortMonthLength = this.getMaxLength(this.shortMonths);
        this.weekdayLength = this.getMaxLength(this.weekdays);
        this.shortWeekdayLength = this.getMaxLength(this.shortWeekdays);
        this.amPmLength = this.getMaxLength(this.amPmStrings);
        this.eraLength = this.getMaxLength(this.eras);
    }

    private final String[] duplicateArray(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private final String[] duplicateArrayToCap(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = OraDateFormatSymbols.toTitleCase(stringArray[i]);
        }
        return stringArray2;
    }

    private final String[] duplicateArrayToUpper(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].toUpperCase();
        }
        return stringArray2;
    }

    private final boolean arrayEquals(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    private int getMaxLength(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= n) continue;
            n = stringArray[i].length();
        }
        return n;
    }
}

