/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.i18n.text.OraDateFormat;
import oracle.i18n.text.OraDateFormatPattern;
import oracle.i18n.text.OraDateFormatSymbols;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.OraLocaleInfo;

public class OraSimpleDateFormat
extends OraDateFormat {
    private static final int FIELD_NULL = Integer.MIN_VALUE;
    private static final int RR_CROSS = 50;
    private static final int MILLISECONDS_PER_HOUR = 3600000;
    private static final int MILLISECONDS_PER_MINUTE = 60000;
    private Locale locale;
    private OraDateFormatPattern oraDatePat;
    private OraDateFormatSymbols symbols;

    public OraSimpleDateFormat() {
        this(127, 127, OraLocaleInfo.getDefault());
    }

    public OraSimpleDateFormat(String string) throws ParseException {
        this(string, Locale.getDefault());
    }

    public OraSimpleDateFormat(String string, Locale locale) throws ParseException {
        this(string, OraLocaleInfo.getInstance(locale));
    }

    public OraSimpleDateFormat(String string, OraLocaleInfo oraLocaleInfo) throws ParseException {
        this.initialize(string, new OraDateFormatSymbols(oraLocaleInfo), oraLocaleInfo.getLocale());
    }

    public OraSimpleDateFormat(String string, OraDateFormatSymbols oraDateFormatSymbols) throws ParseException {
        this(string, oraDateFormatSymbols, Locale.getDefault());
    }

    public OraSimpleDateFormat(String string, OraDateFormatSymbols oraDateFormatSymbols, Locale locale) throws ParseException {
        this.initialize(string, oraDateFormatSymbols, locale);
    }

    public OraSimpleDateFormat(String string, OraDateFormatSymbols oraDateFormatSymbols, OraLocaleInfo oraLocaleInfo) throws ParseException {
        this.initialize(string, oraDateFormatSymbols, oraLocaleInfo.getLocale());
    }

    OraSimpleDateFormat(int n, int n2, OraLocaleInfo oraLocaleInfo) {
        try {
            this.initialize(OraSimpleDateFormat.getDefaultFormatPattern(n, n2, true, oraLocaleInfo.getOraTerritory()), new OraDateFormatSymbols(oraLocaleInfo), oraLocaleInfo.getLocale());
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage());
        }
    }

    public void applyPattern(String string) throws ParseException {
        String string2 = null;
        if (string == null || string.equals("")) {
            throw new ParseException(GDKMessage.getMessage(5087), -1);
        }
        char c = string.charAt(0);
        int n = string.length();
        if (!(n != DEFAULT_DATE_OR_TIME_FORMAT_LENGTH && n != DEFAULT_DATE_AND_TIME_FORMAT_LENGTH || c != "DL".charAt(0) && c != "TS".charAt(0))) {
            string2 = this.toDefaultFormatPattern(string, n);
        }
        if (string2 == null) {
            string2 = string;
        }
        if (this.oraDatePat == null || !string2.equals(this.oraDatePat.pattern)) {
            ParsePosition parsePosition = new ParsePosition(0);
            this.oraDatePat = new OraDateFormatPattern(string2, parsePosition);
            if (parsePosition.getErrorIndex() >= 0) {
                int n2 = parsePosition.getIndex();
                parsePosition.setIndex(0);
                throw new ParseException(GDKMessage.getMessage(n2), parsePosition.getErrorIndex());
            }
        }
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.setTime(date);
        int n = date instanceof Timestamp ? ((Timestamp)date).getNanos() : -1;
        int n2 = this.format(calendar, n, stringBuffer, fieldPosition);
        if (n2 > 0) {
            throw new IllegalArgumentException(GDKMessage.getMessage(n2));
        }
        return stringBuffer;
    }

    public OraDateFormatSymbols getOraDateFormatSymbols() {
        return (OraDateFormatSymbols)this.symbols.clone();
    }

    public void setOraDateFormatSymbols(OraDateFormatSymbols oraDateFormatSymbols) {
        this.symbols = oraDateFormatSymbols;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        int n = this.oraDatePat.checkConflictingFormatElements();
        if (n > 0) {
            throw new IllegalArgumentException(GDKMessage.getMessage(n));
        }
        int n2 = parsePosition.getIndex();
        Calendar calendar = (Calendar)this.calendar.clone();
        int[] nArray = new int[]{-1};
        n = this.parse(string, parsePosition, calendar, nArray);
        if (n > 0) {
            parsePosition.setIndex(n2);
            throw new IllegalArgumentException(GDKMessage.getMessage(n));
        }
        parsePosition.setIndex(string.length());
        if (nArray[0] >= 0) {
            Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
            timestamp.setNanos(nArray[0]);
            return timestamp;
        }
        return calendar.getTime();
    }

    public String toPattern() {
        return this.oraDatePat.pattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object clone() {
        OraSimpleDateFormat oraSimpleDateFormat = (OraSimpleDateFormat)super.clone();
        oraSimpleDateFormat.locale = (Locale)this.locale.clone();
        oraSimpleDateFormat.oraDatePat = (OraDateFormatPattern)this.oraDatePat.clone();
        oraSimpleDateFormat.symbols = (OraDateFormatSymbols)this.symbols.clone();
        return oraSimpleDateFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OraSimpleDateFormat) || !super.equals(object)) {
            return false;
        }
        OraSimpleDateFormat oraSimpleDateFormat = (OraSimpleDateFormat)object;
        return this.locale.equals(oraSimpleDateFormat.locale) && this.oraDatePat.equals(oraSimpleDateFormat.oraDatePat) && this.symbols.equals(oraSimpleDateFormat.symbols);
    }

    public int hashCode() {
        return this.oraDatePat.hashCode();
    }

    private void initialize(String string, OraDateFormatSymbols oraDateFormatSymbols, Locale locale) throws ParseException {
        this.locale = locale;
        this.symbols = oraDateFormatSymbols;
        this.applyPattern(string);
        this.calendar = locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0 ? new GregorianCalendar(locale) : Calendar.getInstance(locale);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String toDefaultFormatPattern(String string, int n) {
        int n2 = -1;
        int n3 = -1;
        boolean bl = true;
        if (string.startsWith("DL")) {
            n2 = 1;
        } else if (string.startsWith("DS")) {
            n2 = 3;
        } else {
            if (!string.startsWith("TS")) return null;
            n3 = 3;
        }
        if (n != DEFAULT_DATE_AND_TIME_FORMAT_LENGTH) return OraSimpleDateFormat.getDefaultFormatPattern(n2, n3, bl, OraLocaleInfo.getInstance(this.locale).getOraTerritory());
        if (string.charAt(DEFAULT_DATE_OR_TIME_FORMAT_LENGTH) != ' ') {
            return null;
        }
        if (n2 != -1) {
            if (!string.regionMatches(true, DEFAULT_DATE_OR_TIME_FORMAT_LENGTH + 1, "TS", 0, DEFAULT_DATE_OR_TIME_FORMAT_LENGTH)) return null;
            n3 = 3;
            return OraSimpleDateFormat.getDefaultFormatPattern(n2, n3, bl, OraLocaleInfo.getInstance(this.locale).getOraTerritory());
        } else {
            if (string.regionMatches(true, DEFAULT_DATE_OR_TIME_FORMAT_LENGTH + 1, "DL", 0, DEFAULT_DATE_OR_TIME_FORMAT_LENGTH)) {
                n2 = 1;
            } else {
                if (!string.regionMatches(true, DEFAULT_DATE_OR_TIME_FORMAT_LENGTH + 1, "DS", 0, DEFAULT_DATE_OR_TIME_FORMAT_LENGTH)) return null;
                n2 = 3;
            }
            bl = false;
        }
        return OraSimpleDateFormat.getDefaultFormatPattern(n2, n3, bl, OraLocaleInfo.getInstance(this.locale).getOraTerritory());
    }

    private int format(Calendar calendar, int n, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        String string = null;
        int n2 = 0;
        boolean bl = false;
        Calendar calendar2 = null;
        TimeZone timeZone = this.calendar.getTimeZone();
        if (fieldPosition.getField() == 1000) {
            fieldPosition.setBeginIndex(stringBuffer.length());
        }
        int n3 = 0;
        int n4 = 0;
        block36: while (n4 < this.oraDatePat.iPatternLength) {
            char c;
            char c2 = this.oraDatePat.iPattern[n4++];
            char c3 = this.oraDatePat.iPattern[n4++];
            if (c2 > '>') {
                c = c2 - 63;
                if (fieldPosition.getField() == this.oraDatePat.getFormatField(62)) {
                    fieldPosition.setBeginIndex(stringBuffer.length());
                }
                stringBuffer.append(this.oraDatePat.iPattern, n4, (int)c);
                n4 += c;
                if (fieldPosition.getField() != this.oraDatePat.getFormatField(62)) continue;
                fieldPosition.setEndIndex(stringBuffer.length());
                continue;
            }
            int[] nArray = OraDateFormatPattern.FORMAT_ATTR[c2];
            int n5 = nArray[3];
            int n6 = -1;
            if (fieldPosition.getField() == this.oraDatePat.getFormatField(c2)) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            switch (c2) {
                case '\u0001': 
                case '\u0002': {
                    n6 = calendar.get(1) / 100 + 1;
                    break;
                }
                case '\u0012': {
                    if (!bl) {
                        calendar2 = (Calendar)calendar.clone();
                        calendar2.setFirstDayOfWeek(2);
                        calendar2.setMinimalDaysInFirstWeek(4);
                        calendar2.clear(3);
                        bl = true;
                    }
                    n6 = calendar2.get(3);
                    break;
                }
                case '\u0003': 
                case '\u0005': 
                case '\u0007': 
                case '\t': {
                    if (!bl) {
                        calendar2 = (Calendar)calendar.clone();
                        calendar2.setFirstDayOfWeek(2);
                        calendar2.setMinimalDaysInFirstWeek(4);
                        calendar2.clear(3);
                        bl = true;
                    }
                    n6 = calendar2.get(1);
                    if (calendar2.get(2) == 11) {
                        if (calendar2.get(3) == 1) {
                            ++n6;
                        }
                    } else if (calendar2.get(3) == 53) {
                        --n6;
                    }
                    if (c2 == '\t') break;
                    if (c2 == '\u0007') {
                        n6 %= 1000;
                        break;
                    }
                    if (c2 == '\u0005') {
                        n6 %= 100;
                        break;
                    }
                    n6 %= 10;
                    break;
                }
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ')': {
                    n6 = calendar.get(1);
                    break;
                }
                case '\b': {
                    n6 = calendar.get(1) % 1000;
                    break;
                }
                case '\u0006': 
                case '(': {
                    n6 = calendar.get(1) % 100;
                    break;
                }
                case '\u0004': {
                    n6 = calendar.get(1) % 10;
                    break;
                }
                case '\u0010': {
                    n6 = 1 + calendar.get(2) / 3;
                    break;
                }
                case '\u0013': {
                    n6 = (calendar.get(6) + 6) / 7;
                    break;
                }
                case '\u0014': {
                    n6 = (calendar.get(5) + 6) / 7;
                    break;
                }
                case '\u0016': {
                    n6 = calendar.get(5);
                    break;
                }
                case '\u0017': {
                    n6 = calendar.get(6);
                    break;
                }
                case '\u0018': {
                    n6 = calendar.get(11);
                    break;
                }
                case '\u0019': {
                    n6 = calendar.get(10);
                    if (n6 != 0) break;
                    n6 = 12;
                    break;
                }
                case '\u001a': {
                    n6 = calendar.get(12);
                    break;
                }
                case '\u001b': {
                    n6 = calendar.get(13);
                    break;
                }
                case '\u001c': {
                    n6 = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
                    break;
                }
                case '\u001d': {
                    n6 = this.toJulianDay(calendar);
                    if (n6 > 0) break;
                    return -n6;
                }
                case '\u0011': {
                    n6 = calendar.get(2) + 1;
                    break;
                }
                case '\u001e': {
                    n6 = calendar.get(2);
                    string = this.symbols.getMonthsRaw()[n6];
                    n3 = this.symbols.getMonthLength();
                    break;
                }
                case '\u001f': {
                    n6 = calendar.get(2);
                    string = this.symbols.getShortMonthsRaw()[n6];
                    n3 = this.symbols.getShortMonthLength();
                    break;
                }
                case ' ': {
                    n6 = calendar.get(7);
                    string = this.symbols.getWeekdaysRaw()[n6 - 1];
                    n3 = this.symbols.getWeekdayLength();
                    break;
                }
                case '!': {
                    n6 = calendar.get(7);
                    string = this.symbols.getShortWeekdaysRaw()[n6 - 1];
                    n3 = this.symbols.getShortWeekdayLength();
                    break;
                }
                case '\u0015': {
                    c = OraLocaleInfo.getInstance(this.locale).getOraTerritory().getStartDayOfTheWeek().charAt(0);
                    n6 = (calendar.get(7) + 7 - Character.digit(c, 10)) % 7;
                    if (n6 != 0) break;
                    n6 = 7;
                    break;
                }
                case '#': {
                    if (this.locale.equals(Locale.US)) {
                        if (calendar.get(9) == 0) {
                            string = "a.m.";
                            break;
                        }
                        string = "p.m.";
                        break;
                    }
                }
                case '\"': {
                    if (calendar.get(9) == 0) {
                        string = this.symbols.getAmPmStringsRaw()[0];
                        break;
                    }
                    string = this.symbols.getAmPmStringsRaw()[1];
                    break;
                }
                case '%': {
                    if (this.locale.equals(Locale.US)) {
                        if (calendar.get(0) == 1) {
                            string = "a.d.";
                            break;
                        }
                        string = "b.c.";
                        break;
                    }
                }
                case '$': {
                    if (calendar.get(0) == 1) {
                        string = this.symbols.getErasRaw()[1];
                        break;
                    }
                    string = this.symbols.getErasRaw()[0];
                    break;
                }
                case '+': 
                case ',': {
                    string = "";
                    break;
                }
                case '3': {
                    string = String.valueOf(this.symbols.getDecimalSeparator());
                    break;
                }
                case '2': {
                    string = timeZone.getID();
                    break;
                }
                case '1': {
                    String string2 = timeZone.getDisplayName(timeZone.inDaylightTime(calendar.getTime()), 0, Locale.US);
                    if (string2.startsWith("GMT")) {
                        string = string2.substring(3);
                        break;
                    }
                    string = string2;
                    break;
                }
                case '/': 
                case '0': {
                    int n7 = calendar.get(15) + calendar.get(16);
                    if (c2 == '/') {
                        n6 = n7 / 3600000;
                        break;
                    }
                    if (n7 < 0) {
                        n7 = -n7;
                    }
                    n6 = n7 % 3600000 / 60000;
                    break;
                }
                case '*': {
                    continue block36;
                }
                default: {
                    if (c2 == '.' || c2 >= '4' && c2 <= '<') {
                        if (n < 0) {
                            return 5021;
                        }
                        n6 = n;
                        if (c2 == '.') {
                            n2 = 9;
                            break;
                        }
                        n2 = c2 - 52 + 1;
                        break;
                    }
                    return 5091;
                }
            }
            if ((n5 & 0x80) == 0) {
                n3 = (c3 & 0x10) != 0 ? n5 & 0xF : 0;
                if (n2 == 0 && (n6 < nArray[1] || n6 > nArray[2])) {
                    return nArray[0];
                }
                if ((n5 & 0x20) != 0) {
                    if (c2 == '\u0002' || c2 == '\f') {
                        if (calendar.get(0) == 0) {
                            stringBuffer.append('-');
                        } else {
                            stringBuffer.append(' ');
                        }
                    } else if (c2 == '/') {
                        if (n6 < 0) {
                            stringBuffer.append('-');
                            n6 = -n6;
                        } else {
                            stringBuffer.append('+');
                        }
                    }
                    --n3;
                }
                if (n2 > 0) {
                    stringBuffer.append(this.toNanosString(n6, n2));
                    n2 = 0;
                } else {
                    stringBuffer.append(this.toNumericString(n6, n5, n3));
                }
            } else {
                if ((c3 & 0x10) == 0 || (n5 & 0x40) != 0) {
                    n3 = 0;
                }
                n5 &= 0xF;
                String string3 = (c3 & 8) == 8 ? string.toUpperCase() : ((c3 & 4) == 4 ? this.toTitleCase(string) : string);
                stringBuffer.append(string3);
                for (int i = n3 - string3.length() - 1; i >= 0; --i) {
                    stringBuffer.append(' ');
                }
            }
            if (fieldPosition.getField() != this.oraDatePat.getFormatField(c2)) continue;
            fieldPosition.setEndIndex(stringBuffer.length());
        }
        if (fieldPosition.getField() == 1000) {
            fieldPosition.setEndIndex(stringBuffer.length());
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int parse(String var1_1, ParsePosition var2_2, Calendar var3_3, int[] var4_4) {
        block137: {
            var11_5 = new char[this.oraDatePat.iPatternLength];
            var20_6 = var3_3.get(1);
            var25_7 = -2147483648;
            var24_8 = -2147483648;
            var23_9 = -2147483648;
            var33_10 = -2147483648;
            var28_11 = -2147483648;
            var27_12 = -2147483648;
            var26_13 = -2147483648;
            var35_14 = -2147483648;
            var34_15 = -2147483648;
            var32_16 = 0;
            var30_17 = 0;
            var31_18 = 0;
            var36_19 = null;
            var38_20 = null;
            var37_21 = null;
            var41_22 = -2147483648;
            var40_23 = -2147483648;
            var39_24 = -2147483648;
            var16_25 = 0;
            var17_26 = -1;
            var42_27 = false;
            var43_28 = true;
            var6_29 = var2_2.getIndex();
            var7_30 = var1_1.length();
            var10_31 = this.oraDatePat.iPattern;
            while (true) {
                var9_34 = 0;
                var15_38 = 0;
                while (var9_34 < this.oraDatePat.iPatternLength) {
                    block139: {
                        block138: {
                            var5_32 = var2_2.getIndex();
                            if (var5_32 >= var7_30) {
                                var15_38 = 5040;
                                break;
                            }
                            var46_43 = 0;
                            if (!var42_27) {
                                while (var5_32 < var7_30 && Character.isWhitespace(var1_1.charAt(var5_32))) {
                                    ++var5_32;
                                    ++var46_43;
                                }
                            }
                            var12_35 = var10_31[var9_34];
                            if (var43_28) {
                                var11_5[var9_34] = var12_35 == 6 ? 10 : (var12_35 == 40 ? 41 : var12_35);
                            }
                            var13_36 = var10_31[++var9_34];
                            if (var43_28) {
                                var11_5[var9_34] = var13_36;
                            }
                            ++var9_34;
                            if (var12_35 >= 62) {
                                var47_44 = var12_35 - 62 - 1;
                                if (var42_27) {
                                    if (!var1_1.regionMatches(true, var5_32, new String(var10_31), var9_34, var47_44)) {
                                        var2_2.setErrorIndex(var5_32);
                                        return 5061;
                                    }
                                    var9_34 += var47_44;
                                    var2_2.setIndex(var5_32 + var47_44);
                                    continue;
                                }
                                if (var43_28) {
                                    System.arraycopy(var10_31, var9_34, var11_5, var9_34, var47_44);
                                }
                                if (var9_34 < this.oraDatePat.iPatternLength) {
                                    var48_45 = var10_31[var9_34 + var47_44];
                                    var49_46 = var10_31[var9_34 + var47_44 + 1];
                                } else {
                                    var49_46 = 0;
                                    var48_45 = 0;
                                }
                                if (var48_45 < 62) {
                                    var50_47 = OraDateFormatPattern.FORMAT_ATTR[var48_45];
                                    var51_48 = var50_47[3];
                                    if (var13_36 == '\u0001') {
                                        if (var7_30 - var5_32 < var47_44 || var9_34 + var46_43 + var47_44 > var10_31.length || !var1_1.regionMatches(true, var5_32, new String(var10_31), var9_34 + var46_43, var47_44)) {
                                            var2_2.setErrorIndex(var5_32);
                                            return 5061;
                                        }
                                        var5_32 += var47_44;
                                    } else {
                                        var52_49 = var47_44;
                                        while (!(var5_32 >= var7_30 || var52_49 <= 0 || Character.isLetterOrDigit(var14_37 = var1_1.charAt(var5_32)) || (var51_48 & 32) > 0 && var14_37 == '-')) {
                                            if (!Character.isWhitespace(var14_37)) {
                                                --var52_49;
                                            }
                                            ++var5_32;
                                        }
                                        while (var5_32 < var7_30 && Character.isWhitespace(var1_1.charAt(var5_32))) {
                                            ++var5_32;
                                        }
                                    }
                                }
                                var9_34 += var47_44;
                                var2_2.setIndex(var5_32);
                                continue;
                            }
                            if (var12_35 == 42) {
                                var42_27 = var42_27 == false;
                                var43_28 = false;
                                continue;
                            }
                            var44_40 = OraDateFormatPattern.FORMAT_ATTR[var12_35];
                            var45_42 = var44_40[3];
                            if ((var45_42 & 128) != 0) break block138;
                            var47_44 = 0;
                            if (var1_1.charAt(var5_32) == '-' || var1_1.charAt(var5_32) == '+') {
                                if (var1_1.charAt(var5_32) == '-') {
                                    var47_44 = 1;
                                }
                                if (++var5_32 < var7_30) {
                                    var2_2.setIndex(var5_32);
                                } else {
                                    var15_38 = 5058;
                                    break;
                                }
                            }
                            var2_2.setIndex(var5_32);
                            var18_39 = this.toNumber(var1_1, var7_30, var2_2, var45_42, (var45_42 & 16) > 0, var42_27, (var13_36 & 16) == 0);
                            if (var18_39 < 0) {
                                var15_38 = -var18_39;
                                break;
                            }
                            if (var47_44 != 0) {
                                var18_39 = -var18_39;
                            }
                            if (var18_39 < var44_40[1] || var18_39 > var44_40[2]) {
                                var15_38 = var44_40[0];
                                break;
                            }
                            switch (var12_35) {
                                case 21: {
                                    var48_45 = OraLocaleInfo.getInstance(this.locale).getOraTerritory().getStartDayOfTheWeek().charAt(0);
                                    var30_17 = (var18_39 + Character.digit((char)var48_45, 10)) % 7;
                                    if (var30_17 == 0) {
                                        var30_17 = 7;
                                        break;
                                    }
                                    break block139;
                                }
                                case 22: {
                                    var25_7 = var18_39;
                                    break;
                                }
                                case 23: {
                                    var31_18 = var18_39;
                                    break;
                                }
                                case 25: {
                                    var26_13 = var18_39;
                                    break;
                                }
                                case 24: {
                                    var26_13 = var18_39;
                                    break;
                                }
                                case 29: {
                                    var32_16 = var18_39;
                                    break;
                                }
                                case 26: {
                                    var27_12 = var18_39;
                                    break;
                                }
                                case 27: {
                                    var28_11 = var18_39;
                                    break;
                                }
                                case 28: {
                                    var33_10 = var18_39;
                                    break;
                                }
                                case 46: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 58: 
                                case 59: 
                                case 60: {
                                    var4_4[0] = var18_39;
                                    for (var49_46 = var2_2.getIndex() - var5_32; var49_46 < 9; ++var49_46) {
                                        var4_4[0] = var4_4[0] * 10;
                                    }
                                    break block139;
                                }
                                case 17: {
                                    var24_8 = var18_39 - 1;
                                    break;
                                }
                                case 10: 
                                case 11: 
                                case 12: {
                                    var23_9 = var18_39;
                                    break;
                                }
                                case 41: {
                                    var23_9 = var18_39;
                                    if (var18_39 >= 1000) break;
                                }
                                case 40: {
                                    var49_46 = var20_6 % 100;
                                    if (var49_46 <= 50) ** GOTO lbl167
                                    if (var18_39 < 50) {
                                        var23_9 = var20_6 + 100 - var49_46 + var18_39;
                                        break;
                                    }
                                    ** GOTO lbl170
lbl167:
                                    // 1 sources

                                    if (var18_39 >= 50) {
                                        var23_9 = var20_6 - 100 - var49_46 + var18_39;
                                        break;
                                    }
                                }
lbl170:
                                // 4 sources

                                case 6: {
                                    var23_9 = var20_6 - var20_6 % 100 + var18_39;
                                    break;
                                }
                                case 4: {
                                    var23_9 = var20_6 - var20_6 % 10 + var18_39;
                                    break;
                                }
                                case 8: {
                                    var23_9 = var20_6 - var20_6 % 1000 + var18_39;
                                    break;
                                }
                                case 47: {
                                    var40_23 = var18_39;
                                    break;
                                }
                                case 48: {
                                    var41_22 = var18_39;
                                    break;
                                }
                                default: {
                                    var15_38 = 5002;
                                    break;
                                }
                            }
                            break block139;
                        }
                        switch (var12_35) {
                            case 35: {
                                if (this.locale.equals(Locale.US)) {
                                    if (var1_1.regionMatches(true, var5_32, "a.m.", 0, 4)) {
                                        var34_15 = 0;
                                        var2_2.setIndex(var5_32 + 4);
                                        break;
                                    }
                                    if (var1_1.regionMatches(true, var5_32, "p.m.", 0, 4)) {
                                        var34_15 = 1;
                                        var2_2.setIndex(var5_32 + 4);
                                        break;
                                    }
                                    var15_38 = 5055;
                                    break;
                                }
                            }
                            case 34: {
                                var8_33 = this.symbols.getAmPmStringsRaw()[0].length();
                                if (var7_30 - var5_32 >= var8_33 && var1_1.regionMatches(true, var5_32, this.symbols.getAmPmStringsRaw()[0], 0, var8_33)) {
                                    var34_15 = 0;
                                } else {
                                    var8_33 = this.symbols.getAmPmStringsRaw()[1].length();
                                    if (var7_30 - var5_32 >= var8_33 && var1_1.regionMatches(true, var5_32, this.symbols.getAmPmStringsRaw()[1], 0, var8_33)) {
                                        var34_15 = 1;
                                    } else {
                                        var15_38 = 5055;
                                    }
                                }
                                var2_2.setIndex(var5_32 + var8_33);
                                break;
                            }
                            case 37: {
                                if (this.locale.equals(Locale.US)) {
                                    if (var5_32 + 4 <= var7_30 && var1_1.regionMatches(true, var5_32, "a.d.", 0, 4)) {
                                        var35_14 = 1;
                                        var2_2.setIndex(var5_32 + 4);
                                        break;
                                    }
                                    if (var5_32 + 4 <= var7_30 && var1_1.regionMatches(true, var5_32, "b.c.", 0, 4)) {
                                        var35_14 = 0;
                                        var2_2.setIndex(var5_32 + 4);
                                        break;
                                    }
                                    var15_38 = 5056;
                                    break;
                                }
                            }
                            case 36: {
                                var8_33 = this.symbols.getErasRaw()[0].length();
                                if (var7_30 - var5_32 >= var8_33 && var1_1.regionMatches(true, var5_32, this.symbols.getErasRaw()[0], 0, var8_33)) {
                                    var35_14 = 0;
                                } else {
                                    var8_33 = this.symbols.getErasRaw()[1].length();
                                    if (var7_30 - var5_32 >= var8_33 && var1_1.regionMatches(true, var5_32, this.symbols.getErasRaw()[1], 0, var8_33)) {
                                        var35_14 = 1;
                                    } else {
                                        var15_38 = 5056;
                                        break;
                                    }
                                }
                                var2_2.setIndex(var5_32 + var8_33);
                                break;
                            }
                            case 43: 
                            case 44: {
                                break;
                            }
                            case 31: {
                                var24_8 = this.toMonthNumber(var1_1, var7_30, var2_2, var42_27, false);
                                if (var24_8 >= 0) break;
                                var15_38 = 5043;
                                break;
                            }
                            case 30: {
                                var24_8 = this.toMonthNumber(var1_1, var7_30, var2_2, var42_27, true);
                                if (var24_8 >= 0) break;
                                var15_38 = 5043;
                                break;
                            }
                            case 33: {
                                var30_17 = this.findName(var1_1, var7_30, var2_2, this.symbols.getShortWeekdaysRaw());
                                if (var30_17 < 0) {
                                    var15_38 = 5046;
                                    break;
                                }
                                ++var30_17;
                                break;
                            }
                            case 32: {
                                var30_17 = this.findName(var1_1, var7_30, var2_2, this.symbols.getWeekdaysRaw());
                                if (var30_17 < 0) {
                                    var15_38 = 5046;
                                    break;
                                }
                                ++var30_17;
                                break;
                            }
                            case 50: {
                                if (var40_23 != -2147483648 || var41_22 != -2147483648) {
                                    var15_38 = 5057;
                                    break;
                                }
                                var39_24 = this.getTimeZoneOffset(var1_1, var7_30, var2_2, var12_35, var42_27, (var13_36 & 16) == 0);
                                if (var39_24 != -2147483648 || (var37_21 = this.getTimeZoneID(var1_1, var7_30, var2_2)) != null) break;
                                var15_38 = 5057;
                                break;
                            }
                            case 49: {
                                if (var40_23 != -2147483648 || var41_22 != -2147483648) {
                                    var15_38 = 5057;
                                }
                                if ((var38_20 = this.getTimeZoneAbbr(var1_1, var7_30, var2_2)) != null) break;
                                var15_38 = 5057;
                                break;
                            }
                            default: {
                                var15_38 = 5091;
                            }
                        }
                    }
                    if (var15_38 <= 0) continue;
                }
                if (var15_38 == 0 && var2_2.getIndex() < var7_30) {
                    if (var42_27) {
                        var15_38 = 5030;
                    } else {
                        for (var5_32 = var2_2.getIndex(); var5_32 < var7_30 && Character.isWhitespace(var1_1.charAt(var5_32)); ++var5_32) {
                        }
                        if (var5_32 < var7_30) {
                            var15_38 = 5030;
                        }
                    }
                }
                if (var15_38 <= 0) break block137;
                if (!var43_28) break;
                var10_31 = var11_5;
                var17_26 = var2_2.getIndex();
                var2_2.setIndex(var6_29);
                var43_28 = false;
                var16_25 = var15_38;
            }
            if (var16_25 > 0) {
                var2_2.setErrorIndex(var17_26);
                return var16_25;
            }
            var2_2.setErrorIndex(var2_2.getIndex());
            return var15_38;
        }
        if (var34_15 != -2147483648 && var26_13 != -2147483648) {
            if (var26_13 == 12) {
                var26_13 = 0;
            } else if (var34_15 == 1) {
                var26_13 += 12;
            }
        }
        var22_50 = 1;
        if (var32_16 > 0) {
            var3_3.clear();
            var15_38 = this.julianToCalendar(var32_16, var3_3);
            if (var15_38 > 0) {
                return var15_38;
            }
            var22_50 = var3_3.get(5);
        }
        var19_51 = var3_3.get(0);
        var20_6 = var3_3.get(1);
        var21_52 = var3_3.get(2);
        if (var35_14 != -2147483648) {
            if (var32_16 > 0 && var35_14 != var19_51) {
                return 5031;
            }
        } else {
            var35_14 = var19_51;
        }
        if (var23_9 == -2147483648) {
            var23_9 = var20_6;
        } else if (var32_16 > 0 && var23_9 != var20_6) {
            return 5031;
        }
        if (var23_9 == 0) {
            return 5041;
        }
        if (var31_18 > 0) {
            var3_3.clear();
            var3_3.set(1, var23_9);
            var3_3.set(6, var31_18);
            var21_52 = var3_3.get(2);
            var22_50 = var3_3.get(5);
        }
        if (var24_8 != -2147483648) {
            if ((var31_18 > 0 || var32_16 > 0) && var24_8 != var21_52) {
                return 5033;
            }
        } else {
            var24_8 = var21_52;
        }
        if (var25_7 != -2147483648) {
            if ((var31_18 > 0 || var32_16 > 0) && var25_7 != var22_50) {
                return 5034;
            }
        } else {
            var25_7 = var22_50;
        }
        if (var33_10 != -2147483648) {
            var44_41 = var33_10 / 3600;
            var45_42 = var33_10 % 3600 / 60;
            var46_43 = var33_10 % 3600 % 60;
            if (var26_13 != -2147483648) {
                if (var26_13 != var44_41) {
                    return 5036;
                }
            } else {
                var26_13 = var44_41;
            }
            if (var27_12 != -2147483648) {
                if (var27_12 != var45_42) {
                    return 5037;
                }
            } else {
                var27_12 = var45_42;
            }
            if (var28_11 != -2147483648) {
                if (var28_11 != var46_43) {
                    return 5038;
                }
            } else {
                var28_11 = var46_43;
            }
        } else {
            if (var26_13 == -2147483648) {
                var26_13 = 0;
            }
            if (var27_12 == -2147483648) {
                var27_12 = 0;
            }
            if (var28_11 == -2147483648) {
                var28_11 = 0;
            }
        }
        if (var23_9 == 1582 && var24_8 == 9 && var25_7 >= 5 && var25_7 < 15) {
            var25_7 = 15;
        }
        var3_3.clear();
        if (var23_9 < 0) {
            var3_3.set(-var23_9, var24_8, var25_7, var26_13, var27_12, var28_11);
            var3_3.set(0, 0);
        } else {
            var3_3.set(var23_9, var24_8, var25_7, var26_13, var27_12, var28_11);
            if (var35_14 != -2147483648) {
                var3_3.set(0, var35_14);
            }
        }
        if (var39_24 != -2147483648) {
            var3_3.setTimeZone(TimeZone.getTimeZone("GMT"));
            var3_3.set(15, var39_24);
        } else if (var40_23 != -2147483648 || var41_22 != -2147483648) {
            if (var40_23 == -2147483648 && ((var40_23 = this.calendar.get(15) / 3600000) > 0 && var41_22 < 0 || var40_23 < 0 && var41_22 > 0)) {
                return 5057;
            }
            if (var41_22 == -2147483648) {
                var41_22 = this.calendar.get(15) % 60000;
            }
            var39_24 = var40_23 * 3600000;
            if (var41_22 != 0) {
                var39_24 += var41_22 * 60000;
            }
            var3_3.setTimeZone(TimeZone.getTimeZone("GMT"));
            var3_3.set(15, var39_24);
        } else if (!this.setTimeZone(var37_21, var38_20, var3_3, this.locale)) {
            return 5057;
        }
        if (var30_17 > 0 && var3_3.get(7) != var30_17) {
            return 5035;
        }
        return 0;
    }

    private int getTimeZoneOffset(String string, int n, ParsePosition parsePosition, int n2, boolean bl, boolean bl2) {
        int n3 = Integer.MIN_VALUE;
        int n4 = parsePosition.getIndex();
        boolean bl3 = false;
        if (n4 >= n) {
            return Integer.MIN_VALUE;
        }
        char c = string.charAt(n4);
        if (c == ':') {
            if (++n4 >= n) {
                return Integer.MIN_VALUE;
            }
            parsePosition.setIndex(n4);
            c = string.charAt(n4);
            bl3 = true;
        }
        if (Character.isDigit(c) || n4 + 2 <= n && (c == '+' || c == '-')) {
            boolean bl4;
            n3 = 0;
            int n5 = 0;
            int n6 = 0;
            if (c == '-') {
                bl4 = true;
                ++n4;
            } else {
                bl4 = false;
                if (c == '+') {
                    ++n4;
                }
            }
            parsePosition.setIndex(n4);
            n6 = this.toNumber(string, n, parsePosition, 2, false, bl, bl2);
            if (n6 >= 0) {
                if (bl3) {
                    n5 = n6;
                    int[] nArray = OraDateFormatPattern.FORMAT_ATTR[48];
                    if (bl4 && -n5 < nArray[1] || !bl4 && n5 > nArray[2]) {
                        return Integer.MIN_VALUE;
                    }
                    n3 = n5 * 60000;
                } else {
                    int[] nArray = OraDateFormatPattern.FORMAT_ATTR[47];
                    if (bl4 && -n6 < nArray[1] || !bl4 && n6 > nArray[2]) {
                        return Integer.MIN_VALUE;
                    }
                    n3 = n6 * 3600000;
                    n4 = parsePosition.getIndex();
                    if (n4 < n && string.charAt(n4) == ':') {
                        parsePosition.setIndex(++n4);
                    }
                    if (n4 < n && string.charAt(n4) == '+') {
                        parsePosition.setIndex(++n4);
                    }
                    if (n4 < n && (n5 = this.toNumber(string, n, parsePosition, 2, false, bl, bl2)) >= 0) {
                        nArray = OraDateFormatPattern.FORMAT_ATTR[48];
                        if (n5 < nArray[1] || n5 > nArray[2]) {
                            return Integer.MIN_VALUE;
                        }
                        n3 += n5 * 60000;
                    }
                }
            }
            if (bl4) {
                n3 = -n3;
            }
        }
        return n3;
    }

    private String getTimeZoneID(String string, int n, ParsePosition parsePosition) {
        String[] stringArray = TimeZone.getAvailableIDs();
        int n2 = parsePosition.getIndex();
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = stringArray[i].length();
            if (n2 + n3 > n || !string.regionMatches(true, n2, stringArray[i], 0, n3)) continue;
            parsePosition.setIndex(n2 + n3);
            return stringArray[i];
        }
        return null;
    }

    private String getTimeZoneAbbr(String string, int n, ParsePosition parsePosition) {
        int n2 = parsePosition.getIndex();
        if (n2 + 3 > n) {
            return null;
        }
        parsePosition.setIndex(n2 + 3);
        return string.substring(n2, n2 + 3);
    }

    private boolean setTimeZone(String string, String string2, Calendar calendar, Locale locale) {
        TimeZone timeZone;
        if (string != null) {
            timeZone = TimeZone.getTimeZone(string);
            calendar.setTimeZone(timeZone);
        } else {
            timeZone = calendar.getTimeZone();
        }
        if (string2 != null) {
            if (timeZone.getDisplayName(true, 0, locale).equals(string2) && !timeZone.inDaylightTime(calendar.getTime())) {
                return false;
            }
            if (timeZone.getDisplayName(false, 0, locale).equals(string2) && timeZone.inDaylightTime(calendar.getTime())) {
                return false;
            }
        }
        return true;
    }

    private int toMonthNumber(String string, int n, ParsePosition parsePosition, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                return this.findName(string, n, parsePosition, this.symbols.getMonthsRaw());
            }
            return this.findName(string, n, parsePosition, this.symbols.getShortMonthsRaw());
        }
        int n2 = this.findName(string, n, parsePosition, this.symbols.getMonthsRaw());
        if (n2 < 0) {
            return this.findName(string, n, parsePosition, this.symbols.getShortMonthsRaw());
        }
        return n2;
    }

    private int findName(String string, int n, ParsePosition parsePosition, String[] stringArray) {
        int n2 = parsePosition.getIndex();
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = stringArray[i].length();
            if (n3 > n || stringArray[i].equals("") || !string.regionMatches(true, n2, stringArray[i], 0, n3)) continue;
            parsePosition.setIndex(n2 + n3);
            return i;
        }
        return -1;
    }

    private String toTitleCase(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c)) {
                stringBuffer.append(c);
                if (bl) continue;
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer.append(Character.toTitleCase(c));
                bl = false;
                continue;
            }
            stringBuffer.append(Character.toLowerCase(c));
        }
        return stringBuffer.toString();
    }

    private int toNumber(String string, int n, ParsePosition parsePosition, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        int n4 = parsePosition.getIndex();
        char c = string.charAt(n4);
        if (!Character.isDigit(c)) {
            return -5058;
        }
        int n5 = Character.digit(c, 10);
        ++n4;
        for (n3 = 1; n3 < n2 && n4 < n; ++n3, ++n4) {
            c = string.charAt(n4);
            if (c == this.symbols.getGroupingSeparator()) {
                if (bl) continue;
                break;
            }
            if (!Character.isDigit(c)) break;
            n5 = n5 * 10 + Character.digit(c, 10);
        }
        if (bl2 && !bl3 && n3 != n2) {
            return -5062;
        }
        parsePosition.setIndex(n4);
        return n5;
    }

    private String toNanosString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(9);
        String string = String.valueOf(n);
        for (int i = string.length(); i < 9; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.substring(0, n2);
    }

    private String toNumericString(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n2 & 0x10) != 0 && (n3 > 0 || n > 1000)) {
            stringBuffer.append(n / 1000);
            stringBuffer.append(this.symbols.getGroupingSeparator());
            n %= 1000;
            n3 = n3 > 0 ? (n3 -= 2) : 3;
        }
        String string = String.valueOf(n);
        for (int i = n3 - string.length() - 1; i >= 0; --i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private int toJulianDay(Calendar calendar) {
        int n;
        int n2;
        int n3 = calendar.get(0) == 1 ? calendar.get(1) : -calendar.get(1);
        if (n3 < -4712 || n3 > 9999) {
            return -5041;
        }
        if (n3 == -4712) {
            n2 = 0;
        } else {
            n2 = n3 + 4712;
            n2 = 365 * n2 + (n2 - 1) / 4;
        }
        if (n3 >= 1583) {
            n2 = n2 - 10 - (n3 - 1501) / 100 + (n3 - 1201) / 400;
        }
        n2 += calendar.get(6);
        if (n3 == 1582 && ((n = calendar.get(2)) == 9 && calendar.get(5) >= 15 || n >= 10)) {
            n2 -= 10;
        }
        return n2;
    }

    private int julianToCalendar(int n, Calendar calendar) {
        if (n < 1) {
            int n2 = 5054;
        } else {
            if (n < 366) {
                int n3 = 4712;
                calendar.set(0, 0);
                calendar.set(1, n3);
                calendar.set(6, n);
                return 0;
            }
            if (n < 2299161) {
                int n4 = -4711 + (n -= 366) / 1461 * 4;
                int n5 = (n %= 1461) / 365;
                int n6 = n % 365;
                if (n6 == 0 && n5 == 4) {
                    n6 = 366;
                    n5 = 3;
                } else {
                    ++n6;
                }
                if ((n4 += n5) < 0) {
                    calendar.set(0, 0);
                    calendar.set(1, -n4);
                } else {
                    calendar.set(0, 1);
                    calendar.set(1, n4);
                }
                calendar.set(6, n6);
                return 0;
            }
            n = 4 * (n - 1721119) - 1;
            int n7 = n / 146097;
            int n8 = (n %= 146097) / 4;
            n = 4 * n8 + 3;
            n8 = n % 1461;
            n /= 1461;
            n8 /= 4;
            int n9 = 5 * ++n8 - 3;
            n8 = n9 % 153;
            n8 /= 5;
            ++n8;
            n7 *= 100;
            n7 += n;
            if ((n9 /= 153) < 10) {
                n9 += 3;
            } else {
                n9 -= 9;
                ++n7;
            }
            calendar.set(n7, n9 - 1, n8);
        }
        return 0;
    }
}

