/*
 * Decompiled with CFR 0.152.
 */
package oracle.report.addin;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.ResultsPanel;
import oracle.dbtools.raptor.controls.BindInfo;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.util.Debug;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.runner.run.RunArb;
import oracle.report.navigator.Report;
import oracle.report.navigator.ReportNode;

public class ReportEditor
extends Editor
implements Controller,
IDBEditor {
    private ResultsPanel _panel;
    private ResultSetTableModel _model;
    private Toolbar _toolbar;
    private DBConnectionComboBox _dbConns;
    private String _dbName;
    private boolean runReport = false;
    private boolean validQuery = true;
    JEWTDialog dlg;
    private boolean _isPinned = false;
    private IdeAction pinAction = IdeAction.get((int)PIN_EDITOR_CMD_ID, null, (String)IdeArb.getString((int)29), null, null, (Icon)IdeArb.getIcon((int)31), null, (boolean)true).newLocalAction((View)this);
    static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"VE_Pin_Editor");

    public ReportEditor() {
        this.pinAction.addController((Controller)this);
        this.init();
    }

    public ResultSetTableModel getModel() {
        return this._model;
    }

    public void raise() {
        EditorManager.getEditorManager().openEditor(new OpenEditorOptions(this.getContext()));
    }

    public Component getGUI() {
        this.init();
        return this._panel;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public Report getReport() {
        if (this.getContext().getNode() != null && this.getContext().getNode() instanceof ReportNode) {
            return ((ReportNode)this.getContext().getNode()).getReport();
        }
        return null;
    }

    public void setReport(Report report) {
        ((ReportNode)this.getContext().getNode()).setReport(report);
        this.updateContent();
    }

    public void openSQLEditor() {
        SqlEditor sqlEditor = SqlEditor.openNewEditor((String)this._dbConns.getCurrentConnectionName());
        sqlEditor.setDb(this._dbConns.getCurrentDatabase());
        try {
            sqlEditor.setText(this.getReport().getQuery(this.getConnection(this._dbName)).getSql());
        }
        catch (IOException e) {
            Debug.debug((Object)Translate.translate((String)"Unable to determine connection"));
        }
    }

    private void buildToolbar() {
        this._toolbar.addToggleButton((ToggleAction)this.pinAction);
        AbstractAction run = new AbstractAction("Run Report", RunArb.getIcon((int)3)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ReportEditor.this.updateContent();
            }
        };
        run.putValue("ShortDescription", "Run Report");
        this._toolbar.add((Action)run);
        this._toolbar.addSeparator();
        AbstractAction sqlWorksheet = new AbstractAction("Run Report in SQLWorksheet", CommonArb.getIcon((int)0)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ReportEditor.this.openSQLEditor();
            }
        };
        sqlWorksheet.putValue("ShortDescription", "Run Report in SQLWorksheet");
        this._toolbar.add((Action)sqlWorksheet);
        this._dbConns = new DBConnectionComboBox();
        this._dbConns.getJComboBox().setSize(50, 20);
        this._toolbar.add(Box.createHorizontalGlue());
        this._toolbar.add((Component)this._dbConns.getJComboBox(), (Object)"Center");
    }

    private Connection getConnection(String name) throws IOException {
        return this._dbConns.getConnection(name);
    }

    private void init() {
        if (this._panel == null) {
            this._panel = new ResultsPanel();
            this._toolbar = this._panel.getToolbar();
            this.buildToolbar();
            this._dbName = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((int)165), (String)ConnectionArb.getString((int)164), (String)this._dbName, (String)"CLASS_DATABASE", (boolean)true);
            if (this._dbName == null) {
                return;
            }
            this._dbConns.setCurrentConnection(this._dbName);
            this._dbConns.getJComboBox().addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ReportEditor.this._dbName = ReportEditor.this._dbConns.getCurrentConnectionName();
                        if (ReportEditor.this.getContext().getNode() != null && ReportEditor.this.getContext().getNode() instanceof ReportNode) {
                            ReportEditor.this.updateContent();
                        }
                    }
                }
            });
        }
    }

    protected void updateContent() {
        try {
            this.runReport = false;
            this.validQuery = true;
            if (this._dbName == null) {
                return;
            }
            Ide.getStatusBar().setText(Translate.translate((String)"Executing_Report"));
            Query query = this.getReport().getQuery(this.getConnection(this._dbName));
            if (query == null) {
                this.runReport = false;
                this.validQuery = false;
                JLabel msg = new JLabel(Translate.translate((String)"No query found for version of the selected database."));
                this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)msg, null, (String)Translate.translate((String)"No Valid Query"), (int)1);
                this.dlg.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ReportEditor.this.dlg.dispose();
                    }
                });
                this.dlg.setSize(500, 150);
                this.dlg.setPreferredSize(this._panel.getPreferredSize());
                IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
                this.dlg.setVisible(true);
            }
            if (this.validQuery) {
                if (query.getBindValues().size() > 0) {
                    BindInfo _panel = new BindInfo(query);
                    this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)_panel, null, (String)Translate.translate((String)"Enter Bind Values"), (int)10);
                    this.dlg.setDefaultButton(8);
                    this.dlg.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            ReportEditor.this.runReport = true;
                            ReportEditor.this.dlg.dispose();
                        }
                    });
                    this.dlg.setSize(800, 300);
                    this.dlg.setPreferredSize(_panel.getPreferredSize());
                    IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
                    this.dlg.setResizable(false);
                    this.dlg.setVisible(true);
                } else {
                    this.runReport = true;
                }
                if (!this.runReport) {
                    return;
                }
                long start = System.currentTimeMillis();
                this._panel.getTable().getAction().setConn(this.getConnection(this._dbName));
                this._panel.getTable().getAction().setSql(query.getSql());
                this._panel.getTable().getAction().setBindMap(query.getBindValues());
                this._model = new ResultSetTableModel(this.getConnection(this._dbName), null, query);
                this._panel.setTableModel(this._model);
                this._panel.getTable().setDefaultExportName(this.getReport().getName());
                Ide.getStatusBar().setText(Translate.translate((String)"Report Execution Time:") + (System.currentTimeMillis() - start) + Translate.translate((String)"ms"));
            }
        }
        catch (IOException e) {
            System.err.println("Report Editor Error:" + e.getMessage());
        }
    }

    public String getTitleLabel() {
        return this.getReport().getName();
    }

    public String getTabLabel() {
        return this.getReport().getName();
    }

    public String getTabDescription() {
        return this.getReport().getDescription();
    }

    public Object getEditorAttribute(String attribute) {
        boolean scrollable = false;
        if ("horizontal_scrollbar_policy".equals(attribute) && !scrollable) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(attribute) && !scrollable) {
            return new Integer(21);
        }
        if ("scrollable".equals(attribute) && !scrollable) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(attribute);
    }

    public void close() {
        super.close();
        try {
            ArrayList<ReportEditor> a = new ArrayList<ReportEditor>();
            a.add(this);
            EditorManager.getEditorManager().closeEditors(a);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPinned(boolean pinned) {
        this._isPinned = pinned;
    }

    public boolean getPinned() {
        return this._isPinned;
    }

    public boolean getRunReport() {
        return this.runReport;
    }

    public boolean update(IdeAction action, Context context) {
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        this.setPinned(!this.getPinned());
        this.pinAction.setState(this.getPinned());
        return true;
    }

    public void editorShown() {
        ReportEditor.updateToolbarActions((Toolbar)this._toolbar);
        this.pinAction.setState(this.getPinned());
    }

    public void editorHidden() {
        ReportEditor.updateToolbarActions((Toolbar)this._toolbar);
        this.pinAction.setState(this.getPinned());
    }

    public void open() {
    }

    public Database getDatabase() {
        return this._dbConns.getCurrentDatabase();
    }

    public Connection getConnection() {
        return this._dbConns.getCurrentConnection();
    }
}

