/*
 * Decompiled with CFR 0.152.
 */
package oracle.report.navigator;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.utils.Translate;
import oracle.report.navigator.GenericTransferable;
import oracle.report.navigator.ReportTree;
import oracle.report.navigator.TreeDropTarget;
import oracle.report.navigator.TreeNode;

public class NodeMoveTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    ReportTree dataTree = null;
    private MutableTreeNode draggedNode;
    private TreePath dragPath;

    protected Transferable createTransferable(JComponent c) {
        GenericTransferable t = null;
        if (c instanceof ReportTree) {
            this.dataTree = (ReportTree)c;
            t = new GenericTransferable(this.dataTree.getSelectionPaths());
            this.dragPath = this.dataTree.getSelectionPath();
            if (this.dragPath != null) {
                this.draggedNode = (MutableTreeNode)this.dragPath.getLastPathComponent();
            }
        }
        return t;
    }

    protected void exportDone(JComponent source, Transferable data, int action) {
        if (source instanceof ReportTree) {
            ReportTree tree = (ReportTree)source;
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            TreePath currentPath = tree.getSelectionPath();
            if (currentPath != null) {
                this.addNodes(currentPath, model, data);
            } else {
                this.insertNodes(tree, model, data);
            }
            tree.saveUserDef((TreeNode)model.getRoot());
        }
        this.draggedNode = null;
        super.exportDone(source, data, action);
    }

    public void handleNode2(TreeNode newNode, TreeNode oldNode) {
        for (int i = 0; i < oldNode.getChildCount(); ++i) {
            TreeNode cNode = this.dataTree.newNode((TreeNode)oldNode.getChildAt(i));
            newNode.add(cNode);
            if (!newNode.getType().equals("folder")) continue;
            this.handleNode2(newNode, cNode);
        }
    }

    private void addNodes(TreePath currentPath, DefaultTreeModel model, Transferable data) {
        MutableTreeNode targetNode = (MutableTreeNode)currentPath.getLastPathComponent();
        try {
            TreePath[] movedPaths = (TreePath[])data.getTransferData(DataFlavor.stringFlavor);
            for (int i = 0; i < movedPaths.length; ++i) {
                MutableTreeNode moveNode = (MutableTreeNode)movedPaths[i].getLastPathComponent();
                TreeNode node = (TreeNode)movedPaths[i].getLastPathComponent();
                TreeNode newNode = this.dataTree.newNode(node);
                for (int z = 0; z < node.getChildCount(); ++z) {
                    TreeNode cNode = this.dataTree.newNode((TreeNode)node.getChildAt(z));
                    if (cNode.getType().equals("folder")) {
                        this.handleNode2(cNode, (TreeNode)node.getChildAt(i));
                    }
                    newNode.add(cNode);
                }
                if (!targetNode.getAllowsChildren()) continue;
                javax.swing.tree.TreeNode[] tPath = node.getPath();
                for (int x = 0; x < tPath.length; ++x) {
                    if (!tPath[x].toString().equals(Translate.translate((String)"User Defined Reports"))) continue;
                    model.removeNodeFromParent(moveNode);
                }
                if (moveNode.equals(targetNode)) continue;
                String name = this.dataTree.checkName(newNode, (TreeNode)targetNode);
                newNode.setName(name);
                model.insertNodeInto(newNode, targetNode, targetNode.getChildCount());
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void insertNodes(JTree tree, DefaultTreeModel model, Transferable data) {
        Point location = ((TreeDropTarget)tree.getDropTarget()).getMostRecentDragLocation();
        TreePath path = tree.getClosestPathForLocation(location.x, location.y);
        MutableTreeNode targetNode = (MutableTreeNode)path.getLastPathComponent();
        MutableTreeNode parent = (MutableTreeNode)targetNode.getParent();
        try {
            TreePath[] movedPaths = (TreePath[])data.getTransferData(DataFlavor.stringFlavor);
            for (int i = 0; i < movedPaths.length; ++i) {
                MutableTreeNode moveNode = (MutableTreeNode)movedPaths[i].getLastPathComponent();
                TreeNode node = (TreeNode)movedPaths[i].getLastPathComponent();
                TreeNode newNode = this.dataTree.newNode(node);
                for (int z = 0; z < node.getChildCount(); ++z) {
                    TreeNode cNode = this.dataTree.newNode((TreeNode)node.getChildAt(z));
                    if (cNode.getType().equals("folder")) {
                        this.handleNode2(cNode, (TreeNode)node.getChildAt(i));
                    }
                    newNode.add(cNode);
                }
                javax.swing.tree.TreeNode[] tPath = node.getPath();
                for (int x = 0; x < tPath.length; ++x) {
                    if (!tPath[x].toString().equals(Translate.translate((String)"User Defined Reports"))) continue;
                    model.removeNodeFromParent(moveNode);
                }
                if (moveNode.equals(targetNode)) continue;
                String name = this.dataTree.checkName(newNode, (TreeNode)parent);
                newNode.setName(name);
                model.insertNodeInto(newNode, parent, model.getIndexOfChild(parent, targetNode));
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getSourceActions(JComponent c) {
        return 2;
    }

    public BufferedImage getDragImage(JTree tree) {
        BufferedImage image = null;
        try {
            if (this.dragPath != null) {
                Rectangle pathBounds = tree.getPathBounds(this.dragPath);
                TreeCellRenderer r = tree.getCellRenderer();
                DefaultTreeModel m = (DefaultTreeModel)tree.getModel();
                boolean nIsLeaf = m.isLeaf(this.dragPath.getLastPathComponent());
                JComponent lbl = (JComponent)r.getTreeCellRendererComponent(tree, this.draggedNode, false, tree.isExpanded(this.dragPath), nIsLeaf, 0, false);
                lbl.setBounds(pathBounds);
                image = new BufferedImage(lbl.getWidth(), lbl.getHeight(), 3);
                Graphics2D graphics = image.createGraphics();
                graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
                lbl.setOpaque(false);
                lbl.paint(graphics);
                graphics.dispose();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return image;
    }
}

