/*
 * Decompiled with CFR 0.152.
 */
package oracle.report.navigator;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Debug;
import oracle.ide.model.UpdateMessage;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Report {
    private String name;
    private String description;
    private String tooltip;
    private String type;
    private ArrayList<Query> query;
    private boolean _enable;
    public static final int RELATION_NODE_CHANGED_MESSAGE_ID = UpdateMessage.newMessageID((String)(Report.class.getName() + ".reportChanged"));
    private float dbVersion;
    Connection conn;
    private String drillClass;

    public Report() {
        this(null);
    }

    public Report(Node node) {
        if (node != null) {
            this.name = XMLHelper.getNodeValue((Node)node, (String)"name");
            this.description = XMLHelper.getNodeValue((Node)node, (String)"description");
            this.tooltip = XMLHelper.getNodeValue((Node)node, (String)"tooltip");
            this.drillClass = XMLHelper.getNodeValue((Node)node, (String)"drillClass");
            String enabled = "true";
            if (XMLHelper.getAttributeNode((Node)node, (String)"enable") != null) {
                enabled = XMLHelper.getAttributeNode((Node)node, (String)"enable");
            }
            this.setEnable(enabled);
        }
    }

    public Report(String nm, String descr, String enable, String tip) {
        this.name = nm;
        this.description = descr;
        this.tooltip = tip;
        this.setEnable(enable);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setEnable(String enable) {
        this._enable = Boolean.parseBoolean(enable);
    }

    public void setEnable(Boolean enable) {
        this._enable = enable;
    }

    public boolean getEnable() {
        return this._enable;
    }

    public String getUrlName() {
        String s = this.name;
        String ret = null;
        ret = s.replace(' ', '_');
        return ret;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setQuery(ArrayList<Query> query) {
        this.query = query;
    }

    private void getDbVersion() {
        int minor = 0;
        int major = 0;
        this.dbVersion = 0.0f;
        try {
            minor = this.conn.getMetaData().getDatabaseMinorVersion();
            major = this.conn.getMetaData().getDatabaseMajorVersion();
            this.dbVersion = Float.parseFloat(major + "." + minor);
        }
        catch (SQLException e) {
            Debug.error((Object)"could_not_detect_db_version");
        }
    }

    private boolean checkVersion(Query query) {
        boolean ret = false;
        float minver = 0.0f;
        float maxver = 0.0f;
        if (this.dbVersion == 0.0f) {
            this.getDbVersion();
        }
        minver = query.getMinversion();
        maxver = query.getMaxversion();
        if ((double)this.dbVersion == 0.0 || ((double)minver == 0.0 || minver != 0.0f && minver <= this.dbVersion) && ((double)maxver == 0.0 || maxver != 0.0f && maxver >= this.dbVersion)) {
            ret = true;
        }
        return ret;
    }

    public Query getQuery(Connection dbConn) {
        this.conn = dbConn;
        for (int i = 0; i < this.query.size(); ++i) {
            if (!this.checkVersion(this.query.get(i))) continue;
            return this.query.get(i);
        }
        return null;
    }

    public Query getQuery() {
        return this.query.get(0);
    }

    public ArrayList<Query> getQueryList() {
        return this.query;
    }

    public String getLongLabel() {
        return this.name;
    }

    public String getShortLabel() {
        return this.name;
    }

    public Icon getIcon() {
        return ConnectionArb.getIcon((int)166);
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t<report");
        if (this.type != null) {
            sb.append(" type=\"" + this.type + "\"");
        }
        if (this._enable) {
            sb.append(" enabled=\"true\"");
        }
        if (!this._enable) {
            sb.append(" enabled=\"false\"");
        }
        sb.append(">\n");
        sb.append("\t\t<name><![CDATA[" + this.name + "]]></name>\n");
        sb.append("\t\t<description><![CDATA[" + this.description + "]]></description>\n");
        sb.append("\t\t<tooltip><![CDATA[" + this.tooltip + "]]></tooltip>\n");
        if (this.query.size() > 0) {
            for (Query q : this.query) {
                sb.append(q.toXML());
            }
        }
        sb.append("\t</report>\n");
        return sb.toString();
    }

    public String getDrillClass() {
        return this.drillClass;
    }

    public void setDrillClass(String drillClass) {
        this.drillClass = drillClass;
    }
}

