/*
 * Decompiled with CFR 0.152.
 */
package oracle.report.navigator;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.Assert;
import oracle.report.addin.ReportAddin;
import oracle.report.navigator.Folder;
import oracle.report.navigator.Report;
import oracle.report.navigator.ReportNavigatorWindow;
import oracle.report.navigator.TreeController;
import oracle.report.navigator.TreeNode;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReportTree
extends JTree {
    private static final long serialVersionUID = 1L;
    public static final int RELATION_NODE_CHANGED_MESSAGE_ID = UpdateMessage.newMessageID((String)(ReportTree.class.getName() + ".relationNodeChanged"));
    TreeNode oldNode = null;
    private TreeNode _sharedNode;
    JTree tree;
    TreePath path;
    TreePath oldPath;
    TreeNode node;
    TreeNode root;
    private ContextMenu _menu = null;
    Element domRoot = null;
    private File file = new File(Resource.raptorUser.getAbsolutePath() + File.separator + "UserReports.xml");

    public ReportTree(TreeNode dmtn, String dummy) {
        super(dmtn);
        this.root = dmtn;
    }

    public ReportTree(TreeNode dmtn) {
        super(dmtn);
        this.root = dmtn;
        this._menu = new ContextMenu();
        this._menu.addContextMenuListener((ContextMenuListener)TreeController.getInstance());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    ReportTree.this.tree = (JTree)e.getComponent();
                    ReportTree.this.oldPath = ReportTree.this.tree.getPathForLocation(e.getX(), e.getY());
                    ReportTree.this.tree.addSelectionPath(ReportTree.this.oldPath);
                }
            }

            public void mouseReleased(MouseEvent e) {
                ReportTree.this.tree = (JTree)e.getComponent();
                ReportTree.this.path = ReportTree.this.tree.getPathForLocation(e.getX(), e.getY());
                if (e.getButton() == 3) {
                    if (ReportTree.this.path != null && ReportTree.this.path.getLastPathComponent() != null && ((TreeNode)ReportTree.this.path.getLastPathComponent()).getType() != null) {
                        TreeNode node = (TreeNode)ReportTree.this.path.getLastPathComponent();
                        Context c = new Context();
                        ReportTree.this.tree = (JTree)e.getComponent();
                        c.setEvent((EventObject)e);
                        c.setProperty("TreeNode", (Object)node);
                        c.setProperty("ReportTree", (Object)ReportTree.this.tree);
                        ReportTree.this._menu.show(c);
                    }
                } else if (e.getButton() == 1 && ReportTree.this.path != null) {
                    Report report;
                    ReportTree.this.node = (TreeNode)ReportTree.this.path.getLastPathComponent();
                    if (ReportTree.this.node.getType() != null && ReportTree.this.node.getType().equalsIgnoreCase("report") && ReportTree.this.oldPath == ReportTree.this.path && (report = ReportTree.this.node.getReport()).getEnable()) {
                        TreeController.getInstance().openReport(report, false);
                    }
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ReportTree.this.tree = (JTree)e.getComponent();
                    ReportTree.this.path = ReportTree.this.tree.getSelectionPath();
                    if (ReportTree.this.path != null) {
                        Report report;
                        ReportTree.this.node = (TreeNode)ReportTree.this.path.getLastPathComponent();
                        if (ReportTree.this.node.getType() != null && ReportTree.this.node.getType().equalsIgnoreCase("report") && (report = ReportTree.this.node.getReport()).getEnable()) {
                            TreeController.getInstance().openReport(report, false);
                        }
                    }
                }
            }
        });
    }

    public TreeNode newNode(TreeNode node) {
        TreeNode nNode = null;
        String tt = node.getToolTipText() == null ? null : node.getToolTipText();
        nNode = new TreeNode(new String(node.getName()), tt);
        if (node.getType().equals("folder")) {
            Folder folder = new Folder(new String(node.getFolder().getName()), new String(node.getFolder().getDescription()));
            nNode.setFolder(folder);
        } else {
            Report oldRep = node.getReport();
            String oldDescr = oldRep.getDescription() != null ? new String(oldRep.getDescription()) : null;
            String oldTT = oldRep.getToolTip() != null ? new String(oldRep.getToolTip()) : null;
            Report report = new Report(new String(node.getReport().getName()), oldDescr, new String(Boolean.toString(node.getReport().getEnable())), oldTT);
            ArrayList<Query> newQueries = new ArrayList<Query>(node.getReport().getQueryList());
            report.setQuery(newQueries);
            nNode.setReport(report);
        }
        nNode.setAllowsChildren(new Boolean(node.getAllowsChildren()));
        nNode.setUserObject(new String((String)node.getUserObject()));
        return nNode;
    }

    public String checkName(TreeNode node, TreeNode parent) {
        String name;
        Boolean valid = false;
        String newName = name = node.getName();
        int x = 0;
        while (!valid.booleanValue()) {
            if (parent.getChildCount() == 0) {
                valid = true;
                continue;
            }
            Boolean found = false;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                if (newName.equals(((TreeNode)parent.getChildAt(i)).getName())) {
                    newName = name + "(" + x + ")";
                    ++x;
                    valid = false;
                    found = true;
                    continue;
                }
                if (found.booleanValue()) continue;
                valid = true;
            }
        }
        return newName;
    }

    public TreeNode getUserRoot(TreeNode root) {
        for (int i = 0; root.getChildCount() > i; ++i) {
            TreeNode treeNode = (TreeNode)root.getChildAt(i);
            if (!treeNode.getType().equals("folder") || !treeNode.getUserObject().toString().equals(Translate.translate((String)"User Defined Reports"))) continue;
            return treeNode;
        }
        return null;
    }

    public void saveUserDef(TreeNode node) {
        TreeNode treeRoot = (TreeNode)node.getRoot();
        TreeNode userRoot = this.getUserRoot(treeRoot);
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));
            out.write("<reports>\n".getBytes());
            this.processFolder(userRoot, out);
            out.write("</reports>\n".getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            System.err.println("OtherException: " + e);
        }
    }

    public void processFolder(TreeNode userRoot, BufferedOutputStream out) throws IOException {
        for (int i = 0; userRoot.getChildCount() > i; ++i) {
            TreeNode treeNode = (TreeNode)userRoot.getChildAt(i);
            if (treeNode.getType().equals("folder")) {
                out.write("\t<folder>\n".getBytes());
                out.write(treeNode.getFolder().toXML(true).getBytes());
                this.processFolder(treeNode, out);
                out.write("\t</folder>\n".getBytes());
                continue;
            }
            if (!treeNode.getType().equals("report")) continue;
            out.write(treeNode.getReport().toXML().getBytes());
        }
    }

    private void processNode(TreeNode parent, Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeName().equalsIgnoreCase("folder")) {
                this.processFolder(parent, children.item(i));
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase("report")) {
                this.processReport(parent, children.item(i));
                continue;
            }
            if (!children.item(i).getNodeName().equalsIgnoreCase(Translate.translate((String)"Reports"))) continue;
            this.processNode(parent, children.item(i));
        }
    }

    private void processFolder(TreeNode parent, Node folder) {
        TreeNode user = null;
        Folder fObject = new Folder(folder);
        TreeNode thisNode = new TreeNode(fObject.getName(), fObject.getTooltip());
        thisNode.setFolder(fObject);
        thisNode.setAllowsChildren(true);
        parent.add(thisNode);
        if (fObject.getName().equals(Translate.translate((String)"User Defined Reports"))) {
            user = thisNode;
            this.parseUserXML(user);
        }
        NodeList children = folder.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeName().equalsIgnoreCase("folder")) {
                this.processFolder(thisNode, children.item(i));
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase("report")) {
                this.processReport(thisNode, children.item(i));
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase("description") || children.item(i).getNodeName().equalsIgnoreCase("name")) continue;
            Assert.print((String)("Folder:Unsupported node in report.xml:" + children.item(i).getNodeName() + "\n"));
        }
    }

    private void processReport(TreeNode parent, Node report) {
        Report rObject = new Report(report);
        rObject.setQuery(Query.getQueries((Node)report));
        TreeNode thisNode = new TreeNode(rObject.getName(), rObject.getToolTip());
        thisNode.setReport(rObject);
        thisNode.setAllowsChildren(false);
        parent.add(thisNode);
    }

    private void parseXML(InputStream xml) {
        DOMParser parser = new DOMParser();
        parser.setPreserveWhitespace(false);
        try {
            parser.parse(xml);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        XMLDocument document = parser.getDocument();
        this.processNode(this.root, (Node)document);
    }

    public void buildTree() {
        this.removeAll();
        this._sharedNode = null;
        this.parseXML(Resource.getResourceAsStream(ReportNavigatorWindow.class, (String)"reports.xml"));
        if (System.getProperty("raptor.shared.reports") != null) {
            String[] files = System.getProperty("raptor.shared.reports").split("[:;]");
            File f = null;
            for (int i = 0; i < files.length; ++i) {
                f = new File(files[i]);
                try {
                    if (!f.exists()) continue;
                    ReportAddin.registerReport(f.toURL());
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Could not load Report File:" + f.toString());
                }
            }
        }
        for (URL url : ReportAddin.getRegisterReport()) {
            try {
                InputStream in = url.openStream();
                this.appendSharedXML(in);
            }
            catch (Exception e) {
                System.err.println("Could not load Report URL:" + url.toString());
            }
        }
    }

    private void parseUserXML(TreeNode node) {
        try {
            DOMParser parser = new DOMParser();
            BufferedReader xml = new BufferedReader(new BufferedReader(new InputStreamReader(new FileInputStream(this.file))));
            parser.parse((Reader)xml);
            XMLDocument document = parser.getDocument();
            this.processNode(node, (Node)document);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void appendSharedXML(InputStream in) {
        try {
            DOMParser parser = new DOMParser();
            BufferedReader xml = new BufferedReader(new BufferedReader(new InputStreamReader(in)));
            if (this._sharedNode == null) {
                TreeNode root = (TreeNode)this.getModel().getRoot();
                Folder fObject = new Folder("Shared Reports", "Shared Reports");
                this._sharedNode = new TreeNode("Shared Reports", "Shared Reports");
                this._sharedNode.setFolder(fObject);
                this._sharedNode.setAllowsChildren(true);
                root.add(this._sharedNode);
            }
            parser.parse((Reader)xml);
            XMLDocument document = parser.getDocument();
            this.processNode(this._sharedNode, (Node)document);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

