/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.graphics.FontUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.inspector.PropertyModel;

class InspectorAppearance
implements PropertyChangeListener {
    private JTable _table;
    private Font _conflictFont;
    private Font _headingFont;
    private boolean _isOracleLookAndFeel;
    private static final int _CONFLICTING_BIT = 1;
    private static final int _READWRITE_BIT = 2;
    private static final int _NUM_BIT_APPEARANCES = 4;
    private static final int _GROUPHEADING_INDEX = 4;
    private static final int _NUM_COLORS = 5;
    private Color[] _backgrounds = new Color[5];
    private Color[] _foregrounds = new Color[5];
    private int _levelColumnIndex = -1;
    private int _valueColumnIndex = -1;
    private int _writableColumnIndex = -1;
    private int _nameColumnIndex = -1;

    public InspectorAppearance(JTable jTable) {
        this._table = jTable;
        this._table.addPropertyChangeListener(this);
        this._computeInfo();
    }

    public void setIndicies(int n, int n2, int n3, int n4) {
        this._nameColumnIndex = n;
        this._levelColumnIndex = n2;
        this._valueColumnIndex = n3;
        this._writableColumnIndex = n4;
    }

    public void prepareRenderer(JTable jTable, boolean bl, boolean bl2, int n, int n2, Component component) {
        Object object;
        if (n2 >= jTable.getColumnCount()) {
            return;
        }
        int n3 = jTable.convertColumnIndexToModel(n2);
        PropertyModel propertyModel = (PropertyModel)this._table.getModel();
        int n4 = 0;
        int n5 = -1;
        if (this._levelColumnIndex != -1) {
            object = propertyModel.getValueAt(n, this._levelColumnIndex);
            int n6 = n5 = object != PropertyModel.DOES_NOT_EXIST && object != null ? (Integer)object : -1;
        }
        if (n5 == 0) {
            n4 = 4;
            this._setFont(component, this._headingFont);
        } else {
            if (propertyModel.isDataConflicting(n3, n)) {
                this._setFont(component, this._conflictFont);
                ++n4;
            } else {
                this._setFont(component, jTable.getFont());
            }
            if (n3 != this._valueColumnIndex || this._writableColumnIndex == -1 || Boolean.TRUE.equals(propertyModel.getValueAt(n, this._writableColumnIndex))) {
                n4 += 2;
            }
        }
        if (!jTable.isEnabled()) {
            this._setForeground(component, UIManager.getColor(LookAndFeel.TEXT_INACTIVE_TEXT));
            this._setBackground(component, jTable.getBackground());
        } else if (bl2) {
            if (this._isOracleLookAndFeel) {
                this._setForeground(component, UIManager.getColor(LookAndFeel.TEXT_TEXT));
                object = new Color(0x999999);
                this._setBackground(component, (Color)object);
            } else if (n3 == this._nameColumnIndex) {
                this._setForeground(component, this._foregrounds[4]);
                this._setBackground(component, this._backgrounds[4]);
            } else {
                this._setForeground(component, this._foregrounds[n4]);
                this._setBackground(component, this._backgrounds[n4]);
            }
        } else if (bl) {
            this._setForeground(component, UIManager.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
            this._setBackground(component, UIManager.getColor(LookAndFeel.TEXT_HIGHLIGHT));
        } else if (n3 == this._nameColumnIndex) {
            this._setForeground(component, this._foregrounds[4]);
            this._setBackground(component, this._backgrounds[4]);
        } else {
            this._setForeground(component, this._foregrounds[n4]);
            this._setBackground(component, this._backgrounds[n4]);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("font".equals(string)) {
            this._computeFonts();
        } else if ("UI".equals(string)) {
            this._computeInfo();
        }
    }

    private void _computeInfo() {
        this._isOracleLookAndFeel = UIManager.getLookAndFeel() instanceof OracleLookAndFeel;
        Color color = UIManager.getColor(LookAndFeel.CONTROL);
        Color color2 = UIManager.getColor(LookAndFeel.WINDOW);
        Color color3 = UIManager.getColor(LookAndFeel.TEXT_TEXT);
        if (this._isOracleLookAndFeel) {
            this._table.setBackground(color);
        } else {
            this._table.setBackground(color2);
        }
        this._computeFonts();
        int n = 0;
        while (n < 4) {
            this._foregrounds[n] = color3;
            this._backgrounds[n] = this._isOracleLookAndFeel ? UIManager.getColor(LookAndFeel.TEXT) : color2;
            if ((n & 2) == 0) {
                this._backgrounds[n] = color;
                this._foregrounds[n] = UIManager.getColor(LookAndFeel.TEXT_INACTIVE_TEXT);
            }
            ++n;
        }
        this._foregrounds[n] = color3;
        this._backgrounds[n] = this._isOracleLookAndFeel ? color : color2;
    }

    private void _computeFonts() {
        Insets insets;
        Font font = this._table.getFont();
        if (font == null) {
            font = UIManager.getFont("Table.font");
        }
        if (font == null) {
            font = FontUtils.getDefaultSansSerifFont();
        }
        this._conflictFont = FontUtils.deriveFontUsingStyle((Font)font, (int)2, (int)2);
        this._headingFont = FontUtils.deriveFontUsingStyle((Font)font, (int)1, (int)1);
        FontMetrics fontMetrics = ((Component)this._table).getFontMetrics(font);
        int n = fontMetrics.getHeight();
        Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
        Insets insets2 = insets = border == null ? null : border.getBorderInsets(this._table);
        if (insets != null) {
            n += insets.top + insets.bottom;
        }
        this._table.setRowHeight(n);
        this._table.setRowMargin(1);
    }

    private void _setFont(Component component, Font font) {
        component.setFont(font);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this._setFont(container.getComponent(n2), font);
                ++n2;
            }
        }
    }

    private void _setForeground(Component component, Color color) {
        component.setForeground(color);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this._setForeground(container.getComponent(n2), color);
                ++n2;
            }
        }
    }

    private void _setBackground(Component component, Color color) {
        component.setBackground(color);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this._setBackground(container.getComponent(n2), color);
                ++n2;
            }
        }
    }
}

