/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.SwitchingCellEditor;

class PropertyEditorHandler
extends DefaultTableCellRenderer
implements TableCellEditor,
ActionListener {
    private static final String _TEAR_OFF_COMMAND = "showTearOff";
    private static final String _ADVANCED_COMMAND = "showAdvanced";
    private static final String _KEY_TOOLTIP = "ADVANCED_EDITOR_TOOLTIP";
    private static final String _KEY_TEAROFF_TOOLTIP = "TEAROFF_EDITOR_TOOLTIP";
    private JButton _advancedButton;
    private JButton _tearOffButton;
    private int _row;
    private PropertyInspector _inspector;
    private TableCellEditor _editor;
    private int _valueIndex;
    private int _factoryIndex;

    public PropertyEditorHandler(PropertyInspector propertyInspector, TableCellEditor tableCellEditor) {
        this._editor = tableCellEditor;
        this._inspector = propertyInspector;
    }

    public void setIndicies(int n, int n2) {
        this._valueIndex = n;
        this._factoryIndex = n2;
    }

    public void clear() {
        if (this._editor instanceof SwitchingCellEditor) {
            ((SwitchingCellEditor)this._editor).init();
        }
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.setValue(null);
        TableCellRenderer tableCellRenderer = null;
        PropertyModel propertyModel = (PropertyModel)jTable.getModel();
        PropertyEditorFactory propertyEditorFactory = this._getEditorFactory(propertyModel, n);
        if (propertyEditorFactory != null) {
            Object object2 = this._getValue(propertyModel, n);
            try {
                propertyEditorFactory.setEditorValue(object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (propertyEditorFactory.hasValueRenderer()) {
                tableCellRenderer = propertyEditorFactory.getValueRenderer();
            }
        }
        return tableCellRenderer == null ? super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2) : tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Object object2;
        PropertyModel propertyModel = (PropertyModel)jTable.getModel();
        Component component = this._editor.getTableCellEditorComponent(jTable, object, bl, n, n2);
        PropertyEditorFactory propertyEditorFactory = this._getEditorFactory(propertyModel, n);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        Component component2 = null;
        Component component3 = null;
        if (propertyEditorFactory != null) {
            object2 = this._getValue(propertyModel, n);
            try {
                propertyEditorFactory.setEditorValue(object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (propertyEditorFactory.hasAdvancedEditor()) {
                component3 = this._getAdvancedButton();
                jPanel.add("East", component3);
            }
            if (propertyEditorFactory.hasTearOffEditor()) {
                component2 = this._getTearOffButton();
                jPanel.add("West", component2);
            }
        }
        object2 = component != null && component.isFocusTraversable() ? component : (component2 != null ? component2 : (component3 != null ? component3 : null));
        JPanel jPanel2 = new JPanel((Component)object2, new BorderLayout(0, 0)){
            private final /* synthetic */ Component val$focus;
            {
                this.val$focus = component;
            }

            public void requestFocus() {
                if (this.val$focus != null) {
                    this.val$focus.requestFocus();
                } else {
                    super.requestFocus();
                }
            }

            public boolean isFocusable() {
                return false;
            }

            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                if (n != 0) {
                    return super.processKeyBinding(keyStroke, keyEvent, n, bl);
                }
                if (this.val$focus != null && PropertyEditorHandler.this._row != -1) {
                    SwingUtilities.invokeLater(new Runnable(this, keyEvent){
                        private final /* synthetic */ KeyEvent val$e;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$e = keyEvent;
                        }

                        public void run() {
                            1.access$100(this.this$1).dispatchEvent(this.val$e);
                        }
                    });
                }
                return false;
            }

            static /* synthetic */ Component access$100(1 var0) {
                return var0.val$focus;
            }
        };
        jPanel2.add("Center", component);
        jPanel2.add("East", jPanel);
        this._row = n;
        return jPanel2;
    }

    public Object getCellEditorValue() {
        return this._editor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof InputEvent && ((InputEvent)eventObject).isConsumed()) {
            return false;
        }
        return this._editor.isCellEditable(eventObject);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this._editor.shouldSelectCell(eventObject);
    }

    public boolean stopCellEditing() {
        this._clear();
        return this._editor.stopCellEditing();
    }

    public void cancelCellEditing() {
        this._clear();
        this._editor.cancelCellEditing();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this._editor.addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this._editor.removeCellEditorListener(cellEditorListener);
    }

    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
        super.paintComponent(graphics);
    }

    private void _clear() {
        this._row = -1;
        if (this._tearOffButton != null) {
            this._tearOffButton.removeActionListener(this);
        }
        this._tearOffButton = null;
        if (this._advancedButton != null) {
            this._advancedButton.removeActionListener(this);
        }
        this._advancedButton = null;
    }

    private Object _getValue(PropertyModel propertyModel, int n) {
        if (this._valueIndex == -1) {
            this._valueIndex = propertyModel.getColumnIndex(PropertyModel.COLUMN_VALUE);
        }
        return propertyModel.getValueAt(n, this._valueIndex);
    }

    private PropertyEditorFactory _getEditorFactory(PropertyModel propertyModel, int n) {
        Object object;
        if (this._factoryIndex == -1) {
            this._factoryIndex = propertyModel.getColumnIndex(PropertyModel.COLUMN_EDITOR_FACTORY);
        }
        return (object = propertyModel.getValueAt(n, this._factoryIndex)) instanceof PropertyEditorFactory ? (PropertyEditorFactory)object : null;
    }

    private Component _getAdvancedButton() {
        if (this._advancedButton == null) {
            this._advancedButton = new JButton();
            this._advancedButton.setMargin(new Insets(2, 2, 2, 2));
            this._advancedButton.setActionCommand(_ADVANCED_COMMAND);
            this._advancedButton.addActionListener(this);
            this._advancedButton.setIcon(this._inspector.getIcon("advanced"));
            this._advancedButton.setToolTipText(this._inspector.__getTranslatedString(_KEY_TOOLTIP));
        }
        return this._advancedButton;
    }

    private Component _getTearOffButton() {
        if (this._tearOffButton == null) {
            this._tearOffButton = new JButton();
            this._tearOffButton.setMargin(new Insets(2, 2, 2, 2));
            this._tearOffButton.setActionCommand(_TEAR_OFF_COMMAND);
            this._tearOffButton.addActionListener(this);
            this._tearOffButton.setIcon(this._inspector.getIcon("tearoff"));
            this._tearOffButton.setToolTipText(this._inspector.__getTranslatedString(_KEY_TEAROFF_TOOLTIP));
        }
        return this._tearOffButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._row == -1) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (_ADVANCED_COMMAND.equals(string)) {
            this._inspector.showAdvancedEditor(this._row);
        } else if (_TEAR_OFF_COMMAND.equals(string)) {
            this._inspector.showTearOffEditorPalette(this._row);
        }
    }
}

