/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyModel;

class PropertyEditorRenderer
extends JPanel
implements TableCellRenderer {
    private static final PropertyEditorRenderer _sINSTANCE = new PropertyEditorRenderer();
    private PropertyEditor _editor;

    private PropertyEditorRenderer() {
    }

    public static TableCellRenderer getTableCellRenderer() {
        return _sINSTANCE;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        PropertyModel propertyModel = (PropertyModel)jTable.getModel();
        PropertyEditorFactory propertyEditorFactory = propertyModel.getPropertyEditorFactory(n);
        this._editor = propertyEditorFactory instanceof PropertyEditorAdapter ? ((PropertyEditorAdapter)propertyEditorFactory).getPropertyEditor() : null;
        this.setOpaque(true);
        return this;
    }

    public void paintComponent(Graphics graphics) {
        if (this._editor != null) {
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            this._editor.paintValue(graphics, rectangle);
        }
    }

    PropertyEditor __getEditor() {
        return this._editor;
    }
}

