/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.beans.PropertyEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import oracle.bali.inspector.BorderlessTextField;
import oracle.bali.inspector.InspectorGroup;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.swing.NonNullComboBoxModel;

class PropertyEditorValueEditor
extends DefaultCellEditor {
    private PropertyEditor _editor;
    private JTable _table;
    private int _row;
    private static PropertyEditorValueEditor _sTextInstance;

    private PropertyEditorValueEditor() {
        super(new BorderlessTextField());
        JTextField jTextField = (JTextField)this.editorComponent;
        jTextField.removeActionListener(this.delegate);
        this.delegate = new Delegate();
        jTextField.addActionListener(this.delegate);
    }

    public void dispose() {
        this._editor = null;
        this._table = null;
    }

    private PropertyEditorValueEditor(JComboBox jComboBox) {
        super(jComboBox);
        jComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        jComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
    }

    public static TableCellEditor getTextFieldEditor() {
        if (_sTextInstance == null) {
            _sTextInstance = new PropertyEditorValueEditor();
        }
        return _sTextInstance;
    }

    public static TableCellEditor getComboBoxEditor(String[] stringArray) {
        NonNullComboBoxModel nonNullComboBoxModel = new NonNullComboBoxModel(stringArray);
        return new PropertyEditorValueEditor(new JComboBox(nonNullComboBoxModel));
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        PropertyEditorAdapter propertyEditorAdapter = PropertyEditorValueEditor._getEditorFactory(jTable, n);
        if (propertyEditorAdapter != null) {
            this._editor = propertyEditorAdapter.getPropertyEditor();
            this._table = jTable;
            this._row = n;
            object = this._editor.getAsText();
        }
        return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    public boolean stopCellEditing() {
        if (this._editor != null) {
            String string = null;
            try {
                string = (String)super.getCellEditorValue();
                this._editor.setAsText(string);
            }
            catch (Exception exception) {
                PropertyModel propertyModel = (PropertyModel)this._table.getModel();
                Object object = propertyModel.getPropertyID(this._row);
                PropertyEditorFactory propertyEditorFactory = propertyModel.getPropertyEditorFactory(this._row);
                if (this._table instanceof PropertyInspector.ExtendedTable) {
                    PropertyInspector propertyInspector = ((PropertyInspector.ExtendedTable)this._table).__getInspector();
                    propertyInspector.getInspectorGroup().showErrorMessage(object, propertyEditorFactory, propertyInspector, exception, string);
                } else {
                    InspectorGroup.showErrorMessage(object, propertyEditorFactory, this._table, exception, string);
                }
                this.cancelCellEditing();
                return true;
            }
        }
        return super.stopCellEditing();
    }

    public Object getCellEditorValue() {
        if (this._editor != null) {
            this._editor.setAsText((String)super.getCellEditorValue());
            return this._editor.getValue();
        }
        return super.getCellEditorValue();
    }

    private static PropertyEditorAdapter _getEditorFactory(JTable jTable, int n) {
        if (jTable.getModel() instanceof PropertyModel) {
            PropertyModel propertyModel = (PropertyModel)jTable.getModel();
            return (PropertyEditorAdapter)propertyModel.getPropertyEditorFactory(n);
        }
        return null;
    }

    private class Delegate
    extends DefaultCellEditor.EditorDelegate {
        private Delegate() {
            super(PropertyEditorValueEditor.this);
        }

        public void setValue(Object object) {
            JTextField jTextField = (JTextField)PropertyEditorValueEditor.this.editorComponent;
            jTextField.setText(object != null ? object.toString() : null);
        }

        public Object getCellEditorValue() {
            JTextField jTextField = (JTextField)PropertyEditorValueEditor.this.editorComponent;
            String string = jTextField.getText();
            if (string != null && string.length() == 0) {
                string = null;
            }
            return string;
        }
    }
}

