/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.bali.inspector.IntVector;
import oracle.bali.inspector.PropertyExpansionState;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.sort.StringComparator;
import oracle.bali.share.util.IntegerUtils;

class PropertyFilterer
extends PropertyModel
implements TableModelListener {
    public static final int SORT_MODE_NONE = 0;
    public static final int SORT_MODE_ALPHABETIZED = 1;
    public static final int SORT_MODE_CATEGORIZED = 2;
    private static final Object[] _FILTERED_COLUMNS = new Object[]{PropertyModel.COLUMN_EDITOR_FACTORY, PropertyModel.COLUMN_IS_WRITABLE, PropertyModel.COLUMN_IS_READABLE};
    private static final Object[] _FILTERED_VALUES = new Object[]{null, Boolean.FALSE, Boolean.FALSE};
    private static final Object[] _COLUMN_DEFAULTS = new Object[]{null, Boolean.TRUE, Boolean.TRUE};
    private transient TableModelListener _drilledModelListener = new DrillDSListen();
    private PropertyInspector _inspector;
    private transient int _nameColumnIndex;
    private transient int _levelColumnIndex;
    private transient int _drillableColumnIndex;
    private transient int[] _filteredIndices;
    private Object[] _filteredValues;
    private Object[] _filteredColumns;
    private Object[] _filteredDefaults;
    private Object[] _columnMapping;
    private boolean _useIntersection = false;
    private PropertyModel _filteredModel;
    private boolean _readOnlyIncluded = false;
    private boolean _writeOnlyIncluded = false;
    private int _sortMode = 2;
    private transient Hashtable _propertyModels = new Hashtable();
    private transient Hashtable _isModelExpanded = new Hashtable();
    private transient Vector _groups = new Vector();
    private transient BitSet _isGroupExpanded = new BitSet();
    private transient int[] _groupedNewToOld;
    private transient int[] _groupedOldToNew;
    private transient int[] _sortedNewToOld;
    private transient int[] _sortedOldToNew;
    private transient int[] _filteredNewToOld;
    private transient int[] _filteredOldToNew;
    private boolean _alphabetize;

    protected PropertyFilterer(PropertyModel propertyModel, PropertyInspector propertyInspector) {
        if (propertyModel == null) {
            throw new IllegalArgumentException();
        }
        this._filteredColumns = (Object[])_FILTERED_COLUMNS.clone();
        this._filteredValues = (Object[])_FILTERED_VALUES.clone();
        this._filteredDefaults = (Object[])_COLUMN_DEFAULTS.clone();
        this._filteredModel = propertyModel;
        this._inspector = propertyInspector;
        propertyModel.addTableModelListener(this);
        this._updateColumnInfo();
    }

    public boolean isPropertyCommon(int n) {
        return this._filteredModel.isPropertyCommon(n);
    }

    public Object[] getColumnMapping() {
        return this._columnMapping;
    }

    public void disposeFilterer() {
        this._filteredModel.removeTableModelListener(this);
    }

    public void setFilteredModel(PropertyModel propertyModel) {
        if (this._filteredModel != propertyModel) {
            this._filteredModel = propertyModel;
        }
    }

    public PropertyModel getFilteredModel() {
        return this._filteredModel;
    }

    public boolean setExpansionState(int n, boolean bl) {
        int[] nArray = this._getReorderedNewToOld();
        int n2 = nArray[n];
        if (n2 < 0) {
            BitSet bitSet = this._isGroupExpanded;
            int n3 = -n2 - 1;
            if (bitSet.get(n3) != bl) {
                PropertyGroup[] propertyGroupArray = this.getGroups(true);
                PropertyFilterer propertyFilterer = this;
                synchronized (propertyFilterer) {
                    if (bl) {
                        bitSet.set(n3);
                    } else {
                        bitSet.clear(n3);
                    }
                    this._invalidateGroupedMapping();
                }
                this._invalidateModel();
                this._inspector.firePropertyChange("expandedGroups", propertyGroupArray, this.getGroups(true));
                return true;
            }
        } else {
            int n4 = this._getDrillDown(nArray, n);
            if (n4 == 0) {
                if (this._filteredModel.isPropertyDrillable(n2)) {
                    PropertyModel propertyModel;
                    boolean bl2;
                    Object object = this._filteredModel.getPropertyID(n2);
                    Boolean bl3 = (Boolean)this._isModelExpanded.get(object);
                    boolean bl4 = bl2 = bl3 != null && bl3 != false;
                    if (bl2 != bl && (propertyModel = this._getDrilledModel(object, n2)) != null) {
                        bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
                        this._isModelExpanded.put(object, bl3);
                        this._invalidateRowMapping();
                        this._invalidateModel();
                        return true;
                    }
                }
            } else {
                Object object = this._filteredModel.getPropertyID(n2);
                if (object != PropertyModel.DOES_NOT_EXIST) {
                    boolean bl5;
                    PropertyFilterer propertyFilterer = (PropertyFilterer)this._getDrilledModel(object, n2);
                    boolean bl6 = bl5 = propertyFilterer == null ? true : propertyFilterer.setExpansionState(n4 - 1, bl);
                    if (bl5) {
                        this._invalidateRowMapping();
                        this._invalidateModel();
                    }
                    return bl5;
                }
            }
        }
        return false;
    }

    public boolean getExpansionState(int n) {
        int[] nArray = this._getReorderedNewToOld();
        int n2 = nArray[n];
        if (n2 < 0) {
            int n3 = -n2 - 1;
            return this._isGroupExpanded.get(n3);
        }
        int n4 = this._getDrillDown(nArray, n);
        if (n4 == 0) {
            Object object;
            if (this._filteredModel.isPropertyDrillable(n2) && (object = this._filteredModel.getPropertyID(n2)) != PropertyModel.DOES_NOT_EXIST) {
                Boolean bl = (Boolean)this._isModelExpanded.get(object);
                return bl != null && bl != false;
            }
        } else {
            Object object = this._filteredModel.getPropertyID(n2);
            if (object != PropertyModel.DOES_NOT_EXIST) {
                PropertyFilterer propertyFilterer = (PropertyFilterer)this._getDrilledModel(object, n2);
                return propertyFilterer == null ? false : propertyFilterer.getExpansionState(n4 - 1);
            }
        }
        return false;
    }

    public PropertyGroup[] getGroups(boolean bl) {
        BitSet bitSet = this._isGroupExpanded;
        Vector vector = new Vector();
        int n = 0;
        while (n < bitSet.size()) {
            if (bitSet.get(n)) {
                if (bl) {
                    vector.addElement(this._groups.elementAt(n));
                }
            } else if (!bl) {
                vector.addElement(this._groups.elementAt(n));
            }
            ++n;
        }
        Object[] objectArray = null;
        int n2 = vector.size();
        if (n2 != 0) {
            objectArray = new PropertyGroup[n2];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public void setGroups(PropertyGroup[] propertyGroupArray, boolean bl) {
        PropertyGroup[] propertyGroupArray2 = this.getGroups(true);
        BitSet bitSet = this._isGroupExpanded;
        Vector vector = this._groups;
        boolean bl2 = false;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            PropertyGroup propertyGroup = (PropertyGroup)vector.elementAt(n2);
            boolean bl3 = false;
            int n3 = 0;
            while (n3 < propertyGroupArray.length) {
                if (propertyGroupArray[n3] == propertyGroup) {
                    bl3 = true;
                    break;
                }
                ++n3;
            }
            if (bl3) {
                if (bl && !bitSet.get(n2)) {
                    bitSet.set(n2);
                    bl2 = true;
                } else if (!bl && bitSet.get(n2)) {
                    bitSet.clear(n2);
                    bl2 = true;
                }
            } else if (bl) {
                if (bitSet.get(n2)) {
                    bitSet.clear(n2);
                    bl2 = true;
                }
            } else if (!bitSet.get(n2)) {
                bitSet.set(n2);
                bl2 = true;
            }
            ++n2;
        }
        if (bl2) {
            this._invalidateGroupedMapping();
            this._invalidateModel();
            this._inspector.firePropertyChange("expandedGroups", propertyGroupArray2, this.getGroups(true));
        }
    }

    public boolean isGroupExpanded(PropertyGroup propertyGroup) {
        Vector vector = this._groups;
        BitSet bitSet = this._isGroupExpanded;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (vector.elementAt(n2) == propertyGroup) {
                return bitSet.get(n2);
            }
            ++n2;
        }
        return false;
    }

    public void setGroupExpanded(PropertyGroup propertyGroup, boolean bl) {
        Vector vector = this._groups;
        BitSet bitSet = this._isGroupExpanded;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (vector.elementAt(n2) == propertyGroup && bitSet.get(n2) != bl) {
                PropertyGroup[] propertyGroupArray = this.getGroups(true);
                if (bl) {
                    bitSet.set(n2);
                } else {
                    bitSet.clear(n2);
                }
                this._invalidateGroupedMapping();
                this._invalidateModel();
                this._inspector.firePropertyChange("expandedGroups", propertyGroupArray, this.getGroups(true));
                break;
            }
            ++n2;
        }
    }

    public void setSortMode(int n) {
        if (this._sortMode != n) {
            if (n < 0 || n > 2) {
                throw new IllegalArgumentException();
            }
            this._sortMode = n;
            this._invalidateModel();
        }
    }

    public int isSorted() {
        return this._sortMode;
    }

    public void setWriteOnlyIncluded(boolean bl) {
        if (this._writeOnlyIncluded != bl) {
            this._writeOnlyIncluded = bl;
            Hashtable hashtable = this._propertyModels;
            Enumeration enumeration = hashtable.keys();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    PropertyFilterer propertyFilterer = (PropertyFilterer)hashtable.get(k);
                    propertyFilterer.setWriteOnlyIncluded(this._writeOnlyIncluded);
                }
            }
            this._setFilterValue(PropertyModel.COLUMN_IS_READABLE, bl ? PropertyModel.DOES_NOT_EXIST : Boolean.FALSE);
        }
    }

    public boolean getWriteOnlyIncluded() {
        return this._writeOnlyIncluded;
    }

    public void setAlphabetizeGroupProperties(boolean bl) {
        if (this._alphabetize != bl) {
            this._alphabetize = bl;
            this._updateFilteredRows();
        }
    }

    public boolean isAlphabetizeGroupProperties() {
        return this._alphabetize;
    }

    public void setReadOnlyIncluded(boolean bl) {
        if (this._readOnlyIncluded != bl) {
            this._readOnlyIncluded = bl;
            Hashtable hashtable = this._propertyModels;
            Enumeration enumeration = hashtable.keys();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    PropertyFilterer propertyFilterer = (PropertyFilterer)hashtable.get(k);
                    propertyFilterer.setReadOnlyIncluded(this._readOnlyIncluded);
                }
            }
            this._setFilterValue(PropertyModel.COLUMN_IS_WRITABLE, bl ? PropertyModel.DOES_NOT_EXIST : Boolean.FALSE);
        }
    }

    public boolean getReadOnlyIncluded() {
        return this._readOnlyIncluded;
    }

    public void setUseIntersection(boolean bl) {
        if (bl != this._useIntersection) {
            this._useIntersection = bl;
            this._updateFilteredRows();
        }
    }

    public boolean getUseIntersection() {
        return this._useIntersection;
    }

    public PropertyExpansionState[] getExpandedProperties() {
        Object object;
        Enumeration enumeration = this._isModelExpanded.keys();
        if (enumeration == null) {
            return null;
        }
        Vector<PropertyExpansionState> vector = new Vector<PropertyExpansionState>(this._isModelExpanded.size());
        while (enumeration.hasMoreElements()) {
            PropertyFilterer propertyFilterer;
            object = enumeration.nextElement();
            if (!Boolean.TRUE.equals(this._isModelExpanded.get(object)) || (propertyFilterer = (PropertyFilterer)this._propertyModels.get(object)) == null) continue;
            vector.add(new PropertyExpansionState(object, propertyFilterer.getExpandedProperties(), true));
        }
        if (vector.size() == 0) {
            return null;
        }
        object = new PropertyExpansionState[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void setExpandedProperties(PropertyExpansionState[] propertyExpansionStateArray) {
        Object object;
        Object object2;
        Hashtable<Object, Boolean> hashtable = new Hashtable<Object, Boolean>();
        int n = propertyExpansionStateArray == null ? 0 : propertyExpansionStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = propertyExpansionStateArray[n2];
            object = ((PropertyExpansionState)object2).getPropertyID();
            int n3 = this.getFilteredModel().getPropertyIndex(object);
            if (n3 != -1 && this.getFilteredModel().isPropertyDrillable(n3)) {
                PropertyModel propertyModel = this._getDrilledModel(object, n3);
                if (propertyModel != null) {
                    this._isModelExpanded.put(object, Boolean.TRUE);
                }
                hashtable.put(object, Boolean.TRUE);
            }
            ++n2;
        }
        object2 = this._isModelExpanded.keys();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (hashtable.get(object) != null) continue;
            this._isModelExpanded.put(object, Boolean.FALSE);
        }
        this._invalidateRowMapping();
        this._invalidateModel();
    }

    public void setLocale(Locale locale) {
        this._filteredModel.setLocale(locale);
    }

    public Locale getLocale() {
        return this._filteredModel.getLocale();
    }

    public String getTargetDisplayName() {
        return this._filteredModel.getTargetDisplayName();
    }

    public int getColumnCount() {
        return this._columnMapping.length;
    }

    public void invalidateValueData() {
        this._filteredModel.invalidateValueData();
        Hashtable hashtable = this._propertyModels;
        Enumeration enumeration = hashtable.keys();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                PropertyFilterer propertyFilterer = (PropertyFilterer)hashtable.get(k);
                propertyFilterer.setWriteOnlyIncluded(this._writeOnlyIncluded);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._filteredModel.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._filteredModel.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == this._nameColumnIndex) {
            return super.isCellEditable(n, n2);
        }
        int[] nArray = this._getReorderedNewToOld();
        int n3 = nArray[n];
        if (n3 < 0) {
            return false;
        }
        return this.getFilteredModel().isCellEditable(n3, n2);
    }

    public int getRowCount() {
        return this._getReorderedNewToOld().length;
    }

    public boolean isDataConflicting(int n, int n2) {
        int n3 = this._getReorderedNewToOld()[n2];
        if (n3 >= 0) {
            return this._filteredModel.isDataConflicting(n, n3);
        }
        return false;
    }

    public Object getValueAt(int n, int n2) {
        boolean bl = this._levelColumnIndex == n2;
        boolean bl2 = this._drillableColumnIndex == n2;
        int[] nArray = this._getReorderedNewToOld();
        int n3 = nArray[n];
        if (n3 >= 0) {
            int n4 = this.isSorted() == 2 ? 1 : 1;
            int n5 = this._getDrillDown(nArray, n);
            if (n5 == 0) {
                Object object;
                boolean bl3;
                if (bl) {
                    return IntegerUtils.getInteger((int)n4);
                }
                Object object2 = this._filteredModel.getValueAt(n3, n2);
                if (bl2 && (bl3 = Boolean.TRUE.equals(object2)) && (object = this._filteredModel.getPropertyID(n3)) != PropertyModel.DOES_NOT_EXIST) {
                    PropertyFilterer propertyFilterer = (PropertyFilterer)this._getDrilledModel(object, n3);
                    object2 = propertyFilterer == null ? Boolean.FALSE : (propertyFilterer.getRowCount() > 0 ? Boolean.TRUE : Boolean.FALSE);
                }
                return object2;
            }
            Object object = this._filteredModel.getPropertyID(n3);
            if (object != null && object != PropertyModel.DOES_NOT_EXIST) {
                Object object3;
                PropertyModel propertyModel = this._getDrilledModel(object, n3);
                Object object4 = this._columnMapping[n2];
                Object object5 = object3 = propertyModel == null ? null : propertyModel.getData(object4, --n5);
                if (bl) {
                    int n6 = n4;
                    if (object3 instanceof Integer) {
                        n6 += ((Integer)object3).intValue();
                    }
                    return IntegerUtils.getInteger((int)n6);
                }
                return object3;
            }
        } else {
            if (bl) {
                return IntegerUtils.getInteger((int)0);
            }
            if (n2 == this._nameColumnIndex) {
                PropertyGroup propertyGroup = (PropertyGroup)this._groups.elementAt(-n3 - 1);
                return propertyGroup.getName(this.getLocale());
            }
        }
        return null;
    }

    public PropertyGroup getPropertyGroupAtIndex(int n) {
        int n2 = -n - 1;
        return (PropertyGroup)this._groups.elementAt(n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        int[] nArray = this._getReorderedNewToOld();
        int n3 = nArray[n];
        int n4 = this._getDrillDown(nArray, n);
        if (n3 >= 0) {
            if (n4 == 0) {
                this._filteredModel.setValueAt(object, n3, n2);
            } else {
                Object object2 = this._filteredModel.getPropertyID(n3);
                if (object2 != null && object2 != PropertyModel.DOES_NOT_EXIST) {
                    Object object3;
                    int n5;
                    --n4;
                    PropertyModel propertyModel = this._getDrilledModel(object2, n3);
                    if (propertyModel != null && (n5 = propertyModel.getColumnIndex(object3 = this._columnMapping[n2])) != -1) {
                        propertyModel.setValueAt(object, n4, n5);
                    }
                }
            }
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getType();
        switch (n) {
            case 1: {
                if (tableModelEvent.getFirstRow() != -1) {
                    this._rowsAdded(tableModelEvent);
                    break;
                }
                this._columnsAdded(tableModelEvent);
                break;
            }
            case -1: {
                if (tableModelEvent.getFirstRow() != -1) {
                    this._rowsRemoved(tableModelEvent);
                    break;
                }
                this._columnsRemoved(tableModelEvent);
                break;
            }
            case 0: {
                if (tableModelEvent.getFirstRow() != -1) {
                    if (tableModelEvent.getColumn() == -1) {
                        this._invalidateRows(tableModelEvent);
                        break;
                    }
                    this._invalidateCells(tableModelEvent);
                    break;
                }
                this._invalidateColumns(tableModelEvent);
            }
        }
    }

    public boolean isSettable(Object object, Object object2) {
        return this._filteredModel.isSettable(object, object2);
    }

    public void startRead() {
        super.startRead();
        this._filteredModel.startRead();
    }

    public void stopRead() {
        super.stopRead();
        this._filteredModel.stopRead();
    }

    public int getModelIndex(int n) {
        int[] nArray = this._getReorderedNewToOld();
        return nArray[n];
    }

    public void dispose() {
        super.dispose();
    }

    Object[] __getFilteredColumns() {
        return this._filteredColumns;
    }

    Object[] __getFilteredValues() {
        return this._filteredValues;
    }

    Object[] __getFilteredDefaults() {
        return this._filteredDefaults;
    }

    void setFilterInfo(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        int n = objectArray.length;
        this._filteredColumns = new Object[n];
        System.arraycopy(objectArray, 0, this._filteredColumns, 0, n);
        this._filteredValues = new Object[n];
        System.arraycopy(objectArray2, 0, this._filteredValues, 0, n);
        this._filteredDefaults = new Object[n];
        System.arraycopy(objectArray3, 0, this._filteredDefaults, 0, n);
        this._updateFilteredRows();
        Hashtable hashtable = this._propertyModels;
        Enumeration enumeration = hashtable.keys();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                PropertyFilterer propertyFilterer = (PropertyFilterer)hashtable.get(k);
                propertyFilterer.setFilterInfo(objectArray, objectArray2, objectArray3);
            }
        }
    }

    private void _updateColumnMapping() {
        Object[] objectArray = this._filteredModel.getColumnMapping();
        int n = objectArray.length;
        Object[] objectArray2 = new Object[n + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        objectArray2[n] = PropertyModel.COLUMN_LEVEL;
        this._columnMapping = objectArray2;
    }

    private void _updateColumnInfo() {
        this._updateColumnMapping();
        this._nameColumnIndex = this.getColumnIndex(PropertyModel.COLUMN_DISPLAY_NAME);
        this._levelColumnIndex = this.getColumnIndex(PropertyModel.COLUMN_LEVEL);
        this._drillableColumnIndex = this.getColumnIndex(PropertyModel.COLUMN_IS_DRILLABLE);
    }

    private void _columnsAdded(TableModelEvent tableModelEvent) {
        this._filteredIndices = null;
        this._updateColumnInfo();
        this._invalidateModel();
    }

    private void _columnsRemoved(TableModelEvent tableModelEvent) {
        this._filteredIndices = null;
        this._updateColumnInfo();
        if (this.getColumnIndex(PropertyModel.COLUMN_MODEL) == -1) {
            this._propertyModels.clear();
            this._isModelExpanded.clear();
        }
        this._invalidateModel();
    }

    private void _invalidateColumns(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getColumn();
        int n2 = 1;
        boolean bl = false;
        if (n == -1) {
            if (tableModelEvent.getFirstRow() == -1) {
                this._filteredIndices = null;
                this._updateColumnInfo();
                bl = true;
            }
            n = 0;
            n2 = this.getColumnCount();
        }
        if (this._invalidateColumns(n, n2)) {
            this._invalidateRowMapping();
        }
        if (bl) {
            this.fireTableChanged(tableModelEvent);
        }
        if (this._isModelColumnInvalid(tableModelEvent)) {
            this._clearModelCache(tableModelEvent);
        }
        this._fireColumnEvent(tableModelEvent);
    }

    private void _invalidateCells(TableModelEvent tableModelEvent) {
        int n;
        int n2 = tableModelEvent.getColumn();
        int n3 = n = tableModelEvent.getColumn() == -1 ? this.getColumnCount() : 1;
        if (this._invalidateColumns(n2, n)) {
            this._invalidateRowMapping();
        }
        if (this._isModelColumnInvalid(tableModelEvent)) {
            this._clearModelCache(tableModelEvent);
        }
        int[] nArray = this._getReorderedOldToNew();
        int[] nArray2 = this._getReorderedNewToOld();
        int n4 = n2 + n;
        int n5 = tableModelEvent.getFirstRow();
        int n6 = tableModelEvent.getLastRow();
        int n7 = n5;
        while (n7 < n6) {
            int n8 = nArray[n7];
            if (n8 != -1) {
                n8 -= this._getDrillDown(nArray2, n8);
            }
            int n9 = n2;
            while (n9 < n4) {
                if (n8 != -1) {
                    this.fireTableCellUpdated(n8, n9);
                }
                ++n9;
            }
            ++n7;
        }
    }

    private void _rowsAdded(TableModelEvent tableModelEvent) {
        this._invalidateRowMapping();
        this._fireRowEvent(tableModelEvent);
    }

    private void _rowsRemoved(TableModelEvent tableModelEvent) {
        int n = this._getReorderedNewToOld().length;
        this._invalidateRowMapping();
        int n2 = this._getReorderedNewToOld().length;
        int n3 = n - n2;
        if (n3 > 0) {
            this.fireTableRowsDeleted(0, n3 - 1);
        } else if (n3 < 0) {
            this.fireTableRowsInserted(0, -n3 - 1);
        }
    }

    private void _invalidateRows(TableModelEvent tableModelEvent) {
        this._invalidateRowMapping();
        this._clearModelCache(tableModelEvent);
        this.fireTableDataChanged();
    }

    private synchronized void _buildFilteredMappings() {
        PropertyModel propertyModel = this._filteredModel;
        propertyModel.startRead();
        try {
            int n;
            boolean bl = this._useIntersection;
            int n2 = propertyModel.getRowCount();
            int[] nArray = new int[n2];
            IntVector intVector = new IntVector(n2);
            int[] nArray2 = this._getFilteredIndices();
            int n3 = nArray2.length;
            int n4 = -1;
            int n5 = propertyModel.getColumnIndex(PropertyModel.COLUMN_ID);
            int n6 = 0;
            while (n6 < n2) {
                if (!bl || propertyModel.isPropertyCommon(n6)) {
                    Object object;
                    Object object2;
                    n = 1;
                    int n7 = 0;
                    while (n7 < n3) {
                        if (nArray2[n7] != -1 && (object2 = this._filteredValues[n7]) != PropertyModel.DOES_NOT_EXIST) {
                            object = propertyModel.getValueAt(n6, nArray2[n7]);
                            if (object == PropertyModel.DOES_NOT_EXIST) {
                                object = this._filteredDefaults[n7];
                            }
                            if (object == object2 || object2 != null && object2.equals(object)) {
                                n = 0;
                                break;
                            }
                        }
                        ++n7;
                    }
                    if (n != 0) {
                        PropertyModel propertyModel2;
                        intVector.addElement(n6);
                        nArray[n6] = ++n4;
                        if (n5 != -1 && (object2 = propertyModel.getValueAt(n6, n5)) != null && object2 != PropertyModel.DOES_NOT_EXIST && (object = (Boolean)this._isModelExpanded.get(object2)) != null && ((Boolean)object).booleanValue() && (propertyModel2 = this._getDrilledModel(object2, n6)) != null) {
                            int n8 = propertyModel2.getRowCount();
                            int n9 = n6;
                            int n10 = 0;
                            while (n10 < n8) {
                                intVector.addElement(n9);
                                ++n4;
                                ++n10;
                            }
                        }
                    } else {
                        nArray[n6] = n4;
                    }
                } else {
                    nArray[n6] = n4;
                }
                ++n6;
            }
            n = intVector.size();
            int[] nArray3 = new int[n];
            intVector.copyInto(nArray3);
            this._filteredNewToOld = nArray3;
            this._filteredOldToNew = nArray;
            Object var20_20 = null;
            propertyModel.stopRead();
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            propertyModel.stopRead();
            throw throwable;
        }
    }

    private int[] _getFilteredNewToOldMapping() {
        if (this._filteredNewToOld == null) {
            this._buildFilteredMappings();
        }
        return this._filteredNewToOld;
    }

    private int[] _getFilteredOldToNewMapping() {
        if (this._filteredOldToNew == null) {
            this._buildFilteredMappings();
        }
        return this._filteredOldToNew;
    }

    private int[] _buildReorderOldToNewMapping(int[] nArray) {
        int n = this._getFilteredOldToNewMapping().length;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = -1;
            ++n2;
        }
        int n3 = nArray.length;
        int[] nArray3 = this._getFilteredNewToOldMapping();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n4];
            if (n5 >= 0) {
                nArray2[nArray3[n5]] = n4;
            }
            ++n4;
        }
        return nArray2;
    }

    private synchronized void _buildGroupedMappings() {
        PropertyModel propertyModel = this._filteredModel;
        propertyModel.startRead();
        try {
            int[] nArray = this._getFilteredNewToOldMapping();
            int n = propertyModel.getColumnIndex(PropertyModel.COLUMN_GROUP);
            if (n != -1) {
                int n2;
                int n3 = nArray.length;
                Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>(13);
                Vector<IntVector> vector = new Vector<IntVector>();
                Vector vector2 = this._groups;
                int n4 = this._groups.size();
                int n5 = 0;
                while (n5 < n4) {
                    hashtable.put(vector2.elementAt(n5), IntegerUtils.getInteger((int)n5));
                    vector.addElement(new IntVector());
                    ++n5;
                }
                int n6 = n4;
                BitSet bitSet = this._isGroupExpanded;
                int n7 = 0;
                while (n7 < n3) {
                    IntVector intVector;
                    Object object = propertyModel.getValueAt(nArray[n7], n);
                    if (object == PropertyModel.DOES_NOT_EXIST) {
                        if (vector.size() > 0) {
                            intVector = (IntVector)vector.elementAt(0);
                            intVector.addElement(n7);
                        }
                    } else {
                        Integer n8 = (Integer)hashtable.get(object);
                        if (n8 == null) {
                            n8 = IntegerUtils.getInteger((int)n6);
                            hashtable.put(object, n8);
                            intVector = new IntVector();
                            vector.addElement(intVector);
                            vector2.addElement(object);
                            bitSet.set(n6);
                            ++n6;
                        } else {
                            intVector = (IntVector)vector.elementAt(n8);
                        }
                        intVector.addElement(n7);
                    }
                    ++n7;
                }
                int n9 = 0;
                int n10 = 0;
                while (n10 < n6) {
                    int n11 = ((IntVector)vector.elementAt(n10)).size();
                    if (n11 > 0) {
                        ++n9;
                        if (bitSet.get(n10)) {
                            n9 += n11;
                        }
                    }
                    ++n10;
                }
                int[] nArray2 = new int[n9];
                int n12 = 0;
                int n13 = this.getColumnIndex(PropertyModel.COLUMN_DISPLAY_NAME);
                int n14 = 0;
                while (n14 < n6) {
                    IntVector intVector = (IntVector)vector.elementAt(n14);
                    if (this.isAlphabetizeGroupProperties()) {
                        this._sortPropertiesInGroup(intVector, n13, nArray);
                    }
                    if ((n2 = intVector.size()) > 0) {
                        nArray2[n12] = -n14 - 1;
                        ++n12;
                        if (bitSet.get(n14)) {
                            int n15 = 0;
                            while (n15 < n2) {
                                nArray2[n12] = intVector.elementAt(n15);
                                ++n12;
                                ++n15;
                            }
                        }
                    }
                    ++n14;
                }
                this._groupedOldToNew = this._buildReorderOldToNewMapping(nArray2);
                int n16 = 0;
                while (n16 < n9) {
                    n2 = nArray2[n16];
                    if (n2 >= 0) {
                        nArray2[n16] = nArray[n2];
                    }
                    ++n16;
                }
                this._groupedNewToOld = nArray2;
            } else {
                this._groupedOldToNew = this._getFilteredOldToNewMapping();
                this._groupedNewToOld = nArray;
            }
            Object var23_28 = null;
            propertyModel.stopRead();
        }
        catch (Throwable throwable) {
            Object var23_29 = null;
            propertyModel.stopRead();
            throw throwable;
        }
    }

    private void _sortPropertiesInGroup(IntVector intVector, int n, int[] nArray) {
        int n2 = intVector.size();
        int[] nArray2 = new int[n2];
        intVector.copyInto(nArray2);
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            int n5 = nArray[n4];
            objectArray[n3] = this._filteredModel.getValueAt(n5, n);
            ++n3;
        }
        StringComparator stringComparator = new StringComparator(Collator.getInstance(this.getLocale()));
        int[] nArray3 = Sort.indirectQSort((Object[])objectArray, (int)n2, (Comparator)stringComparator);
        int n6 = 0;
        while (n6 < n2) {
            int n7 = nArray3[n6];
            int n8 = nArray2[n7];
            intVector.setElementAt(n8, n6);
            ++n6;
        }
    }

    private synchronized void _buildSortedMappings() {
        int[] nArray = this._getFilteredNewToOldMapping();
        int n = nArray.length;
        Object[] objectArray = new Object[n];
        PropertyModel propertyModel = this._filteredModel;
        propertyModel.startRead();
        try {
            int n2 = propertyModel.getColumnIndex(PropertyModel.COLUMN_DISPLAY_NAME);
            if (n2 != -1) {
                int n3 = 0;
                while (n3 < n) {
                    int n4 = nArray[n3];
                    objectArray[n3] = propertyModel.getValueAt(n4, n2);
                    ++n3;
                }
                StringComparator stringComparator = new StringComparator(Collator.getInstance(this.getLocale()));
                int[] nArray2 = Sort.indirectQSort((Object[])objectArray, (int)n, (Comparator)stringComparator);
                this._sortedOldToNew = this._buildReorderOldToNewMapping(nArray2);
                int n5 = 0;
                while (n5 < n) {
                    nArray2[n5] = nArray[nArray2[n5]];
                    ++n5;
                }
                this._sortedNewToOld = nArray2;
            } else {
                this._sortedOldToNew = this._getFilteredOldToNewMapping();
                this._sortedNewToOld = nArray;
            }
            Object var11_11 = null;
            propertyModel.stopRead();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            propertyModel.stopRead();
            throw throwable;
        }
    }

    private int[] _getReorderedNewToOld() {
        switch (this._sortMode) {
            case 0: {
                return this._getFilteredNewToOldMapping();
            }
            case 1: {
                if (this._sortedNewToOld == null) {
                    this._buildSortedMappings();
                }
                return this._sortedNewToOld;
            }
            case 2: {
                if (this._groupedNewToOld == null) {
                    this._buildGroupedMappings();
                }
                return this._groupedNewToOld;
            }
        }
        return null;
    }

    private int[] _getReorderedOldToNew() {
        switch (this._sortMode) {
            case 0: {
                return this._getFilteredOldToNewMapping();
            }
            case 1: {
                if (this._sortedOldToNew == null) {
                    this._buildSortedMappings();
                }
                return this._sortedOldToNew;
            }
            case 2: {
                if (this._groupedOldToNew == null) {
                    this._buildGroupedMappings();
                }
                return this._groupedOldToNew;
            }
        }
        return null;
    }

    private void _fireRowEvent(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (n2 >= this._filteredModel.getRowCount()) {
            n2 = this._filteredModel.getRowCount() - 1;
        }
        int[] nArray = this._getFilteredOldToNewMapping();
        int n3 = nArray[n2];
        int n4 = nArray[n];
        if (n4 == -1) {
            n4 = 0;
        } else if (this._getFilteredNewToOldMapping()[n4] != n) {
            ++n4;
        }
        int n5 = n3 - n4 + 1;
        if (n5 > 0) {
            int n6;
            int n7 = tableModelEvent.getType();
            int[] nArray2 = this._getReorderedOldToNew();
            if (nArray2 != nArray) {
                if (n5 == 1) {
                    n4 = nArray2[n];
                } else {
                    n6 = this.getRowCount();
                    if (n5 != n6) {
                        if (n7 == 0) {
                            n4 = 0;
                            n5 = n6;
                        } else {
                            this._updateFilteredRows();
                            return;
                        }
                    }
                }
            }
            if (n5 != 0) {
                n6 = n4 + n5 - 1;
                if (tableModelEvent.getType() == 0) {
                    this.fireTableRowsUpdated(n4, n6);
                } else {
                    this.fireTableRowsInserted(n4, n6);
                }
            }
        }
    }

    private void _fireColumnEvent(TableModelEvent tableModelEvent) {
        this.fireTableDataChanged();
    }

    private boolean _invalidateColumns(int n, int n2) {
        int n3 = n + n2 - 1;
        int n4 = this.getColumnIndex(PropertyModel.COLUMN_GROUP);
        if (n4 >= n && n4 <= n3) {
            return true;
        }
        int[] nArray = this._getFilteredIndices();
        int n5 = 0;
        while (n5 < nArray.length) {
            int n6 = nArray[n5];
            if (this._filteredValues[n5] != PropertyModel.DOES_NOT_EXIST && n6 >= n && n <= n3) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    private void _updateFilteredRows() {
        this._filteredIndices = null;
        this._invalidateRowMapping();
        this._invalidateModel();
    }

    private synchronized void _invalidateSortedMapping() {
        this._sortedNewToOld = null;
        this._sortedOldToNew = null;
    }

    private synchronized void _invalidateGroupedMapping() {
        this._groupedNewToOld = null;
        this._groupedOldToNew = null;
    }

    private synchronized void _invalidateRowMapping() {
        this._filteredNewToOld = null;
        this._filteredOldToNew = null;
        this._invalidateSortedMapping();
        this._invalidateGroupedMapping();
    }

    private int[] _getFilteredIndices() {
        if (this._filteredIndices == null) {
            PropertyModel propertyModel = this._filteredModel;
            Object[] objectArray = this._filteredColumns;
            int n = objectArray.length;
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = propertyModel.getColumnIndex(objectArray[n2]);
                ++n2;
            }
            this._filteredIndices = nArray;
        }
        return this._filteredIndices;
    }

    private int _getFilterIndex(Object object) {
        int n = 0;
        while (n < this._filteredColumns.length) {
            if (object == this._filteredColumns[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setColumnFilter(Object object, Object object2, Object object3) {
        Object object4;
        int n = this._getFilterIndex(object);
        if (n == -1) {
            int n2 = this._filteredColumns.length;
            object4 = new Object[n2 + 1];
            System.arraycopy(this._filteredColumns, 0, object4, 0, n2);
            object4[n2] = object;
            this._filteredColumns = object4;
            object4 = new Object[n2 + 1];
            System.arraycopy(this._filteredValues, 0, object4, 0, n2);
            object4[n2] = object2;
            this._filteredValues = object4;
            object4 = new Object[n2 + 1];
            System.arraycopy(this._filteredDefaults, 0, object4, 0, n2);
            object4[n2] = object3;
            this._filteredDefaults = object4;
        } else {
            this._filteredValues[n] = object2;
            this._filteredDefaults[n] = object3;
        }
        Hashtable hashtable = this._propertyModels;
        object4 = hashtable.keys();
        if (object4 != null) {
            while (object4.hasMoreElements()) {
                Object e = object4.nextElement();
                PropertyFilterer propertyFilterer = (PropertyFilterer)hashtable.get(e);
                propertyFilterer.setColumnFilter(object, object2, object3);
            }
        }
        this._updateFilteredRows();
    }

    public Object getFilterValue(Object object) {
        int n = this._getFilterIndex(object);
        return n == -1 ? PropertyModel.DOES_NOT_EXIST : this._filteredValues[n];
    }

    public Object getFilterDefaultValue(Object object) {
        int n = this._getFilterIndex(object);
        return n == -1 ? PropertyModel.DOES_NOT_EXIST : this._filteredDefaults[n];
    }

    private void _setFilterValue(Object object, Object object2) {
        int n = this._getFilterIndex(object);
        if (n != -1 && object2 != this._filteredValues[n]) {
            this._filteredValues[n] = object2;
            this._updateFilteredRows();
        }
    }

    private void _invalidateModel() {
        this.fireTableStructureChanged();
    }

    private int _getDrillDown(int[] nArray, int n) {
        int n2 = nArray[n];
        int n3 = 0;
        while (n > 0) {
            if (nArray[--n] != n2) break;
            ++n3;
        }
        return n3;
    }

    private boolean _isModelColumnInvalid(TableModelEvent tableModelEvent) {
        int n;
        int n2 = tableModelEvent.getColumn();
        return n2 == (n = this.getColumnIndex(PropertyModel.COLUMN_MODEL)) || n2 == -1;
    }

    private void _clearModelCache(TableModelEvent tableModelEvent) {
        block7: {
            Hashtable hashtable;
            int n;
            block6: {
                n = tableModelEvent.getFirstRow();
                hashtable = this._propertyModels;
                if (n >= 0) break block6;
                Enumeration enumeration = hashtable.keys();
                if (enumeration == null) break block7;
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    PropertyModel propertyModel = (PropertyModel)hashtable.remove(k);
                    propertyModel.removeTableModelListener(this._drilledModelListener);
                }
                break block7;
            }
            int n2 = tableModelEvent.getLastRow();
            if (n2 >= this._filteredModel.getRowCount()) {
                n2 = this._filteredModel.getRowCount() - 1;
            }
            this._filteredModel.startRead();
            try {
                int n3 = n;
                while (n3 <= n2) {
                    PropertyModel propertyModel;
                    Object object = this._filteredModel.getPropertyID(n3);
                    if (object != null && object != PropertyModel.DOES_NOT_EXIST && (propertyModel = (PropertyModel)hashtable.remove(object)) != null) {
                        propertyModel.removeTableModelListener(this._drilledModelListener);
                    }
                    ++n3;
                }
                Object var9_11 = null;
                this._filteredModel.stopRead();
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                this._filteredModel.stopRead();
                throw throwable;
            }
        }
    }

    private PropertyModel _getDrilledModel(Object object, int n) {
        PropertyModel propertyModel = (PropertyModel)this._propertyModels.get(object);
        if (propertyModel == null && (propertyModel = this._filteredModel.getPropertyModel(n)) != null) {
            PropertyFilterer propertyFilterer = new PropertyFilterer(propertyModel, null);
            propertyFilterer.setFilterInfo(this._filteredColumns, this._filteredValues, this._filteredDefaults);
            propertyFilterer.setWriteOnlyIncluded(this.getWriteOnlyIncluded());
            propertyFilterer.setReadOnlyIncluded(this.getReadOnlyIncluded());
            propertyFilterer.setSortMode(0);
            propertyModel = propertyFilterer;
            propertyModel.addTableModelListener(this._drilledModelListener);
            this._propertyModels.put(object, propertyModel);
        }
        return propertyModel;
    }

    private class DrillDSListen
    implements TableModelListener {
        private DrillDSListen() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            PropertyFilterer.this._invalidateRowMapping();
            PropertyFilterer.this._invalidateModel();
        }
    }
}

