/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.NullEditor;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyEditorValueEditor;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.share.nls.LocaleUtils;

class SwitchingCellEditor
implements TableCellEditor {
    private boolean _clearCache;
    private int _lastColumn;
    private int _lastRow;
    private TableCellEditor _cachedEditor;
    private PropertyInspector _inspector;

    public SwitchingCellEditor(PropertyInspector propertyInspector) {
        this.init();
        this._inspector = propertyInspector;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (this._lastColumn != n2 || this._lastRow != n || this._cachedEditor == null) {
            TableCellEditor tableCellEditor = this._getEditorAt(jTable, n2, n);
            this._lastColumn = n2;
            this._lastRow = n;
            this._cachedEditor = tableCellEditor;
        }
        return this._cachedEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    public Object getCellEditorValue() {
        return this._getEditor().getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            JTable jTable = (JTable)mouseEvent.getSource();
            if (!jTable.isEnabled()) {
                return false;
            }
            int n = jTable.columnAtPoint(point);
            int n2 = jTable.rowAtPoint(point);
            return this._isCellEditable(jTable, n, n2);
        }
        if (eventObject == null) {
            JTable jTable = this._inspector.getPropertyTable();
            if (!jTable.isEnabled()) {
                return false;
            }
            int n = PropertyInspector.__getAnchorSelectionIndex(jTable.getSelectionModel());
            int n3 = PropertyInspector.__getAnchorSelectionIndex(jTable.getColumnModel().getSelectionModel());
            if (jTable.hasFocus() && n3 != -1 && n != -1) {
                return this._isCellEditable(jTable, n3, n);
            }
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this._getEditor().shouldSelectCell(eventObject);
    }

    public boolean stopCellEditing() {
        boolean bl = this._getEditor().stopCellEditing();
        if (this._clearCache) {
            this.init();
        }
        return bl;
    }

    public void cancelCellEditing() {
        this._getEditor().cancelCellEditing();
        if (this._clearCache) {
            this.init();
        }
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this._getEditor().addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this._getEditor().removeCellEditorListener(cellEditorListener);
    }

    public void init() {
        this._lastColumn = -1;
        this._lastRow = -1;
        if (this._cachedEditor instanceof NullEditor) {
            ((NullEditor)this._cachedEditor).dispose();
        } else if (this._cachedEditor instanceof PropertyEditorValueEditor) {
            ((PropertyEditorValueEditor)this._cachedEditor).dispose();
        }
        this._cachedEditor = null;
    }

    private boolean _isCellEditable(JTable jTable, int n, int n2) {
        PropertyModel propertyModel = (PropertyModel)jTable.getModel();
        return propertyModel.isPropertyWritable(n2);
    }

    private TableCellEditor _getEditorAt(JTable jTable, int n, int n2) {
        PropertyEditorFactory propertyEditorFactory;
        TableCellEditor tableCellEditor = NullEditor.getTableCellEditor();
        this._clearCache = false;
        PropertyModel propertyModel = (PropertyModel)jTable.getModel();
        if (propertyModel.isPropertyWritable(n2) && (propertyEditorFactory = propertyModel.getPropertyEditorFactory(n2)) != null) {
            Object object = propertyModel.getData(PropertyModel.COLUMN_VALUE, n2);
            try {
                propertyEditorFactory.setEditorValue(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (propertyEditorFactory.hasInPlaceEditor()) {
                Locale locale = LocaleUtils.getDefaultableLocale((Component)jTable);
                tableCellEditor = propertyEditorFactory.getInPlaceEditor(locale);
            } else if (propertyEditorFactory.hasAdvancedEditor() || propertyEditorFactory.hasTearOffEditor()) {
                if (propertyEditorFactory.hasValueRenderer()) {
                    TableCellRenderer tableCellRenderer = propertyEditorFactory.getValueRenderer();
                    Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, n2, n);
                    tableCellEditor = new NullEditor(component);
                    this._clearCache = true;
                } else {
                    tableCellEditor = NullEditor.getTableCellEditor();
                }
            }
        }
        return tableCellEditor;
    }

    private TableCellEditor _getEditor() {
        return this._cachedEditor == null ? NullEditor.getTableCellEditor() : this._cachedEditor;
    }
}

